/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleRestriction_Base;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixframework.FenixFramework;

public abstract class AcademicDebtGenerationRuleRestriction
extends AcademicDebtGenerationRuleRestriction_Base
implements Predicate<Registration> {
    public AcademicDebtGenerationRuleRestriction() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected AcademicDebtGenerationRuleRestriction(AcademicDebtGenerationRule rule, boolean excludeIfMatches) {
        this();
        this.init(rule, excludeIfMatches);
    }

    protected void init(AcademicDebtGenerationRule rule, boolean excludeIfMatches) {
        super.setAcademicDebtGenerationRule(rule);
        super.setExcludeIfMatches(excludeIfMatches);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleRestriction.domainRoot.required", new String[0]);
        }
        if (this.getAcademicDebtGenerationRule() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleRestriction.academicDebtGenerationRule.required", new String[0]);
        }
    }

    public abstract LocalizedString getName();

    public abstract List<LocalizedString> getParametersDescriptions();

    public abstract AcademicDebtGenerationRuleRestriction makeCopy(AcademicDebtGenerationRule var1);

    public boolean isToInclude() {
        return !this.getExcludeIfMatches();
    }

    public boolean isToExclude() {
        return this.getExcludeIfMatches();
    }

    public void delete() {
        this.setDomainRoot(null);
        this.setAcademicDebtGenerationRule(null);
        super.deleteDomainObject();
    }

    public static Stream<AcademicDebtGenerationRuleRestriction> findAll() {
        return FenixFramework.getDomainRoot().getAcademicDebtGenerationRuleRestrictionsSet().stream();
    }

    public static Stream<AcademicDebtGenerationRuleRestriction> find(AcademicDebtGenerationRule rule) {
        return rule.getAcademicDebtGenerationRuleRestrictionsSet().stream();
    }
}

