/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import com.google.common.base.Strings;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;

public class DebtAccountReportEntryBean
implements SpreadsheetRow {
    public static String[] SPREADSHEET_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.versioningCreator", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.finantialInstitutionName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.identificationType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.identificationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.email", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.address", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.addressCountryCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.vatNumberValid", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtAccountReportEntryBean.header.totalInDebt", new String[0])};
    final DebtAccount debtAccount;
    boolean completed = false;
    private String identification;
    private String versioningCreator;
    private DateTime creationDate;
    private String finantialInstitutionName;
    private String customerId;
    private String name;
    private String identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String email;
    private String address;
    private String addressCountryCode;
    private Integer studentNumber;
    private boolean vatNumberValid;
    private String totalInDebt;

    public DebtAccountReportEntryBean(DebtAccount debtAccount, DebtReportRequest request, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        String decimalSeparator = request.getDecimalSeparator();
        this.debtAccount = debtAccount;
        try {
            this.identification = debtAccount.getExternalId();
            this.versioningCreator = treasuryServices.versioningCreatorUsername((Object)debtAccount);
            this.creationDate = treasuryServices.versioningCreationDate((Object)debtAccount);
            this.finantialInstitutionName = debtAccount.getFinantialInstitution().getName();
            this.customerId = debtAccount.getCustomer().getExternalId();
            this.name = debtAccount.getCustomer().getName();
            if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPerson() != null && ((PersonCustomer)debtAccount.getCustomer()).getPerson().getIdDocumentType() != null) {
                this.identificationType = ((PersonCustomer)debtAccount.getCustomer()).getPerson().getIdDocumentType().getLocalizedName();
            } else if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer().getIdDocumentType() != null) {
                this.identificationType = ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer().getIdDocumentType().getLocalizedName();
            }
            this.identificationNumber = debtAccount.getCustomer().getIdentificationNumber();
            this.vatNumber = debtAccount.getCustomer().getUiFiscalNumber();
            if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPerson() != null) {
                this.email = ((PersonCustomer)debtAccount.getCustomer()).getPerson().getInstitutionalOrDefaultEmailAddressValue();
            } else if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null) {
                this.email = ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer().getInstitutionalOrDefaultEmailAddressValue();
            }
            this.address = debtAccount.getCustomer().getUiCompleteAddress();
            this.addressCountryCode = this.valueOrEmpty(debtAccount.getCustomer().getAddressCountryCode());
            if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPerson() != null && ((PersonCustomer)debtAccount.getCustomer()).getPerson().getStudent() != null) {
                this.studentNumber = ((PersonCustomer)debtAccount.getCustomer()).getPerson().getStudent().getNumber();
            } else if (debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer().getStudent() != null) {
                this.studentNumber = ((PersonCustomer)debtAccount.getCustomer()).getPersonForInactivePersonCustomer().getStudent().getNumber();
            }
            this.vatNumberValid = FiscalCodeValidation.isValidFiscalNumber((String)debtAccount.getCustomer().getFiscalCountry(), (String)debtAccount.getCustomer().getFiscalNumber());
            this.totalInDebt = debtAccount.getFinantialInstitution().getCurrency().getValueWithScale(debtAccount.getTotalInDebt()).toString();
            if (",".equals(decimalSeparator)) {
                this.totalInDebt = this.totalInDebt.replace(".", ",");
            }
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(debtAccount, e);
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.versioningCreator);
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.finantialInstitutionName));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.customerId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.name));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.email));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.address));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.addressCountryCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.studentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumberValid));
            row.createCell(i++).setCellValue(this.totalInDebt.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.debtAccount, e);
        }
    }

    private String valueOrEmpty(DateTime value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd HH:mm:ss");
    }

    private String valueOrEmpty(Boolean value) {
        if (value == null) {
            return "";
        }
        return AcademicTreasuryConstants.academicTreasuryBundle(value != false ? "label.yes" : "label.no", new String[0]);
    }

    private String valueOrEmpty(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String valueOrEmpty(LocalizedString value) {
        if (value == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)value.getContent())) {
            return "";
        }
        return value.getContent();
    }

    private String valueOrEmpty(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return "";
    }
}

