/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup$callable$create;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup$callable$delete;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup$callable$edit;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup_Base;
import org.fenixedu.academictreasury.util.LocalizedStringUtil;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Product;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TuitionPaymentPlanGroup
extends TuitionPaymentPlanGroup_Base {
    public static final Comparator<TuitionPaymentPlanGroup> COMPARE_BY_NAME;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected TuitionPaymentPlanGroup() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected TuitionPaymentPlanGroup(String code, LocalizedString name, boolean forRegistration, boolean forStandalone, boolean forExtracurricular, Product currentProduct) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setForRegistration(forRegistration);
        this.setForStandalone(forStandalone);
        this.setForExtracurricular(forExtracurricular);
        this.setCurrentProduct(currentProduct);
        this.checkRules();
    }

    private void checkRules() {
        if (Strings.isNullOrEmpty((String)this.getCode())) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.name.required", new String[0]);
        }
        if (!(this.isForRegistration() ^ this.isForStandalone() ^ this.isForExtracurricular())) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.only.one.type.supported", new String[0]);
        }
        if (TuitionPaymentPlanGroup.findDefaultGroupForRegistration().count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.for.registration.already.exists", new String[0]);
        }
        if (TuitionPaymentPlanGroup.findDefaultGroupForStandalone().count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.for.standalone.already.exists", new String[0]);
        }
        if (TuitionPaymentPlanGroup.findDefaultGroupForExtracurricular().count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.for.extracurricular.already.exists", new String[0]);
        }
        if (TuitionPaymentPlanGroup.findByCode(this.getCode()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.code.already.exists", new String[0]);
        }
    }

    public void edit(String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, Product product) {
        Object object = advice$edit.perform((Callable)new TuitionPaymentPlanGroup$callable$edit(this, string, localizedString, bl, bl2, bl3, product));
    }

    static /* synthetic */ void advised$edit(TuitionPaymentPlanGroup this_, String code, LocalizedString name, boolean forRegistration, boolean forStandalone, boolean forExtracurricular, Product currentProduct) {
        this_.setCode(code);
        this_.setName(name);
        this_.setForRegistration(forRegistration);
        this_.setForStandalone(forStandalone);
        this_.setForExtracurricular(forExtracurricular);
        this_.setCurrentProduct(currentProduct);
        this_.checkRules();
    }

    public boolean isForRegistration() {
        return this.getForRegistration();
    }

    public boolean isForStandalone() {
        return this.getForStandalone();
    }

    public boolean isForExtracurricular() {
        return this.getForExtracurricular();
    }

    public boolean isForImprovement() {
        return this.getForImprovement();
    }

    public boolean isDeletable() {
        return this.getAcademicTreasuryEventSet().isEmpty() && this.getTuitionPaymentPlansSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new TuitionPaymentPlanGroup$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TuitionPaymentPlanGroup this_) {
        if (!this_.isDeletable()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanGroup.delete.impossible", new String[0]);
        }
        this_.setDomainRoot(null);
        super.deleteDomainObject();
    }

    public static Stream<TuitionPaymentPlanGroup> findAll() {
        return FenixFramework.getDomainRoot().getTuitionPaymentPlanGroupsSet().stream();
    }

    protected static Stream<TuitionPaymentPlanGroup> findDefaultGroupForRegistration() {
        return TuitionPaymentPlanGroup.findAll().filter(t -> t.isForRegistration());
    }

    protected static Stream<TuitionPaymentPlanGroup> findDefaultGroupForStandalone() {
        return TuitionPaymentPlanGroup.findAll().filter(t -> t.isForStandalone());
    }

    protected static Stream<TuitionPaymentPlanGroup> findDefaultGroupForImprovement() {
        return TuitionPaymentPlanGroup.findAll().filter(t -> t.isForImprovement());
    }

    protected static Stream<TuitionPaymentPlanGroup> findDefaultGroupForExtracurricular() {
        return TuitionPaymentPlanGroup.findAll().filter(t -> t.isForExtracurricular());
    }

    protected static Stream<TuitionPaymentPlanGroup> findByCode(String code) {
        return TuitionPaymentPlanGroup.findAll().filter(l -> StringNormalizer.normalize((String)l.getCode().toLowerCase()).equals(StringNormalizer.normalize((String)code).toLowerCase()));
    }

    public static Optional<TuitionPaymentPlanGroup> findUniqueDefaultGroupForRegistration() {
        return TuitionPaymentPlanGroup.findDefaultGroupForRegistration().findFirst();
    }

    public static Optional<TuitionPaymentPlanGroup> findUniqueDefaultGroupForStandalone() {
        return TuitionPaymentPlanGroup.findDefaultGroupForStandalone().findFirst();
    }

    public static Optional<TuitionPaymentPlanGroup> findUniqueDefaultGroupForExtracurricular() {
        return TuitionPaymentPlanGroup.findDefaultGroupForExtracurricular().findFirst();
    }

    public static Optional<TuitionPaymentPlanGroup> findUniqueDefaultGroupForImprovement() {
        return TuitionPaymentPlanGroup.findDefaultGroupForImprovement().findFirst();
    }

    public static TuitionPaymentPlanGroup create(String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, Product product) {
        return (TuitionPaymentPlanGroup)((Object)advice$create.perform((Callable)new TuitionPaymentPlanGroup$callable$create(string, localizedString, bl, bl2, bl3, product)));
    }

    static /* synthetic */ TuitionPaymentPlanGroup advised$create(String code, LocalizedString name, boolean forRegistration, boolean forStandalone, boolean forExtracurricular, Product currentProduct) {
        return new TuitionPaymentPlanGroup(code, name, forRegistration, forStandalone, forExtracurricular, currentProduct);
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = new Comparator<TuitionPaymentPlanGroup>(){

            @Override
            public int compare(TuitionPaymentPlanGroup o1, TuitionPaymentPlanGroup o2) {
                int c = o1.getName().getContent().compareTo(o2.getName().getContent());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

