/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import java.util.Set;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;

public class InferTuitionStudentConditionsBean {
    private RegistrationRegimeType regimeType;
    private RegistrationProtocol registrationProtocol;
    private IngressionType ingression;
    private Set<Integer> semestersWithEnrolments;
    private CurricularYear curricularYear;
    private boolean firstTimeStudent;
    private Set<StatuteType> statutes;

    public static InferTuitionStudentConditionsBean build(Registration registration, ExecutionYear executionYear) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        InferTuitionStudentConditionsBean bean = new InferTuitionStudentConditionsBean();
        bean.setRegimeType(academicTreasuryServices.registrationRegimeType(registration, executionYear));
        bean.setRegistrationProtocol(registration.getRegistrationProtocol());
        bean.setIngression(academicTreasuryServices.ingression(registration));
        bean.setSemestersWithEnrolments(TuitionPaymentPlan.semestersWithEnrolments(registration, executionYear));
        bean.setCurricularYear(CurricularYear.readByYear((Integer)TuitionPaymentPlan.curricularYear(registration, executionYear)));
        bean.setFirstTimeStudent(TuitionPaymentPlan.firstTimeStudent(registration, executionYear));
        bean.setStatutes(academicTreasuryServices.statutesTypesValidOnAnyExecutionSemesterFor(registration.getStudent(), executionYear));
        return bean;
    }

    public RegistrationRegimeType getRegimeType() {
        return this.regimeType;
    }

    public void setRegimeType(RegistrationRegimeType regimeType) {
        this.regimeType = regimeType;
    }

    public RegistrationProtocol getRegistrationProtocol() {
        return this.registrationProtocol;
    }

    public void setRegistrationProtocol(RegistrationProtocol registrationProtocol) {
        this.registrationProtocol = registrationProtocol;
    }

    public IngressionType getIngression() {
        return this.ingression;
    }

    public void setIngression(IngressionType ingression) {
        this.ingression = ingression;
    }

    public Set<Integer> getSemestersWithEnrolments() {
        return this.semestersWithEnrolments;
    }

    public void setSemestersWithEnrolments(Set<Integer> semestersWithEnrolments) {
        this.semestersWithEnrolments = semestersWithEnrolments;
    }

    public CurricularYear getCurricularYear() {
        return this.curricularYear;
    }

    public void setCurricularYear(CurricularYear curricularYear) {
        this.curricularYear = curricularYear;
    }

    public boolean isFirstTimeStudent() {
        return this.firstTimeStudent;
    }

    public void setFirstTimeStudent(boolean firstTimeStudent) {
        this.firstTimeStudent = firstTimeStudent;
    }

    public Set<StatuteType> getStatutes() {
        return this.statutes;
    }

    public void setStatutes(Set<StatuteType> statutes) {
        this.statutes = statutes;
    }
}

