/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.requests;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFile;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFileBean$callable$updateData;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationType;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MassiveDebtGenerationRequestFileBean
implements Serializable,
ITreasuryBean {
    private static final long serialVersionUID = 1L;
    private MassiveDebtGenerationType massiveDebtGenerationType;
    private LocalDate debtDate;
    private ExecutionYear executionYear;
    private TuitionPaymentPlanGroup tuitionPaymentPlanGroup;
    private AcademicTax academicTax;
    private String reason;
    private FinantialInstitution finantialInstitution;
    private List<TreasuryTupleDataSourceBean> massiveDebtGenerationTypeDataSource;
    private List<TreasuryTupleDataSourceBean> executionYearDataSource;
    private List<TreasuryTupleDataSourceBean> academicTaxesDataSource;
    private List<TreasuryTupleDataSourceBean> finantialInstitutionDataSource;
    private boolean forAcademicTax = false;
    private boolean executionYearRequired;
    private boolean academicTaxRequired;
    private boolean debtDateRequired;
    private boolean reasonRequired;
    private boolean finantialInstitutionRequired;
    public static final Advice advice$updateData = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public MassiveDebtGenerationRequestFileBean() {
        this.debtDate = new LocalDate();
        if (FinantialInstitution.findAll().count() == 1L) {
            this.finantialInstitution = (FinantialInstitution)FinantialInstitution.findAll().findFirst().get();
        }
        this.updateData();
    }

    public MassiveDebtGenerationRequestFileBean(MassiveDebtGenerationRequestFile file) {
        this.setMassiveDebtGenerationType(file.getMassiveDebtGenerationType());
        this.setTuitionPaymentPlanGroup(file.getTuitionPaymentPlanGroup());
        this.setAcademicTax(file.getAcademicTax());
        this.setExecutionYear(file.getExecutionYear());
        this.setDebtDate(file.getDebtDate());
        this.setReason(file.getReason());
        this.setFinantialInstitution(file.getFinantialInstitution());
    }

    public void updateData() {
        Object object = advice$updateData.perform((Callable)new MassiveDebtGenerationRequestFileBean$callable$updateData(this));
    }

    static /* synthetic */ void advised$updateData(MassiveDebtGenerationRequestFileBean this_) {
        this_.getMassiveDebtGenerationTypeDataSource();
        this_.getExecutionYearDataSource();
        this_.getAcademicTaxesDataSource();
        this_.getMassiveDebtGenerationTypeDataSource();
        this_.getFinantialInstitutionDataSource();
        if (this_.isForAcademicTax()) {
            this_.tuitionPaymentPlanGroup = null;
        } else {
            this_.tuitionPaymentPlanGroup = TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get();
            this_.academicTax = null;
        }
        this_.setDebtDateRequired(this_.getMassiveDebtGenerationType() != null ? this_.getMassiveDebtGenerationType().isDebtDateRequired() : false);
        this_.setAcademicTaxRequired(this_.getMassiveDebtGenerationType() != null ? this_.getMassiveDebtGenerationType().isForAcademicTaxRequired() : false);
        this_.setExecutionYearRequired(this_.getMassiveDebtGenerationType() != null ? this_.getMassiveDebtGenerationType().isExecutionRequired() : false);
        this_.setReasonRequired(this_.getMassiveDebtGenerationType() != null ? this_.getMassiveDebtGenerationType().isReasonRequired() : false);
        this_.setFinantialInstitutionRequired(this_.getMassiveDebtGenerationType() != null ? this_.getMassiveDebtGenerationType().isFinantialInstitutionRequired() : false);
    }

    public List<TreasuryTupleDataSourceBean> getMassiveDebtGenerationTypeDataSource() {
        this.massiveDebtGenerationTypeDataSource = MassiveDebtGenerationType.findAllActive().map(e -> new TreasuryTupleDataSourceBean(e.getExternalId(), e.getName())).collect(Collectors.toList());
        return this.massiveDebtGenerationTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getExecutionYearDataSource() {
        this.executionYearDataSource = this.possibleExecutionYears().stream().map(e -> new TreasuryTupleDataSourceBean(e.getExternalId(), e.getQualifiedName())).collect(Collectors.toList());
        return this.executionYearDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getAcademicTaxesDataSource() {
        this.academicTaxesDataSource = AcademicTax.findAll().map(e -> new TreasuryTupleDataSourceBean(e.getExternalId(), e.getProduct().getName().getContent())).collect(Collectors.toList());
        return this.academicTaxesDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getFinantialInstitutionDataSource() {
        this.finantialInstitutionDataSource = FinantialInstitution.findAll().map(e -> new TreasuryTupleDataSourceBean(e.getExternalId(), e.getName())).collect(Collectors.toList());
        return this.finantialInstitutionDataSource;
    }

    private List<ExecutionYear> possibleExecutionYears() {
        List<ExecutionYear> executionYears = ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).collect(Collectors.toList());
        return executionYears;
    }

    public boolean isStandaloneTuition() {
        return this.tuitionPaymentPlanGroup != null && this.tuitionPaymentPlanGroup.isForStandalone();
    }

    public boolean isExtracurricularTuition() {
        return this.tuitionPaymentPlanGroup != null && this.tuitionPaymentPlanGroup.isForExtracurricular();
    }

    public boolean isRegistrationTuition() {
        return this.tuitionPaymentPlanGroup != null && this.tuitionPaymentPlanGroup.isForRegistration();
    }

    public boolean isForAcademicTax() {
        return this.forAcademicTax;
    }

    public void setForAcademicTax(boolean forAcademicTax) {
        this.forAcademicTax = forAcademicTax;
    }

    public TuitionPaymentPlanGroup getTuitionPaymentPlanGroup() {
        return this.tuitionPaymentPlanGroup;
    }

    public void setTuitionPaymentPlanGroup(TuitionPaymentPlanGroup tuitionPaymentPlanGroup) {
        this.tuitionPaymentPlanGroup = tuitionPaymentPlanGroup;
    }

    public AcademicTax getAcademicTax() {
        return this.academicTax;
    }

    public void setAcademicTax(AcademicTax academicTax) {
        this.academicTax = academicTax;
    }

    public LocalDate getDebtDate() {
        return this.debtDate;
    }

    public void setDebtDate(LocalDate debtDate) {
        this.debtDate = debtDate;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public MassiveDebtGenerationType getMassiveDebtGenerationType() {
        return this.massiveDebtGenerationType;
    }

    public void setMassiveDebtGenerationType(MassiveDebtGenerationType massiveDebtGenerationType) {
        this.massiveDebtGenerationType = massiveDebtGenerationType;
    }

    public boolean isDebtDateRequired() {
        return this.debtDateRequired;
    }

    public void setDebtDateRequired(boolean debtDateRequired) {
        this.debtDateRequired = debtDateRequired;
    }

    public boolean isExecutionYearRequired() {
        return this.executionYearRequired;
    }

    public void setExecutionYearRequired(boolean executionYearRequired) {
        this.executionYearRequired = executionYearRequired;
    }

    public void setExecutionYearDataSource(List<TreasuryTupleDataSourceBean> executionYearDataSource) {
        this.executionYearDataSource = executionYearDataSource;
    }

    public boolean isAcademicTaxRequired() {
        return this.academicTaxRequired;
    }

    public void setAcademicTaxRequired(boolean forAcademicTaxRequired) {
        this.academicTaxRequired = forAcademicTaxRequired;
    }

    public boolean isReasonRequired() {
        return this.reasonRequired;
    }

    public void setReasonRequired(boolean reasonRequired) {
        this.reasonRequired = reasonRequired;
    }

    public boolean isFinantialInstitutionRequired() {
        return this.finantialInstitutionRequired;
    }

    public void setFinantialInstitutionRequired(boolean finantialInstitutionRequired) {
        this.finantialInstitutionRequired = finantialInstitutionRequired;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public FinantialInstitution getFinantialInstitution() {
        return this.finantialInstitution;
    }

    public void setFinantialInstitution(FinantialInstitution finantialInstitution) {
        this.finantialInstitution = finantialInstitution;
    }
}

