/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.accesscontrol.spi;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.services.accesscontrol.spi.ITreasuryAccessControlExtension;
import org.joda.time.LocalDate;

public class AcademicTreasuryAccessControlExtension
implements ITreasuryAccessControlExtension<Object> {
    public boolean isFrontOfficeMember(String username) {
        return FinantialInstitution.findAll().map(l -> this.isFrontOfficeMember(username, (FinantialInstitution)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public boolean isFrontOfficeMember(String username, FinantialInstitution finantialInstitution) {
        return FinantialEntity.find((FinantialInstitution)finantialInstitution).map(l -> this.isFrontOfficeMember(username, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    private boolean isFrontOfficeMember(String username, FinantialEntity finantialEntity) {
        return AcademicTreasuryPlataformDependentServicesFactory.implementation().isFrontOfficeMember(username, finantialEntity);
    }

    public boolean isFrontOfficeMemberWithinContext(String username, Object context) {
        IAcademicTreasuryPlatformDependentServices services = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (context instanceof Degree) {
            Degree degree = (Degree)context;
            FinantialEntity finantialEntity = services.finantialEntityOfDegree(degree, new LocalDate());
            return this.isFrontOfficeMember(username, finantialEntity);
        }
        return false;
    }

    public boolean isBackOfficeMember(String username) {
        return FinantialInstitution.findAll().map(l -> this.isBackOfficeMember(username, (FinantialInstitution)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public boolean isBackOfficeMember(String username, FinantialInstitution finantialInstitution) {
        return FinantialEntity.find((FinantialInstitution)finantialInstitution).map(l -> this.isBackOfficeMember(username, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public boolean isBackOfficeMember(String username, FinantialEntity finantialEntity) {
        return AcademicTreasuryPlataformDependentServicesFactory.implementation().isBackOfficeMember(username, finantialEntity);
    }

    public boolean isBackOfficeMemberWithinContext(String username, Object context) {
        IAcademicTreasuryPlatformDependentServices services = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (context instanceof Degree) {
            Degree degree = (Degree)context;
            FinantialEntity finantialEntity = services.finantialEntityOfDegree(degree, new LocalDate());
            return this.isBackOfficeMember(username, finantialEntity);
        }
        return false;
    }

    public boolean isContextObjectApplied(Object context) {
        return context instanceof Degree;
    }

    public boolean isManager(String username) {
        return false;
    }

    public boolean isAllowToModifySettlements(String username, FinantialInstitution finantialInstitution) {
        return FinantialEntity.find((FinantialInstitution)finantialInstitution).map(l -> this.isAllowToModifySettlements(username, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    private boolean isAllowToModifySettlements(String username, FinantialEntity finantialEntity) {
        return AcademicTreasuryPlataformDependentServicesFactory.implementation().isAllowToModifySettlements(username, finantialEntity);
    }

    public boolean isAllowToModifyInvoices(String username, FinantialInstitution finantialInstitution) {
        return FinantialEntity.find((FinantialInstitution)finantialInstitution).map(l -> this.isAllowToModifyInvoices(username, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    private boolean isAllowToModifyInvoices(String username, FinantialEntity finantialEntity) {
        return AcademicTreasuryPlataformDependentServicesFactory.implementation().isAllowToModifyInvoices(username, finantialEntity);
    }

    public boolean isAllowToConditionallyAnnulSettlementNote(String username, SettlementNote settlementNote) {
        return false;
    }

    public boolean isAllowToAnnulSettlementNoteWithoutAnyRestriction(String username, SettlementNote settlementNote) {
        return false;
    }

    public Set<String> getFrontOfficeMemberUsernames() {
        IAcademicTreasuryPlatformDependentServices services = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        HashSet result = Sets.newHashSet();
        FinantialEntity.findAll().forEach(entity -> result.addAll(services.getFrontOfficeMemberUsernames((FinantialEntity)entity)));
        return result;
    }

    public Set<String> getBackOfficeMemberUsernames() {
        IAcademicTreasuryPlatformDependentServices services = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        HashSet result = Sets.newHashSet();
        FinantialEntity.findAll().forEach(entity -> result.addAll(services.getBackOfficeMemberUsernames((FinantialEntity)entity)));
        return result;
    }

    public Set<String> getTreasuryManagerMemberUsernames() {
        return Sets.newHashSet();
    }
}

