/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.scripts;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qubit.solution.fenixedu.bennu.webservices.domain.webservice.WebServiceClientConfiguration;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartySocialSecurityNumber;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.custom.CustomTask;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.ProductGroup;
import org.fenixedu.treasury.domain.VatExemptionReason;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStatusType;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.domain.paymentcodes.PaymentCodeTarget;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.SAPExternalService;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.fenixedu.treasury.util.TreasuryConstants;

public class PrepareTreasuryForSAPForCore
extends CustomTask {
    public void runTask() throws Exception {
        this.createWebserviceForSAP();
        this.configureERPInFinantialInstitution();
        this.createTransferBalanceProduct();
        this.activateSeriesAndCreateNewForRegulation();
        this.createReimbursementStatusTypes();
        this.saveFiscalCountryOnPersons();
        this.markDocumentsExportedInLegacyERP();
        this.moveAcademicTreasuryEventsFromDebtAccountToPerson();
        this.saveFiscalInformationAndDeleteMergedCustomers();
        this.checkAllPersonCustomersWithFiscalCountryAndNumber();
        this.taskLog("End", new Object[0]);
    }

    private void createTransferBalanceProduct() {
        this.taskLog("createTransferBalanceProduct", new Object[0]);
        ProductGroup otherProductGroup = ProductGroup.findByCode((String)"OTHER");
        VatType exemptionVatType = VatType.findByCode((String)"ISE");
        VatExemptionReason exemptionReason = VatExemptionReason.findByCode((String)"M07");
        if (!Product.findUniqueByCode((String)"TRANSFERENCIA_SALDO").isPresent()) {
            LocalizedString productName = new LocalizedString(TreasuryConstants.DEFAULT_LANGUAGE, "Transfer\u00eancia de Saldo");
            LocalizedString quantityName = new LocalizedString(TreasuryConstants.DEFAULT_LANGUAGE, "Unidade");
            Product product = Product.create((ProductGroup)otherProductGroup, (String)"TRANSFERENCIA_SALDO", (LocalizedString)productName, (LocalizedString)quantityName, (boolean)true, (boolean)false, (int)0, (VatType)exemptionVatType, FinantialInstitution.findAll().collect(Collectors.toList()), (VatExemptionReason)exemptionReason);
            TreasurySettings.getInstance().setTransferBalanceProduct(product);
        }
    }

    private void checkAllPersonCustomersWithFiscalCountryAndNumber() {
        this.taskLog("checkAllPersonCustomersWithFiscalCountryAndNumber", new Object[0]);
        for (Customer c : Customer.findAll().collect(Collectors.toSet())) {
            if (!Strings.isNullOrEmpty((String)c.getFiscalCountry()) && !Strings.isNullOrEmpty((String)c.getFiscalNumber())) continue;
            throw new RuntimeException("without fiscal information: " + c.getName());
        }
    }

    public void createReimbursementStatusTypes() throws Exception {
        this.taskLog("createReimbursementStatusTypes", new Object[0]);
        ReimbursementProcessStatusType.create((String)"PENDING", (String)"Reembolso pendente", (int)1, (boolean)true, (boolean)false, (boolean)false);
        ReimbursementProcessStatusType.create((String)"ANNULED", (String)"Reembolso anulado", (int)2, (boolean)false, (boolean)true, (boolean)true);
        ReimbursementProcessStatusType.create((String)"CONCLUDED", (String)"Reembolso conclu\u00eddo", (int)3, (boolean)false, (boolean)true, (boolean)false);
    }

    private void moveAcademicTreasuryEventsFromDebtAccountToPerson() {
        this.taskLog("moveAcademicTreasuryEventsFromDebtAccountToPerson", new Object[0]);
        int count = 0;
        long totalCount = AcademicTreasuryEvent.findAll().count();
        for (AcademicTreasuryEvent academicTreasuryEvent : AcademicTreasuryEvent.findAll().collect(Collectors.toList())) {
            DebtAccount debtAccount;
            if (++count % 1000 == 0) {
                this.taskLog("Processing " + count + "/" + totalCount + " treasury events.", new Object[0]);
            }
            if ((debtAccount = academicTreasuryEvent.getDebtAccount()) == null) continue;
            PersonCustomer customer = (PersonCustomer)debtAccount.getCustomer();
            Person person = customer.isActive() ? customer.getPerson() : customer.getPersonForInactivePersonCustomer();
            academicTreasuryEvent.setPerson(person);
        }
    }

    private void saveFiscalInformationAndDeleteMergedCustomers() {
        this.taskLog("saveFiscalInformationAndDeleteMergedCustomers", new Object[0]);
        int count = 0;
        int totalCount = Bennu.getInstance().getPartysSet().size();
        for (Party party : Bennu.getInstance().getPartysSet()) {
            if (++count % 100 == 0) {
                this.taskLog("Processing " + count + "/" + totalCount + " parties.", new Object[0]);
            }
            if (!party.isPerson()) continue;
            Person person = (Person)party;
            if (person.getPersonCustomer() == null && !person.getInactivePersonCustomersSet().isEmpty()) {
                throw new RuntimeException("how to handle it");
            }
            if (person.getPersonCustomer() == null) continue;
            PersonCustomer personCustomer = person.getPersonCustomer();
            if (personCustomer.getDebtAccountsSet().size() > 1) {
                throw new RuntimeException("how to handle it");
            }
            DebtAccount debtAccount = !personCustomer.getDebtAccountsSet().isEmpty() ? (DebtAccount)personCustomer.getDebtAccountsSet().iterator().next() : null;
            for (PersonCustomer ipc : person.getInactivePersonCustomersSet()) {
                if (ipc.getDebtAccountsSet().size() > 1) {
                    throw new RuntimeException("how to handle it");
                }
                if (!ipc.getDebtAccountsSet().isEmpty()) {
                    this.taskLog("Found inactive debt account %s\n", new Object[]{ipc.getName()});
                    DebtAccount ipcDebtAccount = (DebtAccount)ipc.getDebtAccountsSet().iterator().next();
                    if (debtAccount != null) {
                        this.taskLog("Merging %s\n", new Object[]{personCustomer.getName()});
                        for (Invoice invoice : Sets.newHashSet((Iterable)ipcDebtAccount.getInvoiceSet())) {
                            invoice.setPayorDebtAccount(debtAccount);
                        }
                        for (InvoiceEntry invoiceEntry : Sets.newHashSet((Iterable)ipcDebtAccount.getInvoiceEntrySet())) {
                            invoiceEntry.setDebtAccount(debtAccount);
                        }
                        for (FinantialDocument finantialDocument : Sets.newHashSet((Iterable)ipcDebtAccount.getFinantialDocumentsSet())) {
                            finantialDocument.setDebtAccount(debtAccount);
                        }
                        for (PaymentCodeTarget target : Sets.newHashSet((Iterable)ipcDebtAccount.getPaymentCodeTargetsSet())) {
                            target.setDebtAccount(debtAccount);
                        }
                        for (ForwardPayment payment : ipcDebtAccount.getForwardPaymentsSet()) {
                            payment.setDebtAccount(debtAccount);
                        }
                        for (DebitEntry entry : ipcDebtAccount.getPayorDebitEntriesSet()) {
                            entry.setPayorDebtAccount(debtAccount);
                        }
                        for (TreasuryEvent treasuryEvent : ipcDebtAccount.getTreasuryEventsSet()) {
                            treasuryEvent.setDebtAccount(debtAccount);
                        }
                        ipcDebtAccount.delete();
                    } else {
                        ipcDebtAccount.setCustomer((Customer)personCustomer);
                    }
                }
                ipc.delete();
            }
            if (Strings.isNullOrEmpty((String)PersonCustomer.addressCountryCode(person))) {
                throw new RuntimeException("error");
            }
            if (Strings.isNullOrEmpty((String)PersonCustomer.fiscalNumber(person))) {
                throw new RuntimeException("error");
            }
            personCustomer.setAddressCountryCode(PersonCustomer.addressCountryCode(person));
            personCustomer.setFiscalNumber(PersonCustomer.fiscalNumber(person));
        }
        this.taskLog("Finish", new Object[0]);
        System.out.println("TreasuryAcademicBoot - Finished Validating Students and Customers DebtAccount");
    }

    private void markDocumentsExportedInLegacyERP() {
        this.taskLog("markDocumentsExportedInLegacyERP", new Object[0]);
        int count = 0;
        long totalCount = FinantialDocument.findAll().count();
        for (FinantialDocument doc : FinantialDocument.findAll().collect(Collectors.toSet())) {
            if (++count % 1000 == 0) {
                this.taskLog("Processing " + count + "/" + totalCount + " finantial documents.", new Object[0]);
            }
            if (doc.isPreparing()) continue;
            if (doc.isAnnulled()) {
                doc.setExportedInLegacyERP(true);
                continue;
            }
            if (!doc.isClosed() || doc.isDocumentToExport()) continue;
            doc.setExportedInLegacyERP(true);
        }
    }

    private void saveFiscalCountryOnPersons() {
        this.taskLog("saveFiscalCountryOnPersons", new Object[0]);
        int count = 0;
        int totalCount = Bennu.getInstance().getPartysSet().size();
        for (Party party : Bennu.getInstance().getPartysSet()) {
            if (++count % 1000 == 0) {
                this.taskLog("Processing " + count + "/" + totalCount + " parties.", new Object[0]);
            }
            if (!party.isPerson()) continue;
            Person person = (Person)party;
            if (Strings.isNullOrEmpty((String)PersonCustomer.fiscalNumber(person))) {
                if (PersonCustomer.find(person).count() > 0L) {
                    // empty if block
                }
                this.editFiscalInformation((Party)person, Country.readDefault(), "999999990");
                continue;
            }
            if ("999999990".equals(PersonCustomer.fiscalNumber(person))) {
                this.editFiscalInformation((Party)person, Country.readDefault(), PersonCustomer.fiscalNumber(person));
                continue;
            }
            if (FiscalCodeValidation.isValidFiscalNumber((String)Country.readDefault().getCode(), (String)PersonCustomer.fiscalNumber(person))) {
                this.editFiscalInformation((Party)person, Country.readDefault(), PersonCustomer.fiscalNumber(person));
                continue;
            }
            PhysicalAddress physicalAddress = PersonCustomer.physicalAddress(person);
            if (physicalAddress != null && physicalAddress.getCountryOfResidence() != null) {
                this.editFiscalInformation((Party)person, physicalAddress.getCountryOfResidence(), PersonCustomer.fiscalNumber(person));
                continue;
            }
            if (person.getFiscalCountry() != null) continue;
            this.editFiscalInformation((Party)person, Country.readDefault(), PersonCustomer.fiscalNumber(person));
        }
    }

    private void activateSeriesAndCreateNewForRegulation() {
        this.taskLog("activateSeries", new Object[0]);
        FinantialInstitution finantialInstitution = (FinantialInstitution)FinantialInstitution.findAll().findFirst().get();
        Series.find((FinantialInstitution)finantialInstitution).stream().filter(s -> Lists.newArrayList((Object[])new String[]{"INT", "LEG"}).contains(s.getCode())).forEach(s -> s.setSelectable(true));
        if (Series.findByCode((FinantialInstitution)finantialInstitution, (String)"REG") == null) {
            Series regulationSeries = Series.create((FinantialInstitution)finantialInstitution, (String)"REG", (LocalizedString)new LocalizedString(TreasuryConstants.DEFAULT_LANGUAGE, "Regulariza\u00e7\u00e3o"), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            finantialInstitution.setRegulationSeries(regulationSeries);
            DocumentNumberSeries.find((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (Series)regulationSeries).editReplacingPrefix(true, "NY");
            DocumentNumberSeries.find((FinantialDocumentType)FinantialDocumentType.findForCreditNote(), (Series)regulationSeries).editReplacingPrefix(true, "NZ");
        }
    }

    private void configureERPInFinantialInstitution() {
        this.taskLog("configureERPInFinantialInstitution", new Object[0]);
        FinantialInstitution finantialInstitution = (FinantialInstitution)FinantialInstitution.findAll().findFirst().get();
        ERPConfiguration erpConfiguration = finantialInstitution.getErpIntegrationConfiguration();
        erpConfiguration.setErpIdProcess("006");
        erpConfiguration.setImplementationClassName(SAPExternalService.class.getName());
    }

    private void createWebserviceForSAP() {
        this.taskLog("createWebserviceForSAP", new Object[0]);
        new WebServiceClientConfiguration(SAPExternalService.class.getName());
    }

    private void editFiscalInformation(Party party, Country fiscalCountry, String socialSecurityNumber) {
        PartySocialSecurityNumber partySocialSecurityNumber = party.getPartySocialSecurityNumber();
        if (partySocialSecurityNumber == null) {
            partySocialSecurityNumber = new PartySocialSecurityNumber();
            partySocialSecurityNumber.setParty(party);
        }
        partySocialSecurityNumber.setFiscalCountry(fiscalCountry);
        partySocialSecurityNumber.setSocialSecurityNumber(socialSecurityNumber);
    }
}

