/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.tariff;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff;
import org.fenixedu.academictreasury.domain.tuition.EctsCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.joda.time.LocalDate;

public class AcademicTariffBean
implements ITreasuryBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private LocalDate beginDate;
    private LocalDate endDate;
    private DueDateCalculationType dueDateCalculationType;
    private LocalDate fixedDueDate;
    private int numberOfDaysAfterCreationForDueDate;
    private boolean applyInterests;
    private InterestType interestType;
    private int numberOfDaysAfterDueDate;
    private boolean applyInFirstWorkday;
    private int maximumDaysToApplyPenalty;
    private BigDecimal interestFixedAmount;
    private BigDecimal rate;
    private AdministrativeOffice administrativeOffice;
    private DegreeType degreeType;
    private Degree degree;
    private CycleType cycleType;
    private BigDecimal baseAmount;
    private int unitsForBase;
    private boolean applyUnitsAmount;
    private BigDecimal unitAmount;
    private boolean applyPagesAmount;
    private BigDecimal pageAmount;
    private boolean applyMaximumAmount;
    private BigDecimal maximumAmount;
    private BigDecimal urgencyRate;
    private BigDecimal languageTranslationRate;
    private Product tuitionInstallmentProduct;
    private int installmentOrder;
    private TuitionCalculationType tuitionCalculationType;
    private BigDecimal fixedAmount;
    private EctsCalculationType ectsCalculationType;
    private boolean academicalActBlockingOn;
    private BigDecimal factor;
    private BigDecimal totalEctsOrUnits;
    private boolean blockAcademicActsOnDebt;
    private FinantialEntity finantialEntity;
    private Product emolumentProduct;
    private String sheetName;
    private List<TreasuryTupleDataSourceBean> tuitionCalculationTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> ectsCalculationTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> interestTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> dueDateCalculationTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> tuitionInstallmentProductDataSource = null;
    public boolean beanInfoFilled;

    public AcademicTariffBean() {
        this.setBeginDate(new LocalDate());
        this.setEndDate(new LocalDate().plusYears(1));
        this.setDueDateCalculationType(DueDateCalculationType.DAYS_AFTER_CREATION);
        this.setFixedDueDate(null);
        this.setNumberOfDaysAfterCreationForDueDate(0);
        this.setApplyInterests(false);
        this.setInterestType(InterestType.DAILY);
        this.setNumberOfDaysAfterDueDate(0);
        this.setApplyInFirstWorkday(false);
        this.setMaximumDaysToApplyPenalty(0);
        this.setInterestFixedAmount(BigDecimal.ZERO);
        this.setRate(BigDecimal.ZERO);
        this.setAdministrativeOffice(null);
        this.setDegreeType(null);
        this.setDegree(null);
        this.setCycleType(null);
        this.setBaseAmount(BigDecimal.ZERO);
        this.setUnitsForBase(0);
        this.setApplyUnitsAmount(false);
        this.setUnitAmount(BigDecimal.ZERO);
        this.setApplyPagesAmount(false);
        this.setPageAmount(BigDecimal.ZERO);
        this.setApplyMaximumAmount(false);
        this.setMaximumAmount(BigDecimal.ZERO);
        this.setUrgencyRate(BigDecimal.ZERO);
        this.setLanguageTranslationRate(BigDecimal.ZERO);
        this.resetFields();
    }

    public AcademicTariffBean(int installmentOrder) {
        this.setInstallmentOrder(installmentOrder);
    }

    public AcademicTariffBean(AcademicTariff academicTariff) {
        this.setBeginDate(academicTariff.getBeginDate().toLocalDate());
        this.setEndDate(academicTariff.getEndDate() != null ? academicTariff.getEndDate().toLocalDate() : null);
        this.setDueDateCalculationType(academicTariff.getDueDateCalculationType());
        this.setFixedDueDate(academicTariff.getFixedDueDate());
        this.setNumberOfDaysAfterCreationForDueDate(academicTariff.getNumberOfDaysAfterCreationForDueDate());
        this.setApplyInterests(academicTariff.getApplyInterests());
        this.setInterestType(academicTariff.isApplyInterests() ? academicTariff.getInterestRate().getInterestType() : null);
        this.setNumberOfDaysAfterDueDate(academicTariff.isApplyInterests() ? academicTariff.getInterestRate().getNumberOfDaysAfterDueDate() : 1);
        this.setApplyInFirstWorkday(academicTariff.isApplyInterests() ? academicTariff.getInterestRate().getApplyInFirstWorkday() : false);
        this.setMaximumDaysToApplyPenalty(academicTariff.isApplyInterests() ? academicTariff.getInterestRate().getMaximumDaysToApplyPenalty() : 0);
        this.setInterestFixedAmount(academicTariff.isApplyInterests() ? academicTariff.getInterestRate().getInterestFixedAmount() : null);
        this.setRate(academicTariff.isApplyInterests() ? academicTariff.getInterestRate().getRate() : null);
        this.setAdministrativeOffice(academicTariff.getAdministrativeOffice());
        this.setDegreeType(academicTariff.getDegreeType());
        this.setDegree(academicTariff.getDegree());
        this.setCycleType(academicTariff.getCycleType());
        this.setBaseAmount(academicTariff.getBaseAmount());
        this.setUnitsForBase(academicTariff.getUnitsForBase());
        this.setApplyUnitsAmount(academicTariff.isApplyUnitsAmount());
        this.setUnitAmount(academicTariff.getUnitAmount());
        this.setApplyPagesAmount(academicTariff.isApplyPagesAmount());
        this.setPageAmount(academicTariff.getPageAmount());
        this.setApplyMaximumAmount(academicTariff.isApplyMaximumAmount());
        this.setMaximumAmount(academicTariff.getMaximumAmount());
        this.setUrgencyRate(academicTariff.getUrgencyRate());
        this.setLanguageTranslationRate(academicTariff.getLanguageTranslationRate());
    }

    public AcademicTariffBean(TuitionInstallmentTariff tuitionInstallmentTariff) {
        this.setBeginDate(tuitionInstallmentTariff.getBeginDate().toLocalDate());
        this.setEndDate(tuitionInstallmentTariff.getEndDate() != null ? tuitionInstallmentTariff.getEndDate().toLocalDate() : null);
        this.setDueDateCalculationType(tuitionInstallmentTariff.getDueDateCalculationType());
        this.setFixedDueDate(tuitionInstallmentTariff.getFixedDueDate());
        this.setNumberOfDaysAfterCreationForDueDate(tuitionInstallmentTariff.getNumberOfDaysAfterCreationForDueDate());
        this.setApplyInterests(tuitionInstallmentTariff.getApplyInterests());
        this.setInterestType(tuitionInstallmentTariff.isApplyInterests() ? tuitionInstallmentTariff.getInterestRate().getInterestType() : null);
        this.setNumberOfDaysAfterDueDate(tuitionInstallmentTariff.isApplyInterests() ? tuitionInstallmentTariff.getInterestRate().getNumberOfDaysAfterDueDate() : 1);
        this.setApplyInFirstWorkday(tuitionInstallmentTariff.isApplyInterests() ? tuitionInstallmentTariff.getInterestRate().getApplyInFirstWorkday() : false);
        this.setMaximumDaysToApplyPenalty(tuitionInstallmentTariff.isApplyInterests() ? tuitionInstallmentTariff.getInterestRate().getMaximumDaysToApplyPenalty() : 0);
        this.setInterestFixedAmount(tuitionInstallmentTariff.isApplyInterests() ? tuitionInstallmentTariff.getInterestRate().getInterestFixedAmount() : null);
        this.setRate(tuitionInstallmentTariff.isApplyInterests() ? tuitionInstallmentTariff.getInterestRate().getRate() : null);
        this.setTuitionInstallmentProduct(tuitionInstallmentTariff.getProduct());
        this.setInstallmentOrder(tuitionInstallmentTariff.getInstallmentOrder());
        this.setTuitionCalculationType(tuitionInstallmentTariff.getTuitionCalculationType());
        this.setFixedAmount(tuitionInstallmentTariff.getFixedAmount());
        this.setEctsCalculationType(tuitionInstallmentTariff.getEctsCalculationType());
        this.setAcademicalActBlockingOn(!tuitionInstallmentTariff.getAcademicalActBlockingOff());
        this.setBlockAcademicActsOnDebt(tuitionInstallmentTariff.isBlockAcademicActsOnDebt());
        this.setFactor(tuitionInstallmentTariff.getFactor());
        this.setTotalEctsOrUnits(tuitionInstallmentTariff.getTotalEctsOrUnits());
        this.setApplyMaximumAmount(tuitionInstallmentTariff.isApplyMaximumAmount());
        this.setMaximumAmount(tuitionInstallmentTariff.getMaximumAmount());
        this.tuitionCalculationTypeDataSource = TuitionPaymentPlanBean.tuitionCalculationTypeDataSource();
        this.ectsCalculationTypeDataSource = TuitionPaymentPlanBean.ectsCalculationTypeDataSource();
        this.interestTypeDataSource = TuitionPaymentPlanBean.interestTypeDataSource();
        this.dueDateCalculationTypeDataSource = TuitionPaymentPlanBean.dueDateCalculationTypeDataSource();
        this.tuitionInstallmentProductDataSource = TuitionPaymentPlanBean.tuitionInstallmentProductDataSource(tuitionInstallmentTariff.getTuitionPaymentPlan().getTuitionPaymentPlanGroup(), tuitionInstallmentTariff.getProduct().getTuitionInstallmentOrder());
    }

    public void resetFields() {
        if (this.getDueDateCalculationType() == null || !this.getDueDateCalculationType().isDaysAfterCreation()) {
            this.setNumberOfDaysAfterCreationForDueDate(0);
        }
        if (this.getDueDateCalculationType() == null || !this.getDueDateCalculationType().isFixedDate() && !this.getDueDateCalculationType().isBestOfFixedDateAndDaysAfterCreation()) {
            this.setFixedDueDate(null);
        }
        if (this.getInterestType() == null) {
            this.setNumberOfDaysAfterCreationForDueDate(0);
            this.setApplyInFirstWorkday(false);
            this.setRate(BigDecimal.ZERO);
        }
        if (this.getInterestType() == null || !this.getInterestType().isDaily()) {
            this.setMaximumDaysToApplyPenalty(0);
        }
        if (this.getInterestType() == null || !this.getInterestType().isFixedAmount()) {
            this.setInterestFixedAmount(BigDecimal.ZERO);
        }
        if (this.getDegree() == null) {
            this.setCycleType(null);
        }
        if (this.getDegreeType() == null) {
            this.setDegree(null);
        }
        if (!this.isApplyUnitsAmount()) {
            this.setUnitAmount(BigDecimal.ZERO);
        }
        if (!this.isApplyPagesAmount()) {
            this.setPageAmount(BigDecimal.ZERO);
        }
        if (!this.isApplyMaximumAmount()) {
            this.setMaximumAmount(BigDecimal.ZERO);
        }
        if (this.getDueDateCalculationType() != null && (this.getDueDateCalculationType().isFixedDate() || this.getDueDateCalculationType().isBestOfFixedDateAndDaysAfterCreation()) && this.getFixedDueDate() == null) {
            this.setFixedDueDate(new LocalDate());
        }
        this.setBeanInfoFilled(false);
    }

    public BigDecimal getAmountPerEctsOrUnit() {
        if (this.getTuitionCalculationType().isFixedAmount()) {
            throw new RuntimeException("invalid call");
        }
        if (this.getEctsCalculationType().isFixedAmount()) {
            return this.getFixedAmount();
        }
        return BigDecimal.ZERO;
    }

    public boolean isMaximumDaysToApplyPenaltyApplied() {
        return this.getMaximumDaysToApplyPenalty() > 0;
    }

    public boolean isApplyUrgencyRate() {
        return AcademicTreasuryConstants.isPositive(this.getUrgencyRate());
    }

    public boolean isApplyLanguageTranslationRate() {
        return AcademicTreasuryConstants.isPositive(this.getLanguageTranslationRate());
    }

    public boolean isApplyBaseAmount() {
        return AcademicTreasuryConstants.isPositive(this.getBaseAmount());
    }

    public LocalDate getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(LocalDate beginDate) {
        this.beginDate = beginDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public DueDateCalculationType getDueDateCalculationType() {
        return this.dueDateCalculationType;
    }

    public void setDueDateCalculationType(DueDateCalculationType dueDateCalculationType) {
        this.dueDateCalculationType = dueDateCalculationType;
    }

    public LocalDate getFixedDueDate() {
        return this.fixedDueDate;
    }

    public void setFixedDueDate(LocalDate fixedDueDate) {
        this.fixedDueDate = fixedDueDate;
    }

    public int getNumberOfDaysAfterCreationForDueDate() {
        return this.numberOfDaysAfterCreationForDueDate;
    }

    public void setNumberOfDaysAfterCreationForDueDate(int numberOfDaysAfterCreationForDueDate) {
        this.numberOfDaysAfterCreationForDueDate = numberOfDaysAfterCreationForDueDate;
    }

    public boolean isApplyInterests() {
        return this.applyInterests;
    }

    public void setApplyInterests(boolean applyInterests) {
        this.applyInterests = applyInterests;
    }

    public boolean isApplyInFirstWorkday() {
        return this.applyInFirstWorkday;
    }

    public void setApplyInFirstWorkday(boolean applyInFirstWorkday) {
        this.applyInFirstWorkday = applyInFirstWorkday;
    }

    public AdministrativeOffice getAdministrativeOffice() {
        return this.administrativeOffice;
    }

    public void setAdministrativeOffice(AdministrativeOffice administrativeOffice) {
        this.administrativeOffice = administrativeOffice;
    }

    public DegreeType getDegreeType() {
        return this.degreeType;
    }

    public void setDegreeType(DegreeType degreeType) {
        this.degreeType = degreeType;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public CycleType getCycleType() {
        return this.cycleType;
    }

    public void setCycleType(CycleType cycleType) {
        this.cycleType = cycleType;
    }

    public BigDecimal getBaseAmount() {
        return this.baseAmount;
    }

    public void setBaseAmount(BigDecimal baseAmount) {
        this.baseAmount = baseAmount;
    }

    public int getUnitsForBase() {
        return this.unitsForBase;
    }

    public void setUnitsForBase(int unitsForBase) {
        this.unitsForBase = unitsForBase;
    }

    public boolean isApplyUnitsAmount() {
        return this.applyUnitsAmount;
    }

    public void setApplyUnitsAmount(boolean applyUnitsAmount) {
        this.applyUnitsAmount = applyUnitsAmount;
    }

    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public boolean isApplyPagesAmount() {
        return this.applyPagesAmount;
    }

    public void setApplyPagesAmount(boolean applyPagesAmount) {
        this.applyPagesAmount = applyPagesAmount;
    }

    public BigDecimal getPageAmount() {
        return this.pageAmount;
    }

    public void setPageAmount(BigDecimal pageAmount) {
        this.pageAmount = pageAmount;
    }

    public boolean isApplyMaximumAmount() {
        return this.applyMaximumAmount;
    }

    public void setApplyMaximumAmount(boolean applyMaximumAmount) {
        this.applyMaximumAmount = applyMaximumAmount;
    }

    public BigDecimal getMaximumAmount() {
        return this.maximumAmount;
    }

    public void setMaximumAmount(BigDecimal maximumAmount) {
        this.maximumAmount = maximumAmount;
    }

    public BigDecimal getUrgencyRate() {
        return this.urgencyRate;
    }

    public void setUrgencyRate(BigDecimal urgencyRate) {
        this.urgencyRate = urgencyRate;
    }

    public BigDecimal getLanguageTranslationRate() {
        return this.languageTranslationRate;
    }

    public void setLanguageTranslationRate(BigDecimal languageTranslationRate) {
        this.languageTranslationRate = languageTranslationRate;
    }

    public InterestType getInterestType() {
        return this.interestType;
    }

    public void setInterestType(InterestType interestType) {
        this.interestType = interestType;
    }

    public int getNumberOfDaysAfterDueDate() {
        return this.numberOfDaysAfterDueDate;
    }

    public void setNumberOfDaysAfterDueDate(int numberOfDaysAfterDueDate) {
        this.numberOfDaysAfterDueDate = numberOfDaysAfterDueDate;
    }

    public int getMaximumDaysToApplyPenalty() {
        return this.maximumDaysToApplyPenalty;
    }

    public void setMaximumDaysToApplyPenalty(int maximumDaysToApplyPenalty) {
        this.maximumDaysToApplyPenalty = maximumDaysToApplyPenalty;
    }

    public BigDecimal getInterestFixedAmount() {
        return this.interestFixedAmount;
    }

    public void setInterestFixedAmount(BigDecimal interestFixedAmount) {
        this.interestFixedAmount = interestFixedAmount;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public Product getTuitionInstallmentProduct() {
        return this.tuitionInstallmentProduct;
    }

    public void setTuitionInstallmentProduct(Product tuitionInstallmentProduct) {
        this.tuitionInstallmentProduct = tuitionInstallmentProduct;
    }

    public int getInstallmentOrder() {
        return this.installmentOrder;
    }

    public void setInstallmentOrder(int installmentOrder) {
        this.installmentOrder = installmentOrder;
    }

    public TuitionCalculationType getTuitionCalculationType() {
        return this.tuitionCalculationType;
    }

    public void setTuitionCalculationType(TuitionCalculationType tuitionCalculationType) {
        this.tuitionCalculationType = tuitionCalculationType;
    }

    public BigDecimal getFixedAmount() {
        return this.fixedAmount;
    }

    public void setFixedAmount(BigDecimal fixedAmount) {
        this.fixedAmount = fixedAmount;
    }

    public EctsCalculationType getEctsCalculationType() {
        return this.ectsCalculationType;
    }

    public void setEctsCalculationType(EctsCalculationType ectsCalculationType) {
        this.ectsCalculationType = ectsCalculationType;
    }

    public boolean isAcademicalActBlockingOff() {
        return !this.academicalActBlockingOn;
    }

    public boolean isAcademicalActBlockingOn() {
        return this.academicalActBlockingOn;
    }

    public void setAcademicalActBlockingOn(boolean academicalActBlockingOn) {
        this.academicalActBlockingOn = academicalActBlockingOn;
    }

    public boolean isBlockAcademicActsOnDebt() {
        return this.blockAcademicActsOnDebt;
    }

    public void setBlockAcademicActsOnDebt(boolean blockAcademicActsOnDebt) {
        this.blockAcademicActsOnDebt = blockAcademicActsOnDebt;
    }

    public BigDecimal getFactor() {
        return this.factor;
    }

    public void setFactor(BigDecimal factor) {
        this.factor = factor;
    }

    public BigDecimal getTotalEctsOrUnits() {
        return this.totalEctsOrUnits;
    }

    public void setTotalEctsOrUnits(BigDecimal totalEctsOrUnits) {
        this.totalEctsOrUnits = totalEctsOrUnits;
    }

    public FinantialEntity getFinantialEntity() {
        return this.finantialEntity;
    }

    public void setFinantialEntity(FinantialEntity finantialEntity) {
        this.finantialEntity = finantialEntity;
    }

    public Product getEmolumentProduct() {
        return this.emolumentProduct;
    }

    public void setEmolumentProduct(Product emolumentProduct) {
        this.emolumentProduct = emolumentProduct;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean isBeanInfoFilled() {
        return this.beanInfoFilled;
    }

    public void setBeanInfoFilled(boolean beanInfoFilled) {
        this.beanInfoFilled = beanInfoFilled;
    }
}

