/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.signals;

import com.google.common.eventbus.Subscribe;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.joda.time.LocalDate;

public class ImprovementEnrolmentHandler {
    @Subscribe
    public void improvementEnrolment(DomainObjectEvent<EnrolmentEvaluation> event) {
        EnrolmentEvaluation enrolmentEvaluation = (EnrolmentEvaluation)event.getInstance();
        LocalDate when = enrolmentEvaluation.getWhenDateTime().toLocalDate();
        FinantialEntity finantialEntity = AcademicTreasuryConstants.getFinantialEntityOfDegree(enrolmentEvaluation.getDegreeCurricularPlan().getDegree(), when);
        AcademicTaxServices.createImprovementTax(finantialEntity, enrolmentEvaluation, when);
    }
}

