/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tariff;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff$callable$create;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff$callable$delete;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff$callable$edit;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff_Base;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.InterestRateType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicTariff
extends AcademicTariff_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected AcademicTariff(FinantialEntity finantialEntity, Product product, AcademicTariffBean bean) {
        this.init(finantialEntity, product, bean);
    }

    protected void init(FinantialEntity finantialEntity, Product product, DateTime beginDate, DateTime endDate, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests, InterestRateType interestRateType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        throw new RuntimeException("wrong call");
    }

    protected void init(FinantialEntity finantialEntity, Product product, AcademicTariffBean bean) {
        super.init(finantialEntity, product, bean.getBeginDate().toDateTimeAtStartOfDay(), bean.getEndDate() != null ? bean.getEndDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1) : null, bean.getDueDateCalculationType(), bean.getFixedDueDate() != null ? bean.getFixedDueDate() : null, bean.getNumberOfDaysAfterCreationForDueDate(), bean.isApplyInterests(), bean.getInterestRateType(), bean.getNumberOfDaysAfterDueDate(), bean.isApplyInFirstWorkday(), bean.getMaximumDaysToApplyPenalty(), bean.getInterestFixedAmount(), bean.getRate());
        this.setBaseAmount(bean.getBaseAmount());
        this.setUnitsForBase(bean.getUnitsForBase());
        this.setUnitAmount(bean.getUnitAmount());
        this.setPageAmount(bean.getPageAmount());
        this.setMaximumAmount(bean.getMaximumAmount());
        this.setUrgencyRate(bean.getUrgencyRate());
        this.setLanguageTranslationRate(bean.getLanguageTranslationRate());
        this.getUnitsSet().addAll(bean.getUnits());
        this.setDegreeType(bean.getDegreeType());
        this.getAssociatedDegreesSet().addAll(bean.getAssociatedDegrees());
        this.setCycleType(bean.getCycleType());
        this.checkRules();
    }

    public boolean isApplyUnitsAmount() {
        return this.isPositive(this.getUnitAmount());
    }

    public boolean isApplyPagesAmount() {
        return this.isPositive(this.getPageAmount());
    }

    public boolean isApplyMaximumAmount() {
        return this.isPositive(this.getMaximumAmount());
    }

    public boolean isApplyUrgencyRate() {
        return this.isPositive(this.getUrgencyRate());
    }

    public boolean isApplyLanguageTranslationRate() {
        return this.isPositive(this.getLanguageTranslationRate());
    }

    public boolean isApplyBaseAmount() {
        return this.isPositive(this.getBaseAmount());
    }

    public void checkRules() {
        super.checkRules();
        if (this.getCycleType() != null && this.getAssociatedDegreesSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.degree.required", new String[0]);
        }
        if (this.getCycleType() != null && this.getAssociatedDegreesSet().size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.cycleType.requires.single.associatedDegree", new String[0]);
        }
        if (!this.getAssociatedDegreesSet().isEmpty() && this.getAssociatedDegreesSet().stream().anyMatch(d -> this.getDegreeType() != d.getDegreeType())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.degreeType.required", new String[0]);
        }
        if (this.getCycleType() != null && !this.getDegreeType().getCycleTypes().contains(this.getCycleType())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.cycleType.does.not.belong.degree.type", new String[0]);
        }
        if (this.getBaseAmount() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.baseAmount.required", new String[0]);
        }
        if (this.isNegative(this.getBaseAmount())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.baseAmount.negative", new String[0]);
        }
        if (this.getUnitsForBase() < 0) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.unitsForBase.negative", new String[0]);
        }
        if (this.getUnitAmount() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.unitAmount.required", new String[0]);
        }
        if (this.isNegative(this.getUnitAmount())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.unitAmount.negative", new String[0]);
        }
        if (this.getPageAmount() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.pageAmount.required", new String[0]);
        }
        if (this.isNegative(this.getPageAmount())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.pageAmount.negative", new String[0]);
        }
        if (this.getUrgencyRate() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.urgencyRate.required", new String[0]);
        }
        if (this.isNegative(this.getUrgencyRate())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.urgencyRate.negative", new String[0]);
        }
        if (this.getMaximumAmount() != null && this.isNegative(this.getMaximumAmount())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.maximumAmount.negative", new String[0]);
        }
        if (AcademicTreasuryConstants.HUNDRED_PERCENT.compareTo(this.getUrgencyRate()) < 0) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.urgencyRate.greater.than.hundred", new String[0]);
        }
        if (this.getLanguageTranslationRate() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.languageTranslationRate.required", new String[0]);
        }
        if (this.isNegative(this.getLanguageTranslationRate())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.languageTranslationRate.negative", new String[0]);
        }
        if (AcademicTreasuryConstants.HUNDRED_PERCENT.compareTo(this.getLanguageTranslationRate()) < 0) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.languageTranslationRate.greater.than.hundred", new String[0]);
        }
        if (this.getCycleType() != null) {
            this.checkDuplicatesOfCycleType();
        } else if (!this.getAssociatedDegreesSet().isEmpty()) {
            this.checkDuplicatesOfDegree();
        } else if (this.getDegreeType() != null && !this.getUnitsSet().isEmpty()) {
            this.checkDuplicatesOfDegreeTypeAndUnit();
        } else if (this.getDegreeType() != null && this.getUnitsSet().isEmpty()) {
            this.checkDuplicatesOfDegreeType();
        } else if (this.getDegreeType() == null && !this.getUnitsSet().isEmpty()) {
            this.checkDuplicatesOfUnit();
        } else {
            this.checkDuplicateOfFinantialEntity();
        }
    }

    private void checkDuplicateOfFinantialEntity() {
        boolean isDuplicate;
        boolean bl = isDuplicate = AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), this.getInterval()).filter(t -> t.getUnitsSet().isEmpty()).filter(t -> t.getDegreeType() == null).count() > 1L;
        if (isDuplicate) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.overlaps.with.other", this.getProduct().getName().getContent());
        }
    }

    private void checkDuplicatesOfDegreeTypeAndUnit() {
        Predicate<Unit> predicate = u -> AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), this.getDegreeType(), u, false, this.getInterval()).filter(t -> t.getAssociatedDegreesSet().isEmpty()).count() > 1L;
        this.getUnitsSet().forEach(unit -> {
            if (predicate.test((Unit)unit)) {
                throw new AcademicTreasuryDomainException("error.AcademicTariff.overlaps.with.other", this.getProduct().getName().getContent());
            }
        });
    }

    private void checkDuplicatesOfUnit() {
        Predicate<Unit> predicate = u -> AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), u, false, this.getInterval()).filter(t -> t.getDegreeType() == null).count() > 1L;
        this.getUnitsSet().forEach(unit -> {
            if (predicate.test((Unit)unit)) {
                throw new AcademicTreasuryDomainException("error.AcademicTariff.overlaps.with.other", this.getProduct().getName().getContent());
            }
        });
    }

    private void checkDuplicatesOfDegreeType() {
        Boolean isDuplicate = AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), this.getDegreeType(), this.getInterval()).filter(t -> t.getUnitsSet().isEmpty()).filter(t -> t.getAssociatedDegreesSet().isEmpty()).count() > 1L;
        if (isDuplicate.booleanValue()) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.overlaps.with.other", this.getProduct().getName().getContent());
        }
    }

    private void checkDuplicatesOfDegree() {
        Predicate<Degree> isDuplicatePredicate = degree -> AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), this.getDegreeType(), degree, this.getInterval()).filter(t -> t.getCycleType() == null).count() > 1L;
        this.getAssociatedDegreesSet().forEach(d -> {
            if (isDuplicatePredicate.test((Degree)d)) {
                throw new AcademicTreasuryDomainException("error.AcademicTariff.overlaps.with.other", this.getProduct().getName().getContent());
            }
        });
    }

    private void checkDuplicatesOfCycleType() {
        boolean isDuplicate;
        boolean bl = isDuplicate = AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), this.getDegreeType(), (Degree)this.getAssociatedDegreesSet().iterator().next(), this.getCycleType(), this.getInterval()).count() > 1L;
        if (isDuplicate) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.overlaps.with.other", this.getProduct().getName().getContent());
        }
    }

    public void edit(AcademicTariffBean academicTariffBean) {
        Object object = advice$edit.perform((Callable)new AcademicTariff$callable$edit(this, academicTariffBean));
    }

    static /* synthetic */ void advised$edit(AcademicTariff this_, AcademicTariffBean bean) {
        super.edit(bean.getBeginDate().toDateTimeAtStartOfDay(), bean.getEndDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1));
        if (bean.isApplyInterests() && this_.getInterestRate() == null) {
            InterestRate.createForTariff((Tariff)this_, (InterestRateType)bean.getInterestRateType(), (int)bean.getNumberOfDaysAfterDueDate(), (boolean)bean.isApplyInFirstWorkday(), (int)bean.getMaximumDaysToApplyPenalty(), (BigDecimal)bean.getInterestFixedAmount(), (BigDecimal)bean.getRate());
        } else if (bean.isApplyInterests()) {
            this_.getInterestRate().edit(bean.getInterestRateType(), bean.getNumberOfDaysAfterDueDate(), bean.isApplyInFirstWorkday(), bean.getMaximumDaysToApplyPenalty(), bean.getInterestFixedAmount(), bean.getRate());
        }
        super.setApplyInterests(bean.isApplyInterests());
        if (!this_.getApplyInterests() && this_.getInterestRate() != null) {
            this_.getInterestRate().delete();
        }
        this_.checkRules();
    }

    public boolean isDeletable() {
        return super.isDeletable();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AcademicTariff$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AcademicTariff this_) {
        this_.setDegreeType(null);
        this_.getAssociatedDegreesSet().clear();
        this_.getUnitsSet().clear();
        super.delete();
    }

    public BigDecimal amountToPay() {
        return this.getBaseAmount();
    }

    public BigDecimal amountToPay(AcademicTreasuryEvent academicTreasuryEvent) {
        int numberOfUnits = academicTreasuryEvent.getNumberOfUnits();
        int numberOfPages = academicTreasuryEvent.getNumberOfPages();
        Locale language = academicTreasuryEvent.getLanguage();
        boolean urgentRequest = academicTreasuryEvent.isUrgentRequest();
        return this.amountToPay(numberOfUnits, numberOfPages, language, urgentRequest);
    }

    public BigDecimal amountToPay(int numberOfUnits, int numberOfPages, boolean applyLanguageRate, boolean urgentRequest) {
        BigDecimal amount = this.amountWithLanguageRate(numberOfUnits, numberOfPages, applyLanguageRate);
        if (this.isApplyUrgencyRate() && urgentRequest) {
            amount = amount.add(this.amountForUrgencyRate(numberOfUnits, numberOfPages, applyLanguageRate));
        }
        return amount;
    }

    public BigDecimal amountToPay(int numberOfUnits, int numberOfPages, Locale language, boolean urgentRequest) {
        BigDecimal amount = this.amountWithLanguageRate(numberOfUnits, numberOfPages, language);
        if (this.isApplyUrgencyRate() && urgentRequest) {
            amount = amount.add(this.amountForUrgencyRate(numberOfUnits, numberOfPages, language));
        }
        return amount;
    }

    public BigDecimal amountForUrgencyRate(int numberOfUnits, int numberOfPages, boolean applyLanguageRate) {
        BigDecimal amount = this.amountWithLanguageRate(numberOfUnits, numberOfPages, applyLanguageRate);
        return amount.multiply(this.getUrgencyRate().setScale(20, RoundingMode.HALF_EVEN).divide(AcademicTreasuryConstants.HUNDRED_PERCENT).setScale(2, RoundingMode.HALF_EVEN));
    }

    public BigDecimal amountForUrgencyRate(int numberOfUnits, int numberOfPages, Locale language) {
        BigDecimal amount = this.amountWithLanguageRate(numberOfUnits, numberOfPages, language);
        return amount.multiply(this.getUrgencyRate().setScale(20, RoundingMode.HALF_EVEN).divide(AcademicTreasuryConstants.HUNDRED_PERCENT).setScale(2, RoundingMode.HALF_EVEN));
    }

    public BigDecimal amountForLanguageTranslationRate(int numberOfUnits, int numberOfPages) {
        BigDecimal amount = this.amountToPayWithoutRates(numberOfUnits, numberOfPages);
        BigDecimal result = amount.multiply(this.getLanguageTranslationRate().setScale(20, RoundingMode.HALF_EVEN).divide(AcademicTreasuryConstants.HUNDRED_PERCENT).setScale(2, RoundingMode.HALF_EVEN));
        return this.isPositive(result) ? result : BigDecimal.ZERO;
    }

    public BigDecimal amountToPay(int numberOfUnits, int numberOfPages) {
        BigDecimal amount = this.getBaseAmount();
        if (this.isApplyUnitsAmount()) {
            int remainingUnits;
            int n = remainingUnits = numberOfUnits - this.getUnitsForBase() >= 0 ? numberOfUnits - this.getUnitsForBase() : 0;
            if (remainingUnits > 0) {
                amount = amount.add(this.getUnitAmount().multiply(new BigDecimal(remainingUnits)));
            }
        }
        if (this.isApplyPagesAmount()) {
            amount = amount.add(this.getPageAmount().multiply(new BigDecimal(numberOfPages)));
        }
        if (this.isApplyMaximumAmount() && this.isGreaterThan(amount, this.getMaximumAmount())) {
            amount = this.getMaximumAmount();
        }
        return amount;
    }

    public BigDecimal amountToPayWithoutRates(int numberOfUnits, int numberOfPages) {
        int remainingUnits;
        BigDecimal amount = this.getBaseAmount();
        if (this.isApplyUnitsAmount() && (remainingUnits = this.numberOfAdditionalUnits(numberOfUnits)) > 0) {
            amount = amount.add(this.amountForAdditionalUnits(numberOfUnits));
        }
        if (this.isApplyPagesAmount()) {
            amount = amount.add(this.amountForPages(numberOfPages));
        }
        if (this.isApplyMaximumAmount() && this.isGreaterThan(amount, this.getMaximumAmount())) {
            amount = this.getMaximumAmount();
        }
        return amount;
    }

    public BigDecimal amountForPages(int numberOfPages) {
        BigDecimal result = this.getPageAmount().multiply(new BigDecimal(numberOfPages));
        return this.isPositive(result) ? result : BigDecimal.ZERO;
    }

    public BigDecimal amountForAdditionalUnits(int numberOfUnits) {
        int remainingUnits = this.numberOfAdditionalUnits(numberOfUnits);
        BigDecimal result = this.getUnitAmount().multiply(new BigDecimal(remainingUnits));
        return this.isPositive(result) ? result : BigDecimal.ZERO;
    }

    public int numberOfAdditionalUnits(int numberOfUnits) {
        int result = numberOfUnits - this.getUnitsForBase();
        return result >= 0 ? result : 0;
    }

    public BigDecimal amountToPay(AcademicTreasuryEvent academicTreasuryEvent, EnrolmentEvaluation enrolmentEvaluation) {
        return this.getBaseAmount();
    }

    public Vat vat(LocalDate when) {
        return (Vat)Vat.findActiveUnique((VatType)this.getProduct().getVatType(), (FinantialInstitution)this.getFinantialEntity().getFinantialInstitution(), (DateTime)new DateTime()).get();
    }

    public LocalizedString academicServiceRequestDebitEntryName(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return AcademicTreasuryEvent.nameForAcademicServiceRequest(this.getProduct(), iTreasuryServiceRequest);
    }

    public LocalizedString academicTaxDebitEntryName(AcademicTreasuryEvent academicTreasuryEvent) {
        if (!academicTreasuryEvent.isForAcademicTax()) {
            throw new RuntimeException("wrong call");
        }
        return AcademicTreasuryEvent.nameForAcademicTax(academicTreasuryEvent.getAcademicTax(), academicTreasuryEvent.getRegistration(), academicTreasuryEvent.getExecutionYear());
    }

    public static LocalizedString improvementDebitEntryName(AcademicTax improvementAcademicTax, EnrolmentEvaluation enrolmentEvaluation) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        Registration registration = enrolmentEvaluation.getEnrolment().getRegistration();
        ExecutionYear executionYear = enrolmentEvaluation.getExecutionPeriod().getExecutionYear();
        LocalizedString result = new LocalizedString();
        for (Locale locale : treasuryServices.availableLocales()) {
            String enrolmentName = enrolmentEvaluation.getEnrolment().getName().getContent(locale);
            String executionIntervalName = enrolmentEvaluation.getExecutionPeriod().getQualifiedName();
            String academicTreasuryEventDescription = AcademicTreasuryEvent.nameForAcademicTax(improvementAcademicTax, registration, executionYear).getContent(locale);
            result = result.with(locale, academicTreasuryEventDescription + String.format(" (%s - %s)", enrolmentName, executionIntervalName));
        }
        return result;
    }

    public DebitEntry createDebitEntryForAcademicServiceRequest(DebtAccount debtAccoubt, AcademicTreasuryEvent academicTreasuryEvent) {
        LocalDate when = academicTreasuryEvent.getRequestDate();
        return this.createDebitEntryForAcademicServiceRequest(debtAccoubt, academicTreasuryEvent, when);
    }

    public DebitEntry createDebitEntryForAcademicServiceRequest(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        if (!academicTreasuryEvent.isForAcademicServiceRequest()) {
            throw new RuntimeException("wrong call");
        }
        BigDecimal amount = this.amountToPay(academicTreasuryEvent);
        LocalDate dueDate = this.dueDate(when);
        if (DueDateCalculationType.FIXED_DATE == this.getDueDateCalculationType() && dueDate.isBefore((ReadablePartial)when)) {
            when = dueDate;
        }
        LocalizedString debitEntryName = this.academicServiceRequestDebitEntryName(academicTreasuryEvent.getITreasuryServiceRequest());
        Vat vat = this.vat(when);
        this.updatePriceValuesInEvent(academicTreasuryEvent);
        Map<String, String> fillPriceProperties = this.fillPriceCommonPropertiesForAcademicServiceRequest(debtAccount, academicTreasuryEvent, when);
        return DebitEntry.create((FinantialEntity)this.getFinantialEntity(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)debitEntryName.getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay(), (boolean)false, (boolean)false, null);
    }

    public DebitEntry createDebitEntryForAcademicTax(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent) {
        LocalDate when = academicTreasuryEvent.getRequestDate();
        return this.createDebitEntryForAcademicTax(debtAccount, academicTreasuryEvent, when);
    }

    public DebitEntry createDebitEntryForAcademicTax(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        if (!academicTreasuryEvent.isForAcademicTax() || academicTreasuryEvent.isImprovementTax()) {
            throw new RuntimeException("wrong call");
        }
        LocalDate dueDate = this.dueDate(when);
        if (DueDateCalculationType.FIXED_DATE == this.getDueDateCalculationType() && dueDate.isBefore((ReadablePartial)when)) {
            when = dueDate;
        }
        LocalizedString debitEntryName = this.academicTaxDebitEntryName(academicTreasuryEvent);
        Vat vat = this.vat(when);
        BigDecimal amount = this.amountToPay(academicTreasuryEvent);
        this.updatePriceValuesInEvent(academicTreasuryEvent);
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForAcademicTax(debtAccount, academicTreasuryEvent, when);
        return DebitEntry.create((FinantialEntity)this.getFinantialEntity(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)debitEntryName.getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay(), (boolean)false, (boolean)false, null);
    }

    public DebitEntry createDebitEntryForCustomAcademicDebt(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        if (!academicTreasuryEvent.isForCustomAcademicDebt()) {
            throw new RuntimeException("wrong call");
        }
        LocalDate dueDate = this.dueDate(when);
        if (DueDateCalculationType.FIXED_DATE == this.getDueDateCalculationType() && dueDate.isBefore((ReadablePartial)when)) {
            when = dueDate;
        }
        LocalizedString debitEntryName = AcademicTreasuryEvent.nameForCustomAcademicDebt(academicTreasuryEvent.getProduct(), academicTreasuryEvent.getRegistration(), academicTreasuryEvent.getExecutionYear());
        Vat vat = this.vat(when);
        BigDecimal amount = this.amountToPay(academicTreasuryEvent);
        if (!TreasuryConstants.isPositive((BigDecimal)amount)) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.createDebitEntryForCustomAcademicDebt.amount.to.pay.not.positive", new String[0]);
        }
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForAcademicTax(debtAccount, academicTreasuryEvent, when);
        return DebitEntry.create((FinantialEntity)this.getFinantialEntity(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)debitEntryName.getContent(), (BigDecimal)TreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay(), (boolean)false, (boolean)false, null);
    }

    public DebitEntry createDebitEntryForImprovement(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, EnrolmentEvaluation enrolmentEvaluation) {
        return this.createDebitEntryForImprovement(debtAccount, academicTreasuryEvent, enrolmentEvaluation, enrolmentEvaluation.getWhenDateTime().toLocalDate());
    }

    public DebitEntry createDebitEntryForImprovement(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, EnrolmentEvaluation enrolmentEvaluation, LocalDate when) {
        if (!academicTreasuryEvent.isForImprovementTax()) {
            throw new RuntimeException("wrong call");
        }
        LocalizedString debitEntryName = AcademicTariff.improvementDebitEntryName(academicTreasuryEvent.getAcademicTax(), enrolmentEvaluation);
        LocalDate dueDate = this.dueDate(when);
        if (DueDateCalculationType.FIXED_DATE == this.getDueDateCalculationType() && dueDate.isBefore((ReadablePartial)when)) {
            when = dueDate;
        }
        Vat vat = this.vat(when);
        BigDecimal amount = this.amountToPay(academicTreasuryEvent, enrolmentEvaluation);
        this.updatePriceValuesInEvent(academicTreasuryEvent, enrolmentEvaluation);
        Map<String, String> fillPriceProperties = this.fillPriceProperties(academicTreasuryEvent, enrolmentEvaluation);
        DebitEntry debitEntry = DebitEntry.create((FinantialEntity)this.getFinantialEntity(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)debitEntryName.getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)new DateTime(), (boolean)false, (boolean)false, null);
        academicTreasuryEvent.associateEnrolmentEvaluation(debitEntry, enrolmentEvaluation);
        return debitEntry;
    }

    public DebitEntry createDebitEntryForTuition(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        LocalDate dueDate = this.dueDate(when);
        if (DueDateCalculationType.FIXED_DATE == this.getDueDateCalculationType() && dueDate.isBefore((ReadablePartial)when)) {
            when = dueDate;
        }
        LocalizedString debitEntryName = tuitionPaymentPlanGroup.buildDebitEntryDescription(this.getProduct(), academicTreasuryEvent.getRegistration(), academicTreasuryEvent.getExecutionYear());
        Vat vat = this.vat(when);
        BigDecimal amount = this.amountToPay(academicTreasuryEvent);
        if (!TreasuryConstants.isPositive((BigDecimal)amount)) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.createDebitEntryForCustomAcademicDebt.amount.to.pay.not.positive", new String[0]);
        }
        Map<String, String> fillPriceProperties = this.fillPriceCommonProperties(debtAccount, academicTreasuryEvent, when);
        DebitEntry debitEntry = DebitEntry.create((FinantialEntity)this.getFinantialEntity(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)debitEntryName.getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)new DateTime(), (boolean)false, (boolean)false, null);
        return debitEntry;
    }

    public boolean isBroadTariffForFinantialEntity() {
        return this.getUnitsSet().isEmpty() && this.getDegreeType() == null && this.getAssociatedDegreesSet().isEmpty() && this.getCycleType() == null;
    }

    private void updatePriceValuesInEvent(AcademicTreasuryEvent academicTreasuryEvent, EnrolmentEvaluation enrolmentEvaluation) {
        BigDecimal baseAmount = this.getBaseAmount();
        academicTreasuryEvent.updatePricingFields(baseAmount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private void updatePriceValuesInEvent(AcademicTreasuryEvent academicTreasuryEvent) {
        BigDecimal baseAmount = this.getBaseAmount();
        BigDecimal amountForAdditionalUnits = this.amountForAdditionalUnits(academicTreasuryEvent.getNumberOfUnits());
        BigDecimal amountForPages = this.amountForPages(academicTreasuryEvent.getNumberOfPages());
        BigDecimal maximumAmount = this.getMaximumAmount();
        BigDecimal amountForLanguageTranslationRate = this.amountForLanguageTranslationRate(academicTreasuryEvent.getNumberOfUnits(), academicTreasuryEvent.getNumberOfPages());
        BigDecimal amountForUrgencyRate = this.amountForUrgencyRate(academicTreasuryEvent.getNumberOfUnits(), academicTreasuryEvent.getNumberOfPages(), academicTreasuryEvent.getLanguage());
        academicTreasuryEvent.updatePricingFields(baseAmount, amountForAdditionalUnits, amountForPages, maximumAmount, amountForLanguageTranslationRate, amountForUrgencyRate);
    }

    private Map<String, String> fillPriceCommonPropertiesForAcademicServiceRequest(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.putAll(this.fillPriceCommonProperties(debtAccount, academicTreasuryEvent, when));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), academicTreasuryEvent.getITreasuryServiceRequest().getRegistration().getDegree().getPresentationName(academicTreasuryEvent.getITreasuryServiceRequest().getExecutionYear()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), academicTreasuryEvent.getITreasuryServiceRequest().getRegistration().getDegree().getCode());
        if (academicTreasuryEvent.getITreasuryServiceRequest().hasExecutionYear()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent(), academicTreasuryEvent.getITreasuryServiceRequest().getExecutionYear().getQualifiedName());
        }
        return propertiesMap;
    }

    private Map<String, String> fillPricePropertiesForAcademicTax(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.putAll(this.fillPriceCommonProperties(debtAccount, academicTreasuryEvent, when));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent(), academicTreasuryEvent.getExecutionYear().getQualifiedName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), academicTreasuryEvent.getRegistration().getDegree().getPresentationName(academicTreasuryEvent.getExecutionYear()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CURRICULAR_PLAN.getDescriptionI18N().getContent(), academicTreasuryEvent.getRegistration().getDegreeCurricularPlanName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), academicTreasuryEvent.getRegistration().getDegree().getCode());
        return propertiesMap;
    }

    private Map<String, String> fillPriceCommonProperties(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        HashMap propertiesMap = Maps.newHashMap();
        Currency currency = debtAccount.getFinantialInstitution().getCurrency();
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.BASE_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.getBaseAmount()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.UNITS_FOR_BASE.getDescriptionI18N().getContent(), String.valueOf(this.getUnitsForBase()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.UNIT_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.getUnitAmount()).toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ADDITIONAL_UNITS.getDescriptionI18N().getContent(), String.valueOf(this.numberOfAdditionalUnits(academicTreasuryEvent.getNumberOfUnits())));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_UNITS_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.amountForAdditionalUnits(academicTreasuryEvent.getNumberOfUnits())));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.PAGE_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.getPageAmount()).toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.NUMBER_OF_PAGES.getDescriptionI18N().getContent(), String.valueOf(academicTreasuryEvent.getNumberOfPages()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_PAGES_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.amountForPages(academicTreasuryEvent.getNumberOfPages())));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.MAXIMUM_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.getMaximumAmount()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FOREIGN_LANGUAGE_RATE.getDescriptionI18N().getContent(), this.getLanguageTranslationRate().toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_FOREIGN_LANGUAGE_RATE.getDescriptionI18N().getContent(), currency.getValueFor(this.amountForLanguageTranslationRate(academicTreasuryEvent.getNumberOfUnits(), academicTreasuryEvent.getNumberOfPages())));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.URGENT_PERCENTAGE.getDescriptionI18N().getContent(), this.getUrgencyRate().toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_URGENT_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.amountForUrgencyRate(academicTreasuryEvent.getNumberOfUnits(), academicTreasuryEvent.getNumberOfPages(), academicTreasuryEvent.getLanguage())));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.amountToPay(academicTreasuryEvent)));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.USED_DATE.getDescriptionI18N().getContent(), when.toString("dd/MM/yyyy"));
        return propertiesMap;
    }

    private Map<String, String> fillPriceProperties(AcademicTreasuryEvent academicTreasuryEvent, EnrolmentEvaluation improvementEnrolmentEvaluation) {
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.BASE_AMOUNT.getDescriptionI18N().getContent(), this.getBaseAmount().toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.amountToPay(academicTreasuryEvent).toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ENROLMENT.getDescriptionI18N().getContent(), improvementEnrolmentEvaluation.getEnrolment().getName().getContent());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CURRICULAR_PLAN.getDescriptionI18N().getContent(), improvementEnrolmentEvaluation.getDegreeCurricularPlan().getName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), improvementEnrolmentEvaluation.getDegreeCurricularPlan().getDegree().getPresentationName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.EXECUTION_SEMESTER.getDescriptionI18N().getContent(), improvementEnrolmentEvaluation.getExecutionPeriod().getQualifiedName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.EVALUATION_SEASON.getDescriptionI18N().getContent(), improvementEnrolmentEvaluation.getEvaluationSeason().getName().getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE));
        return propertiesMap;
    }

    private BigDecimal amountWithLanguageRate(int numberOfUnits, int numberOfPages, boolean applyLanguageRate) {
        BigDecimal amount = this.amountToPayWithoutRates(numberOfUnits, numberOfPages);
        if (this.isApplyLanguageTranslationRate() && applyLanguageRate) {
            amount = amount.add(this.amountForLanguageTranslationRate(numberOfUnits, numberOfPages));
        }
        return amount;
    }

    private BigDecimal amountWithLanguageRate(int numberOfUnits, int numberOfPages, Locale language) {
        BigDecimal amount = this.amountToPayWithoutRates(numberOfUnits, numberOfPages);
        if (this.isApplyLanguageTranslationRate() && AcademicTreasuryConstants.isForeignLanguage(language)) {
            amount = amount.add(this.amountForLanguageTranslationRate(numberOfUnits, numberOfPages));
        }
        return amount;
    }

    public static AcademicTariff create(FinantialEntity finantialEntity, Product product, AcademicTariffBean academicTariffBean) {
        return (AcademicTariff)((Object)advice$create.perform((Callable)new AcademicTariff$callable$create(finantialEntity, product, academicTariffBean)));
    }

    static /* synthetic */ AcademicTariff advised$create(FinantialEntity finantialEntity, Product product, AcademicTariffBean bean) {
        return new AcademicTariff(finantialEntity, product, bean);
    }

    public static Stream<? extends AcademicTariff> findAll() {
        return Tariff.findAll().filter(t -> t instanceof AcademicTariff).map(AcademicTariff.class::cast);
    }

    public static Stream<? extends AcademicTariff> find(Product product) {
        return product.getTariffSet().stream().filter(t -> t instanceof AcademicTariff).map(AcademicTariff.class::cast);
    }

    public static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity) {
        return finantialEntity.getTariffSet().stream().filter(t -> t instanceof AcademicTariff).map(AcademicTariff.class::cast);
    }

    public static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product) {
        return AcademicTariff.find(product).filter(t -> t.getFinantialEntity() == finantialEntity);
    }

    private static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product, DegreeType degreeType) {
        if (degreeType == null) {
            throw new RuntimeException("degree type is null. wrong find call");
        }
        return AcademicTariff.find(finantialEntity, product).filter(i -> degreeType == i.getDegreeType());
    }

    private static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product, Unit unit, boolean isSubUnit) {
        if (unit == null) {
            throw new RuntimeException("unit is null. wrong find call");
        }
        Predicate<AcademicTariff> unitPredicate = tariff -> !tariff.getUnitsSet().isEmpty() && (tariff.getUnitsSet().contains(unit) || isSubUnit && unit.isSubUnitOf((Collection)tariff.getUnitsSet()));
        return AcademicTariff.find(finantialEntity, product).filter(unitPredicate);
    }

    private static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Unit unit, boolean isSubUnit) {
        if (degreeType == null) {
            throw new RuntimeException("degree type is null. wrong find call");
        }
        if (unit == null) {
            throw new RuntimeException("unit is null. wrong find call");
        }
        Predicate<AcademicTariff> unitPredicate = tariff -> !tariff.getUnitsSet().isEmpty() && (tariff.getUnitsSet().contains(unit) || isSubUnit && unit.isSubUnitOf((Collection)tariff.getUnitsSet()));
        return AcademicTariff.find(finantialEntity, product).filter(i -> i.getDegreeType() == degreeType).filter(unitPredicate);
    }

    private static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Degree degree) {
        if (degree == null) {
            throw new RuntimeException("degree is null. wrong find call");
        }
        return AcademicTariff.find(finantialEntity, product, degreeType).filter(t -> t.getAssociatedDegreesSet().contains(degree));
    }

    private static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Degree degree, CycleType cycleType) {
        if (cycleType == null) {
            throw new RuntimeException("cycle is null. wrong find call");
        }
        return AcademicTariff.find(finantialEntity, product, degreeType, degree).filter(t -> t.getCycleType() == cycleType);
    }

    public static Stream<? extends AcademicTariff> findActive(DateTime when) {
        return AcademicTariff.findAll().filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, DateTime when) {
        return AcademicTariff.find(finantialEntity).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, DateTime when) {
        return AcademicTariff.find(finantialEntity, product).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, DegreeType degreeType, DateTime when) {
        return AcademicTariff.find(finantialEntity, product, degreeType).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, Unit unit, boolean isSubUnit, DateTime when) {
        return AcademicTariff.find(finantialEntity, product, unit, isSubUnit).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Unit unit, boolean isSubUnit, DateTime when) {
        return AcademicTariff.find(finantialEntity, product, degreeType, unit, isSubUnit).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Degree degree, DateTime when) {
        return AcademicTariff.find(finantialEntity, product, degreeType, degree).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Degree degree, CycleType cycleType, DateTime when) {
        return AcademicTariff.find(finantialEntity, product, degreeType, degree, cycleType).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findInInterval(Interval interval) {
        return AcademicTariff.findAll().filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Interval interval) {
        return AcademicTariff.find(finantialEntity).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, Interval interval) {
        return AcademicTariff.find(finantialEntity, product).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Interval interval) {
        return AcademicTariff.find(finantialEntity, product).filter(i -> degreeType == i.getDegreeType()).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, Unit unit, boolean isSubUnit, Interval interval) {
        return AcademicTariff.find(finantialEntity, product, unit, isSubUnit).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Unit unit, boolean isSubUnit, Interval interval) {
        return AcademicTariff.find(finantialEntity, product, degreeType, unit, isSubUnit).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Degree degree, Interval interval) {
        return AcademicTariff.find(finantialEntity, product).filter(i -> degreeType == i.getDegreeType()).filter(t -> t.getAssociatedDegreesSet().contains(degree)).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Degree degree, CycleType cycleType, Interval interval) {
        return AcademicTariff.find(finantialEntity, product).filter(i -> degreeType == i.getDegreeType()).filter(t -> t.getAssociatedDegreesSet().contains(degree)).filter(t -> t.getCycleType() == cycleType).filter(t -> t.isActive(interval));
    }

    public static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, DateTime when) {
        if (product == null) {
            throw new RuntimeException("product is null. wrong findMatch call");
        }
        if (finantialEntity == null) {
            throw new RuntimeException("finantial entity is null. wrong findMatch call");
        }
        Set activeTariffs = AcademicTariff.findActive(finantialEntity, product, when).filter(e -> e.getUnitsSet().isEmpty()).filter(e -> e.getDegreeType() == null).filter(e -> e.getAssociatedDegreesSet().isEmpty()).filter(e -> e.getCycleType() == null).collect(Collectors.toSet());
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (!activeTariffs.isEmpty()) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        return null;
    }

    protected static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, DegreeType degreeType, DateTime when) {
        if (degreeType == null) {
            throw new RuntimeException("degreeType is null. wrong findMatch call");
        }
        Set activeTariffs = AcademicTariff.findActive(finantialEntity, product, degreeType, when).filter(e -> e.getUnitsSet().isEmpty()).filter(e -> e.getAssociatedDegreesSet().isEmpty()).filter(e -> e.getCycleType() == null).collect(Collectors.toSet());
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        return AcademicTariff.findMatch(finantialEntity, product, when);
    }

    protected static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, Unit unit, DateTime when) {
        if (unit == null) {
            throw new RuntimeException("unit is null. wrong findMatch call");
        }
        Function<Boolean, Set> func = isSubUnit -> AcademicTariff.findActive(finantialEntity, product, unit, isSubUnit, when).filter(e -> e.getDegreeType() == null).filter(e -> e.getAssociatedDegreesSet().isEmpty()).filter(e -> e.getCycleType() == null).collect(Collectors.toSet());
        Set activeTariffs = func.apply(false);
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        activeTariffs = func.apply(true);
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        return AcademicTariff.findMatch(finantialEntity, product, when);
    }

    protected static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, DegreeType degreeType, Unit unit, DateTime when) {
        if (degreeType == null) {
            throw new RuntimeException("degreeType is null. wrong findMatch call");
        }
        if (unit == null) {
            throw new RuntimeException("unit is null. wrong findMatch call");
        }
        Function<Boolean, Set> func = isSubUnit -> AcademicTariff.findActive(finantialEntity, product, degreeType, unit, false, when).filter(e -> e.getAssociatedDegreesSet().isEmpty()).filter(e -> e.getCycleType() == null).collect(Collectors.toSet());
        Set activeTariffs = func.apply(false);
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        activeTariffs = func.apply(true);
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        Set activeTariffsByDegreeType = AcademicTariff.findActive(finantialEntity, product, degreeType, when).filter(e -> e.getUnitsSet().isEmpty()).filter(e -> e.getAssociatedDegreesSet().isEmpty()).filter(e -> e.getCycleType() == null).collect(Collectors.toSet());
        if (activeTariffsByDegreeType.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffsByDegreeType.size() == 1) {
            return (AcademicTariff)((Object)activeTariffsByDegreeType.iterator().next());
        }
        return AcademicTariff.findMatch(finantialEntity, product, unit, when);
    }

    public static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, Degree degree, DateTime when) {
        if (degree == null) {
            throw new RuntimeException("degree is null. wrong findMatch call");
        }
        DegreeType degreeType = degree.getDegreeType();
        Unit unit = degree.getUnit();
        Set activeTariffs = AcademicTariff.findActive(finantialEntity, product, degreeType, degree, when).filter(e -> e.getCycleType() == null).collect(Collectors.toSet());
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        if (unit != null) {
            return AcademicTariff.findMatch(finantialEntity, product, degreeType, unit, when);
        }
        return AcademicTariff.findMatch(finantialEntity, product, degreeType, when);
    }

    public static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, Degree degree, CycleType cycleType, DateTime when) {
        if (degree == null || cycleType == null) {
            throw new RuntimeException("degree or cycle type is null. wrong findMatch call");
        }
        DegreeType degreeType = degree.getDegreeType();
        Set activeTariffs = AcademicTariff.findActive(finantialEntity, product, degreeType, degree, cycleType, when).collect(Collectors.toSet());
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        return AcademicTariff.findMatch(finantialEntity, product, degree, when);
    }
}

