/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.coursefunctioncost.CourseFunctionCost;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.ITuitionRegistrationServiceParameters;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff$callable$edit;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff_Base;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.domain.tuition.TuitionTariffCalculatedAmountType;
import org.fenixedu.academictreasury.domain.tuition.TuitionTariffCustomCalculator;
import org.fenixedu.academictreasury.domain.tuition.calculators.TuitionPaymentPlanCalculator;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.InterestRateType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TuitionInstallmentTariff
extends TuitionInstallmentTariff_Base {
    public static final Comparator<? super TuitionInstallmentTariff> COMPARATOR_BY_INSTALLMENT_NUMBER;
    public static final Advice advice$edit;

    protected TuitionInstallmentTariff() {
    }

    protected TuitionInstallmentTariff(FinantialEntity finantialEntity, TuitionPaymentPlan tuitionPaymentPlan, AcademicTariffBean bean) {
        this();
        this.init(finantialEntity, tuitionPaymentPlan, bean);
    }

    public TuitionInstallmentTariff(TuitionInstallmentTariff t, TuitionPaymentPlan copyOfTuitionPaymentPlan, Map<TuitionPaymentPlanCalculator, TuitionPaymentPlanCalculator> calculatorsCopyMap) {
        this();
        this.setTuitionPaymentPlan(copyOfTuitionPaymentPlan);
        this.init(t, calculatorsCopyMap);
    }

    protected void init(FinantialEntity finantialEntity, Product product, DateTime beginDate, DateTime endDate, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests, InterestRateType interestRateType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        throw new RuntimeException("wrong call");
    }

    protected void init(FinantialEntity finantialEntity, TuitionPaymentPlan tuitionPaymentPlan, AcademicTariffBean bean) {
        Product product = bean.getTuitionInstallmentProduct();
        if (product == null && (tuitionPaymentPlan.getTuitionPaymentPlanGroup().isForStandalone() || tuitionPaymentPlan.getTuitionPaymentPlanGroup().isForExtracurricular())) {
            product = tuitionPaymentPlan.getProduct();
        }
        super.init(finantialEntity, product, bean.getBeginDate().toDateTimeAtStartOfDay(), bean.getEndDate() != null ? bean.getEndDate().toDateTimeAtStartOfDay() : null, bean.getDueDateCalculationType(), bean.getFixedDueDate(), bean.getNumberOfDaysAfterCreationForDueDate(), bean.isApplyInterests(), bean.getInterestRateType(), bean.getNumberOfDaysAfterDueDate(), bean.isApplyInFirstWorkday(), bean.getMaximumDaysToApplyPenalty(), bean.getInterestFixedAmount(), bean.getRate());
        super.setTuitionPaymentPlan(tuitionPaymentPlan);
        super.setInstallmentOrder(bean.getInstallmentOrder());
        super.setTuitionCalculationType(bean.getTuitionCalculationType());
        super.setTuitionTariffCalculatedAmountType(bean.getTuitionTariffCalculatedAmountType());
        this.setTuitionTariffCustomCalculator(bean.getTuitionTariffCustomCalculator());
        super.setTuitionPaymentPlanCalculator(bean.getTuitionPaymentPlanCalculator());
        super.setFixedAmount(bean.getFixedAmount());
        super.setEctsCalculationType(bean.getEctsCalculationType());
        super.setFactor(bean.getFactor());
        super.setTotalEctsOrUnits(bean.getTotalEctsOrUnits());
        super.setAcademicalActBlockingOff(bean.isAcademicalActBlockingOff());
        this.setBlockAcademicActsOnDebt(bean.isBlockAcademicActsOnDebt());
        if (bean.isApplyMaximumAmount()) {
            if (bean.getMaximumAmount() == null || !AcademicTreasuryConstants.isPositive(bean.getMaximumAmount())) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.maximum.amount.required", this.getTuitionPaymentPlan().getConditionsDescription());
            }
            this.setMaximumAmount(bean.getMaximumAmount());
        } else {
            this.setMaximumAmount(BigDecimal.ZERO);
        }
        super.setPayorDebtAccount(bean.getPayorDebtAccount());
        this.checkRules();
    }

    protected void init(TuitionInstallmentTariff tariff, Map<TuitionPaymentPlanCalculator, TuitionPaymentPlanCalculator> calculatorsCopyMap) {
        FinantialEntity finantialEntity = tariff.getFinantialEntity();
        Product product = tariff.getProduct();
        ExecutionYear executionYear = this.getTuitionPaymentPlan().getExecutionYear();
        ExecutionYear copiedExecutionYear = tariff.getTuitionPaymentPlan().getExecutionYear();
        int executionYearInterval = executionYear.getAcademicInterval().getStart().getYear() - copiedExecutionYear.getAcademicInterval().getStart().getYear();
        super.init(finantialEntity, product, tariff.getBeginDate().plusYears(executionYearInterval), tariff.getEndDate() != null ? tariff.getEndDate().plusYears(executionYearInterval) : null, tariff.getDueDateCalculationType(), tariff.getFixedDueDate() != null ? tariff.getFixedDueDate().plusYears(executionYearInterval) : null, tariff.getNumberOfDaysAfterCreationForDueDate(), tariff.isApplyInterests(), tariff.getInterestRate() != null ? tariff.getInterestRate().getInterestRateType() : null, tariff.getInterestRate() != null ? tariff.getInterestRate().getNumberOfDaysAfterDueDate() : 0, tariff.getInterestRate() != null ? tariff.getInterestRate().isApplyInFirstWorkday() : false, tariff.getInterestRate() != null ? tariff.getInterestRate().getMaximumDaysToApplyPenalty() : 0, tariff.getInterestRate() != null ? tariff.getInterestRate().getInterestFixedAmount() : null, tariff.getInterestRate() != null ? tariff.getInterestRate().getRate() : null);
        super.setTuitionTariffCalculatedAmountType(tariff.getTuitionTariffCalculatedAmountType());
        this.setTuitionTariffCustomCalculator(tariff.getTuitionTariffCustomCalculator());
        if (tariff.getTuitionPaymentPlanCalculator() != null) {
            super.setTuitionPaymentPlanCalculator(calculatorsCopyMap.get((Object)tariff.getTuitionPaymentPlanCalculator()));
        }
        super.setInstallmentOrder(tariff.getInstallmentOrder());
        super.setTuitionCalculationType(tariff.getTuitionCalculationType());
        super.setFixedAmount(tariff.getFixedAmount());
        super.setEctsCalculationType(tariff.getEctsCalculationType());
        super.setFactor(tariff.getFactor());
        super.setTotalEctsOrUnits(tariff.getTotalEctsOrUnits());
        super.setAcademicalActBlockingOff(tariff.isAcademicalActBlockingOff());
        super.setBlockAcademicActsOnDebt(tariff.isBlockAcademicActsOnDebt());
        super.setMaximumAmount(tariff.getMaximumAmount());
        super.setPayorDebtAccount(tariff.getPayorDebtAccount());
        this.checkRules();
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getTuitionPaymentPlan() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.tuitionPaymentPlan.required", new String[0]);
        }
        if (this.getFinantialEntity() != this.getTuitionPaymentPlan().getFinantialEntity()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.finantialEntity.different.from.payment.plan", new String[0]);
        }
        if (this.getInstallmentOrder() <= 0) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.installmentOrder.must.be.positive", new String[0]);
        }
        if (TuitionInstallmentTariff.find(this.getTuitionPaymentPlan(), this.getInstallmentOrder()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.tariff.installment.order.already.exists", new String[0]);
        }
        if (this.getTuitionCalculationType() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.tuitionCalculationType.required", new String[0]);
        }
        if (this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.ectsCalculationType.required", new String[0]);
        }
        if (this.isFixedAmountRequired() && this.getFixedAmount() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.fixedAmount.required", new String[0]);
        }
        if (this.isFixedAmountRequired() && !this.isPositive(this.getFixedAmount())) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.fixedAmount.must.be.positive", new String[0]);
        }
        if (this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration() && this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.defaultPaymentPlanCourseFunctionCostIndexed.not.supported.for.registrationTuition", new String[0]);
        }
        if (this.isDefaultPaymentPlanDependent()) {
            if (this.getFactor() == null) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.factor.required", this.getTuitionCalculationType().getDescriptionI18N().getContent());
            }
            if (this.getTotalEctsOrUnits() == null) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.totalEctsOrUnits.required", this.getTuitionCalculationType().getDescriptionI18N().getContent());
            }
            if (!this.isPositive(this.getFactor())) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.factor.must.be.positive", this.getTuitionCalculationType().getDescriptionI18N().getContent());
            }
            if (!this.isPositive(this.getTotalEctsOrUnits())) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.totalEctsOrUnits.must.be.positive", this.getTuitionCalculationType().getDescriptionI18N().getContent());
            }
        }
        if (this.isAcademicalActBlockingOff() && this.isBlockAcademicActsOnDebt()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.cannot.suspend.and.also.block.academical.acts.on.debt.detailed", this.getProduct().getName().getContent());
        }
        if (this.getTuitionPaymentPlanCalculator() != null && !this.getTuitionPaymentPlan().getTuitionPaymentPlanCalculatorSet().contains((Object)this.getTuitionPaymentPlanCalculator())) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.tuitionPaymentPlanCalculator.not.in.tuition.payment.plan", new String[0]);
        }
    }

    private boolean isFixedAmountRequired() {
        if (this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType() != null && this.getEctsCalculationType().isDependentOnDefaultPaymentPlan()) {
            return false;
        }
        List<TuitionTariffCalculatedAmountType> doNotRequiredFixedAmountList = List.of(TuitionTariffCalculatedAmountType.PERCENTAGE, TuitionTariffCalculatedAmountType.REMAINING, TuitionTariffCalculatedAmountType.TOTAL_CALCULATED_AMOUNT);
        return !this.getTuitionCalculationType().isCalculatedAmount() || !doNotRequiredFixedAmountList.contains((Object)this.getTuitionTariffCalculatedAmountType());
    }

    private boolean isTuitionCalculationByEctsOrUnits() {
        return this.getTuitionCalculationType().isEcts() || this.getTuitionCalculationType().isUnits();
    }

    public boolean isDefaultPaymentPlanDependent() {
        return this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType() != null && this.getEctsCalculationType().isDependentOnDefaultPaymentPlan();
    }

    public boolean isDefaultPaymentPlanDefined() {
        return this.getTuitionPaymentPlan().getTuitionPaymentPlanOrdersSet().stream().map(order -> order.getDegreeCurricularPlan()).allMatch(dcp -> TuitionPaymentPlan.isDefaultPaymentPlanDefined(dcp, this.getTuitionPaymentPlan().getExecutionYear()));
    }

    public boolean isAcademicalActBlockingOff() {
        return super.getAcademicalActBlockingOff();
    }

    public boolean isBlockAcademicActsOnDebt() {
        return super.getBlockAcademicActsOnDebt();
    }

    public boolean isApplyMaximumAmount() {
        return this.getMaximumAmount() != null && this.isPositive(this.getMaximumAmount());
    }

    public BigDecimal getAmountPerEctsOrUnit(DegreeCurricularPlan dcp) {
        if (this.getTuitionCalculationType().isFixedAmount()) {
            throw new RuntimeException("invalid call");
        }
        if (this.getEctsCalculationType().isFixedAmount()) {
            return this.getFixedAmount();
        }
        if (!this.isDefaultPaymentPlanDefined()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.default.payment.plan.not.defined", new String[0]);
        }
        TuitionPaymentPlan defaultPaymentPlan = TuitionPaymentPlan.findUniqueDefaultPaymentPlan(dcp, this.getTuitionPaymentPlan().getExecutionYear()).get();
        for (TuitionInstallmentTariff tuitionInstallmentTariff : defaultPaymentPlan.getTuitionInstallmentTariffsSet()) {
            if (tuitionInstallmentTariff.getTuitionCalculationType().isFixedAmount()) continue;
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.default.payment.plan.tariffs.calculation.type.not.fixed.amount", new String[0]);
        }
        return AcademicTreasuryConstants.divide(AcademicTreasuryConstants.defaultScale(defaultPaymentPlan.tuitionTotalAmount()).multiply(this.getFactor()), this.getTotalEctsOrUnits());
    }

    private BigDecimal getAmountPerEctsOrUnitUsingFunctionCostIndexed(Enrolment enrolment) {
        if (!this.isTuitionCalculationByEctsOrUnits() || !this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            throw new RuntimeException("invalid call");
        }
        if (!this.isDefaultPaymentPlanDefined()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.default.payment.plan.not.defined", new String[0]);
        }
        if (!CourseFunctionCost.findUnique(enrolment.getExecutionYear(), enrolment.getCurricularCourse()).isPresent()) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.courseFunctionCourse.not.defined", new String[0]);
        }
        CourseFunctionCost cost = CourseFunctionCost.findUnique(enrolment.getExecutionYear(), enrolment.getCurricularCourse()).get();
        TuitionPaymentPlan defaultPaymentPlan = TuitionPaymentPlan.findUniqueDefaultPaymentPlan(enrolment.getDegreeCurricularPlanOfDegreeModule(), this.getTuitionPaymentPlan().getExecutionYear()).get();
        return AcademicTreasuryConstants.divide(AcademicTreasuryConstants.defaultScale(defaultPaymentPlan.tuitionTotalAmount()).multiply(this.getFactor()), this.getTotalEctsOrUnits()).multiply(AcademicTreasuryConstants.divide(cost.getFunctionCost(), BigDecimal.TEN).add(BigDecimal.ONE));
    }

    public BigDecimal amountToPay(AcademicTreasuryEvent academicTreasuryEvent, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        BigDecimal enrolledEctsUnits = academicTreasuryEvent.getEnrolledEctsUnits();
        BigDecimal enrolledCoursesCount = academicTreasuryEvent.getEnrolledCoursesCount();
        return this.amountToPay(academicTreasuryEvent.getRegistration(), enrolledEctsUnits, enrolledCoursesCount, calculatorsMap);
    }

    public BigDecimal amountToPay(Registration registration, BigDecimal enrolledEctsUnits, BigDecimal enrolledCoursesCount, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        BigDecimal amountToPay = null;
        if (this.getTuitionCalculationType().isFixedAmount()) {
            amountToPay = this.getFixedAmount();
        } else if (this.getTuitionCalculationType().isEcts()) {
            amountToPay = enrolledEctsUnits.multiply(this.getAmountPerEctsOrUnit(registration.getActiveDegreeCurricularPlan()));
        } else if (this.getTuitionCalculationType().isUnits()) {
            amountToPay = enrolledCoursesCount.multiply(this.getAmountPerEctsOrUnit(registration.getActiveDegreeCurricularPlan()));
        } else if (this.getTuitionCalculationType().isCalculatedAmount()) {
            BigDecimal customAmount = null;
            customAmount = Boolean.TRUE.equals(this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators()) ? this.getTuitionPaymentPlanCalculator().getTotalAmount(registration) : calculatorsMap.get(this.getTuitionTariffCustomCalculator()).getTotalAmount();
            BigDecimal totalCaptiveAmount = this.getTuitionPaymentPlan().getOrderedTuitionInstallmentTariffs().stream().filter(tariff -> {
                boolean isSameCalculator = false;
                isSameCalculator = Boolean.TRUE.equals(this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators()) ? tariff.getTuitionPaymentPlanCalculator() == this.getTuitionPaymentPlanCalculator() : tariff.getTuitionTariffCustomCalculator().equals(this.getTuitionTariffCustomCalculator());
                return tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType().isCaptive() && isSameCalculator;
            }).map(tariff -> tariff.getFixedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal customAmountWithoutCaptive = customAmount.subtract(totalCaptiveAmount);
            if (this.getTuitionTariffCalculatedAmountType().isCaptive()) {
                amountToPay = this.getFixedAmount();
            } else if (this.getTuitionTariffCalculatedAmountType().isPercentage()) {
                amountToPay = Currency.getValueWithScale((BigDecimal)this.getFactor().multiply(customAmountWithoutCaptive));
            } else if (this.getTuitionTariffCalculatedAmountType().isRemaining()) {
                BigDecimal totalPercentageAmount = this.getTuitionPaymentPlan().getOrderedTuitionInstallmentTariffs().stream().filter(tariff -> {
                    boolean isSameCalculator = false;
                    isSameCalculator = Boolean.TRUE.equals(this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators()) ? tariff.getTuitionPaymentPlanCalculator() == this.getTuitionPaymentPlanCalculator() : tariff.getTuitionTariffCustomCalculator().equals(this.getTuitionTariffCustomCalculator());
                    return tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType().isPercentage() && isSameCalculator;
                }).map(tariff -> Currency.getValueWithScale((BigDecimal)tariff.getFactor().multiply(customAmountWithoutCaptive))).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalTariffAmount = totalCaptiveAmount.add(totalPercentageAmount);
                amountToPay = customAmount.subtract(totalTariffAmount);
            } else if (this.getTuitionTariffCalculatedAmountType().isTotalCalculatedAmount()) {
                amountToPay = customAmount;
            }
        }
        if (amountToPay == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.unknown.amountToPay", new String[0]);
        }
        if (this.isApplyMaximumAmount() && AcademicTreasuryConstants.isGreaterThan(amountToPay, this.getMaximumAmount())) {
            return this.getMaximumAmount();
        }
        return amountToPay;
    }

    public BigDecimal amountToPay(ITuitionRegistrationServiceParameters parameters) {
        Registration registration = parameters.getRegistration();
        BigDecimal enrolledEctsUnits = parameters.getEnrolledEctsUnits();
        BigDecimal enrolledCoursesCount = parameters.getEnrolledCoursesCount();
        Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap = parameters.getCustomCalculatorsMap();
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        BigDecimal amountToPay = null;
        if (this.getTuitionCalculationType().isFixedAmount()) {
            amountToPay = this.getFixedAmount();
        } else if (this.getTuitionCalculationType().isEcts()) {
            amountToPay = enrolledEctsUnits.multiply(this.getAmountPerEctsOrUnit(registration.getActiveDegreeCurricularPlan()));
        } else if (this.getTuitionCalculationType().isUnits()) {
            amountToPay = enrolledCoursesCount.multiply(this.getAmountPerEctsOrUnit(registration.getActiveDegreeCurricularPlan()));
        } else if (this.getTuitionCalculationType().isCalculatedAmount()) {
            BigDecimal customAmount = null;
            customAmount = Boolean.TRUE.equals(this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators()) ? this.getTuitionPaymentPlanCalculator().getTotalAmount(registration, parameters) : calculatorsMap.get(this.getTuitionTariffCustomCalculator()).getTotalAmount();
            BigDecimal totalCaptiveAmount = this.getTuitionPaymentPlan().getOrderedTuitionInstallmentTariffs().stream().filter(tariff -> {
                boolean isSameCalculator = false;
                isSameCalculator = Boolean.TRUE.equals(this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators()) ? tariff.getTuitionPaymentPlanCalculator() == this.getTuitionPaymentPlanCalculator() : tariff.getTuitionTariffCustomCalculator().equals(this.getTuitionTariffCustomCalculator());
                return tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType().isCaptive() && isSameCalculator;
            }).map(tariff -> tariff.getFixedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal customAmountWithoutCaptive = customAmount.subtract(totalCaptiveAmount);
            if (this.getTuitionTariffCalculatedAmountType().isCaptive()) {
                amountToPay = this.getFixedAmount();
            } else if (this.getTuitionTariffCalculatedAmountType().isPercentage()) {
                amountToPay = Currency.getValueWithScale((BigDecimal)this.getFactor().multiply(customAmountWithoutCaptive));
            } else if (this.getTuitionTariffCalculatedAmountType().isRemaining()) {
                BigDecimal totalPercentageAmount = this.getTuitionPaymentPlan().getOrderedTuitionInstallmentTariffs().stream().filter(tariff -> {
                    boolean isSameCalculator = false;
                    isSameCalculator = Boolean.TRUE.equals(this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators()) ? tariff.getTuitionPaymentPlanCalculator() == this.getTuitionPaymentPlanCalculator() : tariff.getTuitionTariffCustomCalculator().equals(this.getTuitionTariffCustomCalculator());
                    return tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType().isPercentage() && isSameCalculator;
                }).map(tariff -> Currency.getValueWithScale((BigDecimal)tariff.getFactor().multiply(customAmountWithoutCaptive))).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalTariffAmount = totalCaptiveAmount.add(totalPercentageAmount);
                amountToPay = customAmount.subtract(totalTariffAmount);
            } else if (this.getTuitionTariffCalculatedAmountType().isTotalCalculatedAmount()) {
                amountToPay = customAmount;
            }
        }
        if (amountToPay == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.unknown.amountToPay", new String[0]);
        }
        if (this.isApplyMaximumAmount() && AcademicTreasuryConstants.isGreaterThan(amountToPay, this.getMaximumAmount())) {
            return this.getMaximumAmount();
        }
        return amountToPay;
    }

    public BigDecimal amountToPay(AcademicTreasuryEvent academicTreasuryEvent, Enrolment enrolment, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForStandalone() && !this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForExtracurricular()) {
            throw new RuntimeException("wrong call");
        }
        BigDecimal amountToPay = null;
        if (this.getTuitionCalculationType().isFixedAmount()) {
            amountToPay = this.getFixedAmount();
        } else if (this.getTuitionCalculationType().isUnits() && !this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            amountToPay = this.getAmountPerEctsOrUnit(enrolment.getDegreeCurricularPlanOfDegreeModule());
        } else if (this.getTuitionCalculationType().isEcts() && !this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            amountToPay = new BigDecimal(enrolment.getCurricularCourse().getEctsCredits()).multiply(this.getAmountPerEctsOrUnit(enrolment.getDegreeCurricularPlanOfDegreeModule()));
        } else if (this.getTuitionCalculationType().isUnits() && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            amountToPay = this.getAmountPerEctsOrUnitUsingFunctionCostIndexed(enrolment);
        } else if (this.getTuitionCalculationType().isEcts() && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            amountToPay = new BigDecimal(enrolment.getCurricularCourse().getEctsCredits()).multiply(this.getAmountPerEctsOrUnitUsingFunctionCostIndexed(enrolment));
        } else if (this.getTuitionCalculationType().isCalculatedAmount()) {
            BigDecimal customAmount = null;
            customAmount = Boolean.TRUE.equals(this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators()) ? this.getTuitionPaymentPlanCalculator().getTotalAmount(enrolment) : calculatorsMap.get(this.getTuitionTariffCustomCalculator()).getTotalAmount();
            BigDecimal totalCaptiveAmount = this.getTuitionPaymentPlan().getOrderedTuitionInstallmentTariffs().stream().filter(tariff -> {
                boolean isSameCalculator = false;
                isSameCalculator = Boolean.TRUE.equals(this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators()) ? tariff.getTuitionPaymentPlanCalculator() == this.getTuitionPaymentPlanCalculator() : tariff.getTuitionTariffCustomCalculator().equals(this.getTuitionTariffCustomCalculator());
                return tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType().isCaptive() && isSameCalculator;
            }).map(tariff -> tariff.getFixedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal customAmountWithoutCaptive = customAmount.subtract(totalCaptiveAmount);
            if (this.getTuitionTariffCalculatedAmountType().isCaptive()) {
                amountToPay = this.getFixedAmount();
            }
            if (this.getTuitionTariffCalculatedAmountType().isPercentage()) {
                amountToPay = Currency.getValueWithScale((BigDecimal)this.getFactor().multiply(customAmountWithoutCaptive));
            }
            if (this.getTuitionTariffCalculatedAmountType().isRemaining()) {
                BigDecimal totalPercentageAmount = this.getTuitionPaymentPlan().getOrderedTuitionInstallmentTariffs().stream().filter(tariff -> {
                    boolean isSameCalculator = false;
                    isSameCalculator = Boolean.TRUE.equals(this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators()) ? tariff.getTuitionPaymentPlanCalculator() == this.getTuitionPaymentPlanCalculator() : tariff.getTuitionTariffCustomCalculator().equals(this.getTuitionTariffCustomCalculator());
                    return tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType().isPercentage() && isSameCalculator;
                }).map(tariff -> Currency.getValueWithScale((BigDecimal)tariff.getFactor().multiply(customAmountWithoutCaptive))).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalTariffAmount = totalCaptiveAmount.add(totalPercentageAmount);
                amountToPay = customAmount.subtract(totalTariffAmount);
            }
        }
        if (amountToPay == null) {
            throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.unknown.amountToPay", new String[0]);
        }
        if (this.isApplyMaximumAmount() && AcademicTreasuryConstants.isGreaterThan(amountToPay, this.getMaximumAmount())) {
            return this.getMaximumAmount();
        }
        return amountToPay;
    }

    public DebitEntry createDebitEntryForRegistration(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap, BigDecimal amountToDiscount) {
        if (amountToDiscount == null) {
            amountToDiscount = BigDecimal.ZERO;
        }
        if (TreasuryConstants.isNegative((BigDecimal)amountToDiscount)) {
            throw new RuntimeException("invalid amount to discount");
        }
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        BigDecimal amount = this.amountToPay(academicTreasuryEvent, calculatorsMap).subtract(amountToDiscount);
        if (TreasuryConstants.isNegative((BigDecimal)amount)) {
            throw new RuntimeException("invalid tuition installment amount");
        }
        LocalDate dueDate = this.dueDate(when != null ? when : new LocalDate());
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForRegistration(academicTreasuryEvent, dueDate, when, calculatorsMap);
        FinantialEntity finantialEntity = this.getTuitionPaymentPlan().getFinantialEntity();
        DebitEntry debitEntry = DebitEntry.create((FinantialEntity)finantialEntity, (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)this.vat(when), (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)this.installmentName(academicTreasuryEvent.getRegistration()).getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay(), (boolean)false, (boolean)false, null);
        if (this.isAcademicalActBlockingOff()) {
            debitEntry.markAcademicalActBlockingSuspension();
        }
        if (this.isBlockAcademicActsOnDebt()) {
            debitEntry.markBlockAcademicActsOnDebt();
        }
        debitEntry.setPayorDebtAccount(this.getPayorDebtAccount());
        return debitEntry;
    }

    public DebitEntry createDebitEntryForRegistration(ITuitionRegistrationServiceParameters parameters) {
        DebtAccount debtAccount = parameters.getDebtAccount().orElseThrow(() -> new IllegalStateException("debt account not created"));
        AcademicTreasuryEvent academicTreasuryEvent = parameters.getAcademicTreasuryEvent().orElseThrow(() -> new IllegalStateException("academic treasury event not created"));
        LocalDate when = parameters.getDebtDate();
        Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap = parameters.getCustomCalculatorsMap();
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        BigDecimal amount = this.amountToPay(parameters);
        if (TreasuryConstants.isNegative((BigDecimal)amount)) {
            throw new RuntimeException("invalid tuition installment amount");
        }
        LocalDate dueDate = this.dueDate(when != null ? when : new LocalDate());
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForRegistration(academicTreasuryEvent, dueDate, when, calculatorsMap);
        FinantialEntity finantialEntity = this.getTuitionPaymentPlan().getFinantialEntity();
        DebitEntry debitEntry = DebitEntry.create((FinantialEntity)finantialEntity, (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)this.vat(when), (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)this.installmentName(academicTreasuryEvent.getRegistration()).getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay(), (boolean)false, (boolean)false, null);
        if (this.isAcademicalActBlockingOff()) {
            debitEntry.markAcademicalActBlockingSuspension();
        }
        if (this.isBlockAcademicActsOnDebt()) {
            debitEntry.markBlockAcademicActsOnDebt();
        }
        debitEntry.setPayorDebtAccount(this.getPayorDebtAccount());
        return debitEntry;
    }

    public DebitEntry createRecalculationDebitEntryForRegistration(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap, BigDecimal recalculatedAmount, LocalDate recalculationDueDate) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        if (TreasuryConstants.isNegative((BigDecimal)recalculatedAmount)) {
            throw new RuntimeException("invalid tuition installment amount");
        }
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForRegistration(academicTreasuryEvent, recalculationDueDate, when, calculatorsMap);
        fillPriceProperties.put("RECALCULATED_AMOUNT", recalculatedAmount.toString());
        String installmentName = this.installmentName(academicTreasuryEvent.getRegistration()).getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE);
        Object installmentDebitEntryName = installmentName;
        TuitionPaymentPlanGroup group = this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup();
        if (group.getTuitionRecalculationDebitEntryPrefix() != null && StringUtils.isNotEmpty((String)group.getTuitionRecalculationDebitEntryPrefix().getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE))) {
            installmentDebitEntryName = group.getTuitionRecalculationDebitEntryPrefix().getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE) + " " + (String)installmentDebitEntryName;
        }
        if (group.getTuitionRecalculationDebitEntrySuffix() != null && StringUtils.isNotEmpty((String)group.getTuitionRecalculationDebitEntrySuffix().getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE))) {
            installmentDebitEntryName = (String)installmentDebitEntryName + " " + group.getTuitionRecalculationDebitEntrySuffix().getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE);
        }
        DebitEntry debitEntry = DebitEntry.create((FinantialEntity)this.getTuitionPaymentPlan().getFinantialEntity(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)this.vat(when), (BigDecimal)recalculatedAmount, (LocalDate)recalculationDueDate, fillPriceProperties, (Product)this.getProduct(), (String)((String)installmentDebitEntryName).trim(), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay(), (boolean)false, (boolean)false, null);
        if (this.isAcademicalActBlockingOff()) {
            debitEntry.markAcademicalActBlockingSuspension();
        }
        if (this.isBlockAcademicActsOnDebt()) {
            debitEntry.markBlockAcademicActsOnDebt();
        }
        debitEntry.setPayorDebtAccount(this.getPayorDebtAccount());
        return debitEntry;
    }

    public DebitEntry createDebitEntryForStandalone(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, Enrolment standaloneEnrolment, LocalDate when, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForStandalone()) {
            throw new RuntimeException("wrong call");
        }
        if (!standaloneEnrolment.isStandalone()) {
            throw new RuntimeException("error.TuitionPaymentPlan.enrolment.not.standalone");
        }
        BigDecimal amount = this.amountToPay(academicTreasuryEvent, standaloneEnrolment, calculatorsMap);
        LocalDate dueDate = this.dueDate(when != null ? when : new LocalDate());
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForStandaloneOrExtracurricular(academicTreasuryEvent, standaloneEnrolment, dueDate, calculatorsMap);
        FinantialEntity finantialEntity = this.getTuitionPaymentPlan().getFinantialEntity();
        DebitEntry debitEntry = DebitEntry.create((FinantialEntity)finantialEntity, (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)this.vat(when), (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)this.standaloneDebitEntryName(standaloneEnrolment).getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay(), (boolean)false, (boolean)false, null);
        if (this.isAcademicalActBlockingOff()) {
            debitEntry.markAcademicalActBlockingSuspension();
        }
        if (this.isBlockAcademicActsOnDebt()) {
            debitEntry.markBlockAcademicActsOnDebt();
        }
        academicTreasuryEvent.associateEnrolment(debitEntry, standaloneEnrolment);
        return debitEntry;
    }

    public DebitEntry createDebitEntryForExtracurricular(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, Enrolment extracurricularEnrolment, LocalDate when, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForExtracurricular()) {
            throw new RuntimeException("wrong call");
        }
        if (!extracurricularEnrolment.isExtraCurricular()) {
            throw new RuntimeException("error.TuitionPaymentPlan.enrolment.not.extracurricular");
        }
        BigDecimal amount = this.amountToPay(academicTreasuryEvent, extracurricularEnrolment, calculatorsMap);
        LocalDate dueDate = this.dueDate(when != null ? when : new LocalDate());
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForStandaloneOrExtracurricular(academicTreasuryEvent, extracurricularEnrolment, dueDate, calculatorsMap);
        FinantialEntity finantialEntity = this.getTuitionPaymentPlan().getFinantialEntity();
        DebitEntry debitEntry = DebitEntry.create((FinantialEntity)finantialEntity, (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)this.vat(when), (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)this.extracurricularDebitEntryName(extracurricularEnrolment).getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay(), (boolean)false, (boolean)false, null);
        if (this.isAcademicalActBlockingOff()) {
            debitEntry.markAcademicalActBlockingSuspension();
        }
        if (this.isBlockAcademicActsOnDebt()) {
            debitEntry.markBlockAcademicActsOnDebt();
        }
        academicTreasuryEvent.associateEnrolment(debitEntry, extracurricularEnrolment);
        return debitEntry;
    }

    public LocalizedString installmentName(Registration registration) {
        return this.getTuitionPaymentPlan().installmentName(registration, this);
    }

    public LocalizedString standaloneDebitEntryName(Enrolment standaloneEnrolment) {
        if (!standaloneEnrolment.isStandalone()) {
            throw new RuntimeException("wrong call");
        }
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryConstants.getAvailableLocales()) {
            result = result.with(locale, AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.standalone.debit.entry.name", standaloneEnrolment.getName().getContent(locale), standaloneEnrolment.getExecutionPeriod().getQualifiedName(), new BigDecimal(standaloneEnrolment.getCurricularCourse().getEctsCredits()).toString()));
        }
        return result;
    }

    public LocalizedString extracurricularDebitEntryName(Enrolment extracurricularEnrolment) {
        if (!extracurricularEnrolment.isExtraCurricular()) {
            throw new RuntimeException("wrong call");
        }
        LocalizedString result = new LocalizedString();
        for (Locale locale : TreasuryConstants.getAvailableLocales()) {
            result = result.with(locale, AcademicTreasuryConstants.academicTreasuryBundle(locale, "label.TuitionPaymentPlan.extracurricular.debit.entry.name", extracurricularEnrolment.getName().getContent(locale), extracurricularEnrolment.getExecutionPeriod().getQualifiedName(), new BigDecimal(extracurricularEnrolment.getCurricularCourse().getEctsCredits()).toString()));
        }
        return result;
    }

    public Vat vat(LocalDate when) {
        return (Vat)Vat.findActiveUnique((VatType)this.getProduct().getVatType(), (FinantialInstitution)this.getFinantialEntity().getFinantialInstitution(), (DateTime)new DateTime()).get();
    }

    private Map<String, String> fillPricePropertiesForStandaloneOrExtracurricular(AcademicTreasuryEvent academicTreasuryEvent, Enrolment enrolment, LocalDate dueDate, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForStandalone() && !this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForExtracurricular()) {
            throw new RuntimeException("wrong call");
        }
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ENROLMENT.getDescriptionI18N().getContent(), enrolment.getName().getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CURRICULAR_PLAN.getDescriptionI18N().getContent(), enrolment.getCurricularCourse().getDegreeCurricularPlan().getName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), enrolment.getCurricularCourse().getDegree().getPresentationName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), enrolment.getCurricularCourse().getDegree().getCode());
        if (this.getTuitionCalculationType().isFixedAmount()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FIXED_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getFixedAmount()));
        } else if (this.getTuitionCalculationType().isEcts() && !this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ECTS_CREDITS.getDescriptionI18N().getContent(), new BigDecimal(enrolment.getCurricularCourse().getEctsCredits()).toString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_ECTS.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnit(enrolment.getDegreeCurricularPlanOfDegreeModule()), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
        } else if (this.getTuitionCalculationType().isUnits() && !this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_COURSE.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnit(enrolment.getDegreeCurricularPlanOfDegreeModule()), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
        } else if (this.getTuitionCalculationType().isEcts() && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            TuitionPaymentPlan defaultPaymentPlan = TuitionPaymentPlan.findUniqueDefaultPaymentPlan(enrolment.getDegreeCurricularPlanOfDegreeModule(), this.getTuitionPaymentPlan().getExecutionYear()).get();
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEFAULT_TUITION_TOTAL_AMOUNT.getDescriptionI18N().getContent(), defaultPaymentPlan.tuitionTotalAmount().toString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ECTS_CREDITS.getDescriptionI18N().getContent(), new BigDecimal(enrolment.getCurricularCourse().getEctsCredits()).toString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_ECTS.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnitUsingFunctionCostIndexed(enrolment), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
            CourseFunctionCost cost = CourseFunctionCost.findUnique(enrolment.getExecutionYear(), enrolment.getCurricularCourse()).get();
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.COURSE_FUNCTION_COST.getDescriptionI18N().getContent(), cost.getFunctionCost().toPlainString());
        } else if (this.getTuitionCalculationType().isUnits() && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_COURSE.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnitUsingFunctionCostIndexed(enrolment), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
            CourseFunctionCost cost = CourseFunctionCost.findUnique(enrolment.getExecutionYear(), enrolment.getCurricularCourse()).get();
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.COURSE_FUNCTION_COST.getDescriptionI18N().getContent(), cost.getFunctionCost().toPlainString());
        } else if (this.getTuitionCalculationType().isCalculatedAmount()) {
            if (this.getTuitionPaymentPlanCalculator() != null) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CUSTOM_CALCULATOR.getDescriptionI18N().getContent(), ((Object)((Object)this.getTuitionPaymentPlanCalculator())).getClass().getSimpleName());
            } else if (this.getTuitionTariffCustomCalculator() != null) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CUSTOM_CALCULATOR.getDescriptionI18N().getContent(), this.getTuitionTariffCustomCalculator().getSimpleName());
            }
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_AMOUNT_TYPE.getDescriptionI18N().getContent(), this.getTuitionTariffCalculatedAmountType().getDescriptionI18N().getContent());
            if (this.getTuitionTariffCalculatedAmountType().isCaptive()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
            }
            if (this.getTuitionTariffCalculatedAmountType().isPercentage()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FACTOR.getDescriptionI18N().getContent(), this.getFactor().toPlainString());
            }
            if (this.getTuitionTariffCalculatedAmountType().isRemaining()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
            }
            if (this.getTuitionTariffCalculatedAmountType().isTotalCalculatedAmount()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(academicTreasuryEvent, enrolment, calculatorsMap)));
            }
        }
        if (this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType().isDependentOnDefaultPaymentPlan()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FACTOR.getDescriptionI18N().getContent(), this.getFactor().toPlainString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.TOTAL_ECTS_OR_UNITS.getDescriptionI18N().getContent(), this.getTotalEctsOrUnits().toPlainString());
        }
        if (this.isApplyMaximumAmount()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.MAXIMUM_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getMaximumAmount()));
        }
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DUE_DATE.getDescriptionI18N().getContent(), dueDate.toString("dd/MM/yyyy"));
        return propertiesMap;
    }

    public Map<String, String> fillPricePropertiesForRegistration(AcademicTreasuryEvent event, LocalDate dueDate, LocalDate usedDate, Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap) {
        if (!this.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_CALCULATION_TYPE.getDescriptionI18N().getContent(), this.getTuitionCalculationType().getDescriptionI18N().getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYMENT_PLAN_CONDITIONS.getDescriptionI18N().getContent(), this.getTuitionPaymentPlan().getConditionsDescription());
        if (this.getPayorDebtAccount() != null) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYOR_DEBT_ACCOUNT.getDescriptionI18N().getContent(), this.getPayorDebtAccount().getCustomer().getUiFiscalNumber());
        }
        TuitionPaymentPlanGroup tuitionPaymentPlanGroup = event.getTuitionPaymentPlanGroup();
        Registration registration = event.getRegistration();
        ExecutionYear executionYear = event.getExecutionYear();
        if (this.getTuitionCalculationType().isFixedAmount()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FIXED_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getFixedAmount()));
        } else if (this.getTuitionCalculationType().isEcts()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ECTS_CREDITS.getDescriptionI18N().getContent(), AcademicTreasuryEvent.getEnrolledEctsUnits(tuitionPaymentPlanGroup, registration, executionYear).toString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_ECTS.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnit(registration.getActiveDegreeCurricularPlan()), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(event, calculatorsMap)));
        } else if (this.getTuitionCalculationType().isUnits()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ENROLLED_COURSES.getDescriptionI18N().getContent(), AcademicTreasuryEvent.getEnrolledCoursesCount(tuitionPaymentPlanGroup, registration, executionYear).toString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.AMOUNT_PER_COURSE.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmountPerEctsOrUnit(registration.getActiveDegreeCurricularPlan()), 3));
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(event, calculatorsMap)));
        } else if (this.getTuitionCalculationType().isCalculatedAmount()) {
            if (this.getTuitionPaymentPlanCalculator() != null) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CUSTOM_CALCULATOR.getDescriptionI18N().getContent(), ((Object)((Object)this.getTuitionPaymentPlanCalculator())).getClass().getSimpleName());
            } else if (this.getTuitionTariffCustomCalculator() != null) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CUSTOM_CALCULATOR.getDescriptionI18N().getContent(), this.getTuitionTariffCustomCalculator().getSimpleName());
            }
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_AMOUNT_TYPE.getDescriptionI18N().getContent(), this.getTuitionTariffCalculatedAmountType().getDescriptionI18N().getContent());
            if (this.getTuitionTariffCalculatedAmountType().isCaptive()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(event, calculatorsMap)));
            }
            if (this.getTuitionTariffCalculatedAmountType().isPercentage()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FACTOR.getDescriptionI18N().getContent(), this.getFactor().toPlainString());
            }
            if (this.getTuitionTariffCalculatedAmountType().isRemaining()) {
                propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.amountToPay(event, calculatorsMap)));
            }
        }
        if (this.isTuitionCalculationByEctsOrUnits() && this.getEctsCalculationType().isDefaultPaymentPlanIndexed()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FACTOR.getDescriptionI18N().getContent(), this.getFactor().toPlainString());
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.TOTAL_ECTS_OR_UNITS.getDescriptionI18N().getContent(), this.getTotalEctsOrUnits().toPlainString());
        }
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.USED_DATE.getDescriptionI18N().getContent(), usedDate.toString("dd/MM/yyyy"));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DUE_DATE.getDescriptionI18N().getContent(), dueDate.toString("dd/MM/yyyy"));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), event.getRegistration().getDegree().getCode());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), event.getRegistration().getDegree().getPresentationName(event.getExecutionYear()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CURRICULAR_PLAN.getDescriptionI18N().getContent(), event.getRegistration().getDegreeCurricularPlanName());
        if (this.isApplyMaximumAmount()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.MAXIMUM_AMOUNT.getDescriptionI18N().getContent(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getMaximumAmount()));
        }
        return propertiesMap;
    }

    public void edit(AcademicTariffBean academicTariffBean) {
        Object object = advice$edit.perform((Callable)new TuitionInstallmentTariff$callable$edit(this, academicTariffBean));
    }

    static /* synthetic */ void advised$edit(TuitionInstallmentTariff this_, AcademicTariffBean bean) {
        super.setApplyInterests(bean.isApplyInterests());
        if (this_.getInterestRate() == null && bean.isApplyInterests()) {
            this_.setInterestRate(InterestRate.createForTariff((Tariff)this_, (InterestRateType)bean.getInterestRateType(), (int)bean.getNumberOfDaysAfterCreationForDueDate(), (boolean)bean.isApplyInFirstWorkday(), (int)bean.getMaximumDaysToApplyPenalty(), (BigDecimal)bean.getInterestFixedAmount(), (BigDecimal)bean.getRate()));
        } else if (this_.getInterestRate() != null && !bean.isApplyInterests()) {
            this_.getInterestRate().delete();
        } else if (this_.getInterestRate() != null && bean.isApplyInterests()) {
            this_.getInterestRate().edit(bean.getInterestRateType(), bean.getNumberOfDaysAfterDueDate(), bean.isApplyInFirstWorkday(), bean.getMaximumDaysToApplyPenalty(), bean.getInterestFixedAmount(), bean.getRate());
        }
        super.setInstallmentOrder(bean.getInstallmentOrder());
        super.setBeginDate(bean.getBeginDate().toDateTimeAtStartOfDay());
        super.setEndDate(bean.getEndDate() != null ? bean.getEndDate().toDateTimeAtStartOfDay() : null);
        super.setTuitionCalculationType(bean.getTuitionCalculationType());
        super.setTuitionTariffCalculatedAmountType(bean.getTuitionTariffCalculatedAmountType());
        super.setTuitionTariffCustomCalculatorClassName(bean.getTuitionTariffCustomCalculator() != null ? bean.getTuitionTariffCustomCalculator().getName() : null);
        super.setTuitionPaymentPlanCalculator(bean.getTuitionPaymentPlanCalculator());
        this_.setDueDateCalculationType(bean.getDueDateCalculationType());
        this_.setFixedDueDate(bean.getFixedDueDate());
        super.setNumberOfDaysAfterCreationForDueDate(bean.getNumberOfDaysAfterCreationForDueDate());
        super.setFixedAmount(bean.getFixedAmount());
        super.setEctsCalculationType(bean.getEctsCalculationType());
        super.setFactor(bean.getFactor());
        super.setTotalEctsOrUnits(bean.getTotalEctsOrUnits());
        super.setAcademicalActBlockingOff(bean.isAcademicalActBlockingOff());
        super.setBlockAcademicActsOnDebt(bean.isBlockAcademicActsOnDebt());
        if (bean.isApplyMaximumAmount()) {
            if (bean.getMaximumAmount() == null || !AcademicTreasuryConstants.isPositive(bean.getMaximumAmount())) {
                throw new AcademicTreasuryDomainException("error.TuitionInstallmentTariff.maximum.amount.required", this_.getTuitionPaymentPlan().getConditionsDescription());
            }
            super.setMaximumAmount(bean.getMaximumAmount());
        } else {
            this_.setMaximumAmount(BigDecimal.ZERO);
        }
        super.setPayorDebtAccount(bean.getPayorDebtAccount());
        this_.checkRules();
    }

    public void delete() {
        super.setTuitionPaymentPlan(null);
        super.setPayorDebtAccount(null);
        super.setTuitionPaymentPlanCalculator(null);
        super.delete();
    }

    public BigDecimal amountToPay() {
        throw new RuntimeException("not supported");
    }

    public boolean isBroadTariffForFinantialEntity() {
        return false;
    }

    protected static Stream<TuitionInstallmentTariff> find(TuitionPaymentPlan tuitionPaymentPlan, int installmentOrder) {
        return tuitionPaymentPlan.getTuitionInstallmentTariffsSet().stream().filter(t -> t.getInstallmentOrder() == installmentOrder);
    }

    public static Optional<TuitionInstallmentTariff> findUnique(TuitionPaymentPlan tuitionPaymentPlan, int installmentOrder) {
        return TuitionInstallmentTariff.find(tuitionPaymentPlan, installmentOrder).findFirst();
    }

    public static TuitionInstallmentTariff create(FinantialEntity finantialEntity, TuitionPaymentPlan tuitionPaymentPlan, AcademicTariffBean bean) {
        return new TuitionInstallmentTariff(finantialEntity, tuitionPaymentPlan, bean);
    }

    public static TuitionInstallmentTariff copy(TuitionInstallmentTariff tuitionInstallmentTariffToCopy, TuitionPaymentPlan copyOfTuitionPaymentPlan, Map<TuitionPaymentPlanCalculator, TuitionPaymentPlanCalculator> calculatorsCopyMap) {
        return new TuitionInstallmentTariff(tuitionInstallmentTariffToCopy, copyOfTuitionPaymentPlan, calculatorsCopyMap);
    }

    public Class<? extends TuitionTariffCustomCalculator> getTuitionTariffCustomCalculator() {
        try {
            return this.getTuitionTariffCustomCalculatorClassName() == null ? null : Class.forName(this.getTuitionTariffCustomCalculatorClassName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void setTuitionTariffCustomCalculator(Class<? extends TuitionTariffCustomCalculator> clazz) {
        this.setTuitionTariffCustomCalculatorClassName(clazz != null ? clazz.getName() : "");
    }

    public void setFixedDueDate(LocalDate fixedDueDate) {
        if (this.getDueDateCalculationType().isBestOfFixedDateAndDaysAfterCreation()) {
            super.setFixedDueDate(fixedDueDate);
        } else {
            super.setFixedDueDate(null);
        }
    }

    public void setDueDateCalculationType(DueDateCalculationType dueDateCalculationType) {
        super.setDueDateCalculationType(dueDateCalculationType);
        if (!dueDateCalculationType.isBestOfFixedDateAndDaysAfterCreation()) {
            this.setFixedDueDate(null);
        }
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_INSTALLMENT_NUMBER = (o1, o2) -> {
            int c = Integer.compare(o1.getInstallmentOrder(), o2.getInstallmentOrder());
            return c != 0 ? c : DomainObjectUtil.COMPARATOR_BY_ID.compare(o1, o2);
        };
    }
}

