/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.listeners;

import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.treasury.domain.Product;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.dml.DeletionListener;

public class ProductDeletionListener {
    public static void attach() {
        FenixFramework.getDomainModel().registerDeletionListener(Product.class, (DeletionListener)new DeletionListener<Product>(){

            public void deleting(Product product) {
                if (product.getAcademicTax() != null) {
                    throw new AcademicTreasuryDomainException("error.Product.cannot.delete.due.to.academic.tax", new String[0]);
                }
                AcademicTreasurySettings.getInstance().removeAcademicalActBlockingProduct(product);
            }
        });
    }
}

