/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.tuition;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.ITuitionRegistrationServiceParameters;
import org.fenixedu.academictreasury.domain.tuition.TuitionAllocation;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.domain.tuition.TuitionTariffCustomCalculator;
import org.fenixedu.academictreasury.dto.tuition.TuitionDebitEntryBean;
import org.fenixedu.academictreasury.services.ITuitionServiceExtension;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.services.tuition.InstallmentOptions;
import org.fenixedu.academictreasury.services.tuition.InstallmentRecalculationOptions;
import org.fenixedu.academictreasury.services.tuition.RegistrationOptions;
import org.fenixedu.academictreasury.services.tuition.TreasuryExemptionsTeller;
import org.fenixedu.academictreasury.services.tuition.TuitionOptions;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.core.AbstractDomainObject;

public class RegistrationTuitionService
implements ITuitionRegistrationServiceParameters {
    boolean isForCalculationsOfOriginalAmounts = false;
    RegistrationOptions registrationOptions;
    TuitionOptions tuitionOptions;
    InstallmentOptions installmentOptions;
    InstallmentRecalculationOptions installmentRecalculationOptions;
    TreasuryExemptionsTeller _treasuryExemptionsTeller;
    Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> _calculatorsMap;
    String _calculationDescription;
    RegistrationTuitionService _originalAmountsCalculator;

    public boolean executeTuitionPaymentPlanCreation() {
        PersonCustomer personCustomer;
        String reason = AcademicTreasuryConstants.academicTreasuryBundle("label.RegistrationTuitionService.tuitionRecalculationReason", new String[0]);
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        LocalDate debtDate = this.registrationOptions.debtDate;
        boolean forceCreationIfNotEnrolled = this.tuitionOptions.forceCreationIfNotEnrolled;
        this.initializeTuitionPaymentPlan();
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        boolean applyTuitionServiceExtensions = this.tuitionOptions.applyTuitionServiceExtensions;
        boolean forceEvenTreasuryEventIsCharged = this.installmentOptions.forceInstallmentsEvenTreasuryEventIsCharged;
        if (!TuitionServices.isToPayRegistrationTuition(registration, executionYear) && !forceCreationIfNotEnrolled) {
            return false;
        }
        if (applyTuitionServiceExtensions) {
            for (ITuitionServiceExtension iTuitionServiceExtension : TuitionServices.TUITION_SERVICE_EXTENSIONS()) {
                if (!iTuitionServiceExtension.applyExtension(registration, executionYear)) continue;
                return iTuitionServiceExtension.createTuitionForRegistration(registration, executionYear, debtDate, forceCreationIfNotEnrolled, tuitionPaymentPlan);
            }
        }
        if (tuitionPaymentPlan == null) {
            return false;
        }
        if (!forceCreationIfNotEnrolled && tuitionPaymentPlan.isStudentMustBeEnrolled() && TuitionServices.normalEnrolmentsIncludingAnnuled(registration, executionYear).isEmpty()) {
            return false;
        }
        Person person = registration.getPerson();
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).isEmpty()) {
            PersonCustomer.create(person, addressFiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", new String[]{personCustomer.getBusinessIdentification(), personCustomer.getName()});
        }
        if (DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).isEmpty()) {
            DebtAccount.create((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
        }
        if (AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).isEmpty()) {
            AcademicTreasuryEvent.createForRegistrationTuition(tuitionPaymentPlan.getProduct(), registration, executionYear);
        }
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).get();
        FinantialInstitution finantialInstitution = tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution();
        Currency currency = finantialInstitution.getCurrency();
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).get();
        if (!tuitionPaymentPlan.getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        if (!forceEvenTreasuryEventIsCharged && academicTreasuryEvent.isCharged()) {
            return false;
        }
        this.initializeCreditsAndEnrolledCoursesCount();
        this.initializeCustomCalculators();
        this.initializeOriginalAmountsCalculator();
        this._treasuryExemptionsTeller = new TreasuryExemptionsTeller(this);
        Map calculatedDebitEntryBeansMap = this._originalAmountsCalculator.executeInstallmentDebitEntryBeansCalculation().stream().collect(Collectors.toMap(TuitionDebitEntryBean::getTuitionInstallmentTariff, Function.identity()));
        if (!this._calculationDescription.isEmpty()) {
            Map propertiesMap = academicTreasuryEvent.getPropertiesMap();
            String key = AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTreasury.CustomCalculatorDescription", new String[0]) + " ( " + DateTime.now().toString("yyyy-MM-dd HH:mm") + " )";
            propertiesMap.put(key, this._calculationDescription);
            academicTreasuryEvent.editPropertiesMap(propertiesMap);
        }
        Stream<? super TuitionInstallmentTariff> installments = tuitionPaymentPlan.getTuitionInstallmentTariffsSet().stream().sorted(TuitionInstallmentTariff.COMPARATOR_BY_INSTALLMENT_NUMBER);
        Function<TuitionInstallmentTariff, Boolean> func = tariff -> {
            boolean isToRecalculateInstallment;
            Product product = tariff.getProduct();
            this._treasuryExemptionsTeller.createDiscountExemptionsMapForOnlyThisInstallment((TuitionInstallmentTariff)((Object)tariff));
            boolean bl = isToRecalculateInstallment = this.installmentRecalculationOptions.recalculateInstallments != null && this.installmentRecalculationOptions.recalculateInstallments.containsKey(product);
            if (isToRecalculateInstallment && this.isTuitionInstallmentCharged(product)) {
                boolean isDifferenceNetAmountPositiveOrZero;
                TuitionDebitEntryBean originalBean = calculatedDebitEntryBeansMap.computeIfAbsent((TuitionInstallmentTariff)((Object)tariff), t -> new TuitionDebitEntryBean(t.getInstallmentOrder(), (TuitionInstallmentTariff)((Object)((Object)t)), this.ls("Installment bean"), debtDate, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, (Map<TreasuryExemptionType, BigDecimal>)new HashMap<TreasuryExemptionType, BigDecimal>(), currency));
                BigDecimal differenceNetAmount = originalBean.getAmount().subtract(this.getNetAmountAlreadyDebited(product));
                BigDecimal differenceInNetExemptedAmount = originalBean.getExemptedAmount().subtract(this.getNetAmountAlreadyExempted(product));
                boolean isExemptionsMapAreEqual = this._treasuryExemptionsTeller.isExemptionsMapAreEqual((TuitionInstallmentTariff)((Object)tariff), academicTreasuryEvent, originalBean);
                boolean isThereIsOnlyRemovalsOrDecrementsInExemptions = this._treasuryExemptionsTeller.isThereIsOnlyRemovalsOrDecrementsInExemptions((TuitionInstallmentTariff)((Object)tariff), academicTreasuryEvent, originalBean);
                boolean isThereAreOnlyNewEntriesOrIncrementsInExemptions = this._treasuryExemptionsTeller.isThereAreOnlyNewEntriesOrIncrementsInExemptions((TuitionInstallmentTariff)((Object)tariff), academicTreasuryEvent, originalBean);
                boolean isThereAreRemovalOrDecrementsInExemptions = this._treasuryExemptionsTeller.isThereAreRemovalOrDecrementsInExemptions((TuitionInstallmentTariff)((Object)tariff), academicTreasuryEvent, originalBean);
                boolean isDifferenceNetAmountZero = TreasuryConstants.isZero((BigDecimal)differenceNetAmount);
                boolean isDifferenceNetAmountNegativeOrZero = !TreasuryConstants.isPositive((BigDecimal)differenceNetAmount);
                boolean bl2 = isDifferenceNetAmountPositiveOrZero = !TreasuryConstants.isNegative((BigDecimal)differenceNetAmount);
                if (isDifferenceNetAmountZero && isExemptionsMapAreEqual) {
                    return false;
                }
                if (isDifferenceNetAmountNegativeOrZero && (isExemptionsMapAreEqual || isThereIsOnlyRemovalsOrDecrementsInExemptions)) {
                    return this.runLogicToDecrementOnlyNetAmountOrExemptions((TuitionInstallmentTariff)((Object)tariff), academicTreasuryEvent, originalBean, product, differenceNetAmount);
                }
                if (isDifferenceNetAmountPositiveOrZero && (isExemptionsMapAreEqual || isThereAreOnlyNewEntriesOrIncrementsInExemptions)) {
                    return this.runLogicToIncrementOnlyNetAmountOrExemptions((TuitionInstallmentTariff)((Object)tariff), product, originalBean, differenceInNetExemptedAmount, differenceNetAmount, debtDate, debtAccount, academicTreasuryEvent);
                }
                this._treasuryExemptionsTeller.revertExemptionAmountsFromAcademicTreasuryToDiscountExemptionsMapForAllInstallments((TuitionInstallmentTariff)((Object)tariff));
                Set<DebitEntry> debitEntriesToAnnul = DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)product).collect(Collectors.toSet());
                Set payorDebtAccountsSet = debitEntriesToAnnul.stream().map(de -> de.getDebitNote() != null ? de.getDebitNote().getPayorDebtAccount() : null).filter(Objects::nonNull).collect(Collectors.toSet());
                DebtAccount payorDebtAccount = payorDebtAccountsSet.size() == 1 ? (DebtAccount)payorDebtAccountsSet.iterator().next() : null;
                Set existingCreditEntriesSet = debitEntriesToAnnul.stream().flatMap(de -> de.getCreditEntriesSet().stream()).filter(ce -> !ce.isAnnulled()).collect(Collectors.toSet());
                debitEntriesToAnnul.forEach(d -> d.annulOnlyThisDebitEntryAndInterestsInBusinessContext(reason, false));
                Set<CreditEntry> newCreditEntriesSet = debitEntriesToAnnul.stream().flatMap(de -> de.getCreditEntriesSet().stream()).filter(ce -> !existingCreditEntriesSet.contains(ce)).filter(ce -> !ce.isAnnulled()).collect(Collectors.toSet());
                BigDecimal tuitionInstallmentAmountToPay = originalBean.getAmount().add(originalBean.getExemptedAmount());
                Map<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap = this._treasuryExemptionsTeller.retrieveUnchargedExemptionsToApplyMapForTariff((TuitionInstallmentTariff)((Object)tariff), tuitionInstallmentAmountToPay);
                this.createDebitEntryForRegistrationAndExempt((TuitionInstallmentTariff)((Object)tariff), exemptionsToApplyMap, payorDebtAccount, newCreditEntriesSet);
                return true;
            }
            if (!this.isTuitionInstallmentCharged(product)) {
                return this.createUnchargedInstallmentDebitEntry((TuitionInstallmentTariff)((Object)tariff));
            }
            if (this.isTuitionInstallmentCharged(product)) {
                return false;
            }
            throw new IllegalStateException("recalculation: do not know how to handle this case???");
        };
        Predicate<TuitionInstallmentTariff> isToCalculateInstallmentProduct = t -> this.installmentOptions.installments == null || this.installmentOptions.installments.contains(t.getProduct()) || this.installmentRecalculationOptions.recalculateInstallments != null && this.installmentRecalculationOptions.recalculateInstallments.containsKey(t.getProduct());
        return installments.filter(isToCalculateInstallmentProduct).map(func).reduce(Boolean.FALSE, Boolean::logicalOr);
    }

    private Boolean runLogicToIncrementOnlyNetAmountOrExemptions(TuitionInstallmentTariff tariff, Product product, TuitionDebitEntryBean originalBean, BigDecimal differenceInNetExemptedAmount, BigDecimal differenceNetAmount, LocalDate debtDate, DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent) {
        LocalDate recalculationDueDate = this.installmentRecalculationOptions.recalculateInstallments.get(product);
        Map<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap = this._treasuryExemptionsTeller.retrieveAdditionalExemptionsToApplyMapForTariff(tariff, product, originalBean, differenceInNetExemptedAmount);
        BigDecimal debitEntryNetAmount = differenceNetAmount.add(differenceInNetExemptedAmount);
        return this.createRecalculationAdditionalDebitEntryForRegistrationAndExempt(debtDate, debtAccount, academicTreasuryEvent, tariff, exemptionsToApplyMap, debitEntryNetAmount, recalculationDueDate);
    }

    private Boolean runLogicToDecrementOnlyNetAmountOrExemptions(TuitionInstallmentTariff tariff, AcademicTreasuryEvent academicTreasuryEvent, TuitionDebitEntryBean originalBean, Product product, BigDecimal differenceNetAmount) {
        String recalculationReason = AcademicTreasuryConstants.academicTreasuryBundle("label.RegistrationTuitionService.tuitionRecalculationReason", new String[0]);
        Map<TreasuryExemptionType, BigDecimal> exemptionDecrementAmountsByTypeMap = this._treasuryExemptionsTeller.getTreasuryExemptionDecrementsByTypeMap(tariff, academicTreasuryEvent, originalBean);
        List debitEntriesToCreditList = DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)product).sorted(DebitEntry.COMPARE_BY_EXTERNAL_ID.reversed()).collect(Collectors.toList());
        BigDecimal remainingAmountToCredit = differenceNetAmount.negate();
        for (DebitEntry d : debitEntriesToCreditList) {
            BigDecimal sumOfExemptionDecrementAmountsByType = exemptionDecrementAmountsByTypeMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            if (!TreasuryConstants.isPositive((BigDecimal)remainingAmountToCredit) && !TreasuryConstants.isPositive((BigDecimal)sumOfExemptionDecrementAmountsByType)) {
                return true;
            }
            BigDecimal netAmountToCredit = remainingAmountToCredit.min(d.getAvailableNetAmountForCredit());
            HashMap<TreasuryExemptionType, BigDecimal> netExemptedAmountToCreditByTypeMap = new HashMap<TreasuryExemptionType, BigDecimal>();
            for (TreasuryExemptionType t2 : exemptionDecrementAmountsByTypeMap.keySet()) {
                BigDecimal netExemptedAmountToCredit = exemptionDecrementAmountsByTypeMap.get(t2).min(d.getAvailableNetExemptedAmountForCredit(t2));
                if (!TreasuryConstants.isPositive((BigDecimal)netExemptedAmountToCredit)) continue;
                netExemptedAmountToCreditByTypeMap.put(t2, netExemptedAmountToCredit);
            }
            remainingAmountToCredit = remainingAmountToCredit.subtract(netAmountToCredit);
            netExemptedAmountToCreditByTypeMap.keySet().forEach(t -> exemptionDecrementAmountsByTypeMap.put((TreasuryExemptionType)t, ((BigDecimal)exemptionDecrementAmountsByTypeMap.get(t)).subtract((BigDecimal)netExemptedAmountToCreditByTypeMap.get(t))));
            if (d.getFinantialDocument() == null || d.getFinantialDocument().isPreparing()) {
                DebtAccount payorDebtAccount = d.getDebitNote() != null ? d.getDebitNote().getPayorDebtAccount() : null;
                d.getEffectiveNetExemptionAmountsMapByType().entrySet().forEach(entry -> this._treasuryExemptionsTeller.fillBackExemptionAmountForAllInstallments(tariff, (TreasuryExemptionType)entry.getKey(), (BigDecimal)entry.getValue()));
                DebitNote debitNote = d.getDebitNote();
                if (d.getDebitNote() != null) {
                    d.removeFromDocument();
                }
                Map creditExemptionsMap = d.calculateNetExemptedAmountsToCreditMapBasedInExplicitAmounts(netExemptedAmountToCreditByTypeMap, true);
                BigDecimal sumOfNetExemptedAmountToCreditByTypeMap = netExemptedAmountToCreditByTypeMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal newNetAmount = d.getNetAmount().add(d.getNetExemptedAmount()).subtract(netAmountToCredit).subtract(sumOfNetExemptedAmountToCreditByTypeMap);
                if (TreasuryConstants.isPositive((BigDecimal)newNetAmount)) {
                    DebitEntry newDebitEntry = DebitEntry.create((FinantialEntity)d.getFinantialEntity(), (DebtAccount)d.getDebtAccount(), (TreasuryEvent)d.getTreasuryEvent(), (Vat)d.getVat(), (BigDecimal)newNetAmount, (LocalDate)d.getDueDate(), (Map)d.getPropertiesMap(), (Product)d.getProduct(), (String)d.getDescription(), (BigDecimal)BigDecimal.ONE, (InterestRate)d.getInterestRate(), (DateTime)d.getEntryDateTime(), (boolean)d.isAcademicalActBlockingSuspension(), (boolean)d.isBlockAcademicActsOnDebt(), (DebitNote)debitNote);
                    if (payorDebtAccount != null) {
                        DocumentNumberSeries debitNoteNumberSeries = DocumentNumberSeries.findUniqueDefaultSeries((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialEntity)newDebitEntry.getFinantialEntity());
                        DebitNote.createDebitNoteForDebitEntry((DebitEntry)newDebitEntry, (DebtAccount)payorDebtAccount, (DocumentNumberSeries)debitNoteNumberSeries, (DateTime)new DateTime(), (LocalDate)new LocalDate(), null, null, null);
                    }
                    Map<TreasuryExemptionType, BigDecimal> newTreasuryExemptionMapByType = this._treasuryExemptionsTeller.retrieveUnchargedExemptionsToApplyMapForTariff(tariff, newNetAmount);
                    newTreasuryExemptionMapByType.entrySet().forEach(entry -> {
                        String exemptionReason = ((TreasuryExemptionType)entry.getKey()).getName().getContent(TreasuryPlataformDependentServicesFactory.implementation().defaultLocale());
                        TreasuryExemption.create((TreasuryExemptionType)((TreasuryExemptionType)entry.getKey()), (String)exemptionReason, (BigDecimal)((BigDecimal)entry.getValue()), (DebitEntry)newDebitEntry);
                    });
                }
                d.annulOnlyThisDebitEntryAndInterestsInBusinessContext(recalculationReason, false);
                continue;
            }
            if (d.getFinantialDocument().isClosed()) {
                Map creditExemptionsMap = d.calculateNetExemptedAmountsToCreditMapBasedInExplicitAmounts(netExemptedAmountToCreditByTypeMap, true);
                creditExemptionsMap.entrySet().forEach(entry -> this._treasuryExemptionsTeller.fillBackExemptionAmountForAllInstallments(tariff, ((TreasuryExemption)entry.getKey()).getTreasuryExemptionType(), (BigDecimal)entry.getValue()));
                d.creditDebitEntry(netAmountToCredit, recalculationReason, false, creditExemptionsMap);
                if (!this.isToBeAnnulledInTreasuryEvent(d)) continue;
                d.annulOnEvent();
                continue;
            }
            throw new IllegalStateException("how to handle this case?");
        }
        return true;
    }

    private boolean isToBeAnnulledInTreasuryEvent(DebitEntry debitEntry) {
        BigDecimal netExemptedAmount = debitEntry.getNetExemptedAmount();
        BigDecimal creditedNetExemptedAmount = debitEntry.getCreditEntriesSet().stream().filter(c -> !c.isAnnulled()).map(c -> c.getNetExemptedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        boolean availableNetAmountForCreditNotPositive = !TreasuryConstants.isPositive((BigDecimal)debitEntry.getAvailableNetAmountForCredit());
        boolean netExemptedAmountNotPositive = !TreasuryConstants.isPositive((BigDecimal)netExemptedAmount.subtract(creditedNetExemptedAmount));
        return availableNetAmountForCreditNotPositive && netExemptedAmountNotPositive;
    }

    private Boolean createUnchargedInstallmentDebitEntry(TuitionInstallmentTariff tariff) {
        BigDecimal tuitionInstallmentAmountToPay = tariff.amountToPay(this);
        if (!TreasuryConstants.isPositive((BigDecimal)tuitionInstallmentAmountToPay)) {
            return false;
        }
        Map<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap = this._treasuryExemptionsTeller.retrieveUnchargedExemptionsToApplyMapForTariff(tariff, tuitionInstallmentAmountToPay);
        this.createDebitEntryForRegistrationAndExempt(tariff, exemptionsToApplyMap, null, Set.of());
        return true;
    }

    private LocalizedString ls(String value) {
        return new LocalizedString(TreasuryPlataformDependentServicesFactory.implementation().defaultLocale(), value);
    }

    private Boolean createRecalculationAdditionalDebitEntryForRegistrationAndExempt(LocalDate debtDate, DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, TuitionInstallmentTariff tariff, Map<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap, BigDecimal recalculatedAmount, LocalDate recalculationDueDate) {
        DebitEntry installmentDebitEntry = tariff.createRecalculationDebitEntryForRegistration(debtAccount, academicTreasuryEvent, debtDate, this._calculatorsMap, recalculatedAmount, recalculationDueDate);
        for (Map.Entry<TreasuryExemptionType, BigDecimal> entry : exemptionsToApplyMap.entrySet()) {
            TreasuryExemptionType treasuryExemptionType = entry.getKey();
            BigDecimal amountToExempt = entry.getValue();
            String reason = treasuryExemptionType.getName().getContent(TreasuryPlataformDependentServicesFactory.implementation().defaultLocale());
            TreasuryExemption.create((TreasuryExemptionType)treasuryExemptionType, (String)reason, (BigDecimal)amountToExempt, (DebitEntry)installmentDebitEntry);
        }
        return true;
    }

    private DebitEntry createDebitEntryForRegistrationAndExempt(TuitionInstallmentTariff tariff, Map<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap, DebtAccount payorDebtAccount, Set<CreditEntry> newCreditEntriesCreatedWithAnnulOfOldDebitEntriesSet) {
        DebitEntry newDebitEntry = tariff.createDebitEntryForRegistration(this);
        for (Map.Entry<TreasuryExemptionType, BigDecimal> entry : exemptionsToApplyMap.entrySet()) {
            TreasuryExemptionType treasuryExemptionType = entry.getKey();
            BigDecimal amountToExempt = entry.getValue();
            String reason = treasuryExemptionType.getName().getContent(TreasuryPlataformDependentServicesFactory.implementation().defaultLocale());
            TreasuryExemption.create((TreasuryExemptionType)treasuryExemptionType, (String)reason, (BigDecimal)amountToExempt, (DebitEntry)newDebitEntry);
        }
        if (payorDebtAccount != null && newDebitEntry.getDebitNote() == null) {
            DocumentNumberSeries debitNoteNumberSeries = DocumentNumberSeries.findUniqueDefaultSeries((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialEntity)newDebitEntry.getFinantialEntity());
            DebitNote.createDebitNoteForDebitEntry((DebitEntry)newDebitEntry, (DebtAccount)payorDebtAccount, (DocumentNumberSeries)debitNoteNumberSeries, (DateTime)new DateTime(), (LocalDate)new LocalDate(), null, null, null);
        }
        Comparator<InvoiceEntry> invoiceEntryHighestAmountComparator = Comparator.comparing(InvoiceEntry::getOpenAmount).reversed().thenComparing(AbstractDomainObject::getExternalId);
        TreeSet<InvoiceEntry> creditEntriesToCompensateSet = new TreeSet<InvoiceEntry>(invoiceEntryHighestAmountComparator);
        creditEntriesToCompensateSet.addAll(newCreditEntriesCreatedWithAnnulOfOldDebitEntriesSet);
        while (!creditEntriesToCompensateSet.isEmpty()) {
            CreditEntry creditEntryToSettle = (CreditEntry)creditEntriesToCompensateSet.pollFirst();
            if (!TreasuryConstants.isPositive((BigDecimal)creditEntryToSettle.getOpenAmount())) continue;
            newDebitEntry.getAllSplittedDebitEntriesSet().stream().filter(de -> de.getDebtAccount() == creditEntryToSettle.getDebtAccount()).filter(de -> TreasuryConstants.isPositive((BigDecimal)de.getOpenAmount())).filter(de -> de.getDebitNote() == null || de.getDebitNote().isPreparing()).filter(this.hasTheSamePayorDebtAccount(creditEntryToSettle)).sorted(invoiceEntryHighestAmountComparator).findFirst().ifPresent(de -> {
                BigDecimal minimumAmountToSettle = creditEntryToSettle.getOpenAmount().min(de.getOpenAmount());
                DocumentNumberSeries settleDocNumSeries = DocumentNumberSeries.findUniqueDefaultSeries((FinantialDocumentType)FinantialDocumentType.findForSettlementNote(), (FinantialEntity)creditEntryToSettle.getFinantialEntity());
                SettlementNoteBean settlementNoteBean = new SettlementNoteBean(creditEntryToSettle.getDebtAccount(), false, false);
                settlementNoteBean.setFinantialEntity(creditEntryToSettle.getFinantialEntity());
                settlementNoteBean.setDocNumSeries(settleDocNumSeries);
                settlementNoteBean.getInvoiceEntryBean((InvoiceEntry)creditEntryToSettle).setIncluded(true);
                settlementNoteBean.getInvoiceEntryBean((InvoiceEntry)creditEntryToSettle).setSettledAmount(minimumAmountToSettle);
                settlementNoteBean.getInvoiceEntryBean((InvoiceEntry)de).setIncluded(true);
                settlementNoteBean.getInvoiceEntryBean((InvoiceEntry)de).setSettledAmount(minimumAmountToSettle);
                SettlementNote.createSettlementNote((SettlementNoteBean)settlementNoteBean);
            });
        }
        return newDebitEntry;
    }

    private Predicate<DebitEntry> hasTheSamePayorDebtAccount(CreditEntry creditEntryToSettle) {
        return de -> {
            DebtAccount debitEntryPayorAccount = de.getDebitNote() != null ? de.getDebitNote().getPayorDebtAccount() : null;
            return creditEntryToSettle.getCreditNote().getPayorDebtAccount() == debitEntryPayorAccount;
        };
    }

    public List<TuitionDebitEntryBean> executeInstallmentDebitEntryBeansCalculation() {
        this.initializeCreditsAndEnrolledCoursesCount();
        this.initializeTuitionPaymentPlan();
        this.initializeCustomCalculators();
        this.initializeOriginalAmountsCalculator();
        this._treasuryExemptionsTeller = new TreasuryExemptionsTeller(this);
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        if (tuitionPaymentPlan == null) {
            return Collections.emptyList();
        }
        if (!tuitionPaymentPlan.getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        Predicate<TuitionInstallmentTariff> isToCalculateInstallmentProduct = t -> this.installmentOptions.installments == null || this.installmentOptions.installments.contains(t.getProduct()) || this.installmentRecalculationOptions.recalculateInstallments != null && this.installmentRecalculationOptions.recalculateInstallments.containsKey(t.getProduct());
        HashMap calculatedDebitEntryBeansMap = new HashMap();
        if (!this.isForCalculationsOfOriginalAmounts) {
            this._originalAmountsCalculator.executeInstallmentDebitEntryBeansCalculation().stream().forEach(e -> calculatedDebitEntryBeansMap.put(e.getTuitionInstallmentTariff(), e));
        }
        List<TuitionDebitEntryBean> entries = tuitionPaymentPlan.getTuitionInstallmentTariffsSet().stream().sorted(TuitionInstallmentTariff.COMPARATOR_BY_INSTALLMENT_NUMBER).filter(isToCalculateInstallmentProduct).flatMap(t -> this.buildInstallmentDebitEntryBeanWithDiscount(calculatedDebitEntryBeansMap, (TuitionInstallmentTariff)((Object)t)).stream()).filter(Objects::nonNull).collect(Collectors.toList());
        return entries;
    }

    private void initializeOriginalAmountsCalculator() {
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        LocalDate debtDate = this.registrationOptions.debtDate;
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        TuitionAllocation tuitionAllocation = this.tuitionOptions.tuitionAllocation;
        RegistrationOptions serviceBuilder = RegistrationTuitionService.startServiceInvocation(registration, executionYear, debtDate);
        serviceBuilder.applyEnrolledEctsUnits(this.registrationOptions.enrolledEctsUnits);
        serviceBuilder.applyEnrolledCoursesCount(this.registrationOptions.enrolledCoursesCount);
        serviceBuilder.applyDefaultEnrolmentCredits(this.registrationOptions.applyDefaultEnrolmentCredits);
        TuitionOptions tuitionPaymentPlanBuilder = serviceBuilder.withTuitionPaymentPlan(tuitionPaymentPlan);
        tuitionPaymentPlanBuilder.applyTuitionAllocation(tuitionAllocation);
        if (this.installmentOptions.installments != null) {
            HashSet<Product> products = new HashSet<Product>(this.installmentOptions.installments);
            if (this.installmentRecalculationOptions.recalculateInstallments != null) {
                products.addAll(this.installmentRecalculationOptions.recalculateInstallments.keySet());
            }
            this._originalAmountsCalculator = tuitionPaymentPlanBuilder.forceCreationIfNotEnrolled(true).restrictForInstallmentProducts(products).forceInstallmentsEvenTreasuryEventIsCharged(true).withoutInstallmentsRecalculation();
        } else {
            this._originalAmountsCalculator = tuitionPaymentPlanBuilder.forceCreationIfNotEnrolled(true).withAllInstallments().forceInstallmentsEvenTreasuryEventIsCharged(true).withoutInstallmentsRecalculation();
        }
        this._originalAmountsCalculator.isForCalculationsOfOriginalAmounts = true;
    }

    private void initializeCreditsAndEnrolledCoursesCount() {
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        TuitionPaymentPlanGroup tuitionPaymentPlanGroup = TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get();
        if (this.registrationOptions.enrolledEctsUnits == null) {
            this.registrationOptions.enrolledEctsUnits = AcademicTreasuryEvent.getEnrolledEctsUnits(tuitionPaymentPlanGroup, registration, executionYear);
        }
        if (this.registrationOptions.enrolledCoursesCount == null) {
            this.registrationOptions.enrolledCoursesCount = AcademicTreasuryEvent.getEnrolledCoursesCount(tuitionPaymentPlanGroup, registration, executionYear);
        }
    }

    private List<TuitionDebitEntryBean> buildInstallmentDebitEntryBeanWithDiscount(Map<TuitionInstallmentTariff, TuitionDebitEntryBean> calculatedDebitEntryBeansMap, TuitionInstallmentTariff tariff) {
        boolean isToRecalculateInstallment;
        Product product = tariff.getProduct();
        Currency currency = tariff.getFinantialEntity().getFinantialInstitution().getCurrency();
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        Registration registration = this.registrationOptions.registration;
        LocalDate debtDate = this.registrationOptions.debtDate;
        int installmentOrder = tariff.getInstallmentOrder();
        LocalizedString installmentName = tuitionPaymentPlan.installmentName(registration, tariff);
        LocalDate dueDate = tariff.dueDate(debtDate);
        Vat vat = tariff.vat(debtDate);
        this._treasuryExemptionsTeller.createDiscountExemptionsMapForOnlyThisInstallment(tariff);
        boolean bl = isToRecalculateInstallment = this.installmentRecalculationOptions.recalculateInstallments != null && this.installmentRecalculationOptions.recalculateInstallments.containsKey(product);
        if (isToRecalculateInstallment && this.isTuitionInstallmentCharged(product)) {
            boolean isDifferenceNetAmountPositiveOrZero;
            TuitionDebitEntryBean originalBean = calculatedDebitEntryBeansMap.computeIfAbsent(tariff, t -> new TuitionDebitEntryBean(installmentOrder, (TuitionInstallmentTariff)((Object)t), this.ls("Dummy installment"), debtDate, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, (Map<TreasuryExemptionType, BigDecimal>)new HashMap<TreasuryExemptionType, BigDecimal>(), currency));
            BigDecimal differenceNetAmount = originalBean.getAmount().subtract(this.getNetAmountAlreadyDebited(product));
            BigDecimal differenceInNetExemptedAmount = originalBean.getExemptedAmount().subtract(this.getNetAmountAlreadyExempted(product));
            AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForRegistrationTuition(this.registrationOptions.registration, this.registrationOptions.executionYear).get();
            boolean isExemptionsMapAreEqual = this._treasuryExemptionsTeller.isExemptionsMapAreEqual(tariff, academicTreasuryEvent, originalBean);
            boolean isThereIsOnlyRemovalsOrDecrementsInExemptions = this._treasuryExemptionsTeller.isThereIsOnlyRemovalsOrDecrementsInExemptions(tariff, academicTreasuryEvent, originalBean);
            boolean isThereAreOnlyNewEntriesOrIncrementsInExemptions = this._treasuryExemptionsTeller.isThereAreOnlyNewEntriesOrIncrementsInExemptions(tariff, academicTreasuryEvent, originalBean);
            boolean isThereAreRemovalOrDecrementsInExemptions = this._treasuryExemptionsTeller.isThereAreRemovalOrDecrementsInExemptions(tariff, academicTreasuryEvent, originalBean);
            boolean isDifferenceNetAmountZero = TreasuryConstants.isZero((BigDecimal)differenceNetAmount);
            boolean isDifferenceNetAmountNegativeOrZero = !TreasuryConstants.isPositive((BigDecimal)differenceNetAmount);
            boolean bl2 = isDifferenceNetAmountPositiveOrZero = !TreasuryConstants.isNegative((BigDecimal)differenceNetAmount);
            if (isDifferenceNetAmountZero && isExemptionsMapAreEqual) {
                return Collections.emptyList();
            }
            if (isDifferenceNetAmountNegativeOrZero && (isExemptionsMapAreEqual || isThereIsOnlyRemovalsOrDecrementsInExemptions)) {
                LocalDate recalculationDueDate = this.installmentRecalculationOptions.recalculateInstallments.get(product);
                LocalizedString recalculationInstallmentName = installmentName;
                if (tuitionPaymentPlan.getTuitionPaymentPlanGroup().getTuitionRecalculationDebitEntryPrefix() != null) {
                    recalculationInstallmentName = tuitionPaymentPlan.getTuitionPaymentPlanGroup().getTuitionRecalculationDebitEntryPrefix().append(recalculationInstallmentName, " ");
                }
                if (tuitionPaymentPlan.getTuitionPaymentPlanGroup().getTuitionRecalculationDebitEntrySuffix() != null) {
                    recalculationInstallmentName = recalculationInstallmentName.append(tuitionPaymentPlan.getTuitionPaymentPlanGroup().getTuitionRecalculationDebitEntrySuffix(), " ");
                }
                recalculationInstallmentName = this.trim(recalculationInstallmentName);
                return Collections.singletonList(new TuitionDebitEntryBean(installmentOrder, tariff, recalculationInstallmentName, recalculationDueDate, vat.getTaxRate(), differenceNetAmount, differenceInNetExemptedAmount, new HashMap<TreasuryExemptionType, BigDecimal>(), currency));
            }
            if (isDifferenceNetAmountPositiveOrZero && (isExemptionsMapAreEqual || isThereAreOnlyNewEntriesOrIncrementsInExemptions)) {
                LocalDate recalculationDueDate = this.installmentRecalculationOptions.recalculateInstallments.get(product);
                LocalizedString recalculationInstallmentName = installmentName;
                if (tuitionPaymentPlan.getTuitionPaymentPlanGroup().getTuitionRecalculationDebitEntryPrefix() != null) {
                    recalculationInstallmentName = tuitionPaymentPlan.getTuitionPaymentPlanGroup().getTuitionRecalculationDebitEntryPrefix().append(recalculationInstallmentName, " ");
                }
                if (tuitionPaymentPlan.getTuitionPaymentPlanGroup().getTuitionRecalculationDebitEntrySuffix() != null) {
                    recalculationInstallmentName = recalculationInstallmentName.append(tuitionPaymentPlan.getTuitionPaymentPlanGroup().getTuitionRecalculationDebitEntrySuffix(), " ");
                }
                recalculationInstallmentName = this.trim(recalculationInstallmentName);
                this._treasuryExemptionsTeller.retrieveAdditionalExemptionsToApplyMapForTariff(tariff, product, originalBean, differenceInNetExemptedAmount);
                return Collections.singletonList(new TuitionDebitEntryBean(installmentOrder, tariff, recalculationInstallmentName, recalculationDueDate, vat.getTaxRate(), differenceNetAmount, differenceInNetExemptedAmount, new HashMap<TreasuryExemptionType, BigDecimal>(), currency));
            }
            LocalizedString annulmentInstallmentName = AcademicTreasuryConstants.academicTreasuryBundleI18N("label.RegistrationTuitionService.annulment.installmentName.prefix", new String[0]).append(installmentName);
            LocalDate recalculationDueDate = this.installmentRecalculationOptions.recalculateInstallments.get(product);
            TuitionDebitEntryBean annulmentBean = new TuitionDebitEntryBean(installmentOrder, tariff, annulmentInstallmentName, recalculationDueDate, vat.getTaxRate(), this.getNetAmountAlreadyDebited(product).negate(), this.getNetAmountAlreadyExempted(product).negate(), new HashMap<TreasuryExemptionType, BigDecimal>(), currency);
            TuitionDebitEntryBean recalculationBean = new TuitionDebitEntryBean(installmentOrder, tariff, installmentName, recalculationDueDate, vat.getTaxRate(), originalBean.getAmount(), originalBean.getExemptedAmount(), new HashMap<TreasuryExemptionType, BigDecimal>(), currency);
            this._treasuryExemptionsTeller.retrieveUnchargedExemptionsToApplyMapForTariff(tariff, originalBean.getExemptedAmount());
            return List.of(annulmentBean, recalculationBean);
        }
        if (!this.isTuitionInstallmentCharged(product) || this.isForCalculationsOfOriginalAmounts) {
            BigDecimal tuitionInstallmentAmountToPay = tariff.amountToPay(this);
            if (!TreasuryConstants.isPositive((BigDecimal)tuitionInstallmentAmountToPay)) {
                return Collections.emptyList();
            }
            Map<TreasuryExemptionType, BigDecimal> exemptionsMapToApply = this._treasuryExemptionsTeller.retrieveUnchargedExemptionsToApplyMapForTariff(tariff, tuitionInstallmentAmountToPay);
            BigDecimal totalAmountToExempt = exemptionsMapToApply.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal finalAmountToPay = tuitionInstallmentAmountToPay.subtract(totalAmountToExempt);
            return Collections.singletonList(new TuitionDebitEntryBean(installmentOrder, tariff, installmentName, dueDate, vat.getTaxRate(), finalAmountToPay, totalAmountToExempt, exemptionsMapToApply, currency));
        }
        return Collections.emptyList();
    }

    private LocalizedString trim(LocalizedString value) {
        return value.getLocales().stream().map(l -> new LocalizedString(l, value.getContent(l) != null ? value.getContent(l).trim() : null)).reduce(new LocalizedString(), LocalizedString::append);
    }

    private BigDecimal getNetAmountAlreadyExempted(Product product) {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(this.registrationOptions.registration, this.registrationOptions.executionYear).map(e -> e.getNetExemptedAmount(product)).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getNetAmountAlreadyDebited(Product product) {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(this.registrationOptions.registration, this.registrationOptions.executionYear).map(e -> e.getNetAmountToPay(product)).orElse(BigDecimal.ZERO);
    }

    private boolean isTuitionInstallmentCharged(Product product) {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(this.registrationOptions.registration, this.registrationOptions.executionYear).map(e -> e.isChargedWithDebitEntry(product)).orElse(false);
    }

    private void initializeCustomCalculators() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        Registration registration = this.registrationOptions.registration;
        StringBuilder strBuilder = new StringBuilder();
        if (Boolean.TRUE.equals(tuitionPaymentPlan.getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators())) {
            tuitionPaymentPlan.getTuitionInstallmentTariffsSet().stream().filter(tariff -> tariff.getTuitionPaymentPlanCalculator() != null).map(tariff -> tariff.getTuitionPaymentPlanCalculator()).collect(Collectors.toSet()).forEach(calculator -> {
                strBuilder.append(calculator.getName().getContent(services.defaultLocale())).append(" (").append(calculator.getTotalAmount(registration, (ITuitionRegistrationServiceParameters)this)).append("): \n");
                strBuilder.append(calculator.getCalculationDescription(registration)).append("\n");
            });
        } else {
            this._calculatorsMap = new HashMap<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator>();
            tuitionPaymentPlan.getTuitionInstallmentTariffsSet().stream().filter(t -> t.getTuitionTariffCustomCalculator() != null).map(TuitionInstallmentTariff::getTuitionTariffCustomCalculator).collect(Collectors.toSet()).forEach(clazz -> {
                if (clazz != null) {
                    TuitionTariffCustomCalculator newInstanceFor = TuitionTariffCustomCalculator.getNewInstanceFor(clazz, registration, tuitionPaymentPlan);
                    this._calculatorsMap.put((Class<? extends TuitionTariffCustomCalculator>)clazz, newInstanceFor);
                    strBuilder.append(newInstanceFor.getPresentationName()).append(" (").append(newInstanceFor.getTotalAmount()).append("): \n");
                    strBuilder.append(newInstanceFor.getCalculationDescription()).append("\n");
                }
            });
        }
        this._calculationDescription = strBuilder.toString();
    }

    private void initializeTuitionPaymentPlan() {
        if (this.tuitionOptions.tuitionPaymentPlan == null) {
            this.tuitionOptions.tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForRegistration(this.registrationOptions.registration, this.registrationOptions.executionYear);
        }
        if (!this.isForCalculationsOfOriginalAmounts && this.tuitionOptions.tuitionPaymentPlan != null) {
            this.tuitionOptions.tuitionPaymentPlan.getTuitionPaymentPlanRecalculationsSet().stream().forEach(r -> {
                if (this.installmentRecalculationOptions.recalculateInstallments == null) {
                    this.installmentRecalculationOptions.recalculateInstallments = new HashMap<Product, LocalDate>();
                }
                this.installmentRecalculationOptions.recalculateInstallments.putIfAbsent(r.getProduct(), r.getRecalculationDueDate());
            });
        }
    }

    public static RegistrationOptions startServiceInvocation(Registration registration, ExecutionYear executionYear, LocalDate debtDate) {
        RegistrationTuitionService service = new RegistrationTuitionService();
        return new RegistrationOptions(service, registration, executionYear, debtDate);
    }

    @Override
    public Registration getRegistration() {
        return this.registrationOptions.registration;
    }

    @Override
    public ExecutionYear getExecutionYear() {
        return this.registrationOptions.executionYear;
    }

    @Override
    public Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> getCustomCalculatorsMap() {
        return this._calculatorsMap;
    }

    @Override
    public BigDecimal getEnrolledEctsUnits() {
        return this.registrationOptions.enrolledEctsUnits;
    }

    @Override
    public BigDecimal getEnrolledCoursesCount() {
        return this.registrationOptions.enrolledCoursesCount;
    }

    @Override
    public boolean isApplyDefaultEnrolmentCredits() {
        return this.registrationOptions.applyDefaultEnrolmentCredits;
    }

    @Override
    public Optional<DebtAccount> getDebtAccount() {
        Person person = this.getRegistration().getPerson();
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            return Optional.empty();
        }
        if (PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).isEmpty()) {
            return Optional.empty();
        }
        PersonCustomer personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get();
        if (!personCustomer.isActive()) {
            return Optional.empty();
        }
        if (this.tuitionOptions.tuitionPaymentPlan == null) {
            return Optional.empty();
        }
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        return DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
    }

    @Override
    public Optional<AcademicTreasuryEvent> getAcademicTreasuryEvent() {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(this.getRegistration(), this.getExecutionYear()).map(AcademicTreasuryEvent.class::cast);
    }

    @Override
    public LocalDate getDebtDate() {
        return this.registrationOptions.debtDate;
    }
}

