/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.calculators;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.calculators.TestTuitionPaymentPlanCalculator_Base;
import org.fenixedu.academictreasury.domain.tuition.calculators.TuitionCalculatorAggregator;
import org.fenixedu.academictreasury.domain.tuition.calculators.TuitionPaymentPlanCalculator;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;

public class TestTuitionPaymentPlanCalculator
extends TestTuitionPaymentPlanCalculator_Base {
    public TestTuitionPaymentPlanCalculator() {
    }

    public TestTuitionPaymentPlanCalculator(LocalizedString name) {
        this();
        super.setName(name);
        this.checkRules();
    }

    private void checkRules() {
    }

    public void edit(LocalizedString name, BigDecimal amount) {
        super.setName(name);
        super.setAmount(amount);
        this.checkRules();
    }

    public boolean isValid() {
        return this.getAmount() != null && TreasuryConstants.isPositive((BigDecimal)this.getAmount());
    }

    public BigDecimal getTotalAmount(Registration registration) {
        if (!this.isValid()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlanCalculator.not.valid", new String[0]);
        }
        BigDecimal normalEnrolmentsEcts = TuitionServices.normalEnrolmentsIncludingAnnuled(registration, this.getTuitionPaymentPlan().getExecutionYear()).stream().map(e -> e.getEctsCreditsForCurriculum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        return this.getAmount().multiply(normalEnrolmentsEcts);
    }

    public BigDecimal getTotalAmount(Enrolment enrolment) {
        return enrolment.getEctsCreditsForCurriculum().multiply(this.getAmount());
    }

    public String getCalculationDescription(Registration registration) {
        BigDecimal normalEnrolmentsEcts = TuitionServices.normalEnrolmentsIncludingAnnuled(registration, this.getTuitionPaymentPlan().getExecutionYear()).stream().map(e -> e.getEctsCreditsForCurriculum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        String description = services.bundle(services.defaultLocale(), "resources.AcademicTreasuryResources", "label.TestTuitionPaymentPlanCalculator.calculationDescription", new String[]{this.getAmount().toString(), normalEnrolmentsEcts.toString(), this.getTotalAmount(registration).toString()});
        return description;
    }

    public String getCalculationDescription(Enrolment enrolment) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        String description = services.bundle(services.defaultLocale(), "resources.AcademicTreasuryResources", "label.TestTuitionPaymentPlanCalculator.calculationDescription", new String[]{this.getAmount().toString(), enrolment.getEctsCreditsForCurriculum().toString(), this.getTotalAmount(enrolment).toString()});
        return description;
    }

    public LocalizedString getParametersDescription() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        LocalizedString result = services.availableLocales().stream().map(locale -> new LocalizedString(locale, services.bundle(locale, "resources.AcademicTreasuryResources", "label.TestTuitionPaymentPlanCalculator.parametersDescription", new String[]{this.getAmount() != null ? this.getAmount().toString() : "N/A"}))).reduce((a, c) -> a.append(c)).get();
        return result;
    }

    public static LocalizedString getCalculatorPresentationName() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        return TreasuryPlataformDependentServicesFactory.implementation().availableLocales().stream().map(locale -> new LocalizedString(locale, services.bundle(locale, "resources.AcademicTreasuryResources", TestTuitionPaymentPlanCalculator.class.getName(), new String[0]))).reduce((a, c) -> a.append(c)).get();
    }

    public TuitionPaymentPlanCalculator copyTo(TuitionPaymentPlan tuitionPaymentPlanTarget) {
        TestTuitionPaymentPlanCalculator copy = new TestTuitionPaymentPlanCalculator();
        copy.setAmount(this.getAmount());
        copy.setTuitionPaymentPlan(tuitionPaymentPlanTarget);
        return copy;
    }

    public TuitionPaymentPlanCalculator copyTo(TuitionCalculatorAggregator tuitionCalculatorAggregatorTarget) {
        TestTuitionPaymentPlanCalculator calculator = new TestTuitionPaymentPlanCalculator();
        calculator.setAmount(this.getAmount());
        calculator.setTuitionCalculatorParentAggregator(tuitionCalculatorAggregatorTarget);
        return calculator;
    }

    public void fillWithParametersFromImportation(String parameters) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            BigDecimal amount = (BigDecimal)objectMapper.readValue(parameters, BigDecimal.class);
            super.setAmount(amount);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete() {
        super.delete();
    }

    public static TestTuitionPaymentPlanCalculator create(LocalizedString name) {
        return new TestTuitionPaymentPlanCalculator(name);
    }
}

