/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.importation;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.importation.ITreasuryImportStrategy;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportType$callable$create;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportType$callable$delete;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportType$callable$edit;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportType_Base;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryImportType
extends TreasuryImportType_Base {
    public static final Comparator<? super TreasuryImportType> COMPARE_BY_NAME;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected TreasuryImportType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected TreasuryImportType(String name, String clazz) {
        this();
        this.setName(name);
        this.setClazz(clazz);
        this.checkRules();
    }

    public void edit(String string, String string2) {
        Object object = advice$edit.perform((Callable)new TreasuryImportType$callable$edit(this, string, string2));
    }

    static /* synthetic */ void advised$edit(TreasuryImportType this_, String name, String clazz) {
        this_.setName(name);
        this_.setClazz(clazz);
        this_.checkRules();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new TreasuryImportType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TreasuryImportType this_) {
        if (!this_.getTreasuryImportFilesSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.TreasuryImportType.delete.impossible", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.TreasuryImportType.bennu.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getName())) {
            throw new AcademicTreasuryDomainException("error.TreasuryImportType.name.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getClazz())) {
            throw new AcademicTreasuryDomainException("error.TreasuryImportType.clazz.required", new String[0]);
        }
        this.implementation();
    }

    public ITreasuryImportStrategy<?> implementation() {
        try {
            return (ITreasuryImportStrategy)Class.forName(this.getClazz()).newInstance();
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AcademicTreasuryDomainException("error.TreasuryImportType.clazz.invalid", new String[0]);
        }
    }

    public static Stream<TreasuryImportType> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryImportTypesSet().stream();
    }

    public static Stream<TreasuryImportType> findByClassName(String clazz) {
        return TreasuryImportType.findAll().filter(t -> t.getClazz().equals(clazz));
    }

    public static TreasuryImportType create(String string, String string2) {
        return (TreasuryImportType)((Object)advice$create.perform((Callable)new TreasuryImportType$callable$create(string, string2)));
    }

    static /* synthetic */ TreasuryImportType advised$create(String name, String clazz) {
        return new TreasuryImportType(name, clazz);
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = new Comparator<TreasuryImportType>(){

            @Override
            public int compare(TreasuryImportType o1, TreasuryImportType o2) {
                int c = o1.getName().compareTo(o2.getName());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

