/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.tariff;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tuition.EctsCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.domain.tuition.TuitionTariffCalculatedAmountType;
import org.fenixedu.academictreasury.domain.tuition.TuitionTariffCustomCalculator;
import org.fenixedu.academictreasury.domain.tuition.calculators.TuitionPaymentPlanCalculator;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.CurricularYearConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.ExecutionIntervalConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.FirstTimeStudentConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.IngressionTypeConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.RegistrationProtocolConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.RegistrationRegimeTypeConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.StatuteTypeConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.WithLaboratorialClassesConditionRule;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean$callable$createForCopy;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestRateType;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TuitionPaymentPlanBean
implements Serializable,
ITreasuryBean {
    private static final long serialVersionUID = 1L;
    private FinantialEntity finantialEntity;
    private Product product;
    private TuitionPaymentPlanGroup tuitionPaymentPlanGroup;
    private ExecutionYear executionYear;
    private DegreeType degreeType;
    private Set<DegreeCurricularPlan> degreeCurricularPlans = Sets.newHashSet();
    private boolean showAllDcps;
    private boolean defaultPaymentPlan;
    private boolean customized;
    private DebtAccount payorDebtAccount;
    Set<TuitionConditionRule> conditionRules;
    private String name;
    private List<TreasuryTupleDataSourceBean> executionYearDataSource = null;
    private List<TreasuryTupleDataSourceBean> degreeTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> degreeCurricularPlanDataSource = null;
    private List<TreasuryTupleDataSourceBean> registrationRegimeTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> registrationProtocolDataSource = null;
    private List<TreasuryTupleDataSourceBean> ingressionDataSource = null;
    private List<TreasuryTupleDataSourceBean> curricularYearDataSource = null;
    private List<TreasuryTupleDataSourceBean> semesterDataSource = null;
    private List<TreasuryTupleDataSourceBean> statuteTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> payorDebtAccountDataSource = null;
    private List<TreasuryTupleDataSourceBean> tuitionCalculationTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> ectsCalculationTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> interestTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> dueDateCalculationTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> tuitionInstallmentProductDataSource = null;
    public List<AcademicTariffBean> tuitionInstallmentBeans = Lists.newArrayList();
    private LocalDate beginDate = new LocalDate();
    private LocalDate endDate = AcademicTreasuryConstants.INFINITY_DATE.toLocalDate();
    private DueDateCalculationType dueDateCalculationType;
    private LocalDate fixedDueDate = new LocalDate();
    private int numberOfDaysAfterCreationForDueDate;
    private boolean applyInterests;
    private InterestRateType interestRateType;
    private int numberOfDaysAfterDueDate;
    private boolean applyInFirstWorkday;
    private int maximumDaysToApplyPenalty;
    private BigDecimal interestFixedAmount;
    private BigDecimal rate;
    private Product tuitionInstallmentProduct;
    private int installmentOrder;
    private TuitionCalculationType tuitionCalculationType;
    private BigDecimal fixedAmount;
    private EctsCalculationType ectsCalculationType;
    private BigDecimal factor;
    private BigDecimal totalEctsOrUnits;
    private boolean applyMaximumAmount;
    private BigDecimal maximumAmount;
    private boolean academicalActBlockingOn;
    private boolean blockAcademicActsOnDebt;
    private TuitionTariffCalculatedAmountType tuitionTariffCalculatedAmountType;
    private Class<? extends TuitionTariffCustomCalculator> tuitionTariffCustomCalculator;
    private TuitionPaymentPlanCalculator tuitionPaymentPlanCalculator;
    private List<TuitionPaymentPlanCalculator> tuitionPaymentPlanCalculatorList = new ArrayList<TuitionPaymentPlanCalculator>();
    private ExecutionYear copiedExecutionYear;
    private String sheetName;
    private Map<Class<? extends TuitionConditionRule>, String> importerMap;
    public static final Comparator<TreasuryTupleDataSourceBean> COMPARE_BY_ID_AND_TEXT;
    public static final Advice advice$createForCopy;

    public TuitionPaymentPlanBean() {
        this.importerMap = new HashMap<Class<? extends TuitionConditionRule>, String>();
    }

    public TuitionPaymentPlanBean(Product product, TuitionPaymentPlanGroup tuitionPaymentPlanGroup, FinantialEntity finantialEntity, ExecutionYear executionYear) {
        this.showAllDcps = false;
        this.product = product;
        this.tuitionPaymentPlanGroup = tuitionPaymentPlanGroup;
        this.finantialEntity = finantialEntity;
        this.executionYear = executionYear;
        this.conditionRules = new HashSet<TuitionConditionRule>();
        this.degreeCurricularPlans = new HashSet<DegreeCurricularPlan>();
        this.importerMap = new HashMap<Class<? extends TuitionConditionRule>, String>();
        this.updateData();
        this.resetInstallmentFields();
    }

    public TuitionPaymentPlanBean(TuitionPaymentPlan tuitionPaymentPlan) {
        this(tuitionPaymentPlan.getProduct(), tuitionPaymentPlan.getTuitionPaymentPlanGroup(), tuitionPaymentPlan.getFinantialEntity(), tuitionPaymentPlan.getExecutionYear());
        this.copiedExecutionYear = tuitionPaymentPlan.getExecutionYear();
        this.customized = tuitionPaymentPlan.isCustomized();
        this.defaultPaymentPlan = tuitionPaymentPlan.isDefaultPaymentPlan();
        if (tuitionPaymentPlan.getCustomizedName() != null) {
            this.name = tuitionPaymentPlan.getCustomizedName().getContent();
        }
        this.conditionRules = new HashSet<TuitionConditionRule>(tuitionPaymentPlan.getTuitionConditionRulesSet());
        this.fillWithInstallments(tuitionPaymentPlan);
        this.tuitionPaymentPlanCalculatorList.addAll(tuitionPaymentPlan.getTuitionPaymentPlanCalculatorSet());
    }

    private void fillWithInstallments(TuitionPaymentPlan tuitionPaymentPlan) {
        DebtAccount tuitionPaymentPlanDebtAccount = this.payorDebtAccount;
        for (TuitionInstallmentTariff tuitionInstallmentTariff : tuitionPaymentPlan.getOrderedTuitionInstallmentTariffs()) {
            this.tuitionInstallmentProduct = tuitionInstallmentTariff.getProduct();
            this.beginDate = tuitionInstallmentTariff.getBeginDate().toLocalDate();
            this.dueDateCalculationType = tuitionInstallmentTariff.getDueDateCalculationType();
            this.fixedDueDate = tuitionInstallmentTariff.getFixedDueDate();
            this.numberOfDaysAfterCreationForDueDate = tuitionInstallmentTariff.getNumberOfDaysAfterCreationForDueDate();
            this.applyInterests = tuitionInstallmentTariff.getApplyInterests();
            if (this.applyInterests) {
                this.interestRateType = tuitionInstallmentTariff.getInterestRate().getInterestRateType();
                this.numberOfDaysAfterDueDate = tuitionInstallmentTariff.getNumberOfDaysAfterCreationForDueDate();
                this.applyInFirstWorkday = tuitionInstallmentTariff.getInterestRate().isApplyInFirstWorkday();
                this.maximumDaysToApplyPenalty = tuitionInstallmentTariff.getInterestRate().getMaximumDaysToApplyPenalty();
                this.interestFixedAmount = tuitionInstallmentTariff.getInterestRate().getInterestFixedAmount();
                this.rate = tuitionInstallmentTariff.getInterestRate().getRate();
            }
            this.tuitionCalculationType = tuitionInstallmentTariff.getTuitionCalculationType();
            this.fixedAmount = tuitionInstallmentTariff.getFixedAmount();
            this.ectsCalculationType = tuitionInstallmentTariff.getEctsCalculationType();
            this.factor = tuitionInstallmentTariff.getFactor();
            this.totalEctsOrUnits = tuitionInstallmentTariff.getTotalEctsOrUnits();
            this.applyMaximumAmount = tuitionInstallmentTariff.isApplyMaximumAmount();
            this.maximumAmount = tuitionInstallmentTariff.getMaximumAmount();
            this.academicalActBlockingOn = !tuitionInstallmentTariff.getAcademicalActBlockingOff();
            this.blockAcademicActsOnDebt = tuitionInstallmentTariff.getBlockAcademicActsOnDebt();
            this.tuitionPaymentPlanCalculator = tuitionInstallmentTariff.getTuitionPaymentPlanCalculator();
            this.tuitionTariffCalculatedAmountType = tuitionInstallmentTariff.getTuitionTariffCalculatedAmountType();
            this.tuitionTariffCustomCalculator = tuitionInstallmentTariff.getTuitionTariffCustomCalculator();
            this.payorDebtAccount = tuitionInstallmentTariff.getPayorDebtAccount();
            this.addInstallment();
        }
        this.payorDebtAccount = tuitionPaymentPlanDebtAccount;
    }

    public void updateData() {
        this.degreeTypeDataSource = this.degreeTypeDataSource();
        this.degreeCurricularPlanDataSource = this.degreeCurricularPlanDataSource();
        this.degreeCurricularPlans.clear();
        this.registrationRegimeTypeDataSource = this.registrationRegimeTypeDataSource();
        this.registrationProtocolDataSource = this.registrationProtocolDataSource();
        this.ingressionDataSource = this.ingressionDataSource();
        this.curricularYearDataSource = this.curricularYearDataSource();
        this.semesterDataSource = this.semesterDataSource();
        this.tuitionCalculationTypeDataSource = TuitionPaymentPlanBean.tuitionCalculationTypeDataSource();
        this.ectsCalculationTypeDataSource = TuitionPaymentPlanBean.ectsCalculationTypeDataSource();
        this.interestTypeDataSource = TuitionPaymentPlanBean.interestTypeDataSource();
        this.dueDateCalculationTypeDataSource = TuitionPaymentPlanBean.dueDateCalculationTypeDataSource();
        this.tuitionInstallmentProductDataSource = TuitionPaymentPlanBean.tuitionInstallmentProductDataSource(this.getTuitionPaymentPlanGroup(), this.tuitionInstallmentBeans.size() + 1);
        this.statuteTypeDataSource = this.statuteTypeDataSource();
        this.payorDebtAccountDataSource = this.payorDebtAccountDataSource();
        this.executionYearDataSource = this.executionYearDataSource();
    }

    public void updateDatesBasedOnSelectedExecutionYear() {
        if (!this.isTuitionPaymentPlanCreationFromCopy()) {
            return;
        }
        int executionYearInterval = this.executionYear.getAcademicInterval().getStart().getYear() - this.copiedExecutionYear.getAcademicInterval().getStart().getYear();
        for (AcademicTariffBean academicTariffBean : this.tuitionInstallmentBeans) {
            academicTariffBean.setBeginDate(academicTariffBean.getBeginDate().plusYears(executionYearInterval));
            if (academicTariffBean.getFixedDueDate() == null) continue;
            academicTariffBean.setFixedDueDate(academicTariffBean.getFixedDueDate().plusYears(executionYearInterval));
        }
    }

    private boolean isTuitionPaymentPlanCreationFromCopy() {
        return this.copiedExecutionYear != null;
    }

    public static List<TreasuryTupleDataSourceBean> dueDateCalculationTypeDataSource() {
        return Arrays.asList(DueDateCalculationType.values()).stream().filter(t -> !t.isNoDueDate() && !t.isFixedDate()).map(t -> new TreasuryTupleDataSourceBean(t.name(), t.getDescriptionI18N().getContent())).collect(Collectors.toList());
    }

    public List<String> addInstallment() {
        ArrayList errorMessages = Lists.newArrayList();
        AcademicTariffBean installmentBean = new AcademicTariffBean(this.tuitionInstallmentBeans.size() + 1);
        if (this.tuitionInstallmentProduct == null) {
            errorMessages.add("error.TuitionPaymentPlan.tuitionInstallmentProduct.required");
        }
        if (this.tuitionCalculationType == null) {
            errorMessages.add("error.TuitionPaymentPlan.tuitionCalculationType.required");
        }
        if (this.tuitionCalculationType != null && this.tuitionCalculationType.isFixedAmount() && this.fixedAmount == null) {
            errorMessages.add("error.TuitionPaymentPlan.fixedAmount.required");
        }
        if (this.tuitionCalculationType != null && (this.tuitionCalculationType.isEcts() || this.tuitionCalculationType.isUnits()) && this.ectsCalculationType == null) {
            errorMessages.add("error.TuitionPaymentPlan.ectsCalculationType.required");
        }
        if (this.tuitionCalculationType != null && (this.tuitionCalculationType.isEcts() || this.tuitionCalculationType.isUnits()) && this.ectsCalculationType != null && this.ectsCalculationType.isFixedAmount() && this.fixedAmount == null) {
            errorMessages.add("error.TuitionPaymentPlan.fixedAmount.required");
        }
        if (this.tuitionCalculationType != null && (this.tuitionCalculationType.isEcts() || this.tuitionCalculationType.isUnits()) && this.ectsCalculationType != null && this.ectsCalculationType.isDependentOnDefaultPaymentPlan() && this.factor == null) {
            errorMessages.add("error.TuitionPaymentPlan.factor.required");
        }
        if (this.tuitionCalculationType != null && (this.tuitionCalculationType.isEcts() || this.tuitionCalculationType.isUnits()) && this.ectsCalculationType != null && this.ectsCalculationType.isDependentOnDefaultPaymentPlan() && this.totalEctsOrUnits == null) {
            errorMessages.add("error.TuitionPaymentPlan.totalEctsOrUnits.required");
        }
        if (this.applyMaximumAmount && (this.maximumAmount == null || !AcademicTreasuryConstants.isPositive(this.maximumAmount))) {
            errorMessages.add("error.TuitionPaymentPlan.maximumAmount.required");
        }
        if (this.beginDate == null) {
            errorMessages.add("error.TuitionPaymentPlan.beginDate.required");
        }
        if (this.dueDateCalculationType == null) {
            errorMessages.add("error.TuitionPaymentPlan.dueDateCalculationType.required");
        }
        if (this.dueDateCalculationType != null && this.dueDateCalculationType.isFixedDate() && this.fixedDueDate == null) {
            errorMessages.add("error.TuitionPaymentPlan.fixedDueDate.required");
        }
        if (this.applyInterests && this.interestRateType == null) {
            errorMessages.add("error.TuitionPaymentPlan.interestType.required");
        }
        if (this.applyInterests && this.interestRateType != null && this.interestRateType.isInterestFixedAmountRequired() && this.interestFixedAmount == null) {
            errorMessages.add("error.TuitionPaymentPlan.interestFixedAmount.required");
        }
        if (this.getTuitionInstallmentBeans().stream().filter(l -> l.getTuitionInstallmentProduct() == this.getTuitionInstallmentProduct()).count() > 0L) {
            errorMessages.add("error.TuitionPaymentPlan.installment.already.with.product");
        }
        if (this.getTuitionPaymentPlanGroup().isForRegistration() && (this.getTuitionCalculationType().isEcts() || this.getTuitionCalculationType().isUnits()) && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            errorMessages.add("error.TuitionInstallmentTariff.defaultPaymentPlanCourseFunctionCostIndexed.not.supported.for.registrationTuition");
        }
        if (!this.isAcademicalActBlockingOn() && this.isBlockAcademicActsOnDebt()) {
            errorMessages.add("error.TuitionPaymentPlanBean.cannot.suspend.and.also.block.academical.acts.on.debt");
        }
        if (!errorMessages.isEmpty()) {
            return errorMessages;
        }
        installmentBean.setFinantialEntity(this.finantialEntity);
        installmentBean.setBeginDate(this.beginDate);
        installmentBean.setEndDate(this.endDate);
        installmentBean.setDueDateCalculationType(this.dueDateCalculationType);
        installmentBean.setFixedDueDate(this.fixedDueDate);
        installmentBean.setNumberOfDaysAfterCreationForDueDate(this.numberOfDaysAfterCreationForDueDate);
        installmentBean.setApplyInterests(this.applyInterests);
        installmentBean.setInterestRateType(this.interestRateType);
        installmentBean.setNumberOfDaysAfterDueDate(this.numberOfDaysAfterDueDate);
        installmentBean.setApplyInFirstWorkday(this.applyInFirstWorkday);
        installmentBean.setMaximumDaysToApplyPenalty(this.maximumDaysToApplyPenalty);
        installmentBean.setInterestFixedAmount(this.interestFixedAmount);
        installmentBean.setRate(this.rate);
        installmentBean.setTuitionInstallmentProduct(this.getTuitionInstallmentProduct());
        installmentBean.setTuitionCalculationType(this.tuitionCalculationType);
        installmentBean.setTuitionTariffCalculatedAmountType(this.tuitionTariffCalculatedAmountType);
        installmentBean.setTuitionPaymentPlanCalculator(this.tuitionPaymentPlanCalculator);
        installmentBean.setTuitionTariffCustomCalculator(this.tuitionTariffCustomCalculator);
        installmentBean.setFixedAmount(this.fixedAmount);
        installmentBean.setEctsCalculationType(this.ectsCalculationType);
        installmentBean.setFactor(this.factor);
        installmentBean.setTotalEctsOrUnits(this.totalEctsOrUnits);
        installmentBean.setApplyMaximumAmount(this.applyMaximumAmount);
        installmentBean.setMaximumAmount(this.maximumAmount);
        installmentBean.setAcademicalActBlockingOn(this.academicalActBlockingOn);
        installmentBean.setBlockAcademicActsOnDebt(this.blockAcademicActsOnDebt);
        installmentBean.setPayorDebtAccount(this.payorDebtAccount);
        this.tuitionInstallmentBeans.add(installmentBean);
        this.tuitionInstallmentProductDataSource = TuitionPaymentPlanBean.tuitionInstallmentProductDataSource(this.getTuitionPaymentPlanGroup(), this.tuitionInstallmentBeans.size() + 1);
        return errorMessages;
    }

    public void removeInstallment(int installmentNumber) {
        if (this.findTariffBeanByInstallmentNumber(installmentNumber + 1) != null) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.delete.after.first", new String[0]);
        }
        AcademicTariffBean removeBean = this.findTariffBeanByInstallmentNumber(installmentNumber);
        if (removeBean != null) {
            this.getTuitionInstallmentBeans().remove(removeBean);
            int i = 1;
            for (AcademicTariffBean academicTariffBean : this.getTuitionInstallmentBeans()) {
                academicTariffBean.setInstallmentOrder(i++);
            }
        }
        this.tuitionInstallmentProductDataSource = TuitionPaymentPlanBean.tuitionInstallmentProductDataSource(this.getTuitionPaymentPlanGroup(), this.tuitionInstallmentBeans.size() + 1);
    }

    private AcademicTariffBean findTariffBeanByInstallmentNumber(int installmentNumber) {
        for (AcademicTariffBean academicTariffBean : this.getTuitionInstallmentBeans()) {
            if (academicTariffBean.getInstallmentOrder() != installmentNumber) continue;
            return academicTariffBean;
        }
        return null;
    }

    public void resetInstallmentFields() {
        this.beginDate = this.executionYear != null ? this.executionYear.getBeginLocalDate() : null;
        this.endDate = AcademicTreasuryConstants.INFINITY_DATE.toLocalDate();
        this.dueDateCalculationType = DueDateCalculationType.DAYS_AFTER_CREATION;
        this.fixedDueDate = this.executionYear != null ? this.executionYear.getBeginLocalDate() : null;
        this.numberOfDaysAfterCreationForDueDate = 0;
        this.applyInterests = true;
        this.interestRateType = InterestRateType.getDefaultInterestRateType();
        this.numberOfDaysAfterDueDate = 1;
        this.applyInFirstWorkday = false;
        this.maximumDaysToApplyPenalty = 0;
        this.interestFixedAmount = null;
        this.rate = null;
        this.tuitionInstallmentProduct = null;
        this.tuitionCalculationType = TuitionCalculationType.FIXED_AMOUNT;
        this.fixedAmount = null;
        this.ectsCalculationType = EctsCalculationType.FIXED_AMOUNT;
        this.factor = null;
        this.totalEctsOrUnits = null;
        this.applyMaximumAmount = false;
        this.maximumAmount = null;
        this.academicalActBlockingOn = true;
        this.blockAcademicActsOnDebt = false;
        if (this.tuitionPaymentPlanGroup.isForExtracurricular() || this.tuitionPaymentPlanGroup.isForStandalone()) {
            this.setTuitionInstallmentProduct(this.tuitionPaymentPlanGroup.getCurrentProduct());
        }
    }

    public FinantialEntity getFinantialEntity() {
        return this.finantialEntity;
    }

    public void setFinantialEntity(FinantialEntity finantialEntity) {
        this.finantialEntity = finantialEntity;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public TuitionPaymentPlanGroup getTuitionPaymentPlanGroup() {
        return this.tuitionPaymentPlanGroup;
    }

    public void setTuitionPaymentPlanGroup(TuitionPaymentPlanGroup tuitionPaymentPlanGroup) {
        this.tuitionPaymentPlanGroup = tuitionPaymentPlanGroup;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public DegreeType getDegreeType() {
        return this.degreeType;
    }

    public void setDegreeType(DegreeType degreeType) {
        this.degreeType = degreeType;
    }

    public Set<DegreeCurricularPlan> getDegreeCurricularPlans() {
        return this.degreeCurricularPlans;
    }

    public void setDegreeCurricularPlans(Set<DegreeCurricularPlan> degreeCurricularPlans) {
        this.degreeCurricularPlans = degreeCurricularPlans;
    }

    public boolean isDefaultPaymentPlan() {
        return this.defaultPaymentPlan;
    }

    public void setDefaultPaymentPlan(boolean defaultPaymentPlan) {
        this.defaultPaymentPlan = defaultPaymentPlan;
    }

    public Set<TuitionConditionRule> getConditionRules() {
        return this.conditionRules;
    }

    public void setConditionRules(Set<TuitionConditionRule> set) {
        this.conditionRules = set;
    }

    public void addOrReplaceConditionRules(TuitionConditionRule tuitionConditionRule) {
        TuitionConditionRule rule = this.conditionRules.stream().filter(c -> ((Object)c).getClass().isAssignableFrom(((Object)((Object)tuitionConditionRule)).getClass())).findFirst().orElse(null);
        if (rule != null) {
            this.conditionRules.remove((Object)rule);
        }
        this.conditionRules.add(tuitionConditionRule);
    }

    public void addConditionRules(TuitionConditionRule tuitionConditionRule) {
        TuitionConditionRule rule = this.conditionRules.stream().filter(c -> ((Object)c).getClass().isAssignableFrom(((Object)((Object)tuitionConditionRule)).getClass())).findFirst().orElse(null);
        if (rule != null) {
            throw new DomainException(TreasuryPlataformDependentServicesFactory.implementation().bundle("resources.AcademicTreasuryResources", "error.TuitionPaymentPlan.conditionRule.duplicated", new String[0]), new String[0]);
        }
        this.conditionRules.add(tuitionConditionRule);
    }

    public void removeConditionRule(Class<? extends TuitionConditionRule> clazz) {
        TuitionConditionRule rule = this.conditionRules.stream().filter(c -> clazz.isAssignableFrom(((Object)c).getClass())).findFirst().orElse(null);
        if (rule != null) {
            this.conditionRules.remove((Object)rule);
        }
    }

    public RegistrationRegimeType getRegistrationRegimeType() {
        RegistrationRegimeTypeConditionRule condition = this.conditionRules.stream().filter(c -> RegistrationRegimeTypeConditionRule.class.equals(((Object)c).getClass())).findFirst().orElse(null);
        return condition == null ? null : condition.getRegistrationRegimeTypes().iterator().next();
    }

    public RegistrationProtocol getRegistrationProtocol() {
        RegistrationProtocolConditionRule condition = this.conditionRules.stream().filter(c -> RegistrationProtocolConditionRule.class.equals(((Object)c).getClass())).findFirst().orElse(null);
        return condition == null ? null : (RegistrationProtocol)condition.getRegistrationProtocolSet().iterator().next();
    }

    public IngressionType getIngression() {
        IngressionTypeConditionRule condition = this.conditionRules.stream().filter(c -> IngressionTypeConditionRule.class.equals(((Object)c).getClass())).findFirst().orElse(null);
        return condition == null ? null : (IngressionType)condition.getIngressionSet().iterator().next();
    }

    public CurricularYear getCurricularYear() {
        CurricularYearConditionRule condition = this.conditionRules.stream().filter(c -> CurricularYearConditionRule.class.equals(((Object)c).getClass())).findFirst().orElse(null);
        return condition == null ? null : (CurricularYear)condition.getCurricularYearSet().iterator().next();
    }

    public ExecutionInterval getExecutionSemester() {
        ExecutionIntervalConditionRule condition = this.conditionRules.stream().filter(c -> ExecutionIntervalConditionRule.class.equals(((Object)c).getClass())).findFirst().orElse(null);
        return condition == null ? null : (ExecutionInterval)condition.getExecutionIntervalSet().iterator().next();
    }

    public Boolean isFirstTimeStudent() {
        FirstTimeStudentConditionRule condition = this.conditionRules.stream().filter(c -> FirstTimeStudentConditionRule.class.equals(((Object)c).getClass())).findFirst().orElse(null);
        return condition == null ? null : condition.getFirstTimeStudent();
    }

    public boolean isCustomized() {
        return this.customized;
    }

    public void setCustomized(boolean customized) {
        this.customized = customized;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean isWithLaboratorialClasses() {
        WithLaboratorialClassesConditionRule condition = this.conditionRules.stream().filter(c -> WithLaboratorialClassesConditionRule.class.equals(((Object)c).getClass())).findFirst().orElse(null);
        return condition == null ? null : condition.getWithLaboratorialClasses();
    }

    public List<AcademicTariffBean> getTuitionInstallmentBeans() {
        return this.tuitionInstallmentBeans;
    }

    public void setTuitionInstallmentBeans(List<AcademicTariffBean> tuitionInstallmentBeans) {
        this.tuitionInstallmentBeans = tuitionInstallmentBeans;
    }

    public List<TreasuryTupleDataSourceBean> getDegreeTypeDataSource() {
        return this.degreeTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getDegreeCurricularPlanDataSource() {
        return this.degreeCurricularPlanDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getRegistrationRegimeTypeDataSource() {
        return this.registrationRegimeTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getRegistrationProtocolDataSource() {
        return this.registrationProtocolDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getIngressionDataSource() {
        return this.ingressionDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getCurricularYearDataSource() {
        return this.curricularYearDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getSemesterDataSource() {
        return this.semesterDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getTuitionCalculationTypeDataSource() {
        return this.tuitionCalculationTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getEctsCalculationTypeDataSource() {
        return this.ectsCalculationTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getInterestTypeDataSource() {
        return this.interestTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getTuitionInstallmentProductDataSource() {
        return this.tuitionInstallmentProductDataSource;
    }

    public DebtAccount getPayorDebtAccount() {
        return this.payorDebtAccount;
    }

    public void setPayorDebtAccount(DebtAccount payorDebtAccount) {
        this.payorDebtAccount = payorDebtAccount;
    }

    public LocalDate getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(LocalDate beginDate) {
        this.beginDate = beginDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public DueDateCalculationType getDueDateCalculationType() {
        return this.dueDateCalculationType;
    }

    public void setDueDateCalculationType(DueDateCalculationType dueDateCalculationType) {
        this.dueDateCalculationType = dueDateCalculationType;
    }

    public LocalDate getFixedDueDate() {
        return this.fixedDueDate;
    }

    public void setFixedDueDate(LocalDate fixedDueDate) {
        this.fixedDueDate = fixedDueDate;
    }

    public int getNumberOfDaysAfterCreationForDueDate() {
        return this.numberOfDaysAfterCreationForDueDate;
    }

    public void setNumberOfDaysAfterCreationForDueDate(int numberOfDaysAfterCreationForDueDate) {
        this.numberOfDaysAfterCreationForDueDate = numberOfDaysAfterCreationForDueDate;
    }

    public boolean isApplyInterests() {
        return this.applyInterests;
    }

    public void setApplyInterests(boolean applyInterests) {
        this.applyInterests = applyInterests;
    }

    public boolean isApplyInFirstWorkday() {
        return this.applyInFirstWorkday;
    }

    public void setApplyInFirstWorkday(boolean applyInFirstWorkday) {
        this.applyInFirstWorkday = applyInFirstWorkday;
    }

    public InterestRateType getInterestRateType() {
        return this.interestRateType;
    }

    public void setInterestRateType(InterestRateType interestRateType) {
        this.interestRateType = interestRateType;
    }

    public int getNumberOfDaysAfterDueDate() {
        return this.numberOfDaysAfterDueDate;
    }

    public void setNumberOfDaysAfterDueDate(int numberOfDaysAfterDueDate) {
        this.numberOfDaysAfterDueDate = numberOfDaysAfterDueDate;
    }

    public int getMaximumDaysToApplyPenalty() {
        return this.maximumDaysToApplyPenalty;
    }

    public void setMaximumDaysToApplyPenalty(int maximumDaysToApplyPenalty) {
        this.maximumDaysToApplyPenalty = maximumDaysToApplyPenalty;
    }

    public BigDecimal getInterestFixedAmount() {
        return this.interestFixedAmount;
    }

    public void setInterestFixedAmount(BigDecimal interestFixedAmount) {
        this.interestFixedAmount = interestFixedAmount;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public Product getTuitionInstallmentProduct() {
        return this.tuitionInstallmentProduct;
    }

    public void setTuitionInstallmentProduct(Product tuitionInstallmentProduct) {
        this.tuitionInstallmentProduct = tuitionInstallmentProduct;
    }

    public int getInstallmentOrder() {
        return this.installmentOrder;
    }

    public void setInstallmentOrder(int installmentOrder) {
        this.installmentOrder = installmentOrder;
    }

    public TuitionCalculationType getTuitionCalculationType() {
        return this.tuitionCalculationType;
    }

    public void setTuitionCalculationType(TuitionCalculationType tuitionCalculationType) {
        this.tuitionCalculationType = tuitionCalculationType;
    }

    public BigDecimal getFixedAmount() {
        return this.fixedAmount;
    }

    public void setFixedAmount(BigDecimal fixedAmount) {
        this.fixedAmount = fixedAmount;
    }

    public EctsCalculationType getEctsCalculationType() {
        return this.ectsCalculationType;
    }

    public void setEctsCalculationType(EctsCalculationType ectsCalculationType) {
        this.ectsCalculationType = ectsCalculationType;
    }

    public BigDecimal getFactor() {
        return this.factor;
    }

    public void setFactor(BigDecimal factor) {
        this.factor = factor;
    }

    public BigDecimal getTotalEctsOrUnits() {
        return this.totalEctsOrUnits;
    }

    public void setTotalEctsOrUnits(BigDecimal totalEctsOrUnits) {
        this.totalEctsOrUnits = totalEctsOrUnits;
    }

    public boolean isAcademicalActBlockingOn() {
        return this.academicalActBlockingOn;
    }

    public void setAcademicalActBlockingOn(boolean academicalActBlockingOn) {
        this.academicalActBlockingOn = academicalActBlockingOn;
    }

    public boolean isBlockAcademicActsOnDebt() {
        return this.blockAcademicActsOnDebt;
    }

    public void setBlockAcademicActsOnDebt(boolean blockAcademicActsOnDebt) {
        this.blockAcademicActsOnDebt = blockAcademicActsOnDebt;
    }

    public StatuteType getStatuteType() {
        StatuteTypeConditionRule condition = this.conditionRules.stream().filter(c -> StatuteTypeConditionRule.class.equals(((Object)c).getClass())).findFirst().orElse(null);
        return condition == null ? null : (StatuteType)condition.getStatuteTypeSet().iterator().next();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean isApplyMaximumAmount() {
        return this.applyMaximumAmount;
    }

    public void setApplyMaximumAmount(boolean applyMaximumAmount) {
        this.applyMaximumAmount = applyMaximumAmount;
    }

    public BigDecimal getMaximumAmount() {
        return this.maximumAmount;
    }

    public void setMaximumAmount(BigDecimal maximumAmount) {
        this.maximumAmount = maximumAmount;
    }

    public boolean isShowAllDcps() {
        return this.showAllDcps;
    }

    public void setShowAllDcps(boolean degreeCurricularPlansShownFilteredByExecutions) {
        this.showAllDcps = degreeCurricularPlansShownFilteredByExecutions;
    }

    private List<TreasuryTupleDataSourceBean> degreeTypeDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        ArrayList result = Lists.newArrayList((Iterable)DegreeType.all().map(dt -> new TreasuryTupleDataSourceBean(dt.getExternalId(), academicTreasuryServices.localizedNameOfDegreeType((DegreeType)dt))).collect(Collectors.toList()));
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> degreeCurricularPlanDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (this.getExecutionYear() == null) {
            return Collections.emptyList();
        }
        if (this.getDegreeType() == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        if (this.isShowAllDcps()) {
            result.addAll(academicTreasuryServices.readAllDegreeCurricularPlansSet().stream().filter(dcp -> dcp.getDegreeType() == this.getDegreeType()).map(dcp -> new TreasuryTupleDataSourceBean(dcp.getExternalId(), "[" + dcp.getDegree().getCode() + "] " + dcp.getPresentationName(this.getExecutionYear()))).collect(Collectors.toList()));
        } else {
            result.addAll(academicTreasuryServices.readDegreeCurricularPlansWithExecutionDegree(this.getExecutionYear(), this.getDegreeType()).stream().map(dcp -> new TreasuryTupleDataSourceBean(dcp.getExternalId(), "[" + dcp.getDegree().getCode() + "] " + dcp.getPresentationName(this.getExecutionYear()))).collect(Collectors.toList()));
        }
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> semesterDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (this.getExecutionYear() == null) {
            return Lists.newArrayList();
        }
        List result = this.getExecutionYear().getExecutionPeriodsSet().stream().map(cs -> new TreasuryTupleDataSourceBean(cs.getExternalId(), cs.getQualifiedName())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> curricularYearDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        List result = academicTreasuryServices.readAllCurricularYearsSet().stream().map(cy -> new TreasuryTupleDataSourceBean(cy.getExternalId(), cy.getYear().toString())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> ingressionDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        List result = academicTreasuryServices.readAllIngressionTypesSet().stream().map(i -> new TreasuryTupleDataSourceBean(i.getExternalId(), i.getDescription().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> registrationProtocolDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        List result = academicTreasuryServices.readAllRegistrationProtocol().stream().map(rp -> new TreasuryTupleDataSourceBean(rp.getExternalId(), rp.getDescription().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> registrationRegimeTypeDataSource() {
        List result = Arrays.asList(RegistrationRegimeType.values()).stream().map(t -> new TreasuryTupleDataSourceBean(t.name(), t.getLocalizedName())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    public static List<TreasuryTupleDataSourceBean> interestTypeDataSource() {
        List result = InterestRateType.getAvailableInterestRateTypesSortedByName().stream().map(it -> new TreasuryTupleDataSourceBean(it.getExternalId(), it.getDescription().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    public static List<TreasuryTupleDataSourceBean> ectsCalculationTypeDataSource() {
        List result = Arrays.asList(EctsCalculationType.values()).stream().map(ct -> new TreasuryTupleDataSourceBean(ct.name(), ct.getDescriptionI18N().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    public static List<TreasuryTupleDataSourceBean> tuitionCalculationTypeDataSource() {
        List result = Arrays.asList(TuitionCalculationType.values()).stream().map(ct -> new TreasuryTupleDataSourceBean(ct.name(), ct.getDescriptionI18N().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    public static List<TreasuryTupleDataSourceBean> tuitionInstallmentProductDataSource(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, int desiredTuitionInstallmentOrder) {
        List result = null;
        result = tuitionPaymentPlanGroup != null && tuitionPaymentPlanGroup.isForRegistration() ? AcademicTreasurySettings.getInstance().getTuitionProductGroup().getProductsSet().stream().filter(p -> p.isActive() && p.getTuitionInstallmentOrder() == desiredTuitionInstallmentOrder).map(p -> new TreasuryTupleDataSourceBean(p.getExternalId(), p.getName().getContent())).collect(Collectors.toList()) : AcademicTreasurySettings.getInstance().getTuitionProductGroup().getProductsSet().stream().filter(p -> p.isActive()).map(p -> new TreasuryTupleDataSourceBean(p.getExternalId(), p.getName().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> statuteTypeDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        List result = academicTreasuryServices.readAllStatuteTypesSet().stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), academicTreasuryServices.localizedNameOfStatuteType((StatuteType)l))).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> payorDebtAccountDataSource() {
        if (this.finantialEntity == null) {
            return Lists.newArrayList();
        }
        SortedSet payorDebtAccountsSet = DebtAccount.findActiveAdhocDebtAccountsSortedByCustomerName((FinantialInstitution)this.finantialEntity.getFinantialInstitution());
        List result = payorDebtAccountsSet.stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), String.format("%s - %s", l.getCustomer().getUiFiscalNumber(), l.getCustomer().getName()))).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> executionYearDataSource() {
        List<TreasuryTupleDataSourceBean> result = ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).collect(Collectors.toList()).stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getQualifiedName())).collect(Collectors.toList());
        result.add(0, AcademicTreasuryConstants.SELECT_OPTION);
        return result;
    }

    public List<String> validateStudentConditions() {
        ArrayList result = Lists.newArrayList();
        if (this.getTuitionPaymentPlanGroup().isForRegistration() && !this.hasAtLeastOneConditionSpecified()) {
            result.add("error.TuitionPaymentPlan.specify.at.least.one.condition");
        }
        if (this.isCustomized() && (this.isDefaultPaymentPlan() || this.hasStudentConditionSelected())) {
            result.add("error.TuitionPaymentPlan.customized.plan.cannot.have.other.options");
        }
        if (this.isDefaultPaymentPlan() && this.hasStudentConditionSelected()) {
            result.add("error.TuitionPaymentPlan.default.payment.plan.cannot.have.other.options");
        }
        return result;
    }

    private boolean hasStudentConditionSelected() {
        return !this.conditionRules.isEmpty();
    }

    private boolean hasAtLeastOneConditionSpecified() {
        boolean hasAtLeastOneCondition = false;
        hasAtLeastOneCondition |= this.isDefaultPaymentPlan();
        hasAtLeastOneCondition |= !this.conditionRules.isEmpty();
        return hasAtLeastOneCondition |= this.isCustomized();
    }

    public void putImporterRule(Class<? extends TuitionConditionRule> ruleClass, String string) {
        this.importerMap.put(ruleClass, string);
    }

    public Map<Class<? extends TuitionConditionRule>, String> getImporterRules() {
        return this.importerMap;
    }

    public void addDegreeCurricularPlans(DegreeCurricularPlan degreeCurricularPlan) {
        this.degreeCurricularPlans.add(degreeCurricularPlan);
    }

    public void addAllDegreeCurricularPlans(Set<DegreeCurricularPlan> degreeCurricularPlans) {
        degreeCurricularPlans.addAll(degreeCurricularPlans);
    }

    public TuitionPaymentPlanCalculator getTuitionPaymentPlanCalculatorBean() {
        return this.tuitionPaymentPlanCalculator;
    }

    public void setTuitionPaymentPlanCalculatorBean(TuitionPaymentPlanCalculator tuitionPaymentPlanCalculator) {
        this.tuitionPaymentPlanCalculator = tuitionPaymentPlanCalculator;
    }

    public List<TuitionPaymentPlanCalculator> getTuitionPaymentPlanCalculatorList() {
        return this.tuitionPaymentPlanCalculatorList;
    }

    public void setTuitionPaymentPlanCalculatorList(List<TuitionPaymentPlanCalculator> tuitionPaymentPlanCalculatorList) {
        this.tuitionPaymentPlanCalculatorList = tuitionPaymentPlanCalculatorList;
    }

    public static TuitionPaymentPlanBean createForCopy(TuitionPaymentPlan tuitionPaymentPlan) {
        return (TuitionPaymentPlanBean)advice$createForCopy.perform((Callable)new TuitionPaymentPlanBean$callable$createForCopy(tuitionPaymentPlan));
    }

    static /* synthetic */ TuitionPaymentPlanBean advised$createForCopy(TuitionPaymentPlan tuitionPaymentPlan) {
        TuitionPaymentPlanBean result = new TuitionPaymentPlanBean(tuitionPaymentPlan);
        HashMap map = new HashMap();
        result.tuitionPaymentPlanCalculatorList.clear();
        tuitionPaymentPlan.getTuitionPaymentPlanCalculatorSet().forEach(c -> {
            TuitionPaymentPlanCalculator copyTo = c.copyTo((TuitionPaymentPlan)null);
            result.tuitionPaymentPlanCalculatorList.add(copyTo);
            map.put(c, copyTo);
        });
        result.tuitionInstallmentBeans.stream().filter(b -> b.getTuitionPaymentPlanCalculator() != null).forEach(b -> b.setTuitionPaymentPlanCalculator((TuitionPaymentPlanCalculator)((Object)((Object)map.get((Object)b.getTuitionPaymentPlanCalculator())))));
        return result;
    }

    static {
        advice$createForCopy = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_ID_AND_TEXT = (o1, o2) -> {
            if (o1.getId() == "") {
                return -1;
            }
            if (o2.getId() == "") {
                return 1;
            }
            return TreasuryTupleDataSourceBean.COMPARE_BY_TEXT.compare(o1, o2);
        };
    }
}

