/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tuition.DiscountTuitionInstallmentsHelper;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan$callable$create;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan$callable$delete;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanOrder;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan_Base;
import org.fenixedu.academictreasury.domain.tuition.TuitionTariffCustomCalculator;
import org.fenixedu.academictreasury.domain.tuition.calculators.TuitionPaymentPlanCalculator;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.academictreasury.util.LocalizedStringUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TuitionPaymentPlan
extends TuitionPaymentPlan_Base {
    private static final String CONDITIONS_DESCRIPTION_SEPARATOR = ", ";
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public TuitionPaymentPlan() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected TuitionPaymentPlan(TuitionPaymentPlan tuitionPaymentPlanToCopy, ExecutionYear toExecutionYear) {
        this();
        this.setFinantialEntity(tuitionPaymentPlanToCopy.getFinantialEntity());
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanToCopy.getTuitionPaymentPlanGroup());
        this.setProduct(tuitionPaymentPlanToCopy.getTuitionPaymentPlanGroup().getCurrentProduct());
        this.setExecutionYear(toExecutionYear);
        this.setDefaultPaymentPlan(tuitionPaymentPlanToCopy.isDefaultPaymentPlan());
        this.setCustomized(tuitionPaymentPlanToCopy.isCustomized());
        this.setCustomizedName(tuitionPaymentPlanToCopy.getCustomizedName());
        HashMap<TuitionPaymentPlanCalculator, TuitionPaymentPlanCalculator> calculatorsCopyMap = new HashMap<TuitionPaymentPlanCalculator, TuitionPaymentPlanCalculator>();
        this.getTuitionPaymentPlanCalculatorSet().forEach(c -> calculatorsCopyMap.put((TuitionPaymentPlanCalculator)((Object)c), c.copyTo(this)));
        this.createInstallments(tuitionPaymentPlanToCopy, calculatorsCopyMap);
        this.setCopyFromTuitionPaymentPlan(tuitionPaymentPlanToCopy);
        tuitionPaymentPlanToCopy.getTuitionConditionRulesSet().forEach(cond -> cond.copyToPlan(this));
        tuitionPaymentPlanToCopy.getTuitionPaymentPlanOrdersSet().forEach(order -> order.copyToPlan(this));
        this.checkRules();
    }

    public TuitionPaymentPlan(TuitionPaymentPlanBean tuitionPaymentPlanBean) {
        this();
        this.setFinantialEntity(tuitionPaymentPlanBean.getFinantialEntity());
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanBean.getTuitionPaymentPlanGroup());
        this.setProduct(tuitionPaymentPlanBean.getTuitionPaymentPlanGroup().getCurrentProduct());
        this.setExecutionYear(tuitionPaymentPlanBean.getExecutionYear());
        this.setDefaultPaymentPlan(tuitionPaymentPlanBean.isDefaultPaymentPlan());
        this.setCustomized(tuitionPaymentPlanBean.isCustomized());
        LocalizedString mls = new LocalizedString();
        for (Locale locale : TreasuryPlataformDependentServicesFactory.implementation().availableLocales()) {
            mls = mls.with(locale, tuitionPaymentPlanBean.getName());
        }
        this.setCustomizedName(mls);
        for (TuitionConditionRule condition : tuitionPaymentPlanBean.getConditionRules()) {
            this.addTuitionConditionRules(condition);
        }
        this.createPaymentPlanOrder(tuitionPaymentPlanBean.getDegreeCurricularPlans());
        tuitionPaymentPlanBean.getTuitionPaymentPlanCalculatorList().forEach(c -> c.setTuitionPaymentPlan(this));
        this.createInstallments(tuitionPaymentPlanBean);
        this.checkRules();
    }

    public void checkRules() {
        if (this.getTuitionPaymentPlanGroup() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.tuitionPaymentPlanGroup.required", new String[0]);
        }
        if (this.getFinantialEntity() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.finantialEntity.required", new String[0]);
        }
        if (this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.executionYear.required", new String[0]);
        }
        if (this.getTuitionPaymentPlanOrdersSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.tuitionPaymentPlanOrders.required", new String[0]);
        }
        if (this.isCustomized() && LocalizedStringUtil.isTrimmedEmpty(this.getCustomizedName())) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.customized.required.name", new String[0]);
        }
        if (this.isCustomized() && this.hasStudentSpecificConditionSelected()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.customized.plan.cannot.have.other.options", new String[0]);
        }
        if (this.isDefaultPaymentPlan() && this.getTuitionPaymentPlanGroup() != TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.default.payment.plan.must.be.for.registration", new String[0]);
        }
        if (this.getTuitionInstallmentTariffsSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.installments.must.not.be.empty", new String[0]);
        }
        if (this.existsAtLeastOneCalculatorWithMoreThanOneRemaining()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.installments.customCalculators.must.have.remaining", new String[0]);
        }
        if ((this.getTuitionPaymentPlanGroup().isForStandalone() || this.getTuitionPaymentPlanGroup().isForExtracurricular()) && this.getTuitionInstallmentTariffsSet().size() > 1) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.standalone.and.extracurricular.supports.only.one.installment", new String[0]);
        }
        if (this.getTuitionPaymentPlanGroup().isForRegistration() && !this.hasAtLeastOneConditionSpecified()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.specify.at.least.one.condition", new String[0]);
        }
    }

    private boolean existsAtLeastOneCalculatorWithMoreThanOneRemaining() {
        return false;
    }

    private boolean existsAtLeastOneTariffCalculatedAmountWithoutOnlyOneRemaining() {
        if (Boolean.TRUE.equals(this.getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators())) {
            return !this.getTuitionInstallmentTariffsSet().stream().filter(tariff -> tariff.getTuitionCalculationType().isCalculatedAmount()).map(tariff -> tariff.getTuitionPaymentPlanCalculator()).allMatch(calculator -> this.getTuitionInstallmentTariffsSet().stream().filter(tariff -> tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType() != null && tariff.getTuitionTariffCalculatedAmountType().isRemaining() && tariff.getTuitionPaymentPlanCalculator() == calculator).count() == 1L);
        }
        return !this.getTuitionInstallmentTariffsSet().stream().filter(tariff -> tariff.getTuitionCalculationType().isCalculatedAmount()).map(tariff -> tariff.getTuitionTariffCustomCalculator()).allMatch(calculator -> this.getTuitionInstallmentTariffsSet().stream().anyMatch(tariff -> tariff.getTuitionCalculationType().isCalculatedAmount() && tariff.getTuitionTariffCalculatedAmountType() != null && tariff.getTuitionTariffCalculatedAmountType().isRemaining() && tariff.getTuitionTariffCustomCalculator() == calculator));
    }

    private boolean hasStudentSpecificConditionSelected() {
        return !this.getTuitionConditionRulesSet().isEmpty();
    }

    private boolean hasAtLeastOneConditionSpecified() {
        boolean hasAtLeastOneCondition = false;
        hasAtLeastOneCondition |= this.isDefaultPaymentPlan();
        hasAtLeastOneCondition |= !this.getTuitionConditionRulesSet().isEmpty();
        return hasAtLeastOneCondition |= this.isCustomized();
    }

    private void createPaymentPlanOrder(Set<DegreeCurricularPlan> degreeCurricularPlans) {
        for (DegreeCurricularPlan plan : degreeCurricularPlans) {
            TuitionPaymentPlanOrder.create(this, plan);
        }
    }

    private TuitionPaymentPlanOrder getTuitionPaymentPlanOrder(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getTuitionPaymentPlanOrdersSet().stream().filter(order -> order.getDegreeCurricularPlan() == degreeCurricularPlan).findFirst().orElse(null);
    }

    private void createInstallments(TuitionPaymentPlanBean tuitionPaymentPlanBean) {
        for (AcademicTariffBean academicTariffBean : tuitionPaymentPlanBean.getTuitionInstallmentBeans()) {
            TuitionInstallmentTariff.create(tuitionPaymentPlanBean.getFinantialEntity(), this, academicTariffBean);
        }
    }

    private void createInstallments(TuitionPaymentPlan tuitionPaymentPlanToCopy, Map<TuitionPaymentPlanCalculator, TuitionPaymentPlanCalculator> calculatorsCopyMap) {
        tuitionPaymentPlanToCopy.getTuitionInstallmentTariffsSet().stream().sorted(TuitionInstallmentTariff.COMPARATOR_BY_INSTALLMENT_NUMBER).forEach(t -> TuitionInstallmentTariff.copy(t, this, calculatorsCopyMap));
    }

    public String getConditionsDescription() {
        if (this.isCustomized()) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionPaymentPlan.customized", new String[0]) + " [" + this.getCustomizedName().getContent() + "] ";
        }
        if (this.isDefaultPaymentPlan()) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionPaymentPlan.defaultPaymentPlan", new String[0]);
        }
        if (this.getTuitionPaymentPlanGroup().isForStandalone()) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionPaymentPlan.standalone", new String[0]) + CONDITIONS_DESCRIPTION_SEPARATOR + this.getTuitionConditionRulesSet().stream().sorted(TuitionConditionRule.COMPARE_BY_CONDITION_RULE_NAME).map(c -> TuitionConditionRule.getPresentationName(((Object)c).getClass()) + " [" + c.getDescription() + "]").collect(Collectors.joining(CONDITIONS_DESCRIPTION_SEPARATOR));
        }
        if (this.getTuitionPaymentPlanGroup().isForExtracurricular()) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionPaymentPlan.extracurricular", new String[0]) + CONDITIONS_DESCRIPTION_SEPARATOR + this.getTuitionConditionRulesSet().stream().sorted(TuitionConditionRule.COMPARE_BY_CONDITION_RULE_NAME).map(c -> TuitionConditionRule.getPresentationName(((Object)c).getClass()) + " [" + c.getDescription() + "]").collect(Collectors.joining(CONDITIONS_DESCRIPTION_SEPARATOR));
        }
        return this.getTuitionConditionRulesSet().stream().sorted(TuitionConditionRule.COMPARE_BY_CONDITION_RULE_NAME).map(c -> TuitionConditionRule.getPresentationName(((Object)c).getClass()) + " [" + c.getDescription() + "]").collect(Collectors.joining(CONDITIONS_DESCRIPTION_SEPARATOR));
    }

    public List<TuitionInstallmentTariff> getOrderedTuitionInstallmentTariffs() {
        return super.getTuitionInstallmentTariffsSet().stream().sorted(TuitionInstallmentTariff.COMPARATOR_BY_INSTALLMENT_NUMBER).collect(Collectors.toList());
    }

    public TuitionInstallmentTariff getStandaloneTuitionInstallmentTariff() {
        if (!this.getTuitionPaymentPlanGroup().isForStandalone()) {
            throw new RuntimeException("wrong call");
        }
        return this.getOrderedTuitionInstallmentTariffs().get(0);
    }

    public TuitionInstallmentTariff getExtracurricularTuitionInstallmentTariff() {
        if (!this.getTuitionPaymentPlanGroup().isForExtracurricular()) {
            throw new RuntimeException("wrong call");
        }
        return this.getOrderedTuitionInstallmentTariffs().get(0);
    }

    public TuitionConditionRule getTuitionConditionRule(Class<? extends TuitionConditionRule> clazz) {
        return this.getTuitionConditionRulesSet().stream().filter(c -> ((Object)c).getClass().equals(clazz)).findFirst().orElse(null);
    }

    public LocalizedString installmentName(Registration registration, TuitionInstallmentTariff installmentTariff) {
        return installmentTariff.getTuitionPaymentPlan().getTuitionPaymentPlanGroup().buildDebitEntryDescription(installmentTariff, registration, this.getExecutionYear());
    }

    public boolean isCustomized() {
        return this.getCustomized();
    }

    public boolean isDefaultPaymentPlan() {
        return this.getDefaultPaymentPlan();
    }

    public boolean createDebitEntriesForRegistration(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        return this.createDebitEntriesForRegistration(debtAccount, academicTreasuryEvent, when, null, false);
    }

    public boolean createDebitEntriesForRegistration(DebtAccount debtAccount, AcademicTreasuryEvent tuitionAcademicTreasuryEvent, LocalDate when, Set<Product> restrictCreationToInstallments, boolean forceEvenTreasuryEventIsCharged) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        Registration registration = tuitionAcademicTreasuryEvent.getRegistration();
        if (!this.getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        if (!forceEvenTreasuryEventIsCharged && tuitionAcademicTreasuryEvent.isCharged()) {
            return false;
        }
        StringBuilder strBuilder = new StringBuilder();
        HashMap<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap = new HashMap<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator>();
        if (Boolean.TRUE.equals(this.getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators())) {
            this.getTuitionInstallmentTariffsSet().stream().filter(tariff -> tariff.getTuitionPaymentPlanCalculator() != null).map(tariff -> tariff.getTuitionPaymentPlanCalculator()).collect(Collectors.toSet()).forEach(calculator -> {
                strBuilder.append(calculator.getName().getContent(services.defaultLocale())).append(" (").append(tuitionAcademicTreasuryEvent.formatMoney(calculator.getTotalAmount(registration))).append("): \n");
                String description = calculator.getCalculationDescription(registration);
                strBuilder.append(description).append("\n");
            });
        } else {
            this.getTuitionInstallmentTariffsSet().stream().map(tariff -> tariff.getTuitionTariffCustomCalculator()).collect(Collectors.toSet()).forEach(clazz -> {
                if (clazz != null) {
                    TuitionTariffCustomCalculator newInstanceFor = TuitionTariffCustomCalculator.getNewInstanceFor(clazz, tuitionAcademicTreasuryEvent.getRegistration(), this);
                    calculatorsMap.put((Class<? extends TuitionTariffCustomCalculator>)clazz, newInstanceFor);
                    strBuilder.append(newInstanceFor.getPresentationName()).append(" (").append(tuitionAcademicTreasuryEvent.formatMoney(newInstanceFor.getTotalAmount())).append("): \n");
                    String description = newInstanceFor.getCalculationDescription();
                    strBuilder.append(description).append("\n");
                }
            });
        }
        if (strBuilder.length() > 0) {
            Map propertiesMap = tuitionAcademicTreasuryEvent.getPropertiesMap();
            propertiesMap.put(TreasuryPlataformDependentServicesFactory.implementation().bundle("resources.AcademicTreasuryResources", "label.AcademicTreasury.CustomCalculatorDescription", new String[0]) + " ( " + DateTime.now().toString("yyyy-MM-dd HH:mm") + " )", strBuilder.toString());
            tuitionAcademicTreasuryEvent.editPropertiesMap(propertiesMap);
        }
        DiscountTuitionInstallmentsHelper discountMapHelper = new DiscountTuitionInstallmentsHelper(debtAccount, tuitionAcademicTreasuryEvent, restrictCreationToInstallments, when, calculatorsMap);
        boolean createdDebitEntries = false;
        for (TuitionInstallmentTariff tariff2 : this.getTuitionInstallmentTariffsSet().stream().sorted(TuitionInstallmentTariff.COMPARATOR_BY_INSTALLMENT_NUMBER).collect(Collectors.toList())) {
            boolean installmentCreated = discountMapHelper.createInstallmentAndDiscountInstallment(tariff2);
            createdDebitEntries = createdDebitEntries || installmentCreated;
        }
        return createdDebitEntries;
    }

    public boolean createDebitEntriesForStandalone(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, Enrolment standaloneEnrolment, LocalDate when) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        Registration registration = academicTreasuryEvent.getRegistration();
        if (!this.getTuitionPaymentPlanGroup().isForStandalone()) {
            throw new RuntimeException("wrong call");
        }
        if (!standaloneEnrolment.isStandalone()) {
            throw new RuntimeException("error.TuitionPaymentPlan.enrolment.not.standalone");
        }
        StringBuilder strBuilder = new StringBuilder();
        HashMap<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap = new HashMap<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator>();
        if (Boolean.TRUE.equals(this.getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators())) {
            this.getTuitionInstallmentTariffsSet().stream().filter(tariff -> tariff.getTuitionPaymentPlanCalculator() != null).map(tariff -> tariff.getTuitionPaymentPlanCalculator()).collect(Collectors.toSet()).forEach(calculator -> {
                strBuilder.append(calculator.getName().getContent(services.defaultLocale())).append(" (").append(academicTreasuryEvent.formatMoney(calculator.getTotalAmount(standaloneEnrolment))).append("): \n");
                String description = calculator.getCalculationDescription(standaloneEnrolment);
                strBuilder.append(description).append("\n");
            });
        } else {
            this.getTuitionInstallmentTariffsSet().stream().map(tariff -> tariff.getTuitionTariffCustomCalculator()).collect(Collectors.toSet()).forEach(clazz -> {
                if (clazz != null) {
                    TuitionTariffCustomCalculator newInstanceFor = TuitionTariffCustomCalculator.getNewInstanceFor(clazz, academicTreasuryEvent.getRegistration(), this, standaloneEnrolment);
                    calculatorsMap.put((Class<? extends TuitionTariffCustomCalculator>)clazz, newInstanceFor);
                    strBuilder.append(newInstanceFor.getPresentationName()).append(" (").append(academicTreasuryEvent.formatMoney(newInstanceFor.getTotalAmount())).append("): \n");
                    String description = newInstanceFor.getCalculationDescription();
                    strBuilder.append(description).append("\n");
                }
            });
        }
        boolean createdDebitEntries = false;
        HashSet createdDebitEntriesSet = Sets.newHashSet();
        for (TuitionInstallmentTariff tariff2 : this.getTuitionInstallmentTariffsSet()) {
            if (academicTreasuryEvent.isChargedWithDebitEntry(standaloneEnrolment)) continue;
            DebitEntry debitEntry = tariff2.createDebitEntryForStandalone(debtAccount, academicTreasuryEvent, standaloneEnrolment, when, calculatorsMap);
            if (strBuilder.length() > 0) {
                Map propertiesMap = debitEntry.getPropertiesMap();
                propertiesMap.put(TreasuryPlataformDependentServicesFactory.implementation().bundleI18N("resources.AcademicTreasuryResources", "label.AcademicTreasury.CustomCalculatorDescription", new String[0]).getContent(), strBuilder.toString());
                debitEntry.editPropertiesMap(propertiesMap);
            }
            createdDebitEntriesSet.add(debitEntry);
            createdDebitEntries = true;
        }
        if (createdDebitEntries) {
            DebitNote debitNote = DebitNote.create((DebtAccount)debtAccount, (DocumentNumberSeries)((DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)debtAccount.getFinantialInstitution()).get()), (DateTime)new DateTime());
            debitNote.addDebitNoteEntries((List)Lists.newArrayList((Iterable)createdDebitEntriesSet));
            if (AcademicTreasurySettings.getInstance().isCloseServiceRequestEmolumentsWithDebitNote()) {
                debitNote.closeDocument();
            }
        }
        return createdDebitEntries;
    }

    public boolean createDebitEntriesForExtracurricular(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, Enrolment extracurricularEnrolment, LocalDate when) {
        Registration registration = academicTreasuryEvent.getRegistration();
        if (!this.getTuitionPaymentPlanGroup().isForExtracurricular()) {
            throw new RuntimeException("wrong call");
        }
        if (!extracurricularEnrolment.isExtraCurricular()) {
            throw new RuntimeException("error.TuitionPaymentPlan.enrolment.not.standalone");
        }
        StringBuilder strBuilder = new StringBuilder();
        HashMap<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> calculatorsMap = new HashMap<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator>();
        if (Boolean.TRUE.equals(this.getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators())) {
            this.getTuitionInstallmentTariffsSet().stream().filter(tariff -> tariff.getTuitionPaymentPlanCalculator() != null).map(tariff -> tariff.getTuitionPaymentPlanCalculator()).collect(Collectors.toSet()).forEach(calculator -> {
                strBuilder.append(calculator.getName()).append(" (").append(academicTreasuryEvent.formatMoney(calculator.getTotalAmount(extracurricularEnrolment))).append("): \n");
                String description = calculator.getCalculationDescription(extracurricularEnrolment);
                strBuilder.append(description).append("\n");
            });
        } else {
            this.getTuitionInstallmentTariffsSet().stream().map(tariff -> tariff.getTuitionTariffCustomCalculator()).collect(Collectors.toSet()).forEach(clazz -> {
                if (clazz != null) {
                    TuitionTariffCustomCalculator newInstanceFor = TuitionTariffCustomCalculator.getNewInstanceFor(clazz, academicTreasuryEvent.getRegistration(), this, extracurricularEnrolment);
                    calculatorsMap.put((Class<? extends TuitionTariffCustomCalculator>)clazz, newInstanceFor);
                    strBuilder.append(newInstanceFor.getPresentationName()).append(" (").append(academicTreasuryEvent.formatMoney(newInstanceFor.getTotalAmount())).append("): \n");
                    String description = newInstanceFor.getCalculationDescription();
                    strBuilder.append(description).append("\n");
                }
            });
        }
        boolean createdDebitEntries = false;
        HashSet createdDebitEntriesSet = Sets.newHashSet();
        for (TuitionInstallmentTariff tariff2 : this.getTuitionInstallmentTariffsSet()) {
            if (academicTreasuryEvent.isChargedWithDebitEntry(extracurricularEnrolment)) continue;
            DebitEntry debitEntry = tariff2.createDebitEntryForExtracurricular(debtAccount, academicTreasuryEvent, extracurricularEnrolment, when, calculatorsMap);
            if (strBuilder.length() > 0) {
                Map propertiesMap = debitEntry.getPropertiesMap();
                propertiesMap.put(TreasuryPlataformDependentServicesFactory.implementation().bundleI18N("resources.AcademicTreasuryResources", "label.AcademicTreasury.CustomCalculatorDescription", new String[0]).getContent(), strBuilder.toString());
                debitEntry.editPropertiesMap(propertiesMap);
            }
            createdDebitEntriesSet.add(debitEntry);
            createdDebitEntries = true;
        }
        if (createdDebitEntries) {
            DebitNote debitNote = DebitNote.create((DebtAccount)debtAccount, (DocumentNumberSeries)((DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)debtAccount.getFinantialInstitution()).get()), (DateTime)new DateTime());
            debitNote.addDebitNoteEntries((List)Lists.newArrayList((Iterable)createdDebitEntriesSet));
            if (AcademicTreasurySettings.getInstance().isCloseServiceRequestEmolumentsWithDebitNote()) {
                debitNote.closeDocument();
            }
        }
        return createdDebitEntries;
    }

    public boolean isDeletable() {
        if (this.getTuitionPaymentPlanGroup().isForRegistration() && this.isDefaultPaymentPlan()) {
            Set collectionOfDcp = this.getTuitionPaymentPlanOrdersSet().stream().map(order -> order.getDegreeCurricularPlan()).collect(Collectors.toSet());
            HashSet allPlans = Sets.newHashSet();
            for (DegreeCurricularPlan degreeCurricularPlan : collectionOfDcp) {
                allPlans.addAll(TuitionPaymentPlan.find(TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), degreeCurricularPlan, this.getExecutionYear()).collect(Collectors.toSet()));
                allPlans.addAll(TuitionPaymentPlan.find(TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().get(), degreeCurricularPlan, this.getExecutionYear()).collect(Collectors.toSet()));
                allPlans.addAll(TuitionPaymentPlan.find(TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get(), degreeCurricularPlan, this.getExecutionYear()).collect(Collectors.toSet()));
            }
            for (TuitionPaymentPlan tuitionPaymentPlan : allPlans) {
                if (tuitionPaymentPlan == this) continue;
                for (TuitionInstallmentTariff tuitionInstallmentTariff : tuitionPaymentPlan.getTuitionInstallmentTariffsSet()) {
                    if (!tuitionInstallmentTariff.isDefaultPaymentPlanDependent()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public BigDecimal tuitionTotalAmount() {
        return this.getTuitionInstallmentTariffsSet().stream().map(t -> t.getFixedAmount()).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new TuitionPaymentPlan$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TuitionPaymentPlan this_) {
        if (!this_.isDeletable()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.delete.impossible", new String[0]);
        }
        this_.setDomainRoot(null);
        while (!this_.getTuitionInstallmentTariffsSet().isEmpty()) {
            ((TuitionInstallmentTariff)((Object)this_.getTuitionInstallmentTariffsSet().iterator().next())).delete();
        }
        this_.getTuitionPaymentPlanCalculatorSet().forEach(c -> c.delete());
        super.getTuitionConditionRulesSet().forEach(rule -> rule.delete());
        while (!this_.getTuitionPaymentPlanOrdersSet().isEmpty()) {
            ((TuitionPaymentPlanOrder)((Object)this_.getTuitionPaymentPlanOrdersSet().iterator().next())).delete(false);
        }
        super.setTuitionPaymentPlanGroup(null);
        super.setExecutionYear(null);
        super.setProduct(null);
        this_.setFinantialEntity(null);
        this_.setPayorDebtAccount(null);
        this_.setCopyFromTuitionPaymentPlan(null);
        while (!this_.getTuitionPaymentPlanCopiesSet().isEmpty()) {
            ((TuitionPaymentPlan)((Object)this_.getTuitionPaymentPlanCopiesSet().iterator().next())).setCopyFromTuitionPaymentPlan(null);
        }
        super.setDegreeCurricularPlan(null);
        super.setCurricularYear(null);
        super.setRegistrationProtocol(null);
        super.setStatuteType(null);
        super.setIngression(null);
        super.deleteDomainObject();
    }

    public boolean isStudentMustBeEnrolled() {
        return true;
    }

    @Deprecated
    public DebtAccount getPayorDebtAccount() {
        return super.getPayorDebtAccount();
    }

    public void setPayorDebtAccount(DebtAccount payorDebtAccount) {
        super.setPayorDebtAccount(payorDebtAccount);
    }

    public boolean isCopyFromOtherExistingTuitionPaymentPlan() {
        return this.getCopyFromTuitionPaymentPlan() != null;
    }

    public boolean hasCopiesInExecutionInterval(ExecutionInterval executionInterval) {
        return this.getTuitionPaymentPlanCopiesSet().stream().anyMatch(p -> p.getExecutionYear() == executionInterval);
    }

    public static Stream<TuitionPaymentPlan> findAll() {
        return FenixFramework.getDomainRoot().getTuitionPaymentPlansSet().stream();
    }

    public static Stream<TuitionPaymentPlan> find(TuitionPaymentPlanGroup tuitionPaymentPlanGroup) {
        return tuitionPaymentPlanGroup.getTuitionPaymentPlansSet().stream();
    }

    public static Stream<TuitionPaymentPlan> find(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, ExecutionYear executionYear) {
        return TuitionPaymentPlan.find(tuitionPaymentPlanGroup).filter(t -> t.getExecutionYear() == executionYear);
    }

    public static Stream<TuitionPaymentPlan> find(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, FinantialEntity finantialEntity, ExecutionYear executionYear) {
        return TuitionPaymentPlan.find(tuitionPaymentPlanGroup).filter(t -> t.getFinantialEntity() == finantialEntity).filter(t -> t.getExecutionYear() == executionYear);
    }

    @Deprecated
    public static Stream<TuitionPaymentPlan> find(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlan.find(tuitionPaymentPlanGroup).filter(t -> t.getExecutionYear() == executionYear && t.getTuitionPaymentPlanOrdersSet().stream().anyMatch(order -> order.getDegreeCurricularPlan() == degreeCurricularPlan));
    }

    @Deprecated
    public static Stream<TuitionPaymentPlan> findSortedByPaymentPlanOrder(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlanOrder.findSortedByPaymentPlanOrder(tuitionPaymentPlanGroup, degreeCurricularPlan, executionYear).map(order -> order.getTuitionPaymentPlan());
    }

    private static Stream<TuitionPaymentPlan> findDefaultPaymentPlans(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlan.find(TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), degreeCurricularPlan, executionYear).filter(t -> t.isDefaultPaymentPlan());
    }

    public static Optional<TuitionPaymentPlan> findUniqueDefaultPaymentPlan(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlan.findDefaultPaymentPlans(degreeCurricularPlan, executionYear).findFirst();
    }

    public static boolean isDefaultPaymentPlanDefined(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        return TuitionPaymentPlan.findUniqueDefaultPaymentPlan(degreeCurricularPlan, executionYear).isPresent();
    }

    public static TuitionPaymentPlan inferTuitionPaymentPlanForRegistration(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, Predicate<? super TuitionPaymentPlan> predicate) {
        List plans = TuitionPaymentPlan.findSortedByPaymentPlanOrder(TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), degreeCurricularPlan, executionYear).collect(Collectors.toList());
        return plans.stream().filter(predicate).findFirst().orElse(null);
    }

    public static TuitionPaymentPlan inferTuitionPaymentPlanForRegistration(Registration registration, ExecutionYear executionYear, Predicate<? super TuitionPaymentPlan> predicate) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        if (studentCurricularPlan == null) {
            return null;
        }
        DegreeCurricularPlan degreeCurricularPlan = studentCurricularPlan.getDegreeCurricularPlan();
        return TuitionPaymentPlan.inferTuitionPaymentPlanForRegistration(degreeCurricularPlan, executionYear, predicate);
    }

    public static TuitionPaymentPlan inferTuitionPaymentPlanForRegistration(Registration registration, ExecutionYear executionYear) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        if (studentCurricularPlan == null) {
            return null;
        }
        Predicate<TuitionPaymentPlan> predicate = plan -> !plan.isCustomized() && plan.isValidTo(registration, executionYear, null, Collections.emptySet());
        return TuitionPaymentPlan.inferTuitionPaymentPlanForRegistration(registration, executionYear, predicate);
    }

    public static TuitionPaymentPlan inferTuitionPaymentPlanForStandaloneEnrolment(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        if (!enrolment.isStandalone()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.enrolment.is.not.standalone", new String[0]);
        }
        DegreeCurricularPlan degreeCurricularPlan = enrolment.getCurricularCourse().getDegreeCurricularPlan();
        List filtered = TuitionPaymentPlan.findSortedByPaymentPlanOrder(TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().get(), degreeCurricularPlan, executionYear).collect(Collectors.toList());
        return filtered.stream().filter(plan -> !plan.isCustomized() && plan.isValidTo(registration, executionYear, enrolment, Collections.emptySet())).findFirst().orElse(null);
    }

    public static TuitionPaymentPlan inferTuitionPaymentPlanForExtracurricularEnrolment(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        if (!enrolment.isExtraCurricular()) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.enrolment.is.not.extracurricular", new String[0]);
        }
        DegreeCurricularPlan degreeCurricularPlan = enrolment.getCurricularCourse().getDegreeCurricularPlan();
        List filtered = TuitionPaymentPlan.findSortedByPaymentPlanOrder(TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().get(), degreeCurricularPlan, executionYear).collect(Collectors.toList());
        return filtered.stream().filter(plan -> !plan.isCustomized() && plan.isValidTo(registration, executionYear, enrolment, Collections.emptySet())).findFirst().orElse(null);
    }

    public boolean isValidTo(Registration registration, ExecutionYear executionYear, Enrolment enrolment, Set<Class<? extends TuitionConditionRule>> exclude) {
        return this.isCustomized() || this.isDefaultPaymentPlan() || this.getTuitionConditionRulesSet().stream().allMatch(c -> !exclude.contains(((Object)c).getClass()) && c.isValidTo(registration, executionYear, enrolment));
    }

    public static boolean firstTimeStudent(Registration registration, ExecutionYear executionYear) {
        return registration.isFirstTime(executionYear);
    }

    public static Integer curricularYear(Registration registration, ExecutionYear executionYear) {
        return registration.getCurricularYear(executionYear);
    }

    public static Set<Integer> semestersWithEnrolments(Registration registration, ExecutionYear executionYear) {
        IAcademicTreasuryPlatformDependentServices implementation = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        return registration.getEnrolments(executionYear).stream().map(e -> implementation.executionIntervalChildOrder(e.getExecutionPeriod())).collect(Collectors.toSet());
    }

    public static TuitionPaymentPlan create(TuitionPaymentPlanBean tuitionPaymentPlanBean) {
        return (TuitionPaymentPlan)((Object)advice$create.perform((Callable)new TuitionPaymentPlan$callable$create(tuitionPaymentPlanBean)));
    }

    static /* synthetic */ TuitionPaymentPlan advised$create(TuitionPaymentPlanBean tuitionPaymentPlanBean) {
        return new TuitionPaymentPlan(tuitionPaymentPlanBean);
    }

    public static TuitionPaymentPlan copy(TuitionPaymentPlan tuitionPaymentPlanToCopy, ExecutionYear toExecutionYear) {
        return new TuitionPaymentPlan(tuitionPaymentPlanToCopy, toExecutionYear);
    }

    public boolean equalsTuitionPlanConditions(TuitionPaymentPlan plan) {
        return this.containsTuitionPlanConditions(plan) && plan.containsTuitionPlanConditions(this);
    }

    public boolean containsTuitionPlanConditions(TuitionPaymentPlan plan) {
        for (TuitionConditionRule otherCondition : plan.getTuitionConditionRulesSet()) {
            TuitionConditionRule condition = this.getTuitionConditionRule(((Object)((Object)otherCondition)).getClass());
            if (condition != null && condition.containsRule(otherCondition)) continue;
            return false;
        }
        return true;
    }
}

