/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.tuition;

import com.google.common.base.Strings;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.ITuitionRegistrationServiceParameters;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.domain.tuition.TuitionTariffCustomCalculator;
import org.fenixedu.academictreasury.domain.tuition.exemptions.StatuteExemptionByIntervalMapEntry;
import org.fenixedu.academictreasury.dto.tuition.TuitionDebitEntryBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.ITuitionServiceExtension;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption_Base;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class RegistrationTuitionService
implements ITuitionRegistrationServiceParameters {
    boolean isForCalculationsOfOriginalAmounts = false;
    RegistrationOptions registrationOptions;
    TuitionOptions tuitionOptions;
    InstallmentOptions installmentOptions;
    InstallmentRecalculationOptions installmentRecalculationOptions;
    TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> _discountExemptionsMapForAllInstallments;
    Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> _calculatorsMap;
    String _calculationDescription;
    RegistrationTuitionService _originalAmountsCalculator;
    Comparator<TreasuryExemptionType> TREASURY_EVENT_COMPARATOR = (o1, o2) -> o1.getExternalId().compareTo(o2.getExternalId());

    public boolean executeTuitionPaymentPlanCreation() {
        PersonCustomer personCustomer;
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        LocalDate debtDate = this.registrationOptions.debtDate;
        boolean forceCreationIfNotEnrolled = this.tuitionOptions.forceCreationIfNotEnrolled;
        this.initializeTuitionPaymentPlan();
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        boolean applyTuitionServiceExtensions = this.tuitionOptions.applyTuitionServiceExtensions;
        boolean forceEvenTreasuryEventIsCharged = this.installmentOptions.forceInstallmentsEvenTreasuryEventIsCharged;
        if (!TuitionServices.isToPayRegistrationTuition(registration, executionYear) && !forceCreationIfNotEnrolled) {
            return false;
        }
        if (applyTuitionServiceExtensions) {
            for (ITuitionServiceExtension iTuitionServiceExtension : TuitionServices.TUITION_SERVICE_EXTENSIONS()) {
                if (!iTuitionServiceExtension.applyExtension(registration, executionYear)) continue;
                return iTuitionServiceExtension.createTuitionForRegistration(registration, executionYear, debtDate, forceCreationIfNotEnrolled, tuitionPaymentPlan);
            }
        }
        if (tuitionPaymentPlan == null) {
            return false;
        }
        if (!forceCreationIfNotEnrolled && tuitionPaymentPlan.isStudentMustBeEnrolled() && TuitionServices.normalEnrolmentsIncludingAnnuled(registration, executionYear).isEmpty()) {
            return false;
        }
        Person person = registration.getPerson();
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, addressFiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", new String[]{personCustomer.getBusinessIdentification(), personCustomer.getName()});
        }
        if (!DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
            DebtAccount.create((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
        }
        if (!AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).isPresent()) {
            AcademicTreasuryEvent.createForRegistrationTuition(tuitionPaymentPlan.getProduct(), registration, executionYear);
        }
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).get();
        FinantialInstitution finantialInstitution = tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution();
        Currency currency = finantialInstitution.getCurrency();
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).get();
        if (!tuitionPaymentPlan.getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        if (!forceEvenTreasuryEventIsCharged && academicTreasuryEvent.isCharged()) {
            return false;
        }
        this.initializeCreditsAndEnrolledCoursesCount();
        this.initializeCustomCalculators();
        this.initializeOriginalAmountsCalculator();
        this.initializeDiscountExemptionsMapForAllInstallments();
        Map calculatedDebitEntryBeansMap = this._originalAmountsCalculator.executeInstallmentDebitEntryBeansCalculation().stream().collect(Collectors.toMap(TuitionDebitEntryBean::getTuitionInstallmentTariff, Function.identity()));
        if (this._calculationDescription.length() > 0) {
            Map propertiesMap = academicTreasuryEvent.getPropertiesMap();
            String key = AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTreasury.CustomCalculatorDescription", new String[0]) + " ( " + DateTime.now().toString("yyyy-MM-dd HH:mm") + " )";
            propertiesMap.put(key, this._calculationDescription);
            academicTreasuryEvent.editPropertiesMap(propertiesMap);
        }
        Stream<? super TuitionInstallmentTariff> installments = tuitionPaymentPlan.getTuitionInstallmentTariffsSet().stream().sorted(TuitionInstallmentTariff.COMPARATOR_BY_INSTALLMENT_NUMBER);
        Function<TuitionInstallmentTariff, Boolean> func = tariff -> {
            boolean isToRecalculateInstallment;
            Product product = tariff.getProduct();
            TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> _discountExemptionsMapForOnlyThisInstallment = this.buildDiscountExemptionsMapForOnlyThisInstallment((TuitionInstallmentTariff)((Object)tariff));
            boolean bl = isToRecalculateInstallment = this.installmentRecalculationOptions.recalculateInstallments != null && this.installmentRecalculationOptions.recalculateInstallments.containsKey(product);
            if (isToRecalculateInstallment && this.isTuitionInstallmentCharged(product)) {
                TuitionDebitEntryBean originalBean = calculatedDebitEntryBeansMap.computeIfAbsent((TuitionInstallmentTariff)((Object)tariff), t -> new TuitionDebitEntryBean(t.getInstallmentOrder(), (TuitionInstallmentTariff)((Object)((Object)t)), this.ls("Installment bean"), debtDate, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, (Map<TreasuryExemptionType, BigDecimal>)new HashMap<TreasuryExemptionType, BigDecimal>(), currency));
                BigDecimal differenceNetAmount = originalBean.getAmount().subtract(this.getNetAmountAlreadyDebited(product));
                BigDecimal differenceInNetExemptedAmount = originalBean.getExemptedAmount().subtract(this.getNetAmountAlreadyExempted(product));
                if (TreasuryConstants.isZero((BigDecimal)differenceNetAmount) && TreasuryConstants.isZero((BigDecimal)differenceInNetExemptedAmount) && this.isExemptionsMapAreEqual((TuitionInstallmentTariff)((Object)tariff), academicTreasuryEvent, originalBean)) {
                    return false;
                }
                if (TreasuryConstants.isNegative((BigDecimal)differenceNetAmount) && TreasuryConstants.isZero((BigDecimal)differenceInNetExemptedAmount) && this.isExemptionsMapAreEqual((TuitionInstallmentTariff)((Object)tariff), academicTreasuryEvent, originalBean)) {
                    this.closeDebitEntriesInDebitNote(academicTreasuryEvent, tariff.getProduct());
                    BigDecimal remainingAmountToCredit = differenceNetAmount.negate();
                    List debitEntriesToCreditList = DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)product).sorted(DebitEntry.COMPARE_BY_EXTERNAL_ID.reversed()).collect(Collectors.toList());
                    for (DebitEntry d2 : debitEntriesToCreditList) {
                        BigDecimal netAmountToCredit = remainingAmountToCredit.min(d2.getAvailableNetAmountForCredit());
                        remainingAmountToCredit = netAmountToCredit.subtract(netAmountToCredit);
                        if (!TreasuryConstants.isPositive((BigDecimal)netAmountToCredit)) continue;
                        String reason = TreasuryConstants.treasuryBundle((String)"label.RegistrationTuitionService.tuitionRecalculationReason", (String[])new String[0]);
                        d2.creditDebitEntry(netAmountToCredit, reason, false);
                        if (TreasuryConstants.isPositive((BigDecimal)d2.getAvailableNetAmountForCredit()) || TreasuryConstants.isPositive((BigDecimal)d2.getNetExemptedAmount())) continue;
                        d2.annulOnEvent();
                    }
                    return true;
                }
                if (!TreasuryConstants.isNegative((BigDecimal)differenceNetAmount) && !TreasuryConstants.isNegative((BigDecimal)differenceInNetExemptedAmount) && this.isThereAreOnlyNewEntriesOrIncrementsInExemptions((TuitionInstallmentTariff)((Object)tariff), academicTreasuryEvent, originalBean)) {
                    LocalDate recalculationDueDate = this.installmentRecalculationOptions.recalculateInstallments.get(product);
                    HashMap<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap = new HashMap<TreasuryExemptionType, BigDecimal>();
                    BigDecimal simulationOfTotalExemptedAmountForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(this.buildDiscountExemptionsMapForOnlyThisInstallment((TuitionInstallmentTariff)((Object)tariff)), originalBean.getExemptedAmount(), new HashMap<TreasuryExemptionType, BigDecimal>());
                    BigDecimal simulationOfAlreadyExemptedAmountForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(this.buildDiscountExemptionsMapForOnlyThisInstallmentByAmount(this.getNetAmountAlreadyDebited(product).add(this.getNetAmountAlreadyExempted(product))), this.getNetAmountAlreadyExempted(product), new HashMap<TreasuryExemptionType, BigDecimal>());
                    BigDecimal netExemptedAmountToTakeFromExemptionsMapForAllInstallments = differenceInNetExemptedAmount;
                    if (TreasuryConstants.isGreaterOrEqualThan((BigDecimal)simulationOfTotalExemptedAmountForOnlyThisInstallment, (BigDecimal)simulationOfAlreadyExemptedAmountForOnlyThisInstallment)) {
                        this.getAndDecrementFromDiscountMap(_discountExemptionsMapForOnlyThisInstallment, simulationOfAlreadyExemptedAmountForOnlyThisInstallment, new HashMap<TreasuryExemptionType, BigDecimal>());
                        BigDecimal totalExemptedAmountFromExemptionsMapForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(_discountExemptionsMapForOnlyThisInstallment, simulationOfTotalExemptedAmountForOnlyThisInstallment.subtract(simulationOfAlreadyExemptedAmountForOnlyThisInstallment), exemptionsToApplyMap);
                        netExemptedAmountToTakeFromExemptionsMapForAllInstallments = netExemptedAmountToTakeFromExemptionsMapForAllInstallments.subtract(totalExemptedAmountFromExemptionsMapForOnlyThisInstallment);
                    }
                    this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForAllInstallments, netExemptedAmountToTakeFromExemptionsMapForAllInstallments, exemptionsToApplyMap);
                    BigDecimal debitEntryNetAmount = differenceNetAmount.add(differenceInNetExemptedAmount);
                    return this.createRecalculationAdditionalDebitEntryForRegistrationAndExempt(debtDate, debtAccount, academicTreasuryEvent, (TuitionInstallmentTariff)((Object)tariff), (Map<TreasuryExemptionType, BigDecimal>)exemptionsToApplyMap, debitEntryNetAmount, recalculationDueDate);
                }
                if (TreasuryConstants.isNegative((BigDecimal)differenceInNetExemptedAmount) || TreasuryConstants.isNegative((BigDecimal)differenceNetAmount) && !TreasuryConstants.isZero((BigDecimal)differenceInNetExemptedAmount) || this.isThereAreRemovalOrDecrementsInExemptions((TuitionInstallmentTariff)((Object)tariff), academicTreasuryEvent, originalBean)) {
                    this.closeDebitEntriesInDebitNote(academicTreasuryEvent, tariff.getProduct());
                    this.revertExemptionAmountsFromAcademicTreasuryToDiscountExemptionsMapForAllInstallments((TuitionInstallmentTariff)((Object)tariff));
                    DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)product).forEach(d -> d.annulOnlyThisDebitEntryAndInterestsInBusinessContext(AcademicTreasuryConstants.academicTreasuryBundle("label.RegistrationTuitionService.tuitionRecalculationReason", new String[0])));
                    HashMap<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap = new HashMap<TreasuryExemptionType, BigDecimal>();
                    BigDecimal tuitionInstallmentAmountToPay = originalBean.getAmount().add(originalBean.getExemptedAmount());
                    BigDecimal netAmountToExemptForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(_discountExemptionsMapForOnlyThisInstallment, tuitionInstallmentAmountToPay, exemptionsToApplyMap);
                    this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForAllInstallments, tuitionInstallmentAmountToPay.subtract(netAmountToExemptForOnlyThisInstallment), exemptionsToApplyMap);
                    return this.createDebitEntryForRegistrationAndExempt(debtDate, debtAccount, academicTreasuryEvent, (TuitionInstallmentTariff)((Object)tariff), (Map<TreasuryExemptionType, BigDecimal>)exemptionsToApplyMap);
                }
                throw new IllegalStateException("reculation: do not know how to handle this case???");
            }
            if (!this.isTuitionInstallmentCharged(product)) {
                return this.createUnchargedInstallmentDebitEntry(debtDate, debtAccount, academicTreasuryEvent, (TuitionInstallmentTariff)((Object)tariff), _discountExemptionsMapForOnlyThisInstallment);
            }
            if (this.isTuitionInstallmentCharged(product)) {
                return false;
            }
            throw new IllegalStateException("reculation: do not know how to handle this case???");
        };
        Predicate<TuitionInstallmentTariff> isToCalculateInstallmentProduct = t -> this.installmentOptions.installments == null || this.installmentOptions.installments.contains(t.getProduct()) || this.installmentRecalculationOptions.recalculateInstallments != null && this.installmentRecalculationOptions.recalculateInstallments.containsKey(t.getProduct());
        return installments.filter(isToCalculateInstallmentProduct).map(func).reduce(Boolean.FALSE, Boolean::logicalOr);
    }

    private boolean isThereAreRemovalOrDecrementsInExemptions(TuitionInstallmentTariff tariff, AcademicTreasuryEvent academicTreasuryEvent, TuitionDebitEntryBean newTuitionDebitEntryBean) {
        Map alreadyCreatedMap = academicTreasuryEvent.getNetExemptedAmountsMap(tariff.getProduct());
        Map<TreasuryExemptionType, BigDecimal> newTuitionDebitEntryBeanExemptionsMap = newTuitionDebitEntryBean.getExemptionsMap();
        Predicate<Map.Entry> predicate = alreadyExemptedEntry -> !newTuitionDebitEntryBeanExemptionsMap.containsKey(alreadyExemptedEntry.getKey()) || TreasuryConstants.isLessThan((BigDecimal)((BigDecimal)newTuitionDebitEntryBeanExemptionsMap.get(alreadyExemptedEntry.getKey())), (BigDecimal)((BigDecimal)alreadyExemptedEntry.getValue()));
        return alreadyCreatedMap.entrySet().stream().anyMatch(predicate);
    }

    private boolean isThereAreOnlyNewEntriesOrIncrementsInExemptions(TuitionInstallmentTariff tariff, AcademicTreasuryEvent academicTreasuryEvent, TuitionDebitEntryBean newTuitionDebitEntryBean) {
        Map alreadyCreatedMap = academicTreasuryEvent.getNetExemptedAmountsMap(tariff.getProduct());
        Map<TreasuryExemptionType, BigDecimal> newTuitionDebitEntryBeanExemptionsMap = newTuitionDebitEntryBean.getExemptionsMap();
        if (alreadyCreatedMap.keySet().size() > newTuitionDebitEntryBeanExemptionsMap.keySet().size()) {
            return false;
        }
        Predicate<Map.Entry> predicate = e -> !newTuitionDebitEntryBeanExemptionsMap.containsKey(e.getKey()) || TreasuryConstants.isLessThan((BigDecimal)((BigDecimal)newTuitionDebitEntryBeanExemptionsMap.get(e.getKey())), (BigDecimal)((BigDecimal)e.getValue()));
        return !alreadyCreatedMap.entrySet().stream().anyMatch(predicate);
    }

    private boolean isExemptionsMapAreEqual(TuitionInstallmentTariff tariff, AcademicTreasuryEvent academicTreasuryEvent, TuitionDebitEntryBean newTuitionDebitEntryBean) {
        Map alreadyCreatedMap = academicTreasuryEvent.getNetExemptedAmountsMap(tariff.getProduct());
        Map<TreasuryExemptionType, BigDecimal> originalExemptionsMap = newTuitionDebitEntryBean.getExemptionsMap();
        if (alreadyCreatedMap.keySet().equals(originalExemptionsMap.keySet())) {
            return true;
        }
        Predicate<Map.Entry> predicate = e -> TreasuryConstants.isEqual((BigDecimal)((BigDecimal)e.getValue()), (BigDecimal)((BigDecimal)originalExemptionsMap.get(e.getKey())));
        return alreadyCreatedMap.entrySet().stream().allMatch(predicate);
    }

    private Boolean createUnchargedInstallmentDebitEntry(LocalDate debtDate, DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, TuitionInstallmentTariff tariff, TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> _discountExemptionsMapForOnlyThisInstallment) {
        BigDecimal tuitionInstallmentAmountToPay = tariff.amountToPay(this);
        if (!TreasuryConstants.isPositive((BigDecimal)tuitionInstallmentAmountToPay)) {
            return false;
        }
        HashMap<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap = new HashMap<TreasuryExemptionType, BigDecimal>();
        BigDecimal netAmountToExemptForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(_discountExemptionsMapForOnlyThisInstallment, tuitionInstallmentAmountToPay, exemptionsToApplyMap);
        this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForAllInstallments, tuitionInstallmentAmountToPay.subtract(netAmountToExemptForOnlyThisInstallment), exemptionsToApplyMap);
        return this.createDebitEntryForRegistrationAndExempt(debtDate, debtAccount, academicTreasuryEvent, tariff, exemptionsToApplyMap);
    }

    private void closeDebitEntriesInDebitNote(AcademicTreasuryEvent academicTreasuryEvent, Product product) {
        Predicate<DebitEntry> isDebitEntryInPreparingDocument = de -> de.getFinantialDocument() != null && de.getFinantialDocument().isPreparing();
        Map preparingDebitNotesMapByDebtAccount = DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)product).filter(isDebitEntryInPreparingDocument).map(DebitEntry::getDebitNote).collect(Collectors.toMap(note -> note.getPayorDebtAccount() != null ? note.getPayorDebtAccount() : note.getDebtAccount(), Function.identity()));
        DebitEntry.findActive((TreasuryEvent)academicTreasuryEvent, (Product)product).filter(de -> de.getFinantialDocument() == null).forEach(de -> {
            DebtAccount debitEntryDebtAccount = de.getPayorDebtAccount() != null ? de.getPayorDebtAccount() : de.getDebtAccount();
            DebitNote newlyDebitNote = preparingDebitNotesMapByDebtAccount.computeIfAbsent(debitEntryDebtAccount, da -> this.createDebitNoteForPayorDebtAccount(de.getDebtAccount(), (DebtAccount)da));
            preparingDebitNotesMapByDebtAccount.put(debitEntryDebtAccount, newlyDebitNote);
            de.setFinantialDocument((FinantialDocument)newlyDebitNote);
        });
        preparingDebitNotesMapByDebtAccount.values().forEach(note -> note.closeDocument());
    }

    private DebitNote createDebitNoteForPayorDebtAccount(DebtAccount studentDebtAccount, DebtAccount debitEntryDebtAccount) {
        DebtAccount payorDebtAccount = studentDebtAccount != debitEntryDebtAccount ? debitEntryDebtAccount : null;
        FinantialInstitution finantialInstitution = studentDebtAccount.getFinantialInstitution();
        return DebitNote.create((DebtAccount)studentDebtAccount, (DebtAccount)payorDebtAccount, (DocumentNumberSeries)((DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)finantialInstitution).get()), (DateTime)new DateTime(), (LocalDate)new LocalDate(), null);
    }

    private void revertExemptionAmountsFromAcademicTreasuryToDiscountExemptionsMapForAllInstallments(TuitionInstallmentTariff tariff) {
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).ifPresent(tuitionEvent -> {
            Product product = tariff.getProduct();
            Map<TreasuryExemptionType, BigDecimal> exemptedAmountsByTypeMap = DebitEntry.findActive((TreasuryEvent)tuitionEvent, (Product)product).flatMap(d -> d.getTreasuryExemptionsSet().stream()).collect(Collectors.toMap(TreasuryExemption_Base::getTreasuryExemptionType, TreasuryExemption::getNetAmountToExempt, BigDecimal::add));
            for (Map.Entry<TreasuryExemptionType, BigDecimal> entry : exemptedAmountsByTypeMap.entrySet()) {
                TreasuryExemptionType treasuryExemptionType = entry.getKey();
                if (!this._discountExemptionsMapForAllInstallments.containsKey(treasuryExemptionType)) continue;
                BigDecimal netExemptedAmount = entry.getValue();
                BigDecimal totalDebitCreatedIncludingExemptions = DebitEntry.findActive((TreasuryEvent)tuitionEvent, (Product)product).map(d -> d.getNetAmount().add(d.getNetExemptedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal maximumAmountToExemptFromDiscountExemptionsMapForOnlyThisInstallment = this.buildDiscountExemptionsMapForOnlyThisInstallmentByAmount((BigDecimal)totalDebitCreatedIncludingExemptions).computeIfAbsent((TreasuryExemptionType)treasuryExemptionType, (Function<TreasuryExemptionType, TreasuryExemptionMoneyBox>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$revertExemptionAmountsFromAcademicTreasuryToDiscountExemptionsMapForAllInstallments$15(org.fenixedu.treasury.domain.exemption.TreasuryExemptionType ), (Lorg/fenixedu/treasury/domain/exemption/TreasuryExemptionType;)Lorg/fenixedu/academictreasury/services/tuition/RegistrationTuitionService$TreasuryExemptionMoneyBox;)()).maximumNetAmountForExemption.min(netExemptedAmount);
                BigDecimal remainingAmountToRemoveFromDiscountMapForAllInstallments = netExemptedAmount.subtract(maximumAmountToExemptFromDiscountExemptionsMapForOnlyThisInstallment);
                this._discountExemptionsMapForAllInstallments.get(treasuryExemptionType).addToAvailableNetAmountForExemption(remainingAmountToRemoveFromDiscountMapForAllInstallments);
            }
        });
    }

    private LocalizedString ls(String value) {
        return new LocalizedString(TreasuryPlataformDependentServicesFactory.implementation().defaultLocale(), value);
    }

    private Boolean createRecalculationAdditionalDebitEntryForRegistrationAndExempt(LocalDate debtDate, DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, TuitionInstallmentTariff tariff, Map<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap, BigDecimal recalculatedAmount, LocalDate recalculationDueDate) {
        DebitEntry installmentDebitEntry = tariff.createRecalculationDebitEntryForRegistration(debtAccount, academicTreasuryEvent, debtDate, this._calculatorsMap, recalculatedAmount, recalculationDueDate);
        for (Map.Entry<TreasuryExemptionType, BigDecimal> entry : exemptionsToApplyMap.entrySet()) {
            TreasuryExemptionType treasuryExemptionType = entry.getKey();
            BigDecimal amountToExempt = entry.getValue();
            String reason = treasuryExemptionType.getName().getContent(TreasuryPlataformDependentServicesFactory.implementation().defaultLocale());
            TreasuryExemption.create((TreasuryExemptionType)treasuryExemptionType, (String)reason, (BigDecimal)amountToExempt, (DebitEntry)installmentDebitEntry);
        }
        return true;
    }

    private Boolean createDebitEntryForRegistrationAndExempt(LocalDate debtDate, DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, TuitionInstallmentTariff tariff, Map<TreasuryExemptionType, BigDecimal> exemptionsToApplyMap) {
        DebitEntry installmentDebitEntry = tariff.createDebitEntryForRegistration(this);
        for (Map.Entry<TreasuryExemptionType, BigDecimal> entry : exemptionsToApplyMap.entrySet()) {
            TreasuryExemptionType treasuryExemptionType = entry.getKey();
            BigDecimal amountToExempt = entry.getValue();
            String reason = treasuryExemptionType.getName().getContent(TreasuryPlataformDependentServicesFactory.implementation().defaultLocale());
            TreasuryExemption.create((TreasuryExemptionType)treasuryExemptionType, (String)reason, (BigDecimal)amountToExempt, (DebitEntry)installmentDebitEntry);
        }
        return true;
    }

    public List<TuitionDebitEntryBean> executeInstallmentDebitEntryBeansCalculation() {
        this.initializeCreditsAndEnrolledCoursesCount();
        this.initializeTuitionPaymentPlan();
        this.initializeCustomCalculators();
        this.initializeOriginalAmountsCalculator();
        this.initializeDiscountExemptionsMapForAllInstallments();
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        if (tuitionPaymentPlan == null) {
            return Collections.emptyList();
        }
        if (!tuitionPaymentPlan.getTuitionPaymentPlanGroup().isForRegistration()) {
            throw new RuntimeException("wrong call");
        }
        Predicate<TuitionInstallmentTariff> isToCalculateInstallmentProduct = t -> this.installmentOptions.installments == null || this.installmentOptions.installments.contains(t.getProduct()) || this.installmentRecalculationOptions.recalculateInstallments != null && this.installmentRecalculationOptions.recalculateInstallments.containsKey(t.getProduct());
        HashMap calculatedDebitEntryBeansMap = new HashMap();
        if (!this.isForCalculationsOfOriginalAmounts) {
            this._originalAmountsCalculator.executeInstallmentDebitEntryBeansCalculation().stream().forEach(e -> calculatedDebitEntryBeansMap.put(e.getTuitionInstallmentTariff(), e));
        }
        List<TuitionDebitEntryBean> entries = tuitionPaymentPlan.getTuitionInstallmentTariffsSet().stream().sorted(TuitionInstallmentTariff.COMPARATOR_BY_INSTALLMENT_NUMBER).filter(isToCalculateInstallmentProduct).flatMap(t -> this.buildInstallmentDebitEntryBeanWithDiscount(calculatedDebitEntryBeansMap, (TuitionInstallmentTariff)((Object)t)).stream()).filter(Objects::nonNull).collect(Collectors.toList());
        return entries;
    }

    private void initializeOriginalAmountsCalculator() {
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        LocalDate debtDate = this.registrationOptions.debtDate;
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        RegistrationOptions serviceBuilder = RegistrationTuitionService.startServiceInvocation(registration, executionYear, debtDate);
        serviceBuilder.applyEnrolledEctsUnits(this.registrationOptions.enrolledEctsUnits);
        serviceBuilder.applyEnrolledCoursesCount(this.registrationOptions.enrolledCoursesCount);
        serviceBuilder.applyDefaultEnrolmentCredits(this.registrationOptions.applyDefaultEnrolmentCredits);
        TuitionOptions tuitionPaymentPlanBuilder = serviceBuilder.withTuitionPaymentPlan(tuitionPaymentPlan);
        if (this.installmentOptions.installments != null) {
            HashSet<Product> products = new HashSet<Product>(this.installmentOptions.installments);
            if (this.installmentRecalculationOptions.recalculateInstallments != null) {
                products.addAll(this.installmentRecalculationOptions.recalculateInstallments.keySet());
            }
            this._originalAmountsCalculator = tuitionPaymentPlanBuilder.forceCreationIfNotEnrolled(true).restrictForInstallmentProducts(products).forceInstallmentsEvenTreasuryEventIsCharged(true).withoutInstallmentsRecalculation();
        } else {
            this._originalAmountsCalculator = tuitionPaymentPlanBuilder.forceCreationIfNotEnrolled(true).withAllInstallments().forceInstallmentsEvenTreasuryEventIsCharged(true).withoutInstallmentsRecalculation();
        }
        this._originalAmountsCalculator.isForCalculationsOfOriginalAmounts = true;
    }

    private void initializeCreditsAndEnrolledCoursesCount() {
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        TuitionPaymentPlanGroup tuitionPaymentPlanGroup = TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get();
        if (this.registrationOptions.enrolledEctsUnits == null) {
            this.registrationOptions.enrolledEctsUnits = AcademicTreasuryEvent.getEnrolledEctsUnits(tuitionPaymentPlanGroup, registration, executionYear);
        }
        if (this.registrationOptions.enrolledCoursesCount == null) {
            this.registrationOptions.enrolledCoursesCount = AcademicTreasuryEvent.getEnrolledCoursesCount(tuitionPaymentPlanGroup, registration, executionYear);
        }
    }

    private void initializeDiscountExemptionsMapForAllInstallments() {
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        Person person = registration.getPerson();
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        DegreeCurricularPlan degreeCurricularPlan = studentCurricularPlan.getDegreeCurricularPlan();
        TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> result = new TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox>(this.TREASURY_EVENT_COMPARATOR);
        RegistrationTuitionService.getOtherEventsToDiscountInTuitionFee(person, executionYear, degreeCurricularPlan).stream().collect(Collectors.toMap(TreasuryEvent::getTreasuryExemptionToApplyInEventDiscountInTuitionFee, ev -> new TreasuryExemptionMoneyBox(ev.getNetAmountToPay(), ev.getNetAmountToPay()), (rec$, x$0) -> ((TreasuryExemptionMoneyBox)rec$).mergeBySumming((TreasuryExemptionMoneyBox)x$0), () -> result));
        if (!this.isForCalculationsOfOriginalAmounts) {
            this.removeAlreadyCreatedExemptedAmountsFromTheDiscountMapForAllInstallments(result);
        }
        this._discountExemptionsMapForAllInstallments = result;
    }

    private TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> removeAlreadyCreatedExemptedAmountsFromTheDiscountMapForAllInstallments(TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> discountMapForAllInstallments) {
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).ifPresent(tuitionEvent -> this.tuitionOptions.tuitionPaymentPlan.getOrderedTuitionInstallmentTariffs().forEach(tariff -> {
            Product product = tariff.getProduct();
            Map<TreasuryExemptionType, BigDecimal> exemptedAmountsByTypeMap = DebitEntry.findActive((TreasuryEvent)tuitionEvent, (Product)product).flatMap(d -> d.getTreasuryExemptionsSet().stream()).collect(Collectors.toMap(TreasuryExemption_Base::getTreasuryExemptionType, TreasuryExemption::getNetAmountToExempt, BigDecimal::add));
            for (Map.Entry<TreasuryExemptionType, BigDecimal> entry : exemptedAmountsByTypeMap.entrySet()) {
                TreasuryExemptionType treasuryExemptionType = entry.getKey();
                if (!discountMapForAllInstallments.containsKey(treasuryExemptionType)) continue;
                BigDecimal netExemptedAmount = entry.getValue();
                BigDecimal totalDebitCreatedIncludingExemptions = DebitEntry.findActive((TreasuryEvent)tuitionEvent, (Product)product).map(d -> d.getNetAmount().add(d.getNetExemptedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal maximumAmountToExemptFromDiscountExemptionsMapForOnlyThisInstallment = this.buildDiscountExemptionsMapForOnlyThisInstallmentByAmount((BigDecimal)totalDebitCreatedIncludingExemptions).computeIfAbsent((TreasuryExemptionType)treasuryExemptionType, (Function<TreasuryExemptionType, TreasuryExemptionMoneyBox>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$removeAlreadyCreatedExemptedAmountsFromTheDiscountMapForAllInstallments$26(org.fenixedu.treasury.domain.exemption.TreasuryExemptionType ), (Lorg/fenixedu/treasury/domain/exemption/TreasuryExemptionType;)Lorg/fenixedu/academictreasury/services/tuition/RegistrationTuitionService$TreasuryExemptionMoneyBox;)()).maximumNetAmountForExemption.min(netExemptedAmount);
                BigDecimal remainingAmountToRemoveFromDiscountMapForAllInstallments = netExemptedAmount.subtract(maximumAmountToExemptFromDiscountExemptionsMapForOnlyThisInstallment);
                ((TreasuryExemptionMoneyBox)discountMapForAllInstallments.get(treasuryExemptionType)).subtractFromCurrentNetAmount(remainingAmountToRemoveFromDiscountMapForAllInstallments);
            }
        }));
        return discountMapForAllInstallments;
    }

    private static List<TreasuryEvent> getOtherEventsToDiscountInTuitionFee(Person person, ExecutionYear executionYear, DegreeCurricularPlan degreeCurricularPlan) {
        return TreasuryBridgeAPIFactory.implementation().getAllAcademicTreasuryEventsList(person).stream().map(TreasuryEvent.class::cast).filter(t -> t.isEventDiscountInTuitionFee()).filter(t -> executionYear.getQualifiedName().equals(t.getExecutionYearName())).filter(t -> degreeCurricularPlan.getDegree().getCode().equals(t.getDegreeCode())).collect(Collectors.toList());
    }

    private List<TuitionDebitEntryBean> buildInstallmentDebitEntryBeanWithDiscount(Map<TuitionInstallmentTariff, TuitionDebitEntryBean> calculatedDebitEntryBeansMap, TuitionInstallmentTariff tariff) {
        boolean isToRecalculateInstallment;
        Product product = tariff.getProduct();
        Currency currency = tariff.getFinantialEntity().getFinantialInstitution().getCurrency();
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        Registration registration = this.registrationOptions.registration;
        LocalDate debtDate = this.registrationOptions.debtDate;
        int installmentOrder = tariff.getInstallmentOrder();
        LocalizedString installmentName = tuitionPaymentPlan.installmentName(registration, tariff);
        LocalDate dueDate = tariff.dueDate(debtDate);
        Vat vat = tariff.vat(debtDate);
        TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> _discountExemptionsMapForOnlyThisInstallment = this.buildDiscountExemptionsMapForOnlyThisInstallment(tariff);
        boolean bl = isToRecalculateInstallment = this.installmentRecalculationOptions.recalculateInstallments != null && this.installmentRecalculationOptions.recalculateInstallments.containsKey(product);
        if (isToRecalculateInstallment && this.isTuitionInstallmentCharged(product)) {
            TuitionDebitEntryBean originalBean = calculatedDebitEntryBeansMap.computeIfAbsent(tariff, t -> new TuitionDebitEntryBean(installmentOrder, (TuitionInstallmentTariff)((Object)t), this.ls("Dummy installment"), debtDate, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, (Map<TreasuryExemptionType, BigDecimal>)new HashMap<TreasuryExemptionType, BigDecimal>(), currency));
            BigDecimal differenceNetAmount = originalBean.getAmount().subtract(this.getNetAmountAlreadyDebited(product));
            BigDecimal differenceInNetExemptedAmount = originalBean.getExemptedAmount().subtract(this.getNetAmountAlreadyExempted(product));
            AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForRegistrationTuition(this.registrationOptions.registration, this.registrationOptions.executionYear).get();
            if (TreasuryConstants.isZero((BigDecimal)differenceNetAmount) && TreasuryConstants.isZero((BigDecimal)differenceInNetExemptedAmount) && this.isExemptionsMapAreEqual(tariff, academicTreasuryEvent, originalBean)) {
                return Collections.emptyList();
            }
            if (TreasuryConstants.isNegative((BigDecimal)differenceNetAmount) && TreasuryConstants.isZero((BigDecimal)differenceInNetExemptedAmount) && this.isExemptionsMapAreEqual(tariff, academicTreasuryEvent, originalBean)) {
                LocalDate recalculationDueDate = this.installmentRecalculationOptions.recalculateInstallments.get(product);
                LocalizedString recalculationInstallmentName = AcademicTreasuryConstants.academicTreasuryBundleI18N("label.RegistrationTuitionService.recalculation.installmentName.prefix", new String[0]).append(" ").append(installmentName);
                return Collections.singletonList(new TuitionDebitEntryBean(installmentOrder, tariff, recalculationInstallmentName, recalculationDueDate, vat.getTaxRate(), differenceNetAmount.negate(), BigDecimal.ZERO, new HashMap<TreasuryExemptionType, BigDecimal>(), currency));
            }
            if (!TreasuryConstants.isNegative((BigDecimal)differenceNetAmount) && !TreasuryConstants.isNegative((BigDecimal)differenceInNetExemptedAmount) && this.isThereAreOnlyNewEntriesOrIncrementsInExemptions(tariff, academicTreasuryEvent, originalBean)) {
                LocalDate recalculationDueDate = this.installmentRecalculationOptions.recalculateInstallments.get(product);
                LocalizedString recalculationInstallmentName = AcademicTreasuryConstants.academicTreasuryBundleI18N("label.RegistrationTuitionService.recalculation.installmentName.prefix", new String[0]).append(" ").append(installmentName);
                BigDecimal simulationOfTotalExemptedAmountForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(this.buildDiscountExemptionsMapForOnlyThisInstallment(tariff), originalBean.getExemptedAmount(), new HashMap<TreasuryExemptionType, BigDecimal>());
                if (TreasuryConstants.isLessOrEqualThan((BigDecimal)simulationOfTotalExemptedAmountForOnlyThisInstallment, (BigDecimal)this.getNetAmountAlreadyDebited(product))) {
                    this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForAllInstallments, differenceInNetExemptedAmount, new HashMap<TreasuryExemptionType, BigDecimal>());
                } else {
                    this.getAndDecrementFromDiscountMap(_discountExemptionsMapForOnlyThisInstallment, this.getNetAmountAlreadyDebited(product), new HashMap<TreasuryExemptionType, BigDecimal>());
                    BigDecimal totalExemptedAmountFromExemptionsMapForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(_discountExemptionsMapForOnlyThisInstallment, differenceInNetExemptedAmount, new HashMap<TreasuryExemptionType, BigDecimal>());
                    this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForAllInstallments, differenceInNetExemptedAmount.subtract(totalExemptedAmountFromExemptionsMapForOnlyThisInstallment), new HashMap<TreasuryExemptionType, BigDecimal>());
                }
                return Collections.singletonList(new TuitionDebitEntryBean(installmentOrder, tariff, recalculationInstallmentName, recalculationDueDate, vat.getTaxRate(), differenceNetAmount, differenceInNetExemptedAmount, new HashMap<TreasuryExemptionType, BigDecimal>(), currency));
            }
            if (TreasuryConstants.isNegative((BigDecimal)differenceInNetExemptedAmount) || TreasuryConstants.isNegative((BigDecimal)differenceNetAmount) && !TreasuryConstants.isZero((BigDecimal)differenceInNetExemptedAmount) || this.isThereAreRemovalOrDecrementsInExemptions(tariff, academicTreasuryEvent, originalBean)) {
                LocalizedString annullmentInstallmentName = AcademicTreasuryConstants.academicTreasuryBundleI18N("label.RegistrationTuitionService.annulment.installmentName.prefix", new String[0]).append(installmentName);
                LocalDate recalculationDueDate = this.installmentRecalculationOptions.recalculateInstallments.get(product);
                TuitionDebitEntryBean annulmentBean = new TuitionDebitEntryBean(installmentOrder, tariff, annullmentInstallmentName, recalculationDueDate, vat.getTaxRate(), this.getNetAmountAlreadyDebited(product).negate(), this.getNetAmountAlreadyExempted(product).negate(), new HashMap<TreasuryExemptionType, BigDecimal>(), currency);
                TuitionDebitEntryBean recalculationBean = new TuitionDebitEntryBean(installmentOrder, tariff, installmentName, recalculationDueDate, vat.getTaxRate(), originalBean.getAmount(), originalBean.getExemptedAmount(), new HashMap<TreasuryExemptionType, BigDecimal>(), currency);
                BigDecimal recurringAmountToExempt = this.getAndDecrementFromDiscountMap(_discountExemptionsMapForOnlyThisInstallment, originalBean.getExemptedAmount(), new HashMap<TreasuryExemptionType, BigDecimal>());
                this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForAllInstallments, originalBean.getExemptedAmount().subtract(recurringAmountToExempt), new HashMap<TreasuryExemptionType, BigDecimal>());
                return List.of(annulmentBean, recalculationBean);
            }
            throw new IllegalStateException("reculation: do not know how to handle this case???");
        }
        if (!this.isTuitionInstallmentCharged(product) || this.isForCalculationsOfOriginalAmounts) {
            BigDecimal tuitionInstallmentAmountToPay = tariff.amountToPay(this);
            if (!TreasuryConstants.isPositive((BigDecimal)tuitionInstallmentAmountToPay)) {
                return Collections.emptyList();
            }
            HashMap<TreasuryExemptionType, BigDecimal> exemptionsMapToApply = new HashMap<TreasuryExemptionType, BigDecimal>();
            BigDecimal netAmountToExemptFromMapForOnlyThisInstallment = this.getAndDecrementFromDiscountMap(_discountExemptionsMapForOnlyThisInstallment, tuitionInstallmentAmountToPay, exemptionsMapToApply);
            BigDecimal totalAmountToExempt = this.getAndDecrementFromDiscountMap(this._discountExemptionsMapForAllInstallments, tuitionInstallmentAmountToPay.subtract(netAmountToExemptFromMapForOnlyThisInstallment), exemptionsMapToApply);
            totalAmountToExempt = totalAmountToExempt.add(netAmountToExemptFromMapForOnlyThisInstallment);
            BigDecimal finalAmountToPay = tuitionInstallmentAmountToPay.subtract(totalAmountToExempt);
            return Collections.singletonList(new TuitionDebitEntryBean(installmentOrder, tariff, installmentName, dueDate, vat.getTaxRate(), finalAmountToPay, totalAmountToExempt, exemptionsMapToApply, currency));
        }
        return Collections.emptyList();
    }

    private TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> buildDiscountExemptionsMapForOnlyThisInstallment(TuitionInstallmentTariff tuitionInstallmentTariff) {
        BigDecimal tuitionInstallmentAmountToPay = tuitionInstallmentTariff.amountToPay(this);
        return this.buildDiscountExemptionsMapForOnlyThisInstallmentByAmount(tuitionInstallmentAmountToPay);
    }

    private TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> buildDiscountExemptionsMapForOnlyThisInstallmentByAmount(BigDecimal tuitionInstallmentAmountToPay) {
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        FinantialEntity finantialEntity = AcademicTreasuryPlataformDependentServicesFactory.implementation().finantialEntityOfDegree(registration.getDegree(), executionYear.getBeginLocalDate());
        Set<StatuteType> statutesOfStudent = AcademicTreasuryPlataformDependentServicesFactory.implementation().statutesTypesValidOnAnyExecutionSemesterFor(registration, (ExecutionInterval)executionYear);
        return StatuteExemptionByIntervalMapEntry.find(finantialEntity, (ExecutionInterval)executionYear).filter(s -> statutesOfStudent.contains(s.getStatuteType())).collect(Collectors.toMap(s -> s.getTreasuryExemptionType(), s -> {
            BigDecimal val = s.getTreasuryExemptionType().calculateDefaultNetAmountToExempt(tuitionInstallmentAmountToPay);
            return new TreasuryExemptionMoneyBox(val, val);
        }, (rec$, x$0) -> ((TreasuryExemptionMoneyBox)rec$).mergeByChoosingTheGreaterMaximumAmount((TreasuryExemptionMoneyBox)x$0), () -> new TreeMap(this.TREASURY_EVENT_COMPARATOR)));
    }

    private BigDecimal getAndDecrementFromDiscountMap(TreeMap<TreasuryExemptionType, TreasuryExemptionMoneyBox> _discountExemptionsMap, BigDecimal maximumAmountToDiscount, Map<TreasuryExemptionType, BigDecimal> treasuryExemptionsToApplyMap) {
        BigDecimal result = BigDecimal.ZERO;
        for (TreasuryExemptionType treasuryExemptionType : _discountExemptionsMap.navigableKeySet()) {
            if (!_discountExemptionsMap.get(treasuryExemptionType).isAvailableNetAmountForExemptionPositive()) continue;
            BigDecimal availableAmountToDiscount = _discountExemptionsMap.get((Object)treasuryExemptionType).availableNetAmountForExemption;
            BigDecimal amountToDiscount = availableAmountToDiscount.min(maximumAmountToDiscount);
            result = result.add(amountToDiscount);
            maximumAmountToDiscount = maximumAmountToDiscount.subtract(amountToDiscount);
            _discountExemptionsMap.get(treasuryExemptionType).subtractFromCurrentNetAmount(amountToDiscount);
            treasuryExemptionsToApplyMap.merge(treasuryExemptionType, amountToDiscount, BigDecimal::add);
            if (TreasuryConstants.isPositive((BigDecimal)maximumAmountToDiscount)) continue;
            break;
        }
        return result;
    }

    private BigDecimal getNetAmountAlreadyExempted(Product product) {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(this.registrationOptions.registration, this.registrationOptions.executionYear).map(e -> e.getNetExemptedAmount(product)).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getNetAmountAlreadyDebited(Product product) {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(this.registrationOptions.registration, this.registrationOptions.executionYear).map(e -> e.getNetAmountToPay(product)).orElse(BigDecimal.ZERO);
    }

    private boolean isTuitionInstallmentCharged(Product product) {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(this.registrationOptions.registration, this.registrationOptions.executionYear).map(e -> e.isChargedWithDebitEntry(product)).orElse(false);
    }

    private void initializeCustomCalculators() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        Registration registration = this.registrationOptions.registration;
        ExecutionYear executionYear = this.registrationOptions.executionYear;
        StringBuilder strBuilder = new StringBuilder();
        if (Boolean.TRUE.equals(tuitionPaymentPlan.getTuitionPaymentPlanGroup().getApplyDomainObjectCalculators())) {
            tuitionPaymentPlan.getTuitionInstallmentTariffsSet().stream().filter(tariff -> tariff.getTuitionPaymentPlanCalculator() != null).map(tariff -> tariff.getTuitionPaymentPlanCalculator()).collect(Collectors.toSet()).forEach(calculator -> {
                strBuilder.append(calculator.getName().getContent(services.defaultLocale())).append(" (").append(calculator.getTotalAmount(registration, (ITuitionRegistrationServiceParameters)this)).append("): \n");
                strBuilder.append(calculator.getCalculationDescription(registration)).append("\n");
            });
        } else {
            this._calculatorsMap = new HashMap<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator>();
            tuitionPaymentPlan.getTuitionInstallmentTariffsSet().stream().filter(t -> t.getTuitionTariffCustomCalculator() != null).map(tariff -> tariff.getTuitionTariffCustomCalculator()).collect(Collectors.toSet()).forEach(clazz -> {
                if (clazz != null) {
                    TuitionTariffCustomCalculator newInstanceFor = TuitionTariffCustomCalculator.getNewInstanceFor(clazz, registration, tuitionPaymentPlan);
                    this._calculatorsMap.put((Class<? extends TuitionTariffCustomCalculator>)clazz, newInstanceFor);
                    strBuilder.append(newInstanceFor.getPresentationName()).append(" (").append(newInstanceFor.getTotalAmount()).append("): \n");
                    strBuilder.append(newInstanceFor.getCalculationDescription()).append("\n");
                }
            });
        }
        this._calculationDescription = strBuilder.toString();
    }

    private void initializeTuitionPaymentPlan() {
        if (this.tuitionOptions.tuitionPaymentPlan == null) {
            this.tuitionOptions.tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForRegistration(this.registrationOptions.registration, this.registrationOptions.executionYear);
        }
    }

    public static RegistrationOptions startServiceInvocation(Registration registration, ExecutionYear executionYear, LocalDate debtDate) {
        RegistrationTuitionService service;
        RegistrationTuitionService registrationTuitionService = service = new RegistrationTuitionService();
        Objects.requireNonNull(registrationTuitionService);
        return registrationTuitionService.new RegistrationOptions(registration, executionYear, debtDate);
    }

    @Override
    public Registration getRegistration() {
        return this.registrationOptions.registration;
    }

    @Override
    public ExecutionYear getExecutionYear() {
        return this.registrationOptions.executionYear;
    }

    @Override
    public Map<Class<? extends TuitionTariffCustomCalculator>, TuitionTariffCustomCalculator> getCustomCalculatorsMap() {
        return this._calculatorsMap;
    }

    @Override
    public BigDecimal getEnrolledEctsUnits() {
        return this.registrationOptions.enrolledEctsUnits;
    }

    @Override
    public BigDecimal getEnrolledCoursesCount() {
        return this.registrationOptions.enrolledCoursesCount;
    }

    @Override
    public boolean isApplyDefaultEnrolmentCredits() {
        return this.registrationOptions.applyDefaultEnrolmentCredits;
    }

    @Override
    public Optional<DebtAccount> getDebtAccount() {
        Person person = this.getRegistration().getPerson();
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            return Optional.empty();
        }
        if (!PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).isPresent()) {
            return Optional.empty();
        }
        PersonCustomer personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get();
        if (!personCustomer.isActive()) {
            return Optional.empty();
        }
        if (this.tuitionOptions.tuitionPaymentPlan == null) {
            return Optional.empty();
        }
        TuitionPaymentPlan tuitionPaymentPlan = this.tuitionOptions.tuitionPaymentPlan;
        return DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
    }

    @Override
    public Optional<AcademicTreasuryEvent> getAcademicTreasuryEvent() {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(this.getRegistration(), this.getExecutionYear()).map(AcademicTreasuryEvent.class::cast);
    }

    @Override
    public LocalDate getDebtDate() {
        return this.registrationOptions.debtDate;
    }

    private static /* synthetic */ TreasuryExemptionMoneyBox lambda$removeAlreadyCreatedExemptedAmountsFromTheDiscountMapForAllInstallments$26(TreasuryExemptionType t) {
        return TreasuryExemptionMoneyBox.zero();
    }

    private static /* synthetic */ TreasuryExemptionMoneyBox lambda$revertExemptionAmountsFromAcademicTreasuryToDiscountExemptionsMapForAllInstallments$15(TreasuryExemptionType t) {
        return TreasuryExemptionMoneyBox.zero();
    }

    private static class TreasuryExemptionMoneyBox {
        private BigDecimal maximumNetAmountForExemption;
        private BigDecimal availableNetAmountForExemption;

        private TreasuryExemptionMoneyBox(BigDecimal maximumNetAmountForExemption, BigDecimal availableNetAmountForExemption) {
            this.maximumNetAmountForExemption = maximumNetAmountForExemption;
            this.availableNetAmountForExemption = availableNetAmountForExemption;
        }

        private void addToAvailableNetAmountForExemption(BigDecimal netAmount) {
            this.availableNetAmountForExemption = this.availableNetAmountForExemption.add(netAmount);
            this.availableNetAmountForExemption = this.availableNetAmountForExemption.min(this.maximumNetAmountForExemption);
        }

        private void subtractFromCurrentNetAmount(BigDecimal netAmount) {
            this.availableNetAmountForExemption = this.availableNetAmountForExemption.subtract(netAmount);
            this.availableNetAmountForExemption = this.availableNetAmountForExemption.max(BigDecimal.ZERO);
        }

        private TreasuryExemptionMoneyBox mergeBySumming(TreasuryExemptionMoneyBox o) {
            return new TreasuryExemptionMoneyBox(this.maximumNetAmountForExemption.add(o.maximumNetAmountForExemption), this.availableNetAmountForExemption.add(o.availableNetAmountForExemption));
        }

        private TreasuryExemptionMoneyBox mergeByChoosingTheGreaterMaximumAmount(TreasuryExemptionMoneyBox o) {
            if (TreasuryConstants.isGreaterOrEqualThan((BigDecimal)o.maximumNetAmountForExemption, (BigDecimal)this.maximumNetAmountForExemption)) {
                return o;
            }
            return this;
        }

        private boolean isAvailableNetAmountForExemptionPositive() {
            return TreasuryConstants.isPositive((BigDecimal)this.availableNetAmountForExemption);
        }

        private static TreasuryExemptionMoneyBox zero() {
            return new TreasuryExemptionMoneyBox(BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    class InstallmentRecalculationOptions {
        Map<Product, LocalDate> recalculateInstallments;

        InstallmentRecalculationOptions() {
            this.recalculateInstallments = null;
        }

        InstallmentRecalculationOptions(Map<Product, LocalDate> recalculateInstallments) {
            this.recalculateInstallments = recalculateInstallments;
        }
    }

    public class InstallmentOptions {
        Set<Product> installments = null;
        boolean forceInstallmentsEvenTreasuryEventIsCharged = false;

        InstallmentOptions() {
        }

        InstallmentOptions(Set<Product> installments) {
            this.installments = installments;
        }

        public InstallmentOptions forceInstallmentsEvenTreasuryEventIsCharged(boolean value) {
            this.forceInstallmentsEvenTreasuryEventIsCharged = value;
            return this;
        }

        public RegistrationTuitionService withoutInstallmentsRecalculation() {
            RegistrationTuitionService.this.installmentRecalculationOptions = new InstallmentRecalculationOptions();
            return RegistrationTuitionService.this;
        }

        public RegistrationTuitionService recalculateInstallments(Map<Product, LocalDate> recalculateInstallments) {
            RegistrationTuitionService.this.installmentRecalculationOptions = new InstallmentRecalculationOptions(recalculateInstallments);
            return RegistrationTuitionService.this;
        }
    }

    public class TuitionOptions {
        TuitionPaymentPlan tuitionPaymentPlan = null;
        boolean forceCreationIfNotEnrolled = false;
        boolean applyTuitionServiceExtensions = true;

        TuitionOptions() {
            RegistrationTuitionService.this.tuitionOptions = this;
        }

        TuitionOptions(TuitionPaymentPlan tuitionPaymentPlan) {
            this.tuitionPaymentPlan = tuitionPaymentPlan;
            RegistrationTuitionService.this.tuitionOptions = this;
        }

        public TuitionOptions discardTuitionServiceExtensions(boolean value) {
            this.applyTuitionServiceExtensions = value;
            return this;
        }

        public TuitionOptions forceCreationIfNotEnrolled(boolean value) {
            this.forceCreationIfNotEnrolled = value;
            return this;
        }

        public InstallmentOptions withAllInstallments() {
            RegistrationTuitionService.this.installmentOptions = new InstallmentOptions();
            return RegistrationTuitionService.this.installmentOptions;
        }

        public InstallmentOptions restrictForInstallmentProducts(Set<Product> installmentProducts) {
            RegistrationTuitionService.this.installmentOptions = new InstallmentOptions(installmentProducts);
            return RegistrationTuitionService.this.installmentOptions;
        }
    }

    public class RegistrationOptions {
        Registration registration;
        ExecutionYear executionYear;
        LocalDate debtDate;
        boolean useDefaultEnrolledEctsCredits = false;
        BigDecimal enrolledEctsUnits;
        BigDecimal enrolledCoursesCount;
        boolean applyDefaultEnrolmentCredits = false;

        RegistrationOptions(Registration registration, ExecutionYear executionYear, LocalDate debtDate) {
            this.registration = registration;
            this.executionYear = executionYear;
            this.debtDate = debtDate;
            RegistrationTuitionService.this.registrationOptions = this;
        }

        public RegistrationOptions useDefaultEnrolledEctsCredits(boolean value) {
            this.useDefaultEnrolledEctsCredits = value;
            return this;
        }

        public RegistrationOptions applyEnrolledEctsUnits(BigDecimal enrolledEctsUnits) {
            this.enrolledEctsUnits = enrolledEctsUnits;
            return this;
        }

        public RegistrationOptions applyEnrolledCoursesCount(BigDecimal enrolledCoursesCount) {
            this.enrolledCoursesCount = enrolledCoursesCount;
            return this;
        }

        public RegistrationOptions applyDefaultEnrolmentCredits(boolean value) {
            this.applyDefaultEnrolmentCredits = value;
            return this;
        }

        public TuitionOptions withTuitionPaymentPlan(TuitionPaymentPlan tuitionPaymentPlan) {
            return new TuitionOptions(tuitionPaymentPlan);
        }

        public TuitionOptions withInferedTuitionPaymentPlan() {
            return new TuitionOptions();
        }
    }
}

