/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.AbstractReportEntryBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class AcademicActBlockingSuspensionReportEntryBean
extends AbstractReportEntryBean {
    public static String[] SPREADSHEET_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.versioningCreator", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.identificationType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.identificationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.email", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.address", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.addressCountryCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.beginDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.endDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicActBlockingSuspensionReportEntryBean.header.reason", new String[0])};
    private String identification;
    private String versioningCreator;
    private DateTime creationDate;
    private String name;
    private String identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String email;
    private String address;
    private String addressCountryCode;
    private Integer studentNumber;
    private LocalDate beginDate;
    private LocalDate endDate;
    private String reason;
    private AcademicActBlockingSuspension academicActBlockingSuspension;
    boolean completed = false;

    public AcademicActBlockingSuspensionReportEntryBean(AcademicActBlockingSuspension academicActBlockingSuspension, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        this.academicActBlockingSuspension = academicActBlockingSuspension;
        try {
            this.identification = academicActBlockingSuspension.getExternalId();
            this.versioningCreator = treasuryServices.versioningCreatorUsername((Object)academicActBlockingSuspension);
            this.creationDate = treasuryServices.versioningCreationDate((Object)academicActBlockingSuspension);
            Person person = academicActBlockingSuspension.getPerson();
            this.name = person.getName();
            if (academicActBlockingSuspension.getPerson().getIdDocumentType() != null) {
                this.identificationType = academicActBlockingSuspension.getPerson().getIdDocumentType().getLocalizedName();
            }
            this.identificationNumber = PersonCustomer.identificationNumber(person);
            this.vatNumber = PersonCustomer.uiPersonFiscalNumber(person);
            this.email = academicActBlockingSuspension.getPerson().getInstitutionalOrDefaultEmailAddressValue();
            this.address = PersonCustomer.physicalAddress(person) != null ? PersonCustomer.physicalAddress(person).getAddress() : "";
            String string = this.addressCountryCode = PersonCustomer.physicalAddress(person) != null && PersonCustomer.physicalAddress(person).getCountryOfResidence() != null ? PersonCustomer.physicalAddress(person).getCountryOfResidence().getCode() : "";
            if (academicActBlockingSuspension.getPerson().getStudent() != null) {
                this.studentNumber = academicActBlockingSuspension.getPerson().getStudent().getNumber();
            }
            this.beginDate = academicActBlockingSuspension.getBeginDate();
            this.endDate = academicActBlockingSuspension.getEndDate();
            this.reason = academicActBlockingSuspension.getReason();
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(academicActBlockingSuspension, e);
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.versioningCreator));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.name));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.email));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.address));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.addressCountryCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.studentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.beginDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.endDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.reason));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.academicActBlockingSuspension, e);
        }
    }
}

