/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition;

import java.util.Comparator;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionAnnotation;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule_Base;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import pt.ist.fenixframework.FenixFramework;

public abstract class TuitionConditionRule
extends TuitionConditionRule_Base {
    public static final Comparator<TuitionConditionRule> COMPARE_BY_CONDITION_RULE_NAME = (o1, o2) -> TuitionConditionRule.getPresentationName(((Object)o1).getClass()).compareTo(TuitionConditionRule.getPresentationName(((Object)o2).getClass()));

    public TuitionConditionRule() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public abstract boolean containsRule(TuitionConditionRule var1);

    public boolean isValidTo(Registration registration, ExecutionYear executionYear) {
        return this.isValidTo(registration, executionYear, null);
    }

    public String getPresentationName() {
        return TuitionConditionRule.getPresentationName(((Object)((Object)this)).getClass());
    }

    public abstract boolean checkRules();

    public String getDescription() {
        throw new IllegalArgumentException("description not implemented");
    }

    public abstract void delete();

    public abstract boolean isValidTo(Registration var1, ExecutionYear var2, Enrolment var3);

    protected abstract String getBundle();

    public static String getPresentationName(Class<? extends TuitionConditionRule> tuitionConditionRule) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundle(tuitionConditionRule.getAnnotation(TuitionConditionAnnotation.class).value(), tuitionConditionRule.getName(), new String[0]);
    }

    public String i18n(String key, String ... args) {
        return TreasuryPlataformDependentServicesFactory.implementation().bundle(this.getBundle(), key, args);
    }

    public TuitionConditionRule copyToPlan(TuitionPaymentPlan tuitionPaymentPlan) {
        TuitionConditionRule result = this.duplicate();
        result.setTuitionPaymentPlan(tuitionPaymentPlan);
        return result;
    }

    public abstract void fillRuleFromImporter(TuitionPaymentPlanBean var1);

    public abstract TuitionConditionRule duplicate();
}

