/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.strategies.massive;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.IMassiveDebtGenerationStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFile;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRequestFileBean;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationRowResult;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.academictreasury.util.ExcelUtils;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import pt.ist.fenixframework.FenixFramework;

public class AnullDebitEntriesStrategy
implements IMassiveDebtGenerationStrategy<MassiveDebtGenerationRowResult> {
    private static final int MAX_COLS = 6;
    private static final int DEBIT_ENTRY_ID_IDX = 0;
    private static final int DEBIT_ENTRY_DESC_IDX = 1;
    private static final int CUSTOMER_NAME_IDX = 2;
    private static final int ANNUL_OTHER_ENTRIES_IN_DEBIT_NOTE_IDX = 3;
    private static final int ANNUL_IN_CLOSED_DEBIT_NOTE_IDX = 4;
    private static final int ANNUL_WITH_SETTLEMENT_IDX = 5;
    public static final Locale LOCALE_PT = new Locale("PT");
    public static final Locale LOCALE_EN = new Locale("EN");

    @Override
    public void checkRules(MassiveDebtGenerationRequestFile file) {
        if (Strings.isNullOrEmpty((String)file.getReason())) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.reason.required", new String[0]);
        }
    }

    @Override
    public String dataDescription(MassiveDebtGenerationRequestFile file) {
        return AcademicTreasuryConstants.academicTreasuryBundle("label.AnullDebitEntriesStrategy.dataDescription", file.getReason());
    }

    @Override
    public void process(MassiveDebtGenerationRequestFile file) {
        List<MassiveDebtGenerationRowResult> rows = this.readExcel(file.getContent(), new MassiveDebtGenerationRequestFileBean(file));
        for (MassiveDebtGenerationRowResult row : rows) {
            try {
                if (row.getDebitEntry().isAnnulled()) continue;
                if (row.getDebitEntry().getFinantialDocument() != null) {
                    ((DebitNote)row.getDebitEntry().getFinantialDocument()).anullDebitNoteWithCreditNote(AcademicTreasuryConstants.academicTreasuryBundle("label.AnullDebitEntriesStrategy.anull.message", file.getReason()), false);
                    continue;
                }
                row.getDebitEntry().annulDebitEntry(AcademicTreasuryConstants.academicTreasuryBundle("label.AnullDebitEntriesStrategy.anull.message", file.getReason()));
            }
            catch (Exception e) {
                throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.on.anull.debit.entry", new String[]{String.valueOf(row.getRowNum()), e.getLocalizedMessage()});
            }
        }
    }

    @Override
    public List<MassiveDebtGenerationRowResult> readExcel(byte[] content, MassiveDebtGenerationRequestFileBean bean) {
        if (Strings.isNullOrEmpty((String)bean.getReason())) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequestFile.reason.required", new String[0]);
        }
        try {
            List<List<String>> data = ExcelUtils.readExcel(new ByteArrayInputStream(content), 6);
            ArrayList result = Lists.newArrayList();
            int rowNum = 0;
            for (List<String> row : data) {
                boolean annulWithSettlements;
                boolean annullInClosedDebitNote;
                boolean annullOtherEntriesInDebitNote;
                if (++rowNum == 1) continue;
                String debitEntryOidValue = this.trim(row.get(0));
                String debitEntryDescriptionValue = this.trim(row.get(1));
                String customerNameValue = this.trim(row.get(2));
                String annullOtherEntriesInDebitNoteValue = this.trim(row.get(3));
                String annullInClosedDebitNoteValue = this.trim(row.get(4));
                String annulWithSettlementsValue = this.trim(row.get(5));
                if (Strings.isNullOrEmpty((String)debitEntryOidValue)) continue;
                DebitEntry debitEntry = null;
                try {
                    debitEntry = (DebitEntry)FenixFramework.getDomainObject((String)debitEntryOidValue);
                }
                catch (Exception e) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.debitEntry.invalid", new String[]{String.valueOf(rowNum), debitEntryOidValue});
                }
                if (debitEntry == null) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.debitEntry.invalid", new String[]{String.valueOf(rowNum), debitEntryOidValue});
                }
                if (!debitEntry.getDescription().trim().equals(debitEntryDescriptionValue)) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.debitEntryDescription.invalid", new String[]{String.valueOf(rowNum), debitEntryDescriptionValue, debitEntry.getDescription().trim()});
                }
                if (!debitEntry.getDebtAccount().getCustomer().getName().trim().equals(customerNameValue)) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.customerName.invalid", new String[]{String.valueOf(rowNum), customerNameValue, debitEntry.getDebtAccount().getCustomer().getName().trim()});
                }
                if (debitEntry.isAnnulled()) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.debitEntry.already.annuled", String.valueOf(rowNum));
                }
                if (!this.isYes(annullOtherEntriesInDebitNoteValue) && !this.isNo(annullOtherEntriesInDebitNoteValue)) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.annullOtherEntriesInDebitNoteValue.invalid", new String[]{String.valueOf(rowNum), annullOtherEntriesInDebitNoteValue});
                }
                boolean bl = annullOtherEntriesInDebitNote = this.isYes(annullOtherEntriesInDebitNoteValue);
                if (!annullOtherEntriesInDebitNote && debitEntry.isProcessedInDebitNote() && debitEntry.getFinantialDocument().getFinantialDocumentEntriesSet().size() > 1) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.debitEntry.in.debit.note.with.other.debit.entries", new String[]{String.valueOf(rowNum), debitEntry.getFinantialDocument().getUiDocumentNumber()});
                }
                if (!this.isYes(annullInClosedDebitNoteValue) && !this.isNo(annullInClosedDebitNoteValue)) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.annullInClosedDebitNote.invalid", new String[]{String.valueOf(rowNum), annullInClosedDebitNoteValue});
                }
                boolean bl2 = annullInClosedDebitNote = this.isYes(annullInClosedDebitNoteValue);
                if (!annullInClosedDebitNote && debitEntry.isProcessedInClosedDebitNote()) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.debitEntry.closed.in.debit.note", new String[]{String.valueOf(rowNum), debitEntry.getFinantialDocument().getUiDocumentNumber()});
                }
                if (!this.isYes(annulWithSettlementsValue) && !this.isNo(annulWithSettlementsValue)) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.annulWithSettlementsValue.invalid", new String[]{String.valueOf(rowNum), annulWithSettlementsValue});
                }
                boolean bl3 = annulWithSettlements = this.isYes(annulWithSettlementsValue);
                if (!annulWithSettlements && debitEntry.getSettlementEntriesSet().stream().filter(s -> !s.isAnnulled()).count() > 0L) {
                    throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.debit.entry.with.settlements", new String[]{String.valueOf(rowNum), annulWithSettlementsValue});
                }
                result.add(new MassiveDebtGenerationRowResult(rowNum, debitEntry));
            }
            if (result.isEmpty()) {
                throw new AcademicTreasuryDomainException("error.AnullDebitEntriesStrategy.result.empty", new String[0]);
            }
            return result;
        }
        catch (IOException e) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationRequest.invalid.sheet", new String[0]);
        }
    }

    @Override
    public boolean isDebtDateRequired() {
        return false;
    }

    @Override
    public boolean isExecutionYearRequired() {
        return false;
    }

    @Override
    public boolean isForAcademicTaxRequired() {
        return false;
    }

    @Override
    public boolean isReasonRequired() {
        return true;
    }

    @Override
    public boolean isFinantialInstitutionRequired() {
        return false;
    }

    @Override
    public String viewUrl() {
        return "/WEB-INF/academicTreasury/debtGeneration/strategies/massive/AnullDebitEntriesStrategy.jsp";
    }

    private boolean isYes(String value) {
        LocalizedString ls = AcademicTreasuryConstants.academicTreasuryBundleI18N("label.true", new String[0]);
        String pt = ls.getContent(LOCALE_PT);
        String en = ls.getContent(LOCALE_EN);
        return pt.equalsIgnoreCase(value) || en.equalsIgnoreCase(value);
    }

    private boolean isNo(String value) {
        LocalizedString ls = AcademicTreasuryConstants.academicTreasuryBundleI18N("label.false", new String[0]);
        String pt = ls.getContent(LOCALE_PT);
        String en = ls.getContent(LOCALE_EN);
        return pt.equalsIgnoreCase(value) || en.equalsIgnoreCase(value);
    }

    private String trim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }
}

