/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.restrictions;

import java.util.Set;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.IDebtGenerationRuleRestrictionStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreatePaymentReferencesStrategy;
import org.fenixedu.treasury.domain.document.DebitEntry;

public class DebtsWithNoPaymentCodeReferences
implements IDebtGenerationRuleRestrictionStrategy {
    @Override
    public boolean isToApply(AcademicDebtGenerationRule rule, Registration registration) {
        Set<DebitEntry> debitEntries = CreatePaymentReferencesStrategy.grabDebitEntries(rule, registration);
        for (DebitEntry debitEntry : debitEntries) {
            if (debitEntry.getSibsPaymentRequests().stream().filter(p -> !p.isInAnnuledState()).count() <= 0L) continue;
            return false;
        }
        return true;
    }
}

