/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.requests;

import com.google.common.base.Strings;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.IMassiveDebtGenerationStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.requests.MassiveDebtGenerationType_Base;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import pt.ist.fenixframework.FenixFramework;

public class MassiveDebtGenerationType
extends MassiveDebtGenerationType_Base {
    public MassiveDebtGenerationType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public MassiveDebtGenerationType(String name, String implementationClass) {
        this();
        this.setName(name);
        this.setImplementationClass(implementationClass);
        this.setActive(false);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationType.bennu.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getName())) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationType.name.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getImplementationClass())) {
            throw new AcademicTreasuryDomainException("error.MassiveDebtGenerationType.implementationClass.required", new String[0]);
        }
        this.implementation();
    }

    public boolean isActive() {
        return this.getActive();
    }

    public boolean isExecutionRequired() {
        return this.implementation().isExecutionYearRequired();
    }

    public boolean isForAcademicTaxRequired() {
        return this.implementation().isForAcademicTaxRequired();
    }

    public boolean isDebtDateRequired() {
        return this.implementation().isDebtDateRequired();
    }

    public boolean isReasonRequired() {
        return this.implementation().isReasonRequired();
    }

    public boolean isFinantialInstitutionRequired() {
        return this.implementation().isFinantialInstitutionRequired();
    }

    public IMassiveDebtGenerationStrategy implementation() {
        try {
            Class<?> clazz = Class.forName(this.getImplementationClass());
            return (IMassiveDebtGenerationStrategy)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<MassiveDebtGenerationType> findAll() {
        return FenixFramework.getDomainRoot().getMassiveDebtGenerationTypesSet().stream();
    }

    public static Stream<MassiveDebtGenerationType> findByClassName(String className) {
        return MassiveDebtGenerationType.findAll().filter(t -> t.getImplementationClass().equals(className));
    }

    public static Stream<MassiveDebtGenerationType> findAllActive() {
        return MassiveDebtGenerationType.findAll().filter(m -> m.isActive());
    }

    public static MassiveDebtGenerationType create(String name, String implementationClass) {
        return new MassiveDebtGenerationType(name, implementationClass);
    }
}

