/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration;

import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleType_Base;
import org.fenixedu.academictreasury.domain.debtGeneration.IAcademicDebtGenerationRuleStrategy;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import pt.ist.fenixframework.FenixFramework;

public class AcademicDebtGenerationRuleType
extends AcademicDebtGenerationRuleType_Base {
    public static Comparator<AcademicDebtGenerationRuleType> COMPARE_BY_ORDER_NUMBER = new Comparator<AcademicDebtGenerationRuleType>(){

        @Override
        public int compare(AcademicDebtGenerationRuleType o1, AcademicDebtGenerationRuleType o2) {
            int c = Integer.compare(o1.getOrderNumber(), o2.getOrderNumber());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };

    protected AcademicDebtGenerationRuleType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public AcademicDebtGenerationRuleType(String code, String name, String strategyImplementation, int orderNumber) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setStrategyImplementation(strategyImplementation);
        this.setOrderNumber(orderNumber);
        this.checkRules();
    }

    private void checkRules() {
        if (Strings.isNullOrEmpty((String)this.getCode())) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleType.code.required", new String[0]);
        }
        if (AcademicDebtGenerationRuleType.findByCodeIgnoresCase(this.getCode()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleType.code.already.exists", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getName())) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleType.name.required", new String[0]);
        }
        this.strategyImplementation();
        if (AcademicDebtGenerationRuleType.findAll().filter(i -> i.getOrderNumber() == this.getOrderNumber()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleType.orderNumber.already.exists", new String[0]);
        }
        if (AcademicDebtGenerationRuleType.findAll().filter(l -> l.getStrategyImplementation().equals(this.getStrategyImplementation())).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRuleType.strategyImplementation.already.exists", new String[0]);
        }
    }

    public IAcademicDebtGenerationRuleStrategy strategyImplementation() {
        try {
            return (IAcademicDebtGenerationRuleStrategy)Class.forName(this.getStrategyImplementation()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<AcademicDebtGenerationRuleType> findAll() {
        return FenixFramework.getDomainRoot().getAcademicDebtGenerationRuleTypesSet().stream();
    }

    public static Optional<AcademicDebtGenerationRuleType> findByCode(String code) {
        return AcademicDebtGenerationRuleType.findAll().filter(l -> l.getCode().equals(code)).findAny();
    }

    private static Stream<AcademicDebtGenerationRuleType> findByCodeIgnoresCase(String code) {
        return AcademicDebtGenerationRuleType.findAll().filter(l -> l.getCode().toLowerCase().equals(code.toLowerCase()));
    }

    public static AcademicDebtGenerationRuleType create(String code, String name, String strategyImplementation, int orderNumber) {
        return new AcademicDebtGenerationRuleType(code, name, strategyImplementation, orderNumber);
    }
}

