/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.fenixedu.academictreasury.util.ExcelSheet;

public class ExcelUtils {
    public static List<List<String>> readExcel(InputStream stream, int maxCols) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook(stream);
        XSSFSheet sheet = wb.getSheetAt(0);
        if (sheet == null) {
            throw new RuntimeException("error.ExcelUploadComponent.invalid.spreadsheet");
        }
        ArrayList<List<String>> spreadsheetContent = new ArrayList<List<String>>();
        for (int i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
            XSSFRow row = sheet.getRow(i);
            ArrayList<String> rowContent = new ArrayList<String>();
            spreadsheetContent.add(rowContent);
            if (row == null) {
                for (int j = 0; j < maxCols; ++j) {
                    rowContent.add("");
                }
                continue;
            }
            for (int j = 0; j < maxCols; ++j) {
                XSSFCell cell = row.getCell(j);
                if (cell == null) {
                    rowContent.add("");
                    continue;
                }
                if (0 == cell.getCellType() && DateUtil.isCellDateFormatted((Cell)cell)) {
                    rowContent.add(new SimpleDateFormat("dd/MM/yyyy HH:mm").format(cell.getDateCellValue()));
                    continue;
                }
                cell.setCellType(1);
                String value = cell.getStringCellValue();
                rowContent.add(value);
            }
        }
        return spreadsheetContent;
    }

    public static List<ExcelSheet> readExcelSheets(InputStream stream, int maxCols) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook(stream);
        ArrayList result = Lists.newArrayList();
        for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
            XSSFSheet sheet = wb.getSheetAt(k);
            if (sheet == null) {
                throw new RuntimeException("error.ExcelUploadComponent.invalid.spreadsheet");
            }
            ArrayList<List<String>> spreadsheetContent = new ArrayList<List<String>>();
            for (int i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
                XSSFRow row = sheet.getRow(i);
                ArrayList<String> rowContent = new ArrayList<String>();
                spreadsheetContent.add(rowContent);
                if (row == null) {
                    for (int j = 0; j < maxCols; ++j) {
                        rowContent.add("");
                    }
                    continue;
                }
                for (int j = 0; j < maxCols; ++j) {
                    XSSFCell cell = row.getCell(j);
                    if (cell == null) {
                        rowContent.add("");
                        continue;
                    }
                    if (0 == cell.getCellType() && DateUtil.isCellDateFormatted((Cell)cell)) {
                        rowContent.add(new SimpleDateFormat("dd/MM/yyyy HH:mm").format(cell.getDateCellValue()));
                        continue;
                    }
                    cell.setCellType(1);
                    String value = cell.getStringCellValue();
                    rowContent.add(value);
                }
            }
            result.add(new ExcelSheet(sheet.getSheetName(), spreadsheetContent));
        }
        return result;
    }
}

