/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.joda.time.LocalDate;

public interface IAcademicTreasuryPlatformDependentServices {
    public Set<DegreeType> readAllDegreeTypes();

    public Set<DegreeCurricularPlan> readAllDegreeCurricularPlansSet();

    public Set<DegreeCurricularPlan> readDegreeCurricularPlansWithExecutionDegree(ExecutionYear var1, DegreeType var2);

    public Set<CurricularYear> readAllCurricularYearsSet();

    public Set<IngressionType> readAllIngressionTypesSet();

    public Set<RegistrationProtocol> readAllRegistrationProtocol();

    public Set<StatuteType> readAllStatuteTypesSet();

    public Set<StatuteType> readAllStatuteTypesSet(boolean var1);

    public Set<Registration> readAllRegistrations(RegistrationProtocol var1);

    public Set<Registration> readAllRegistrations(IngressionType var1);

    public Set<Person> readAllPersonsSet();

    public PersonCustomer personCustomer(Person var1);

    public Set<PersonCustomer> inactivePersonCustomers(Person var1);

    public PhysicalAddress fiscalAddress(Person var1);

    public String iban(Person var1);

    public Set<AcademicTreasuryEvent> academicTreasuryEventsSet(Person var1);

    public String defaultPhoneNumber(Person var1);

    public String defaultMobilePhoneNumber(Person var1);

    public List<PhysicalAddress> pendingOrValidPhysicalAddresses(Person var1);

    public List<? extends PartyContact> pendingOrValidPartyContacts(Person var1, Class<? extends PartyContact> var2);

    public void editSocialSecurityNumber(Person var1, String var2, PhysicalAddress var3);

    public void setFiscalAddress(PhysicalAddress var1, boolean var2);

    public PhysicalAddress createPhysicalAddress(Person var1, Country var2, String var3, String var4, String var5, String var6);

    public String fiscalCountry(Person var1);

    public String fiscalNumber(Person var1);

    @Deprecated
    public boolean isFrontOfficeMember(String var1, FinantialEntity var2);

    @Deprecated
    public boolean isBackOfficeMember(String var1, FinantialEntity var2);

    @Deprecated
    public boolean isAllowToModifySettlements(String var1, FinantialEntity var2);

    @Deprecated
    public boolean isAllowToModifyInvoices(String var1, FinantialEntity var2);

    public Set<Degree> readDegrees(FinantialEntity var1);

    public FinantialEntity finantialEntityOfDegree(Degree var1, LocalDate var2);

    @Deprecated
    public Optional<FinantialEntity> finantialEntity(AdministrativeOffice var1);

    public Optional<FinantialEntity> finantialEntity(Unit var1);

    @Deprecated
    public Set<String> getFrontOfficeMemberUsernames(FinantialEntity var1);

    @Deprecated
    public Set<String> getBackOfficeMemberUsernames(FinantialEntity var1);

    public String localizedNameOfDegreeType(DegreeType var1);

    public String localizedNameOfDegreeType(DegreeType var1, Locale var2);

    public String localizedNameOfStatuteType(StatuteType var1);

    public String localizedNameOfStatuteType(StatuteType var1, Locale var2);

    public String localizedNameOfEnrolment(Enrolment var1);

    public String localizedNameOfEnrolment(Enrolment var1, Locale var2);

    public String localizedNameOfAdministrativeOffice(AdministrativeOffice var1);

    public String localizedNameOfAdministrativeOffice(AdministrativeOffice var1, Locale var2);

    public RegistrationDataByExecutionYear findRegistrationDataByExecutionYear(Registration var1, ExecutionYear var2);

    public IngressionType ingression(Registration var1);

    public RegistrationProtocol registrationProtocol(Registration var1);

    public RegistrationRegimeType registrationRegimeType(Registration var1, ExecutionYear var2);

    public Set<StatuteType> statutesTypesValidOnAnyExecutionSemesterFor(Registration var1, ExecutionInterval var2);

    public Stream<AdministrativeOffice> findAdministrativeOfficesByPredicate(Predicate<AdministrativeOffice> var1);

    public ExecutionInterval executionSemester(Enrolment var1);

    public ExecutionInterval executionSemester(EnrolmentEvaluation var1);

    public ExecutionYear executionYearOfExecutionSemester(ExecutionInterval var1);

    public Integer executionIntervalChildOrder(ExecutionInterval var1);

    public ExecutionInterval getExecutionIntervalByName(String var1);
}

