/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.conditionRule;

import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionAnnotation;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.StatuteTypeConditionRule_Base;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;

@TuitionConditionAnnotation(value="resources.AcademicTreasuryResources")
public class StatuteTypeConditionRule
extends StatuteTypeConditionRule_Base {
    public static Comparator<StatuteType> STATUTE_TYPE_COMPARATOR_BY_NAME = (o1, o2) -> {
        IAcademicTreasuryPlatformDependentServices services = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        int c = services.localizedNameOfStatuteType((StatuteType)o1).compareTo(services.localizedNameOfStatuteType((StatuteType)o2));
        return c != 0 ? c : DomainObjectUtil.COMPARATOR_BY_ID.compare(o1, o2);
    };
    public static final String BUNDLE_NAME = "resources.AcademicTreasuryResources";

    public boolean containsRule(TuitionConditionRule tuitionConditionRule) {
        if (!(tuitionConditionRule instanceof StatuteTypeConditionRule)) {
            return false;
        }
        StatuteTypeConditionRule rule = (StatuteTypeConditionRule)((Object)tuitionConditionRule);
        return this.getStatuteTypeSet().containsAll(rule.getStatuteTypeSet());
    }

    public boolean isValidTo(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        Set<StatuteType> statutesTypesValidOnAnyExecutionSemesterFor = academicTreasuryServices.statutesTypesValidOnAnyExecutionSemesterFor(registration, (ExecutionInterval)executionYear);
        return this.getStatuteTypeSet().stream().anyMatch(statute -> statutesTypesValidOnAnyExecutionSemesterFor.contains(statute));
    }

    public boolean checkRules() {
        if (this.getStatuteTypeSet() == null || this.getStatuteTypeSet().isEmpty()) {
            throw new DomainException(this.i18n("org.fenixedu.academictreasury.domain.tuition.conditionRule.StatuteTypeConditionRule.statuteTypeSet.cannotBeEmpty", new String[0]), new String[0]);
        }
        return true;
    }

    public String getDescription() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        return this.getStatuteTypeSet().stream().sorted(STATUTE_TYPE_COMPARATOR_BY_NAME).map(c -> academicTreasuryServices.localizedNameOfStatuteType((StatuteType)c)).collect(Collectors.joining(", "));
    }

    protected String getBundle() {
        return BUNDLE_NAME;
    }

    public void delete() {
        this.getStatuteTypeSet().clear();
        this.setTuitionPaymentPlan(null);
        this.setTuitionPaymentPlanCalculator(null);
        this.setDomainRoot(null);
        this.deleteDomainObject();
    }

    public TuitionConditionRule duplicate() {
        StatuteTypeConditionRule result = new StatuteTypeConditionRule();
        this.getStatuteTypeSet().forEach(c -> result.addStatuteType((StatuteType)c));
        return result;
    }

    public void fillRuleFromImporter(TuitionPaymentPlanBean bean) {
        String[] split;
        String string = bean.getImporterRules().get(((Object)((Object)this)).getClass());
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        for (String s : split = string.split("\\|")) {
            StatuteType value = academicTreasuryServices.readAllStatuteTypesSet().stream().filter(statute -> academicTreasuryServices.localizedNameOfStatuteType((StatuteType)statute).equals(s)).findFirst().orElse(null);
            if (value == null) {
                throw new AcademicTreasuryDomainException("error.StatuteTypeConditionRule.statute.invalid", s);
            }
            this.addStatuteType(value);
        }
    }
}

