/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tuition.conditionRule;

import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionAnnotation;
import org.fenixedu.academictreasury.domain.tuition.TuitionConditionRule;
import org.fenixedu.academictreasury.domain.tuition.conditionRule.RegistrationProtocolConditionRule_Base;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;

@TuitionConditionAnnotation(value="resources.AcademicTreasuryResources")
public class RegistrationProtocolConditionRule
extends RegistrationProtocolConditionRule_Base {
    public static final Comparator<RegistrationProtocol> REGISTRATION_PROTOCOL_COMPARATOR = (o1, o2) -> {
        int c = o1.getCode().compareTo(o2.getCode());
        return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare(o1, o2) : c;
    };
    public static final String BUNDLE_NAME = "resources.AcademicTreasuryResources";

    public boolean containsRule(TuitionConditionRule tuitionConditionRule) {
        if (!(tuitionConditionRule instanceof RegistrationProtocolConditionRule)) {
            return false;
        }
        RegistrationProtocolConditionRule rule = (RegistrationProtocolConditionRule)((Object)tuitionConditionRule);
        return this.getRegistrationProtocolSet().containsAll(rule.getRegistrationProtocolSet());
    }

    public boolean isValidTo(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        IAcademicTreasuryPlatformDependentServices implementation = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        return this.getRegistrationProtocolSet().contains(implementation.registrationProtocol(registration));
    }

    public boolean checkRules() {
        if (this.getRegistrationProtocolSet() == null || this.getRegistrationProtocolSet().isEmpty()) {
            throw new DomainException(this.i18n("org.fenixedu.academictreasury.domain.tuition.conditionRule.RegistrationProtocolConditionRule.registrationProtocolSet.cannotBeEmpty", new String[0]), new String[0]);
        }
        return true;
    }

    public String getDescription() {
        return this.getRegistrationProtocolSet().stream().sorted(REGISTRATION_PROTOCOL_COMPARATOR).map(c -> c.getDescription().getContent()).collect(Collectors.joining(", "));
    }

    protected String getBundle() {
        return BUNDLE_NAME;
    }

    public void delete() {
        this.getRegistrationProtocolSet().clear();
        this.setTuitionPaymentPlan(null);
        this.setTuitionPaymentPlanCalculator(null);
        this.setDomainRoot(null);
        this.deleteDomainObject();
    }

    public TuitionConditionRule duplicate() {
        RegistrationProtocolConditionRule result = new RegistrationProtocolConditionRule();
        this.getRegistrationProtocolSet().forEach(c -> result.addRegistrationProtocol((RegistrationProtocol)c));
        return result;
    }

    public void fillRuleFromImporter(TuitionPaymentPlanBean bean) {
        String[] split;
        String string = bean.getImporterRules().get(((Object)((Object)this)).getClass());
        Function<String, RegistrationProtocol> func = description -> AcademicTreasuryPlataformDependentServicesFactory.implementation().readAllRegistrationProtocol().stream().filter(p -> description.equals(p.getDescription().getContent())).findFirst().orElse(null);
        for (String s : split = string.split("\\|")) {
            RegistrationProtocol value = func.apply(s);
            if (value == null) {
                throw new AcademicTreasuryDomainException("error.RegistrationProtocolConditionRule.registrationProtocol.invalid", s);
            }
            this.addRegistrationProtocol(value);
        }
    }
}

