/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.strategies;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationProcessingResult;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry_Base;
import org.fenixedu.academictreasury.domain.debtGeneration.IAcademicDebtGenerationRuleStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreateDebtsStrategy$callable$process;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreateDebtsStrategy$callable$process$1;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreateDebtsStrategy$callable$processDebtsForRegistration;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateDebtsStrategy
implements IAcademicDebtGenerationRuleStrategy {
    private static final LocalDate FROM_DATE_TO_CONSIDER_TOTALLY_EXEMPTED_AMOUNTS;
    private static Logger logger;
    public static final Advice advice$process;
    public static final Advice advice$process$1;
    public static final Advice advice$processDebtsForRegistration;

    @Override
    public boolean isAppliedOnTuitionDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnAcademicTaxDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnOtherDebitEntries() {
        return false;
    }

    @Override
    public boolean isToCreateDebitEntries() {
        return true;
    }

    @Override
    public boolean isToAggregateDebitEntries() {
        return true;
    }

    @Override
    public boolean isToCloseDebitNote() {
        return false;
    }

    @Override
    public boolean isToCreatePaymentReferenceCodes() {
        return false;
    }

    @Override
    public boolean isEntriesRequired() {
        return true;
    }

    @Override
    public boolean isToAlignAcademicTaxesDueDate() {
        return false;
    }

    @Override
    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule academicDebtGenerationRule) {
        return (List)advice$process.perform((Callable)new CreateDebtsStrategy$callable$process(this, academicDebtGenerationRule));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$process(CreateDebtsStrategy this_, AcademicDebtGenerationRule rule) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        ArrayList resultList = Lists.newArrayList();
        for (DegreeCurricularPlan degreeCurricularPlan : rule.getDegreeCurricularPlansSet()) {
            for (Registration registration : degreeCurricularPlan.getRegistrations()) {
                if (this_.isToDiscard(rule, registration)) continue;
                AcademicDebtGenerationProcessingResult result = new AcademicDebtGenerationProcessingResult(rule, registration);
                resultList.add(result);
                try {
                    this_.processDebtsForRegistration(rule, registration);
                    result.markProcessingEndDateTime();
                }
                catch (AcademicTreasuryDomainException e) {
                    result.markException(e);
                    logger.debug(e.getMessage());
                }
                catch (Exception e) {
                    result.markException(e);
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }

    @Override
    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        return (List)advice$process$1.perform((Callable)new CreateDebtsStrategy$callable$process$1(this, academicDebtGenerationRule, registration));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$process(CreateDebtsStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        AcademicDebtGenerationProcessingResult result = new AcademicDebtGenerationProcessingResult(rule, registration);
        try {
            if (this_.isToDiscard(rule, registration)) {
                return Lists.newArrayList();
            }
            this_.processDebtsForRegistration(rule, registration);
            result.markProcessingEndDateTime();
        }
        catch (AcademicTreasuryDomainException e) {
            result.markException(e);
            logger.debug(e.getMessage());
        }
        catch (Exception e) {
            result.markException(e);
            e.printStackTrace();
        }
        return Lists.newArrayList((Object[])new AcademicDebtGenerationProcessingResult[]{result});
    }

    private boolean isToDiscard(AcademicDebtGenerationRule rule, Registration registration) {
        if (!rule.isRuleToApply(registration)) {
            return true;
        }
        ExecutionYear year = rule.getExecutionYear();
        StudentCurricularPlan scp = registration.getStudentCurricularPlan(year);
        if (scp == null) {
            return true;
        }
        if (!rule.getDegreeCurricularPlansSet().contains(scp.getDegreeCurricularPlan())) {
            return true;
        }
        if (!registration.hasAnyActiveState(year)) {
            return true;
        }
        return registration.getRegistrationDataByExecutionYearSet().stream().noneMatch(i -> i.getExecutionYear() == year) && !this.isRuleWithOneEntryForcingCreation(rule);
    }

    private boolean isRuleWithOneEntryForcingCreation(AcademicDebtGenerationRule rule) {
        return rule.isWithAtLeastOneForceCreationEntry();
    }

    private void processDebtsForRegistration(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        Object object = advice$processDebtsForRegistration.perform((Callable)new CreateDebtsStrategy$callable$processDebtsForRegistration(this, academicDebtGenerationRule, registration));
    }

    static /* synthetic */ void advised$processDebtsForRegistration(CreateDebtsStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        HashSet debitEntries = Sets.newHashSet();
        DebitEntry grabbedDebitEntry = null;
        for (AcademicDebtGenerationRuleEntry academicDebtGenerationRuleEntry : rule.getOrderedAcademicDebtGenerationRuleEntries()) {
            Product product = academicDebtGenerationRuleEntry.getProduct();
            if (AcademicTreasurySettings.getInstance().getTuitionProductGroup() == product.getProductGroup()) {
                grabbedDebitEntry = this_.grabOrCreateDebitEntryForTuition(rule, registration, academicDebtGenerationRuleEntry);
            } else if (AcademicTax.findUnique(product).isPresent()) {
                grabbedDebitEntry = this_.grabOrCreateDebitEntryForAcademicTax(rule, registration, academicDebtGenerationRuleEntry);
            }
            if (grabbedDebitEntry == null) continue;
            debitEntries.add(grabbedDebitEntry);
        }
        if (debitEntries.isEmpty()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.empty.debitEntries.to.process", new String[0]);
        }
        if (!rule.isAggregateOnDebitNote()) {
            return;
        }
        Map<DebtAccount, DebitNote> debitNotesMap = this_.grabPreparingOrCreateDebitNotes(debitEntries);
        for (DebitEntry debitEntry : debitEntries) {
            if (debitEntry.getFinantialDocument() == null) {
                DebitNote debitNote = debitNotesMap.get(debitEntry.getPayorDebtAccount() != null ? debitEntry.getPayorDebtAccount() : debitEntry.getDebtAccount());
                debitEntry.addToFinantialDocument((FinantialDocument)debitNote);
            }
            if (debitEntry.getDebtAccount() == debitEntry.getFinantialDocument().getDebtAccount()) continue;
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debitEntry.debtAccount.not.equal.to.debitNote.debtAccount", new String[0]);
        }
        for (DebitNote debitNote : debitNotesMap.values()) {
            if (!debitNote.getFinantialDocumentEntriesSet().isEmpty()) continue;
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debit.note.without.debit.entries", new String[0]);
        }
        if (rule.isAggregateAllOrNothing()) {
            for (DebitEntry debitEntry : debitEntries) {
                if (debitNotesMap.containsValue(debitEntry.getFinantialDocument())) continue;
                throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debit.entries.not.aggregated.on.same.debit.note", new String[0]);
            }
            for (Product product : rule.getAcademicDebtGenerationRuleEntriesSet().stream().map(AcademicDebtGenerationRuleEntry_Base::getProduct).collect(Collectors.toSet())) {
                if (!debitNotesMap.values().stream().flatMap(d -> d.getDebitEntriesSet().stream()).noneMatch(de -> de.getProduct() == product)) continue;
                throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debit.entries.not.aggregated.on.same.debit.note", new String[0]);
            }
        }
        if (rule.isEventDebitEntriesMustEqualRuleProducts()) {
            TreasuryEvent treasuryEvent = ((DebitEntry)debitEntries.iterator().next()).getTreasuryEvent();
            for (DebitEntry db : debitEntries) {
                if (db.getTreasuryEvent() != treasuryEvent) {
                    throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debitEntry.not.from.same.academic.event", new String[0]);
                }
                Product interestProduct = TreasurySettings.getInstance().getInterestProduct();
                Set treasuryEventDebitEntries = DebitEntry.findActive((TreasuryEvent)treasuryEvent).filter(d -> d.getProduct() != interestProduct).collect(Collectors.toSet());
                if (treasuryEventDebitEntries.equals(debitEntries)) continue;
                throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.all.debitEntries.aggregated", new String[0]);
            }
        }
    }

    private DebitEntry grabOrCreateDebitEntryForAcademicTax(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        IAcademicTreasuryPlatformDependentServices services;
        PersonCustomer customer;
        AcademicTax academicTax;
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax = AcademicTax.findUnique(product).get());
        if (t == null || !t.isChargedWithDebitEntry()) {
            if (!entry.isCreateDebt()) {
                return null;
            }
            boolean forceCreation = entry.isCreateDebt() && entry.isForceCreation() && registration.getLastRegistrationState(executionYear) != null && registration.getLastRegistrationState(executionYear).isActive() && (!entry.isLimitToRegisteredOnExecutionYear() || registration.isFirstTime(rule.getExecutionYear()));
            AcademicTaxServices.createAcademicTaxForEnrolmentDateAndDefaultFinantialEntity(registration, executionYear, academicTax, forceCreation);
        }
        if ((customer = (services = AcademicTreasuryPlataformDependentServicesFactory.implementation()).personCustomer(registration.getPerson())) == null) {
            return null;
        }
        AcademicTreasuryEvent t2 = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax);
        if (t2 != null && t2.isChargedWithDebitEntry()) {
            return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t2).filter(d -> d.isInDebt()).findFirst().orElse(null);
        }
        return null;
    }

    private DebitEntry grabOrCreateDebitEntryForTuition(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear);
        if (t == null || !t.isChargedWithDebitEntry(product)) {
            boolean forceCreation;
            if (!entry.isCreateDebt()) {
                return null;
            }
            boolean isRegistrationToPayGratuities = TuitionServices.isToPayRegistrationTuition(registration, rule.getExecutionYear());
            boolean bl = forceCreation = entry.isCreateDebt() && entry.isForceCreation() && isRegistrationToPayGratuities && registration.getLastRegistrationState(executionYear) != null && registration.getLastRegistrationState(executionYear).isActive() && (!entry.isLimitToRegisteredOnExecutionYear() || registration.isFirstTime(rule.getExecutionYear()));
            if (entry.isToCreateAfterLastRegistrationStateDate()) {
                LocalDate lastRegisteredStateDate = TuitionServices.lastRegisteredDate(registration, executionYear);
                if (lastRegisteredStateDate == null) {
                    return null;
                }
                if (lastRegisteredStateDate.isAfter((ReadablePartial)new LocalDate())) {
                    return null;
                }
                TuitionServices.createInferedTuitionForRegistration(registration, executionYear, lastRegisteredStateDate, forceCreation);
            } else {
                LocalDate enrolmentDate = TuitionServices.enrolmentDate(registration, executionYear, forceCreation);
                TuitionServices.createInferedTuitionForRegistration(registration, executionYear, enrolmentDate, forceCreation);
            }
        }
        if (TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear) == null) {
            return null;
        }
        t = TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear);
        if (!t.isChargedWithDebitEntry(product)) {
            return null;
        }
        IAcademicTreasuryPlatformDependentServices services = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        PersonCustomer customer = services.personCustomer(registration.getPerson());
        if (customer == null) {
            return null;
        }
        return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t, product).filter(d -> {
            if (d.isInDebt()) {
                return true;
            }
            LocalDate debitEntryCreationDate = TreasuryPlataformDependentServicesFactory.implementation().versioningCreationDate(d).toLocalDate();
            if (!FROM_DATE_TO_CONSIDER_TOTALLY_EXEMPTED_AMOUNTS.isAfter((ReadablePartial)debitEntryCreationDate)) {
                return d.isTotallyExempted();
            }
            return false;
        }).findFirst().orElse(null);
    }

    private Map<DebtAccount, DebitNote> grabPreparingOrCreateDebitNotes(Set<DebitEntry> debitEntries) {
        HashMap<DebtAccount, DebitNote> result = new HashMap<DebtAccount, DebitNote>();
        for (DebitEntry debitEntry : debitEntries) {
            DebtAccount debtAccountOwnerOfDebitNote;
            if (debitEntry.getFinantialDocument() != null && debitEntry.getFinantialDocument().isPreparing()) {
                DebitNote debitNote = (DebitNote)debitEntry.getFinantialDocument();
                DebtAccount ownerDebtAccount = debitNote.getPayorDebtAccount() != null ? debitNote.getPayorDebtAccount() : debitNote.getDebtAccount();
                result.put(ownerDebtAccount, debitNote);
                continue;
            }
            if (debitEntry.getFinantialDocument() != null || result.get(debtAccountOwnerOfDebitNote = debitEntry.getPayorDebtAccount() != null ? debitEntry.getPayorDebtAccount() : debitEntry.getDebtAccount()) != null) continue;
            DocumentNumberSeries documentNumberSeries = (DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)debtAccountOwnerOfDebitNote.getFinantialInstitution()).get();
            DebitNote debitNote = DebitNote.create((DebtAccount)debitEntry.getDebtAccount(), (DocumentNumberSeries)documentNumberSeries, (DateTime)new DateTime());
            if (debtAccountOwnerOfDebitNote != debitEntry.getDebtAccount()) {
                debitNote.updatePayorDebtAccount(debtAccountOwnerOfDebitNote);
            }
            result.put(debtAccountOwnerOfDebitNote, debitNote);
        }
        if (!result.values().stream().allMatch(d -> d.isPreparing())) {
            throw new RuntimeException("error.CreateDebtsStrategy.grabPreparingOrCreateDebitNotes.debitNote.preparing.state.failed");
        }
        return result;
    }

    static {
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$process$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$processDebtsForRegistration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        FROM_DATE_TO_CONSIDER_TOTALLY_EXEMPTED_AMOUNTS = new LocalDate(2023, 1, 30);
        logger = LoggerFactory.getLogger(CreateDebtsStrategy.class);
    }
}

