/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.listeners.DebitEntryDeletionListener;
import org.fenixedu.academictreasury.domain.listeners.FinantialEntityListener;
import org.fenixedu.academictreasury.domain.listeners.ProductDeletionListener;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import pt.ist.fenixframework.FenixFramework;

@WebListener
public class AcademicTreasuryInitializer
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public void contextInitialized(ServletContextEvent arg0) {
        DebitEntryDeletionListener.attach();
        ProductDeletionListener.attach();
        FinantialEntityListener.attach();
        this.addDeletionListeners();
    }

    private void addDeletionListeners() {
        FenixFramework.getDomainModel().registerDeletionListener(Person.class, p -> {
            if (this.academicTreasuryServices().personCustomer((Person)p) != null) {
                this.academicTreasuryServices().personCustomer((Person)p).delete();
            }
            this.academicTreasuryServices().inactivePersonCustomers((Person)p).forEach(ipc -> ipc.delete());
        });
    }

    private IAcademicTreasuryPlatformDependentServices academicTreasuryServices() {
        return AcademicTreasuryPlataformDependentServicesFactory.implementation();
    }
}

