/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import com.google.common.base.Strings;
import com.qubit.terra.framework.tools.excel.ExcelUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.DebtReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.IFinantialReportEntryCommonMethods;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class SettlementReportEntryBean
implements SpreadsheetRow,
IFinantialReportEntryCommonMethods {
    public static String[] SPREADSHEET_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.responsible", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementNoteNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementNoteDocumentDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.paymentDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementNoteAnnuled", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.documentExportationPending", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementEntryOrder", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.amount", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.productCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementEntryDescription", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceEntryIdentification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceEntryType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceEntryAmountToPay", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceDocumentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.debtAccountId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.identificationType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.identificationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.email", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.personalEmail", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.address", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.closeDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.degreeType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.degreeCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.degreeName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.executionYear", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.documentObservations", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SettlementReportEntryBean.header.termsAndConditions", new String[0])};
    private SettlementEntry settlementEntry;
    private SettlementNote settlementNote;
    private boolean completed;
    private String identification;
    private DateTime creationDate;
    private String responsible;
    private String invoiceEntryIdentification;
    private String invoiceEntryType;
    private String invoiceDocumentNumber;
    private String settlementNoteNumber;
    private DateTime settlementNoteDocumentDate;
    private DateTime paymentDate;
    private Boolean settlementNoteAnnuled;
    private Boolean documentExportationPending;
    private Integer settlementEntryOrder;
    private BigDecimal invoiceEntryAmountToPay;
    private BigDecimal netExemptedAmount;
    private BigDecimal openAmountToPay;
    private BigDecimal amount;
    private String productCode;
    private String settlementEntryDescription;
    private String customerId;
    private String debtAccountId;
    private String name;
    private String identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String institutionalOrDefaultEmail;
    private String emailForSendingEmails;
    private String personalEmail;
    private String address;
    private Integer studentNumber;
    private Integer registrationNumber;
    private String degreeType;
    private String degreeCode;
    private String degreeName;
    private String executionYear;
    private String executionSemester;
    private LocalizedString agreement;
    private LocalizedString ingression;
    private Boolean firstTimeStudent;
    private Boolean partialRegime;
    private String statutes;
    private Integer numberOfNormalEnrolments;
    private Integer numberOfStandaloneEnrolments;
    private Integer numberOfExtracurricularEnrolments;
    private String tuitionPaymentPlan;
    private String tuitionPaymentPlanConditions;
    private DateTime closeDate;
    private Boolean exportedInLegacyERP;
    private LocalDate erpCertificationDate;
    private String erpCertificateDocumentReference;
    private String erpCustomerId;
    private String erpPayorCustomerId;
    private String invoiceEntryCertifiedDocumentNumber;
    private LocalDate invoiceEntryCertifiedDocumentDate;
    private String settlementNoteCertifiedDocumentNumber;
    private LocalDate settlementNoteCertifiedDocumentDate;
    private String decimalSeparator;
    private String documentObservations;
    private String documentTermsAndConditions;
    private String finantialEntityCode;
    private LocalizedString finantialEntityName;

    public SettlementReportEntryBean(SettlementEntry entry, DebtReportRequest request, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        this.decimalSeparator = request != null ? request.getDecimalSeparator() : ".";
        this.settlementEntry = entry;
        this.settlementNote = (SettlementNote)entry.getFinantialDocument();
        try {
            this.identification = entry.getExternalId();
            this.creationDate = treasuryServices.versioningCreationDate((Object)entry);
            this.responsible = treasuryServices.versioningCreatorUsername((Object)entry);
            this.invoiceEntryIdentification = entry.getInvoiceEntry().getExternalId();
            this.settlementNoteNumber = this.settlementNote.getUiDocumentNumber();
            this.settlementNoteDocumentDate = this.settlementNote.getDocumentDate();
            this.paymentDate = this.settlementNote.getPaymentDate();
            this.settlementNoteAnnuled = this.settlementNote.isAnnulled();
            this.documentExportationPending = this.settlementNote.isDocumentToExport();
            this.invoiceEntryType = this.entryType(entry.getInvoiceEntry());
            this.invoiceDocumentNumber = entry.getInvoiceEntry().getFinantialDocument().getUiDocumentNumber();
            this.settlementEntryOrder = entry.getEntryOrder();
            this.invoiceEntryAmountToPay = entry.getInvoiceEntry().getAmountWithVat();
            this.netExemptedAmount = entry.getInvoiceEntry().isDebitNoteEntry() ? ((DebitEntry)entry.getInvoiceEntry()).getNetExemptedAmount() : BigDecimal.ZERO;
            this.openAmountToPay = entry.getInvoiceEntry().getOpenAmount();
            this.amount = entry.getTotalAmount();
            this.productCode = entry.getInvoiceEntry().getProduct().getCode();
            this.settlementEntryDescription = entry.getDescription();
            this.documentObservations = this.settlementNote.getDocumentObservations();
            this.documentTermsAndConditions = this.settlementNote.getDocumentTermsAndConditions();
            this.fillStudentInformation(entry);
            this.fillAcademicInformation(entry.getInvoiceEntry());
            if (entry.getInvoiceEntry().getFinantialEntity() != null) {
                this.finantialEntityCode = entry.getInvoiceEntry().getFinantialEntity().getCode();
                this.finantialEntityName = entry.getInvoiceEntry().getFinantialEntity().getName();
            }
            this.fillERPInformation(entry);
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(entry, e);
        }
    }

    private void fillERPInformation(SettlementEntry entry) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        this.closeDate = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getCloseDate() : null;
        this.exportedInLegacyERP = entry.getFinantialDocument() != null ? entry.getFinantialDocument().isExportedInLegacyERP() : false;
        this.erpCertificationDate = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getErpCertificationDate() : null;
        this.erpCertificateDocumentReference = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getErpCertificateDocumentReference() : null;
        this.erpCustomerId = entry.getFinantialDocument().getDebtAccount().getCustomer().getErpCustomerId();
        if (entry.getInvoiceEntry().getFinantialDocument() != null && ((Invoice)entry.getInvoiceEntry().getFinantialDocument()).getPayorDebtAccount() != null) {
            this.erpPayorCustomerId = ((Invoice)entry.getInvoiceEntry().getFinantialDocument()).getPayorDebtAccount().getCustomer().getErpCustomerId();
        }
        if (treasuryServices.hasCertifiedDocument((FinantialDocument)entry.getSettlementNote())) {
            this.settlementNoteCertifiedDocumentNumber = treasuryServices.getCertifiedDocumentNumber((FinantialDocument)entry.getSettlementNote());
            this.settlementNoteCertifiedDocumentDate = treasuryServices.getCertifiedDocumentDate((FinantialDocument)entry.getSettlementNote());
        }
        if (entry.getInvoiceEntry().getFinantialDocument() != null && treasuryServices.hasCertifiedDocument(entry.getInvoiceEntry().getFinantialDocument())) {
            this.invoiceEntryCertifiedDocumentNumber = treasuryServices.getCertifiedDocumentNumber(entry.getInvoiceEntry().getFinantialDocument());
            this.invoiceEntryCertifiedDocumentDate = treasuryServices.getCertifiedDocumentDate(entry.getInvoiceEntry().getFinantialDocument());
        }
    }

    private IAcademicTreasuryPlatformDependentServices academicTreasuryServices() {
        return AcademicTreasuryPlataformDependentServicesFactory.implementation();
    }

    private void fillStudentInformation(SettlementEntry entry) {
        Customer customer = entry.getFinantialDocument().getDebtAccount().getCustomer();
        this.customerId = customer.getExternalId();
        this.debtAccountId = entry.getFinantialDocument().getDebtAccount().getExternalId();
        this.name = customer.getName();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null && ((PersonCustomer)customer).getAssociatedPerson().getIdDocumentType() != null) {
            this.identificationType = ((PersonCustomer)customer).getAssociatedPerson().getIdDocumentType().getLocalizedName();
        }
        this.identificationNumber = customer.getIdentificationNumber();
        this.vatNumber = customer.getUiFiscalNumber();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null) {
            Person person = ((PersonCustomer)customer).getAssociatedPerson();
            this.institutionalOrDefaultEmail = person.getInstitutionalOrDefaultEmailAddressValue();
            this.emailForSendingEmails = person.getEmailForSendingEmails();
            this.personalEmail = DebtReportEntryBean.personalEmail(person) != null ? DebtReportEntryBean.personalEmail(person).getValue() : "";
        }
        this.address = customer.getAddress();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null && ((PersonCustomer)customer).getAssociatedPerson().getStudent() != null) {
            this.studentNumber = ((PersonCustomer)customer).getAssociatedPerson().getStudent().getNumber();
        }
    }

    private String entryType(InvoiceEntry entry) {
        if (entry.isDebitNoteEntry()) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.debitNoteEntry", new String[0]);
        }
        if (entry.isCreditNoteEntry()) {
            return AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.creditNoteEntry", new String[0]);
        }
        return null;
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            String value;
            ExcelUtil.createCellWithValue((Row)row, (int)0, (String)this.identification);
            if (!this.completed) {
                ExcelUtil.createCellWithValue((Row)row, (int)1, (String)AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.creationDate));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.responsible));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.settlementNoteNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.settlementNoteDocumentDate));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.paymentDate));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.settlementNoteAnnuled));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.documentExportationPending));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.settlementEntryOrder));
            String string = value = this.amount != null ? this.amount.toString() : "";
            if (",".equals(this.decimalSeparator)) {
                value = value.replace(".", ",");
            }
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(value));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.productCode));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.settlementEntryDescription));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.invoiceEntryIdentification));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.invoiceEntryType));
            String string2 = value = this.invoiceEntryAmountToPay != null ? this.invoiceEntryAmountToPay.toString() : "";
            if (",".equals(this.decimalSeparator)) {
                value = value.replace(".", ",");
            }
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(value));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.invoiceDocumentNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.customerId);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.debtAccountId);
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.name));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.identificationType));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.identificationNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.vatNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.institutionalOrDefaultEmail));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.personalEmail));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.address));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.studentNumber));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.closeDate));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeType));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeCode));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.degreeName));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.executionYear));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.documentObservations));
            ExcelUtil.createCellWithValue((Row)row, (int)i++, (String)this.valueOrEmpty(this.documentTermsAndConditions));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.settlementEntry, e);
        }
    }

    private String valueOrEmpty(DateTime value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd HH:mm:ss");
    }

    private String valueOrEmpty(Boolean value) {
        if (value == null) {
            return "";
        }
        return AcademicTreasuryConstants.academicTreasuryBundle(value != false ? "label.yes" : "label.no", new String[0]);
    }

    private String valueOrEmpty(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String valueOrEmpty(LocalizedString value) {
        if (value == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)value.getContent())) {
            return "";
        }
        return value.getContent();
    }

    private String valueOrEmpty(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return "";
    }

    public DebitEntry getAssociatedDebitEntry() {
        return this.settlementEntry.getInvoiceEntry().isDebitNoteEntry() ? (DebitEntry)this.settlementEntry.getInvoiceEntry() : null;
    }

    public CreditEntry getAssociatedCreditEntry() {
        return this.settlementEntry.getInvoiceEntry().isCreditNoteEntry() ? (CreditEntry)this.settlementEntry.getInvoiceEntry() : null;
    }

    public SibsPaymentRequest getAssociatedSibsPaymentRequest() {
        PaymentTransaction paymentTransaction = this.settlementEntry.getSettlementNote().getPaymentTransaction();
        if (paymentTransaction == null) {
            return null;
        }
        return paymentTransaction.getPaymentRequest() instanceof SibsPaymentRequest ? (SibsPaymentRequest)paymentTransaction.getPaymentRequest() : null;
    }

    public Person getAssociatedPerson() {
        if (!this.settlementEntry.getDebtAccount().getCustomer().isPersonCustomer()) {
            return null;
        }
        PersonCustomer personCustomer = (PersonCustomer)this.settlementEntry.getDebtAccount().getCustomer();
        return personCustomer.getAssociatedPerson();
    }

    public Set<TreasuryExemption> getTreasuryExemptionsSetToPresentCode() {
        if (this.getAssociatedDebitEntry() != null) {
            return this.getAssociatedDebitEntry().getTreasuryExemptionsSet();
        }
        if (this.getAssociatedCreditEntry() != null) {
            return this.getAssociatedCreditEntry().getCreditTreasuryExemptionsSet().stream().map(cte -> cte.getTreasuryExemption()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public Set<TreasuryExemption> getTreasuryExemptionsSetToPresentName() {
        return this.getTreasuryExemptionsSetToPresentCode();
    }

    public SettlementEntry getSettlementEntry() {
        return this.settlementEntry;
    }

    public void setSettlementEntry(SettlementEntry settlementEntry) {
        this.settlementEntry = settlementEntry;
    }

    public SettlementNote getSettlementNote() {
        return this.settlementNote;
    }

    public void setSettlementNote(SettlementNote settlementNote) {
        this.settlementNote = settlementNote;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime creationDate) {
        this.creationDate = creationDate;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public void setResponsible(String responsible) {
        this.responsible = responsible;
    }

    public String getInvoiceEntryIdentification() {
        return this.invoiceEntryIdentification;
    }

    public void setInvoiceEntryIdentification(String invoiceEntryIdentification) {
        this.invoiceEntryIdentification = invoiceEntryIdentification;
    }

    public String getInvoiceEntryType() {
        return this.invoiceEntryType;
    }

    public void setInvoiceEntryType(String invoiceEntryType) {
        this.invoiceEntryType = invoiceEntryType;
    }

    public String getInvoiceDocumentNumber() {
        return this.invoiceDocumentNumber;
    }

    public void setInvoiceDocumentNumber(String invoiceDocumentNumber) {
        this.invoiceDocumentNumber = invoiceDocumentNumber;
    }

    public String getSettlementNoteNumber() {
        return this.settlementNoteNumber;
    }

    public void setSettlementNoteNumber(String settlementNoteNumber) {
        this.settlementNoteNumber = settlementNoteNumber;
    }

    public DateTime getSettlementNoteDocumentDate() {
        return this.settlementNoteDocumentDate;
    }

    public void setSettlementNoteDocumentDate(DateTime settlementNoteDocumentDate) {
        this.settlementNoteDocumentDate = settlementNoteDocumentDate;
    }

    public DateTime getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(DateTime paymentDate) {
        this.paymentDate = paymentDate;
    }

    public boolean getSettlementNoteAnnuled() {
        return this.settlementNoteAnnuled;
    }

    public void setSettlementNoteAnnuled(Boolean settlementNoteAnnuled) {
        this.settlementNoteAnnuled = settlementNoteAnnuled;
    }

    public boolean getDocumentExportationPending() {
        return this.documentExportationPending;
    }

    public void setDocumentExportationPending(Boolean documentExportationPending) {
        this.documentExportationPending = documentExportationPending;
    }

    public Integer getSettlementEntryOrder() {
        return this.settlementEntryOrder;
    }

    public void setSettlementEntryOrder(Integer settlementEntryOrder) {
        this.settlementEntryOrder = settlementEntryOrder;
    }

    public BigDecimal getInvoiceEntryAmountToPay() {
        return this.invoiceEntryAmountToPay;
    }

    public void setInvoiceEntryAmountToPay(BigDecimal invoiceEntryAmountToPay) {
        this.invoiceEntryAmountToPay = invoiceEntryAmountToPay;
    }

    public BigDecimal getNetExemptedAmount() {
        return this.netExemptedAmount;
    }

    public void setNetExemptedAmount(BigDecimal netExemptedAmount) {
        this.netExemptedAmount = netExemptedAmount;
    }

    public BigDecimal getOpenAmountToPay() {
        return this.openAmountToPay;
    }

    public void setOpenAmountToPay(BigDecimal openAmountToPay) {
        this.openAmountToPay = openAmountToPay;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getSettlementEntryDescription() {
        return this.settlementEntryDescription;
    }

    public void setSettlementEntryDescription(String settlementEntryDescription) {
        this.settlementEntryDescription = settlementEntryDescription;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getDebtAccountId() {
        return this.debtAccountId;
    }

    public void setDebtAccountId(String debtAccountId) {
        this.debtAccountId = debtAccountId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(String identificationType) {
        this.identificationType = identificationType;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public String getInstitutionalOrDefaultEmail() {
        return this.institutionalOrDefaultEmail;
    }

    public void setInstitutionalOrDefaultEmailEmail(String institutionalOrDefaultEmail) {
        this.institutionalOrDefaultEmail = institutionalOrDefaultEmail;
    }

    public String getEmailForSendingEmails() {
        return this.emailForSendingEmails;
    }

    public void setEmailForSendingEmails(String emailForSendingEmails) {
        this.emailForSendingEmails = emailForSendingEmails;
    }

    public String getPersonalEmail() {
        return this.personalEmail;
    }

    public void setPersonalEmail(String personalEmail) {
        this.personalEmail = personalEmail;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    @Override
    public Integer getRegistrationNumber() {
        return this.registrationNumber;
    }

    @Override
    public void setRegistrationNumber(Integer registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    @Override
    public String getDegreeType() {
        return this.degreeType;
    }

    @Override
    public void setDegreeType(String degreeType) {
        this.degreeType = degreeType;
    }

    @Override
    public String getDegreeCode() {
        return this.degreeCode;
    }

    @Override
    public void setDegreeCode(String degreeCode) {
        this.degreeCode = degreeCode;
    }

    @Override
    public String getDegreeName() {
        return this.degreeName;
    }

    @Override
    public void setDegreeName(String degreeName) {
        this.degreeName = degreeName;
    }

    @Override
    public String getExecutionYear() {
        return this.executionYear;
    }

    @Override
    public void setExecutionYear(String executionYear) {
        this.executionYear = executionYear;
    }

    @Override
    public String getExecutionSemester() {
        return this.executionSemester;
    }

    @Override
    public void setExecutionSemester(String executionSemester) {
        this.executionSemester = executionSemester;
    }

    public DateTime getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(DateTime closeDate) {
        this.closeDate = closeDate;
    }

    public Boolean getExportedInLegacyERP() {
        return this.exportedInLegacyERP;
    }

    public void setExportedInLegacyERP(Boolean exportedInLegacyERP) {
        this.exportedInLegacyERP = exportedInLegacyERP;
    }

    public LocalDate getErpCertificationDate() {
        return this.erpCertificationDate;
    }

    public void setErpCertificationDate(LocalDate erpCertificationDate) {
        this.erpCertificationDate = erpCertificationDate;
    }

    public String getErpCertificateDocumentReference() {
        return this.erpCertificateDocumentReference;
    }

    public void setErpCertificateDocumentReference(String erpCertificateDocumentReference) {
        this.erpCertificateDocumentReference = erpCertificateDocumentReference;
    }

    public String getErpCustomerId() {
        return this.erpCustomerId;
    }

    public void setErpCustomerId(String erpCustomerId) {
        this.erpCustomerId = erpCustomerId;
    }

    public String getErpPayorCustomerId() {
        return this.erpPayorCustomerId;
    }

    public void setErpPayorCustomerId(String erpPayorCustomerId) {
        this.erpPayorCustomerId = erpPayorCustomerId;
    }

    public String getInvoiceEntryCertifiedDocumentNumber() {
        return this.invoiceEntryCertifiedDocumentNumber;
    }

    public void setInvoiceEntryCertifiedDocumentNumber(String invoiceEntryCertifiedDocumentNumber) {
        this.invoiceEntryCertifiedDocumentNumber = invoiceEntryCertifiedDocumentNumber;
    }

    public LocalDate getInvoiceEntryCertifiedDocumentDate() {
        return this.invoiceEntryCertifiedDocumentDate;
    }

    public void setInvoiceEntryCertifiedDocumentDate(LocalDate invoiceEntryCertifiedDocumentDate) {
        this.invoiceEntryCertifiedDocumentDate = invoiceEntryCertifiedDocumentDate;
    }

    public String getSettlementNoteCertifiedDocumentNumber() {
        return this.settlementNoteCertifiedDocumentNumber;
    }

    public void setSettlementNoteCertifiedDocumentNumber(String settlementNoteCertifiedDocumentNumber) {
        this.settlementNoteCertifiedDocumentNumber = settlementNoteCertifiedDocumentNumber;
    }

    public LocalDate getSettlementNoteCertifiedDocumentDate() {
        return this.settlementNoteCertifiedDocumentDate;
    }

    public void setSettlementNoteCertifiedDocumentDate(LocalDate settlementNoteCertifiedDocumentDate) {
        this.settlementNoteCertifiedDocumentDate = settlementNoteCertifiedDocumentDate;
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(String decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public String getDocumentObservations() {
        return this.documentObservations;
    }

    public void setDocumentObservations(String documentObservations) {
        this.documentObservations = documentObservations;
    }

    public String getDocumentTermsAndConditions() {
        return this.documentTermsAndConditions;
    }

    public void setDocumentTermsAndConditions(String documentTermsAndConditions) {
        this.documentTermsAndConditions = documentTermsAndConditions;
    }

    public String getFinantialEntityCode() {
        return this.finantialEntityCode;
    }

    public void setFinantialEntityCode(String finantialEntityCode) {
        this.finantialEntityCode = finantialEntityCode;
    }

    public LocalizedString getFinantialEntityName() {
        return this.finantialEntityName;
    }

    public void setFinantialEntityName(LocalizedString finantialEntityName) {
        this.finantialEntityName = finantialEntityName;
    }

    @Override
    public LocalizedString getAgreement() {
        return this.agreement;
    }

    @Override
    public void setAgreement(LocalizedString agreement) {
        this.agreement = agreement;
    }

    @Override
    public LocalizedString getIngression() {
        return this.ingression;
    }

    @Override
    public void setIngression(LocalizedString ingression) {
        this.ingression = ingression;
    }

    @Override
    public Boolean getFirstTimeStudent() {
        return this.firstTimeStudent;
    }

    @Override
    public void setFirstTimeStudent(Boolean firstTimeStudent) {
        this.firstTimeStudent = firstTimeStudent;
    }

    @Override
    public Boolean getPartialRegime() {
        return this.partialRegime;
    }

    @Override
    public void setPartialRegime(Boolean partialRegime) {
        this.partialRegime = partialRegime;
    }

    @Override
    public String getStatutes() {
        return this.statutes;
    }

    @Override
    public void setStatutes(String statutes) {
        this.statutes = statutes;
    }

    @Override
    public Integer getNumberOfNormalEnrolments() {
        return this.numberOfNormalEnrolments;
    }

    @Override
    public void setNumberOfNormalEnrolments(Integer numberOfNormalEnrolments) {
        this.numberOfNormalEnrolments = numberOfNormalEnrolments;
    }

    @Override
    public Integer getNumberOfStandaloneEnrolments() {
        return this.numberOfStandaloneEnrolments;
    }

    @Override
    public void setNumberOfStandaloneEnrolments(Integer numberOfStandaloneEnrolments) {
        this.numberOfStandaloneEnrolments = numberOfStandaloneEnrolments;
    }

    @Override
    public Integer getNumberOfExtracurricularEnrolments() {
        return this.numberOfExtracurricularEnrolments;
    }

    @Override
    public void setNumberOfExtracurricularEnrolments(Integer numberOfExtracurricularEnrolments) {
        this.numberOfExtracurricularEnrolments = numberOfExtracurricularEnrolments;
    }

    @Override
    public String getTuitionPaymentPlan() {
        return this.tuitionPaymentPlan;
    }

    @Override
    public void setTuitionPaymentPlan(String tuitionPaymentPlan) {
        this.tuitionPaymentPlan = tuitionPaymentPlan;
    }

    @Override
    public String getTuitionPaymentPlanConditions() {
        return this.tuitionPaymentPlanConditions;
    }

    @Override
    public void setTuitionPaymentPlanConditions(String tuitionPaymentPlanConditions) {
        this.tuitionPaymentPlanConditions = tuitionPaymentPlanConditions;
    }
}

