/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.treasury;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.IAcademicServiceRequestAndAcademicTaxTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academic.domain.treasury.IImprovementTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IPaymentCodePool;
import org.fenixedu.academic.domain.treasury.ITreasuryBridgeAPI;
import org.fenixedu.academic.domain.treasury.ITreasuryCustomer;
import org.fenixedu.academic.domain.treasury.ITreasuryDebtAccount;
import org.fenixedu.academic.domain.treasury.ITreasuryEntity;
import org.fenixedu.academic.domain.treasury.ITreasuryProduct;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.treasury.HandleSettlementNotePayment;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.services.PersonServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.FenixFramework;

@Deprecated
public class AcademicTreasuryBridgeImpl
implements ITreasuryBridgeAPI {
    private HandleSettlementNotePayment handleSettlementNotePayment = new HandleSettlementNotePayment();

    public Set<ITreasuryEntity> getTreasuryEntities() {
        return FinantialEntity.findAll().map(f -> new TreasuryEntity((FinantialEntity)f)).collect(Collectors.toSet());
    }

    public ITreasuryEntity getTreasuryEntityByCode(String code) {
        if (FenixFramework.getDomainObject((String)code) == null) {
            throw new AcademicTreasuryDomainException("error.ITreasuryBridgeAPI.finantial.entity.not.found", new String[0]);
        }
        return new TreasuryEntity((FinantialEntity)FenixFramework.getDomainObject((String)code));
    }

    public Set<ITreasuryProduct> getProducts(ITreasuryEntity treasuryEntity) {
        return Product.findAllActive().filter(p -> p.getFinantialInstitutionsSet().contains(((TreasuryEntity)treasuryEntity).finantialEntity.getFinantialInstitution())).map(p -> new AcademicProduct((Product)p)).collect(Collectors.toSet());
    }

    public ITreasuryProduct getProductByCode(String code) {
        return Product.findUniqueByCode((String)code).map(p -> new AcademicProduct((Product)p)).orElse(null);
    }

    public List<IPaymentCodePool> getPaymentCodePools(ITreasuryEntity treasuryEntity) {
        FinantialInstitution finantialInstitution = ((TreasuryEntity)treasuryEntity).finantialEntity.getFinantialInstitution();
        return DigitalPaymentPlatform.findForSibsPaymentCodeServiceByActive((FinantialInstitution)finantialInstitution, (boolean)true).map(p -> new PaymentCodePoolImpl((DigitalPaymentPlatform)p)).collect(Collectors.toList());
    }

    public IPaymentCodePool getPaymentCodePoolByCode(String code) {
        if (FenixFramework.getDomainObject((String)code) == null) {
            throw new AcademicTreasuryDomainException("error.ITreasuryBridgeAPI.paymentCodePool.not.found", new String[0]);
        }
        return new PaymentCodePoolImpl((DigitalPaymentPlatform)FenixFramework.getDomainObject((String)code));
    }

    public IAcademicServiceRequestAndAcademicTaxTreasuryEvent academicTreasuryEventForAcademicServiceRequest(AcademicServiceRequest academicServiceRequest) {
        return AcademicTreasuryPlataformDependentServicesFactory.implementation().academicTreasuryEventsSet(academicServiceRequest.getPerson()).stream().filter(e -> e.getAcademicServiceRequest() == academicServiceRequest).findFirst().orElse(null);
    }

    public void standaloneUnenrolment(Enrolment standaloneEnrolment) {
        TuitionServices.removeDebitEntryForStandaloneEnrolment(standaloneEnrolment);
    }

    public void extracurricularUnenrolment(Enrolment extracurricularEnrolment) {
        TuitionServices.removeDebitEntryForExtracurricularEnrolment(extracurricularEnrolment);
    }

    public IAcademicTreasuryEvent getTuitionForRegistrationTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear);
    }

    public IAcademicTreasuryEvent getTuitionForStandaloneTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return TuitionServices.findAcademicTreasuryEventTuitionForStandalone(registration, executionYear);
    }

    public IAcademicTreasuryEvent getTuitionForExtracurricularTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return null;
    }

    public IAcademicTreasuryEvent getTuitionForImprovementTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear);
    }

    public void improvementUnrenrolment(EnrolmentEvaluation improvementEnrolmentEvaluation) {
        AcademicTaxServices.removeDebitEntryForImprovement(improvementEnrolmentEvaluation);
    }

    public boolean isToPayTuition(Registration registration, ExecutionYear executionYear) {
        return TuitionServices.isToPayRegistrationTuition(registration, executionYear);
    }

    public List<IAcademicTreasuryEvent> getAcademicTaxesList(Registration registration, ExecutionYear executionYear) {
        return AcademicTaxServices.findAllTreasuryEventsForAcademicTaxes(registration, executionYear);
    }

    public IImprovementTreasuryEvent getImprovementTaxTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        if (!AcademicTreasuryEvent.findUniqueForImprovementTuition(registration, executionYear).isPresent()) {
            return null;
        }
        return AcademicTreasuryEvent.findUniqueForImprovementTuition(registration, executionYear).get();
    }

    public IAcademicTreasuryEvent getAcademicTreasuryEventForTarget(IAcademicTreasuryTarget target) {
        Person person = target.getAcademicTreasuryTargetPerson();
        return AcademicTreasuryEvent.findUniqueForTarget(person, target).orElse(null);
    }

    public void anullDebtsForTarget(IAcademicTreasuryTarget target, String reason) {
        IAcademicTreasuryEvent event = this.getAcademicTreasuryEventForTarget(target);
        if (event != null) {
            event.annulDebts(reason);
        }
    }

    private SibsPaymentRequest createPaymentReferenceCode(DigitalPaymentPlatform platform, DebitEntry debitEntry, LocalDate when) {
        return platform.castToSibsPaymentCodePoolService().createSibsPaymentRequest(debitEntry.getDebtAccount(), Collections.singleton(debitEntry), Collections.emptySet());
    }

    public boolean isAcademicalActsBlocked(Person person, LocalDate when) {
        return PersonServices.isAcademicalActsBlocked(person, when);
    }

    public boolean isAcademicalActBlockingSuspended(Person person, LocalDate when) {
        return AcademicActBlockingSuspension.isBlockingSuspended(person, when);
    }

    public List<IAcademicTreasuryEvent> getAllAcademicTreasuryEventsList(Person person) {
        return AcademicTreasuryEvent.find(person).collect(Collectors.toList());
    }

    public String getPersonAccountTreasuryManagementURL(Person person) {
        return AcademicTreasurySettings.getInstance().getAcademicTreasuryAccountUrl().getPersonAccountTreasuryManagementURL(person);
    }

    public boolean isPersonAccountTreasuryManagementAvailable(Person person) {
        String addressCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        return PersonCustomer.findUnique(person, addressCountryCode, fiscalNumber).isPresent();
    }

    public String getRegistrationAccountTreasuryManagementURL(Registration registration) {
        return AcademicTreasurySettings.getInstance().getAcademicTreasuryAccountUrl().getRegistrationAccountTreasuryManagementURL(registration);
    }

    public void createAcademicDebts(Registration registration) {
        AcademicDebtGenerationRule.runAllActiveForRegistration(registration, true);
    }

    @Subscribe
    public void handle(DomainObjectEvent<SettlementNote> settlementNoteEvent) {
        SettlementNote settlementNote = (SettlementNote)settlementNoteEvent.getInstance();
        this.handleSettlementNotePayment.handleObject(settlementNote);
    }

    public boolean isValidFiscalNumber(String fiscalAddressCountryCode, String fiscalNumber) {
        return FiscalCodeValidation.isValidFiscalNumber((String)fiscalAddressCountryCode, (String)fiscalNumber);
    }

    public boolean updateCustomer(Person person, String fiscalCountryCode, String fiscalNumber) {
        return PersonCustomer.switchCustomer(person, fiscalCountryCode, fiscalNumber);
    }

    public boolean createCustomerIfMissing(Person person) {
        String fiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            return false;
        }
        Optional<? extends PersonCustomer> findUnique = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber);
        if (findUnique.isPresent()) {
            return true;
        }
        PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        return true;
    }

    public void saveFiscalAddressFieldsFromPersonInActiveCustomer(Person person) {
        IAcademicTreasuryPlatformDependentServices implementation = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (implementation.personCustomer(person) == null) {
            return;
        }
        implementation.personCustomer(person).saveFiscalAddressFieldsFromPersonInCustomer();
    }

    public PhysicalAddress createSaftDefaultPhysicalAddress(Person person) {
        IAcademicTreasuryPlatformDependentServices implementation = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        String unknownAddress = AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTreasuryBridgeImpl.unknown.address", new String[0]);
        PhysicalAddress result = implementation.createPhysicalAddress(person, Country.readDefault(), unknownAddress, unknownAddress, "0000-000", unknownAddress);
        result.setValid();
        return result;
    }

    public ITreasuryCustomer getActiveCustomer(Person person) {
        PersonCustomer customer = PersonCustomer.findUnique(person, PersonCustomer.addressCountryCode(person), PersonCustomer.fiscalNumber(person)).orElse(null);
        if (customer == null) {
            return null;
        }
        return new TreasuryCustomer(customer);
    }

    public List<ITreasuryCustomer> getCustomersForFiscalNumber(Person person, String fiscalCountry, String fiscalNumber) {
        return PersonCustomer.find(person, fiscalCountry, fiscalNumber).map(pc -> new TreasuryCustomer((PersonCustomer)((Object)pc))).collect(Collectors.toList());
    }

    public ITreasuryDebtAccount getActiveDebtAccountForRegistration(Registration registration) {
        String fiscalNumber;
        String addressCountryCode;
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        Person person = registration.getPerson();
        PersonCustomer customer = PersonCustomer.findUnique(person, addressCountryCode = PersonCustomer.addressCountryCode(person), fiscalNumber = PersonCustomer.fiscalNumber(person)).orElse(null);
        if (customer == null) {
            return null;
        }
        FinantialEntity finantialEntity = academicTreasuryServices.finantialEntityOfDegree(registration.getDegree(), new LocalDate());
        if (finantialEntity == null) {
            return null;
        }
        FinantialInstitution finantialInstitution = finantialEntity.getFinantialInstitution();
        DebtAccount debtAccount = DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)customer).orElse(null);
        if (debtAccount == null) {
            return null;
        }
        return new TreasuryDebtAccount(debtAccount);
    }

    @Deprecated
    public static class TreasuryEntity
    implements ITreasuryEntity {
        private FinantialEntity finantialEntity;

        public TreasuryEntity(FinantialEntity finantialEntity) {
            this.finantialEntity = finantialEntity;
        }

        public String getCode() {
            return this.finantialEntity.getExternalId();
        }

        public String getName() {
            return this.finantialEntity.getName().getContent();
        }

        public int hashCode() {
            return this.finantialEntity.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TreasuryEntity && ((TreasuryEntity)obj).finantialEntity == this.finantialEntity;
        }

        public FinantialEntity getFinantialEntity() {
            return this.finantialEntity;
        }
    }

    @Deprecated
    public static class PaymentCodePoolImpl
    implements IPaymentCodePool {
        private DigitalPaymentPlatform digitalPaymentPlatform;

        public PaymentCodePoolImpl(DigitalPaymentPlatform digitalPaymentPlatform) {
            this.digitalPaymentPlatform = digitalPaymentPlatform;
        }

        public String getCode() {
            return this.digitalPaymentPlatform.getExternalId();
        }

        public String getName() {
            return this.digitalPaymentPlatform.getName();
        }

        public boolean isActive() {
            return this.digitalPaymentPlatform.isActive();
        }

        public int hashCode() {
            return this.digitalPaymentPlatform.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof PaymentCodePoolImpl && ((PaymentCodePoolImpl)obj).digitalPaymentPlatform == this.digitalPaymentPlatform;
        }

        public DigitalPaymentPlatform getDigitalPaymentPlatform() {
            return this.digitalPaymentPlatform;
        }
    }

    @Deprecated
    public static class TreasuryCustomer
    implements ITreasuryCustomer {
        private PersonCustomer personCustomer;

        public TreasuryCustomer(PersonCustomer personCustomer) {
            this.personCustomer = personCustomer;
        }

        @Override
        public String getExternalId() {
            return this.personCustomer.getExternalId();
        }

        @Override
        @Deprecated
        public String getFiscalCountry() {
            return this.personCustomer.getAddressCountryCode();
        }

        @Override
        public String getFiscalNumber() {
            return this.personCustomer.getFiscalNumber();
        }

        @Override
        public String getUiFiscalNumber() {
            return this.personCustomer.getUiFiscalNumber();
        }

        public PersonCustomer getPersonCustomer() {
            return this.personCustomer;
        }
    }

    @Deprecated
    public static class TreasuryDebtAccount
    implements ITreasuryDebtAccount {
        private DebtAccount debtAccount;

        public TreasuryDebtAccount(DebtAccount debtAccount) {
            this.debtAccount = debtAccount;
        }

        @Override
        public String getExternalId() {
            return this.debtAccount.getExternalId();
        }

        public DebtAccount getDebtAccount() {
            return this.debtAccount;
        }
    }

    @Deprecated
    public static class AcademicProduct
    implements ITreasuryProduct {
        private Product product;

        private AcademicProduct(Product product) {
            this.product = product;
        }

        public String getCode() {
            return this.product.getCode();
        }

        public String getName() {
            return this.product.getName().getContent();
        }

        public int hashCode() {
            return this.product.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof AcademicProduct && ((AcademicProduct)obj).product == this.product;
        }

        public Product getProduct() {
            return this.product;
        }
    }
}

