/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.exceptions;

import com.google.gson.JsonObject;
import javax.ws.rs.core.Response;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;

public class AcademicTreasuryDomainException
extends RuntimeException {
    private final String key;
    private final String[] args;
    private final String bundle;
    private final Response.Status status;
    private static final long serialVersionUID = 1L;

    private AcademicTreasuryDomainException(String bundle, String key, String ... args) {
        this(Response.Status.PRECONDITION_FAILED, bundle, key, args);
    }

    private AcademicTreasuryDomainException(Response.Status status, String bundle, String key, String ... args) {
        super(key);
        this.status = status;
        this.bundle = bundle;
        this.key = key;
        this.args = args;
    }

    private AcademicTreasuryDomainException(Throwable cause, String bundle, String key, String ... args) {
        this(cause, Response.Status.INTERNAL_SERVER_ERROR, bundle, key, args);
    }

    private AcademicTreasuryDomainException(Throwable cause, Response.Status status, String bundle, String key, String ... args) {
        super(key, cause);
        this.status = status;
        this.bundle = bundle;
        this.key = key;
        this.args = args;
    }

    @Override
    public String getLocalizedMessage() {
        return TreasuryPlataformDependentServicesFactory.implementation().bundle(this.bundle, this.key, this.args);
    }

    public Response.Status getResponseStatus() {
        return this.status;
    }

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("message", this.getLocalizedMessage());
        return json;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getArgs() {
        return this.args;
    }

    public AcademicTreasuryDomainException(String key, String ... args) {
        this("resources.AcademicTreasuryResources", key, args);
    }

    public AcademicTreasuryDomainException(Response.Status status, String key, String ... args) {
        this(status, "resources.AcademicTreasuryResources", key, args);
    }

    public AcademicTreasuryDomainException(Throwable cause, String key, String ... args) {
        this(cause, "resources.AcademicTreasuryResources", key, args);
    }

    public AcademicTreasuryDomainException(Throwable cause, Response.Status status, String key, String ... args) {
        this(cause, status, "resources.AcademicTreasuryResources", key, args);
    }
}

