/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.strategies;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationProcessingResult;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry;
import org.fenixedu.academictreasury.domain.debtGeneration.IAcademicDebtGenerationRuleStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.AnnulPendingDebtsGenerationRuleStrategy$callable$process;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.AnnulPendingDebtsGenerationRuleStrategy$callable$process$1;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.AnnulPendingDebtsGenerationRuleStrategy$callable$processAnnulmentOfDebtsForRegistration;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreateDebtsStrategy;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AnnulPendingDebtsGenerationRuleStrategy
implements IAcademicDebtGenerationRuleStrategy {
    private static Logger logger;
    public static final Advice advice$process;
    public static final Advice advice$process$1;
    public static final Advice advice$processAnnulmentOfDebtsForRegistration;

    @Override
    public boolean isAppliedOnTuitionDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnAcademicTaxDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnOtherDebitEntries() {
        return false;
    }

    @Override
    public boolean isToCreateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToAggregateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToCloseDebitNote() {
        return false;
    }

    @Override
    public boolean isToCreatePaymentReferenceCodes() {
        return false;
    }

    @Override
    public boolean isEntriesRequired() {
        return true;
    }

    @Override
    public boolean isToAlignAcademicTaxesDueDate() {
        return false;
    }

    @Override
    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule academicDebtGenerationRule) {
        return (List)advice$process.perform((Callable)new AnnulPendingDebtsGenerationRuleStrategy$callable$process(this, academicDebtGenerationRule));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$process(AnnulPendingDebtsGenerationRuleStrategy this_, AcademicDebtGenerationRule rule) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        ArrayList resultList = Lists.newArrayList();
        for (DegreeCurricularPlan degreeCurricularPlan : rule.getDegreeCurricularPlansSet()) {
            for (Registration registration : this_.getRegistrations(degreeCurricularPlan)) {
                if (this_.isToDiscard(rule, registration)) continue;
                AcademicDebtGenerationProcessingResult result = new AcademicDebtGenerationProcessingResult(rule, registration);
                resultList.add(result);
                try {
                    this_.processAnnulmentOfDebtsForRegistration(rule, registration, result);
                    result.markProcessingEndDateTime();
                }
                catch (AcademicTreasuryDomainException e) {
                    result.markException(e);
                    logger.debug(e.getMessage());
                }
                catch (Exception e) {
                    result.markException(e);
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }

    private Set<Registration> getRegistrations(DegreeCurricularPlan degreeCurricularPlan) {
        return degreeCurricularPlan.getStudentCurricularPlansSet().stream().map(s -> s.getRegistration()).collect(Collectors.toSet());
    }

    @Override
    public List<AcademicDebtGenerationProcessingResult> process(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        return (List)advice$process$1.perform((Callable)new AnnulPendingDebtsGenerationRuleStrategy$callable$process$1(this, academicDebtGenerationRule, registration));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$process(AnnulPendingDebtsGenerationRuleStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        AcademicDebtGenerationProcessingResult result = new AcademicDebtGenerationProcessingResult(rule, registration);
        try {
            if (this_.isToDiscard(rule, registration)) {
                return Lists.newArrayList();
            }
            this_.processAnnulmentOfDebtsForRegistration(rule, registration, result);
            result.markProcessingEndDateTime();
        }
        catch (AcademicTreasuryDomainException e) {
            result.markException(e);
            logger.debug(e.getMessage());
        }
        catch (Exception e) {
            result.markException(e);
            e.printStackTrace();
        }
        return Lists.newArrayList((Object[])new AcademicDebtGenerationProcessingResult[]{result});
    }

    private boolean isToDiscard(AcademicDebtGenerationRule rule, Registration registration) {
        if (!rule.isRuleToApply(registration)) {
            return true;
        }
        ExecutionYear year = rule.getExecutionYear();
        StudentCurricularPlan scp = registration.getStudentCurricularPlan(year);
        if (scp == null) {
            return true;
        }
        return !rule.getDegreeCurricularPlansSet().contains(scp.getDegreeCurricularPlan());
    }

    private void processAnnulmentOfDebtsForRegistration(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration, AcademicDebtGenerationProcessingResult academicDebtGenerationProcessingResult) {
        Object object = advice$processAnnulmentOfDebtsForRegistration.perform((Callable)new AnnulPendingDebtsGenerationRuleStrategy$callable$processAnnulmentOfDebtsForRegistration(this, academicDebtGenerationRule, registration, academicDebtGenerationProcessingResult));
    }

    static /* synthetic */ void advised$processAnnulmentOfDebtsForRegistration(AnnulPendingDebtsGenerationRuleStrategy this_, AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationProcessingResult processingResult) {
        LocalDate now = new LocalDate();
        HashSet debitEntries = Sets.newHashSet();
        for (AcademicDebtGenerationRuleEntry entry : rule.getOrderedAcademicDebtGenerationRuleEntries()) {
            registration.getAcademicTreasuryEventSet().stream().filter(te -> te.getExecutionYear() == rule.getExecutionYear()).flatMap(te -> DebitEntry.findActive((TreasuryEvent)te, (Product)entry.getProduct())).filter(de -> de.isInDebt()).filter(de -> de.isDueDateExpired(now)).filter(de -> de.getFinantialDocument() == null || de.getFinantialDocument().isPreparing()).filter(de -> this.allSplittedDebitEntriesArePreparing((DebitEntry)de)).collect(Collectors.toCollection(() -> debitEntries));
        }
        Set productsSet = rule.getAcademicDebtGenerationRuleEntriesSet().stream().map(e -> e.getProduct()).collect(Collectors.toSet());
        if (debitEntries.stream().anyMatch(de -> !productsSet.contains(de.getProduct()))) {
            throw new RuntimeException("error in collecting debit entries to annul, error in product");
        }
        if (debitEntries.stream().anyMatch(de -> !rule.getExecutionYear().getQualifiedName().equals(de.getExecutionYearName()))) {
            throw new RuntimeException("error in collecting debit entries to annul, error in execution year");
        }
        debitEntries.forEach(d -> {
            d.annulOnlyThisDebitEntryAndInterestsInBusinessContext(AcademicTreasuryConstants.academicTreasuryBundle("label.AnnulPendingDebtsGenerationRuleStrategy.annuled.automatically", new String[0]));
            processingResult.markRuleMadeUpdates();
            processingResult.appendRemarks(String.format("\t%s;%s;%s;%s;%s;\"%s\"", d.getExternalId(), d.getDebtAccount().getCustomer().getUiFiscalNumber(), d.getProduct().getCode(), d.getDueDate().toString("yyyy-MM-dd"), d.getTotalAmount().toString(), d.getDescription()));
        });
    }

    private boolean allSplittedDebitEntriesArePreparing(DebitEntry debitEntry) {
        return debitEntry.getAllSplittedDebitEntriesSet().stream().filter(d -> !d.isAnnulled()).allMatch(d -> d.isInDebt() && (d.getFinantialDocument() == null || d.getFinantialDocument().isPreparing()));
    }

    static {
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$process$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$processAnnulmentOfDebtsForRegistration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(CreateDebtsStrategy.class);
    }
}

