/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.academictreasurytarget;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academic.domain.treasury.ITreasuryBridgeAPI;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.InterestRateType;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class AcademicTreasuryTargetCreateDebtBuilder {
    private FinantialEntity finantialEntity;
    private Product product;
    private IAcademicTreasuryTarget target;
    private LocalDate when;
    private boolean createPaymentCode;
    private ISibsPaymentCodePoolService paymentCodePool;

    protected AcademicTreasuryTargetCreateDebtBuilder() {
    }

    private SibsPaymentRequest createPaymentReferenceCode(DebitEntry debitEntry, LocalDate dueDate) {
        return this.paymentCodePool.createSibsPaymentRequest(debitEntry.getDebtAccount(), Collections.singleton(debitEntry), Collections.emptySet());
    }

    public static AcademicTreasuryTargetCreateDebtBuilder createBuilder() {
        return new AcademicTreasuryTargetCreateDebtBuilder();
    }

    public DebtBuilderWithAmountAndDueDate explicitAmountAndDueDate(FinantialEntity finantialEntity, Product product, IAcademicTreasuryTarget target, LocalDate when) {
        DebtBuilderWithAmountAndDueDate result = new DebtBuilderWithAmountAndDueDate();
        result.setFinantialEntity(finantialEntity);
        result.setProduct(product);
        result.setTarget(target);
        result.setWhen(when);
        return result;
    }

    public DebtBuilderWithAcademicTariff useInferedAcademicTariff(FinantialEntity finantialEntity, Product product, IAcademicTreasuryTarget target, LocalDate when) {
        DebtBuilderWithAcademicTariff result = new DebtBuilderWithAcademicTariff();
        result.setFinantialEntity(finantialEntity);
        result.setProduct(product);
        result.setTarget(target);
        result.setWhen(when);
        return result;
    }

    public class DebtBuilderWithAmountAndDueDate {
        private BigDecimal amount;
        private LocalDate dueDate;
        private InterestRateType interestRateType;
        private BigDecimal interestFixedAmount;

        public DebtBuilderWithAmountAndDueDate setAmount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public DebtBuilderWithAmountAndDueDate setWhen(LocalDate when) {
            AcademicTreasuryTargetCreateDebtBuilder.this.when = when;
            return this;
        }

        public DebtBuilderWithAmountAndDueDate setDueDate(LocalDate dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public DebtBuilderWithAmountAndDueDate setCreatePaymentCode(boolean createPaymentCode) {
            AcademicTreasuryTargetCreateDebtBuilder.this.createPaymentCode = createPaymentCode;
            return this;
        }

        public DebtBuilderWithAmountAndDueDate setPaymentCodePool(ISibsPaymentCodePoolService paymentCodePool) {
            AcademicTreasuryTargetCreateDebtBuilder.this.paymentCodePool = paymentCodePool;
            return this;
        }

        public DebtBuilderWithAmountAndDueDate setFinantialEntity(FinantialEntity finantialEntity) {
            AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity = finantialEntity;
            return this;
        }

        public DebtBuilderWithAmountAndDueDate setProduct(Product product) {
            AcademicTreasuryTargetCreateDebtBuilder.this.product = product;
            return this;
        }

        public DebtBuilderWithAmountAndDueDate setTarget(IAcademicTreasuryTarget target) {
            AcademicTreasuryTargetCreateDebtBuilder.this.target = target;
            return this;
        }

        public DebtBuilderWithAmountAndDueDate setInterestRateType(InterestRateType interestRateType) {
            this.interestRateType = interestRateType;
            return this;
        }

        public DebtBuilderWithAmountAndDueDate setInterestFixedAmount(BigDecimal interestFixedAmount) {
            this.interestFixedAmount = interestFixedAmount;
            return this;
        }

        public IAcademicTreasuryEvent createDebt() {
            AcademicTreasuryEvent treasuryEvent;
            DebtAccount debtAccount;
            this.checkParameters();
            ITreasuryBridgeAPI api = TreasuryBridgeAPIFactory.implementation();
            FinantialInstitution finantialInstitution = AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity.getFinantialInstitution();
            DocumentNumberSeries documentNumberSeries = (DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)finantialInstitution).get();
            DateTime now = new DateTime();
            Vat vat = (Vat)Vat.findActiveUnique((VatType)AcademicTreasuryTargetCreateDebtBuilder.this.product.getVatType(), (FinantialInstitution)finantialInstitution, (DateTime)new DateTime()).get();
            Person person = AcademicTreasuryTargetCreateDebtBuilder.this.target.getAcademicTreasuryTargetPerson();
            PersonCustomer personCustomer = AcademicTreasuryPlataformDependentServicesFactory.implementation().personCustomer(person);
            if (personCustomer == null) {
                personCustomer = PersonCustomer.createWithCurrentFiscalInformation(person);
            }
            if ((debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).orElse(null)) == null) {
                debtAccount = DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)personCustomer);
            }
            if ((treasuryEvent = (AcademicTreasuryEvent)api.getAcademicTreasuryEventForTarget(AcademicTreasuryTargetCreateDebtBuilder.this.target)) == null) {
                treasuryEvent = AcademicTreasuryEvent.createForAcademicTreasuryEventTarget(AcademicTreasuryTargetCreateDebtBuilder.this.product, AcademicTreasuryTargetCreateDebtBuilder.this.target);
            }
            DebitNote debitNote = DebitNote.create((FinantialEntity)AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity, (DebtAccount)debtAccount, null, (DocumentNumberSeries)documentNumberSeries, (DateTime)now, (LocalDate)now.toLocalDate(), null, Collections.emptyMap(), null, null);
            DebitEntry debitEntry = DebitEntry.create((FinantialEntity)AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity, (DebtAccount)debtAccount, (TreasuryEvent)treasuryEvent, (Vat)vat, (BigDecimal)this.amount, (LocalDate)this.dueDate, (Map)AcademicTreasuryTargetCreateDebtBuilder.this.target.getAcademicTreasuryTargetPropertiesMap(), (Product)AcademicTreasuryTargetCreateDebtBuilder.this.product, (String)AcademicTreasuryTargetCreateDebtBuilder.this.target.getAcademicTreasuryTargetDescription().getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)BigDecimal.ONE, null, (DateTime)AcademicTreasuryTargetCreateDebtBuilder.this.when.toDateTimeAtStartOfDay(), (boolean)false, (boolean)false, (DebitNote)debitNote);
            if (this.interestRateType != null) {
                InterestRate.createForDebitEntry((DebitEntry)debitEntry, (InterestRateType)this.interestRateType, (int)1, (boolean)false, (int)0, (BigDecimal)this.interestFixedAmount, null);
            }
            if (AcademicTreasuryTargetCreateDebtBuilder.this.createPaymentCode) {
                AcademicTreasuryTargetCreateDebtBuilder.this.createPaymentReferenceCode(debitEntry, this.dueDate);
            }
            return treasuryEvent;
        }

        private void checkParameters() {
            if (AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity == null) {
                throw new IllegalArgumentException("Finantial entity required");
            }
            if (AcademicTreasuryTargetCreateDebtBuilder.this.product == null) {
                throw new IllegalArgumentException("Product required");
            }
            if (AcademicTreasuryTargetCreateDebtBuilder.this.target == null) {
                throw new IllegalArgumentException("AcademicTreasuryTarget required");
            }
            if (this.amount == null) {
                throw new IllegalArgumentException("Amount required");
            }
            if (this.dueDate == null) {
                throw new IllegalArgumentException("Due date required");
            }
            if (AcademicTreasuryTargetCreateDebtBuilder.this.createPaymentCode && AcademicTreasuryTargetCreateDebtBuilder.this.paymentCodePool == null) {
                throw new IllegalArgumentException("Payment code pool required");
            }
        }
    }

    public class DebtBuilderWithAcademicTariff {
        private int numberOfUnits;
        private boolean urgentRequest;
        private boolean applyLanguageRate;

        public DebtBuilderWithAcademicTariff setWhen(LocalDate when) {
            AcademicTreasuryTargetCreateDebtBuilder.this.when = when;
            return this;
        }

        public DebtBuilderWithAcademicTariff setCreatePaymentCode(boolean createPaymentCode) {
            AcademicTreasuryTargetCreateDebtBuilder.this.createPaymentCode = createPaymentCode;
            return this;
        }

        public DebtBuilderWithAcademicTariff setPaymentCodePool(ISibsPaymentCodePoolService paymentCodePool) {
            AcademicTreasuryTargetCreateDebtBuilder.this.paymentCodePool = paymentCodePool;
            return this;
        }

        public DebtBuilderWithAcademicTariff setNumberOfUnits(int numberOfUnits) {
            this.numberOfUnits = numberOfUnits;
            return this;
        }

        public DebtBuilderWithAcademicTariff setUrgentRequest(boolean urgentRequest) {
            this.urgentRequest = urgentRequest;
            return this;
        }

        public DebtBuilderWithAcademicTariff setApplyLanguageRate(boolean applyLanguageRate) {
            this.applyLanguageRate = applyLanguageRate;
            return this;
        }

        public DebtBuilderWithAcademicTariff setFinantialEntity(FinantialEntity finantialEntity) {
            AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity = finantialEntity;
            return this;
        }

        public DebtBuilderWithAcademicTariff setProduct(Product product) {
            AcademicTreasuryTargetCreateDebtBuilder.this.product = product;
            return this;
        }

        public DebtBuilderWithAcademicTariff setTarget(IAcademicTreasuryTarget target) {
            AcademicTreasuryTargetCreateDebtBuilder.this.target = target;
            return this;
        }

        public IAcademicTreasuryEvent createDebt() {
            this.checkParameters();
            ITreasuryBridgeAPI api = TreasuryBridgeAPIFactory.implementation();
            FinantialInstitution finantialInstitution = AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity.getFinantialInstitution();
            DocumentNumberSeries documentNumberSeries = (DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)finantialInstitution).get();
            DateTime now = new DateTime();
            Person person = AcademicTreasuryTargetCreateDebtBuilder.this.target.getAcademicTreasuryTargetPerson();
            PersonCustomer personCustomer = AcademicTreasuryPlataformDependentServicesFactory.implementation().personCustomer(person);
            if (personCustomer == null) {
                personCustomer = PersonCustomer.createWithCurrentFiscalInformation(person);
            }
            DebtAccount debtAccount = DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).orElse(DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)personCustomer));
            AcademicTreasuryEvent treasuryEvent = (AcademicTreasuryEvent)api.getAcademicTreasuryEventForTarget(AcademicTreasuryTargetCreateDebtBuilder.this.target);
            if (treasuryEvent == null) {
                treasuryEvent = AcademicTreasuryEvent.createForAcademicTreasuryEventTarget(AcademicTreasuryTargetCreateDebtBuilder.this.product, AcademicTreasuryTargetCreateDebtBuilder.this.target);
            }
            if (treasuryEvent.isCharged()) {
                return treasuryEvent;
            }
            AcademicTariff academicTariff = null;
            academicTariff = AcademicTreasuryTargetCreateDebtBuilder.this.target.getAcademicTreasuryTargetDegree() != null ? AcademicTariff.findMatch(AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity, AcademicTreasuryTargetCreateDebtBuilder.this.product, AcademicTreasuryTargetCreateDebtBuilder.this.target.getAcademicTreasuryTargetDegree(), AcademicTreasuryTargetCreateDebtBuilder.this.when.toDateTimeAtStartOfDay()) : AcademicTariff.findMatch(AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity, AcademicTreasuryTargetCreateDebtBuilder.this.product, AcademicTreasuryTargetCreateDebtBuilder.this.when.toDateTimeAtStartOfDay());
            if (academicTariff == null) {
                throw new AcademicTreasuryDomainException("error.EmolumentServices.tariff.not.found", AcademicTreasuryTargetCreateDebtBuilder.this.when.toString("yyyy/MM/dd"));
            }
            LocalDate dueDate = academicTariff.dueDate(AcademicTreasuryTargetCreateDebtBuilder.this.when);
            LocalDate effectiveWhen = AcademicTreasuryTargetCreateDebtBuilder.this.when;
            if (DueDateCalculationType.FIXED_DATE == academicTariff.getDueDateCalculationType() && dueDate.isBefore((ReadablePartial)AcademicTreasuryTargetCreateDebtBuilder.this.when)) {
                effectiveWhen = dueDate;
            }
            Vat vat = (Vat)Vat.findActiveUnique((VatType)AcademicTreasuryTargetCreateDebtBuilder.this.product.getVatType(), (FinantialInstitution)finantialInstitution, (DateTime)effectiveWhen.toDateTimeAtStartOfDay()).get();
            DebitNote debitNote = DebitNote.create((FinantialEntity)AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity, (DebtAccount)debtAccount, null, (DocumentNumberSeries)documentNumberSeries, (DateTime)now, (LocalDate)now.toLocalDate(), null, Collections.emptyMap(), null, null);
            BigDecimal amount = academicTariff.amountToPay(this.numberOfUnits, 0, this.applyLanguageRate, this.urgentRequest);
            DebitEntry debitEntry = DebitEntry.create((FinantialEntity)AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity, (DebtAccount)debtAccount, (TreasuryEvent)treasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, (Map)AcademicTreasuryTargetCreateDebtBuilder.this.target.getAcademicTreasuryTargetPropertiesMap(), (Product)AcademicTreasuryTargetCreateDebtBuilder.this.product, (String)AcademicTreasuryTargetCreateDebtBuilder.this.target.getAcademicTreasuryTargetDescription().getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)BigDecimal.ONE, (InterestRate)academicTariff.getInterestRate(), (DateTime)effectiveWhen.toDateTimeAtStartOfDay(), (boolean)false, (boolean)false, (DebitNote)debitNote);
            if (AcademicTreasuryTargetCreateDebtBuilder.this.createPaymentCode) {
                AcademicTreasuryTargetCreateDebtBuilder.this.createPaymentReferenceCode(debitEntry, dueDate);
            }
            return treasuryEvent;
        }

        private void checkParameters() {
            if (AcademicTreasuryTargetCreateDebtBuilder.this.finantialEntity == null) {
                throw new IllegalArgumentException("Finantial entity required");
            }
            if (AcademicTreasuryTargetCreateDebtBuilder.this.product == null) {
                throw new IllegalArgumentException("Product required");
            }
            if (AcademicTreasuryTargetCreateDebtBuilder.this.target == null) {
                throw new IllegalArgumentException("AcademicTreasuryTarget required");
            }
            if (AcademicTreasuryTargetCreateDebtBuilder.this.createPaymentCode && AcademicTreasuryTargetCreateDebtBuilder.this.paymentCodePool == null) {
                throw new IllegalArgumentException("Payment code pool required");
            }
        }
    }
}

