/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.util;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.CustomerType;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.ProductGroup;
import org.fenixedu.treasury.domain.VatExemptionReason;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.util.TreasuryConstants;

public class AcademicTreasuryBootstrapper {
    public static void bootstrap() {
        AcademicTreasuryBootstrapper.initializeCustomerType();
        AcademicTreasuryBootstrapper.initializeProductGroup();
        AcademicTreasuryBootstrapper.initializeTuitionsTypeProducts();
        AcademicTreasuryBootstrapper.initializeTuitionPaymentPlanGroups();
        AcademicTreasuryBootstrapper.initializeTuitionsProducts();
    }

    private static void initializeCustomerType() {
        CustomerType.findByCode((String)"STUDENT").findFirst().ifPresentOrElse(t -> {}, () -> CustomerType.create((String)"STUDENT", (LocalizedString)TreasuryConstants.treasuryBundleI18N((String)"label.CustomerType.STUDENT", (String[])new String[0])));
    }

    private static void initializeProductGroup() {
        Optional.ofNullable(ProductGroup.findByCode((String)"TUITION")).ifPresentOrElse(p -> Function.identity().apply((ProductGroup)p), () -> ProductGroup.create((String)"TUITION", (LocalizedString)TreasuryConstants.treasuryBundleI18N((String)"label.productGroup.tuition", (String[])new String[0])));
        Optional.ofNullable(AcademicTreasurySettings.getInstance().getTuitionProductGroup()).ifPresentOrElse(p -> Function.identity().apply((ProductGroup)p), () -> AcademicTreasurySettings.getInstance().setTuitionProductGroup(ProductGroup.findByCode((String)"TUITION")));
        Optional.ofNullable(AcademicTreasurySettings.getInstance().getEmolumentsProductGroup()).ifPresentOrElse(p -> Function.identity().apply((ProductGroup)p), () -> AcademicTreasurySettings.getInstance().setEmolumentsProductGroup(ProductGroup.findByCode((String)"TUITION")));
    }

    public static void initializeTuitionsProducts() {
        for (int cycle = 1; cycle <= 3; ++cycle) {
            int num = 1;
            while (num <= 12) {
                Object numlabel = num <= 3 ? "_" + num : "";
                String code = String.format("PROP_%d_PREST_%d_CIC", num, cycle);
                String label = String.format("PROP%s_PREST_%d_CIC", numlabel, cycle);
                LocalizedString description = AcademicTreasuryConstants.academicTreasuryBundleI18N("TreasuryBootstrap." + label, String.valueOf(num));
                int installmentNumber = num++;
                Product.findUniqueByCode((String)code).ifPresentOrElse(p -> Function.identity().apply((Product)p), () -> Product.create((ProductGroup)ProductGroup.findByCode((String)"TUITION"), (String)code, (LocalizedString)description, (LocalizedString)TreasuryConstants.treasuryBundleI18N((String)"label.unit", (String[])new String[0]), (boolean)true, (boolean)false, (int)installmentNumber, (VatType)VatType.findByCode((String)"ISE"), FinantialInstitution.findAll().collect(Collectors.toList()), (VatExemptionReason)VatExemptionReason.findByCode((String)"M07")));
            }
        }
    }

    public static void initializeTuitionsTypeProducts() {
        Product.findUniqueByCode((String)"PROPINA_MATRICULA").ifPresentOrElse(p -> Function.identity().apply((Product)p), () -> Product.create((ProductGroup)ProductGroup.findByCode((String)"TUITION"), (String)"PROPINA_MATRICULA", (LocalizedString)TreasuryConstants.treasuryBundleI18N((String)"label.registration.tuition", (String[])new String[0]), (LocalizedString)TreasuryConstants.treasuryBundleI18N((String)"label.unit", (String[])new String[0]), (boolean)true, (boolean)false, (int)0, (VatType)VatType.findByCode((String)"ISE"), FinantialInstitution.findAll().collect(Collectors.toList()), (VatExemptionReason)VatExemptionReason.findByCode((String)"M07")));
        Product.findUniqueByCode((String)"PROPINA_ISOLADAS").ifPresentOrElse(p -> Function.identity().apply((Product)p), () -> Product.create((ProductGroup)ProductGroup.findByCode((String)"TUITION"), (String)"PROPINA_ISOLADAS", (LocalizedString)TreasuryConstants.treasuryBundleI18N((String)"label.standalone.tuition", (String[])new String[0]), (LocalizedString)TreasuryConstants.treasuryBundleI18N((String)"label.unit", (String[])new String[0]), (boolean)true, (boolean)false, (int)0, (VatType)VatType.findByCode((String)"ISE"), FinantialInstitution.findAll().collect(Collectors.toList()), (VatExemptionReason)VatExemptionReason.findByCode((String)"M07")));
        Product.findUniqueByCode((String)"PROPINA_EXTRACURRIC").ifPresentOrElse(p -> Function.identity().apply((Product)p), () -> Product.create((ProductGroup)ProductGroup.findByCode((String)"TUITION"), (String)"PROPINA_EXTRACURRIC", (LocalizedString)TreasuryConstants.treasuryBundleI18N((String)"label.extracurricular.tuition", (String[])new String[0]), (LocalizedString)TreasuryConstants.treasuryBundleI18N((String)"label.unit", (String[])new String[0]), (boolean)true, (boolean)false, (int)0, (VatType)VatType.findByCode((String)"ISE"), FinantialInstitution.findAll().collect(Collectors.toList()), (VatExemptionReason)VatExemptionReason.findByCode((String)"M07")));
    }

    public static void initializeTuitionPaymentPlanGroups() {
        Product REGISTRATION_TUITION_product = (Product)Product.findUniqueByCode((String)"PROPINA_MATRICULA").get();
        Product STANDALONE_TUITION_product = (Product)Product.findUniqueByCode((String)"PROPINA_ISOLADAS").get();
        Product EXTRACURRICULAR_TUITION_product = (Product)Product.findUniqueByCode((String)"PROPINA_EXTRACURRIC").get();
        if (!TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().isPresent()) {
            TuitionPaymentPlanGroup.create("REGISTRATION_TUITION", REGISTRATION_TUITION_product.getName(), true, false, false, REGISTRATION_TUITION_product);
        }
        if (!TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().isPresent()) {
            TuitionPaymentPlanGroup.create("STANDALONE_TUITION", STANDALONE_TUITION_product.getName(), false, true, false, STANDALONE_TUITION_product);
        }
        if (!TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().isPresent()) {
            TuitionPaymentPlanGroup.create("EXTRACURRICULAR_TUITION", EXTRACURRICULAR_TUITION_product.getName(), false, false, true, EXTRACURRICULAR_TUITION_product);
        }
    }
}

