/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff;
import org.fenixedu.academictreasury.dto.academictax.AcademicDebitEntryBean;
import org.fenixedu.academictreasury.services.AcademicTaxServices$callable$createAcademicTax;
import org.fenixedu.academictreasury.services.AcademicTaxServices$callable$createAcademicTaxForDefaultFinantialEntity;
import org.fenixedu.academictreasury.services.AcademicTaxServices$callable$createAcademicTaxForEnrolmentDateAndDefaultFinantialEntity;
import org.fenixedu.academictreasury.services.AcademicTaxServices$callable$createImprovementTax;
import org.fenixedu.academictreasury.services.AcademicTaxServices$callable$createImprovementTaxForDefaultFinantialEntity;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicTaxServices {
    public static final Advice advice$createAcademicTaxForEnrolmentDateAndDefaultFinantialEntity = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicTaxForDefaultFinantialEntity = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicTax = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createImprovementTaxForDefaultFinantialEntity = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createImprovementTax = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static List<IAcademicTreasuryEvent> findAllTreasuryEventsForAcademicTaxes(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findAllForAcademicTax(registration, executionYear).collect(Collectors.toList());
    }

    public static AcademicTreasuryEvent findAcademicTreasuryEvent(Registration registration, ExecutionYear executionYear, AcademicTax academicTax) {
        return AcademicTreasuryEvent.findUniqueForAcademicTax(registration, executionYear, academicTax).orElse(null);
    }

    public static AcademicTariff findAcademicTariff(AcademicTax academicTax, Registration registration, LocalDate debtDate) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        FinantialEntity finantialEntity = academicTreasuryServices.finantialEntityOfDegree(registration.getDegree(), debtDate);
        return AcademicTariff.findMatch(finantialEntity, academicTax.getProduct(), registration.getDegree(), debtDate.toDateTimeAtStartOfDay());
    }

    public static AcademicDebitEntryBean calculateAcademicTaxForDefaultFinantialEntity(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, LocalDate debtDate, boolean forceCreation) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        FinantialEntity finantialEntity = academicTreasuryServices.finantialEntityOfDegree(registration.getDegree(), debtDate);
        return AcademicTaxServices.calculateAcademicTax(finantialEntity, registration, executionYear, academicTax, debtDate, forceCreation);
    }

    public static AcademicDebitEntryBean calculateAcademicTax(FinantialEntity finantialEntity, Registration registration, ExecutionYear executionYear, AcademicTax academicTax, LocalDate debtDate, boolean forceCreation) {
        if (!forceCreation && TuitionServices.normalEnrolmentsIncludingAnnuled(registration, executionYear).isEmpty()) {
            throw new AcademicTreasuryDomainException("error.AcademicTaxServices.calculateAcademicTax.not.enrolled", new String[0]);
        }
        if (!AcademicTaxServices.isAppliableOnRegistration(academicTax, registration, executionYear)) {
            throw new AcademicTreasuryDomainException("error.AcademicTaxServices.calculateAcademicTax.not.appliable.for.registration.and.execution.year", new String[0]);
        }
        AcademicTariff academicTariff = AcademicTariff.findMatch(finantialEntity, academicTax.getProduct(), registration.getDegree(), debtDate.toDateTimeAtStartOfDay());
        if (academicTariff == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTaxServices.calculateAcademicTax.tariff.not.found", debtDate.toString("dd/MM/yyyy"));
        }
        LocalizedString debitEntryName = AcademicTreasuryEvent.nameForAcademicTax(academicTax, registration, executionYear);
        LocalDate dueDate = academicTariff.dueDate(debtDate);
        Vat vat = academicTariff.vat(debtDate);
        BigDecimal amount = academicTariff.amountToPay(0, 0, AcademicTreasuryConstants.DEFAULT_LANGUAGE, false);
        return new AcademicDebitEntryBean(debitEntryName, dueDate, vat.getTaxRate(), amount);
    }

    public static boolean isAcademicTaxCharged(Registration registration, ExecutionYear executionYear, AcademicTax academicTax) {
        if (AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax) == null) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax);
        return academicTreasuryEvent.isCharged();
    }

    public static boolean createAcademicTaxForEnrolmentDateAndDefaultFinantialEntity(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, boolean bl) {
        return (Boolean)advice$createAcademicTaxForEnrolmentDateAndDefaultFinantialEntity.perform((Callable)new AcademicTaxServices$callable$createAcademicTaxForEnrolmentDateAndDefaultFinantialEntity(registration, executionYear, academicTax, bl));
    }

    static /* synthetic */ boolean advised$createAcademicTaxForEnrolmentDateAndDefaultFinantialEntity(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, boolean forceCreation) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        LocalDate enrolmentDate = AcademicTaxServices.possibleEnrolmentDate(registration, executionYear);
        FinantialEntity finantialEntity = academicTreasuryServices.finantialEntityOfDegree(registration.getDegree(), enrolmentDate);
        return AcademicTaxServices.createAcademicTax(finantialEntity, registration, executionYear, academicTax, enrolmentDate, forceCreation);
    }

    private static LocalDate possibleEnrolmentDate(Registration registration, ExecutionYear executionYear) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        RegistrationDataByExecutionYear data = academicTreasuryServices.findRegistrationDataByExecutionYear(registration, executionYear);
        if (data != null && data.getEnrolmentDate() != null) {
            return data.getEnrolmentDate();
        }
        if (AcademicTreasurySettings.getInstance().getFixAcademicTaxEmolumentEnrolmentDate()) {
            return new LocalDate();
        }
        return executionYear.getBeginLocalDate();
    }

    public static boolean createAcademicTaxForDefaultFinantialEntity(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, LocalDate localDate, boolean bl) {
        return (Boolean)advice$createAcademicTaxForDefaultFinantialEntity.perform((Callable)new AcademicTaxServices$callable$createAcademicTaxForDefaultFinantialEntity(registration, executionYear, academicTax, localDate, bl));
    }

    static /* synthetic */ boolean advised$createAcademicTaxForDefaultFinantialEntity(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, LocalDate when, boolean forceCreation) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        FinantialEntity finantialEntity = academicTreasuryServices.finantialEntityOfDegree(registration.getDegree(), when);
        return AcademicTaxServices.createAcademicTax(finantialEntity, registration, executionYear, academicTax, when, forceCreation);
    }

    public static boolean createAcademicTax(FinantialEntity finantialEntity, Registration registration, ExecutionYear executionYear, AcademicTax academicTax, LocalDate localDate, boolean bl) {
        return (Boolean)advice$createAcademicTax.perform((Callable)new AcademicTaxServices$callable$createAcademicTax(finantialEntity, registration, executionYear, academicTax, localDate, bl));
    }

    static /* synthetic */ boolean advised$createAcademicTax(FinantialEntity finantialEntity, Registration registration, ExecutionYear executionYear, AcademicTax academicTax, LocalDate when, boolean forceCreation) {
        AcademicTreasuryEvent academicTreasuryEvent;
        if (!forceCreation && TuitionServices.normalEnrolmentsIncludingAnnuled(registration, executionYear).isEmpty()) {
            return false;
        }
        if (!AcademicTaxServices.isAppliableOnRegistration(academicTax, registration, executionYear)) {
            return false;
        }
        AcademicTariff academicTariff = AcademicTariff.findMatch(finantialEntity, academicTax.getProduct(), registration.getDegree(), when.toDateTimeAtStartOfDay());
        if (academicTariff == null) {
            return false;
        }
        Person person = registration.getPerson();
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax) == null) {
            PersonCustomer personCustomer;
            if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
            }
            if (!PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).isPresent()) {
                PersonCustomer.create(person, addressFiscalCountryCode, fiscalNumber);
            }
            if (!(personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get()).isActive()) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", new String[]{addressFiscalCountryCode, fiscalNumber});
            }
            if (!DebtAccount.findUnique((FinantialInstitution)finantialEntity.getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
                DebtAccount.create((FinantialInstitution)finantialEntity.getFinantialInstitution(), (Customer)personCustomer);
            }
            AcademicTreasuryEvent.createForAcademicTax(academicTax, registration, executionYear);
        }
        if ((academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax)).isChargedWithDebitEntry()) {
            return false;
        }
        PersonCustomer personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get();
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialEntity.getFinantialInstitution(), (Customer)personCustomer).get();
        academicTariff.createDebitEntryForAcademicTax(debtAccount, academicTreasuryEvent, when);
        return true;
    }

    public static boolean isRegistrationFirstYear(Registration registration, ExecutionYear executionYear) {
        return registration.getRegistrationYear() == executionYear;
    }

    public static boolean isRegistrationSubsequentYear(Registration registration, ExecutionYear executionYear) {
        return registration.getRegistrationYear().isBefore(executionYear);
    }

    public static boolean isAppliableOnRegistration(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        return AcademicTaxServices.isRegistrationFirstYear(registration, executionYear) && academicTax.isAppliedOnRegistrationFirstYear() || AcademicTaxServices.isRegistrationSubsequentYear(registration, executionYear) && academicTax.isAppliedOnRegistrationSubsequentYears();
    }

    public static AcademicTreasuryEvent findAcademicTreasuryEventForImprovementTax(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findUniqueForImprovementTuition(registration, executionYear).orElse(null);
    }

    public static AcademicTariff findAcademicTariffForDefaultFinantialEntity(EnrolmentEvaluation enrolmentEvaluation, LocalDate debtDate) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        FinantialEntity finantialEntity = academicTreasuryServices.finantialEntityOfDegree(enrolmentEvaluation.getEnrolment().getRegistration().getDegree(), debtDate);
        return AcademicTaxServices.findAcademicTariff(finantialEntity, enrolmentEvaluation, debtDate);
    }

    public static AcademicTariff findAcademicTariff(FinantialEntity finantialEntity, EnrolmentEvaluation enrolmentEvaluation, LocalDate debtDate) {
        Registration registration = enrolmentEvaluation.getRegistration();
        Product improvementAcademicTaxProduct = AcademicTreasurySettings.getInstance().getImprovementAcademicTax().getProduct();
        return AcademicTariff.findMatch(finantialEntity, improvementAcademicTaxProduct, registration.getDegree(), debtDate.toDateTimeAtStartOfDay());
    }

    public static boolean isImprovementAcademicTaxCharged(Registration registration, ExecutionYear executionYear, EnrolmentEvaluation enrolmentEvaluation) {
        if (AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear) == null) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear);
        return academicTreasuryEvent.isChargedWithDebitEntry(enrolmentEvaluation);
    }

    public static AcademicDebitEntryBean calculateImprovementTaxForDefaultEntity(EnrolmentEvaluation enrolmentEvaluation, LocalDate debtDate) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        FinantialEntity finantialEntity = academicTreasuryServices.finantialEntityOfDegree(enrolmentEvaluation.getEnrolment().getRegistration().getDegree(), debtDate);
        return AcademicTaxServices.calculateImprovementTax(finantialEntity, enrolmentEvaluation, debtDate);
    }

    public static AcademicDebitEntryBean calculateImprovementTax(FinantialEntity finantialEntity, EnrolmentEvaluation enrolmentEvaluation, LocalDate debtDate) {
        ExecutionYear executionYear;
        if (!enrolmentEvaluation.getEvaluationSeason().isImprovement()) {
            throw new AcademicTreasuryDomainException("error.AcademicTaxServices.enrolmentEvaluation.is.not.improvement", new String[0]);
        }
        AcademicTax improvementAcademicTax = AcademicTreasurySettings.getInstance().getImprovementAcademicTax();
        if (improvementAcademicTax == null) {
            return null;
        }
        Registration registration = enrolmentEvaluation.getRegistration();
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear = enrolmentEvaluation.getExecutionPeriod().getExecutionYear());
        if (academicTreasuryEvent.isChargedWithDebitEntry(enrolmentEvaluation)) {
            return null;
        }
        AcademicTariff academicTariff = AcademicTariff.findMatch(finantialEntity, improvementAcademicTax.getProduct(), registration.getDegree(), debtDate.toDateTimeAtStartOfDay());
        if (academicTariff == null) {
            return null;
        }
        LocalizedString debitEntryName = AcademicTariff.improvementDebitEntryName(improvementAcademicTax, enrolmentEvaluation);
        LocalDate dueDate = academicTariff.dueDate(debtDate);
        Vat vat = academicTariff.vat(debtDate);
        BigDecimal amount = academicTariff.amountToPay(academicTreasuryEvent, enrolmentEvaluation);
        return new AcademicDebitEntryBean(debitEntryName, dueDate, vat.getTaxRate(), amount);
    }

    public static boolean createImprovementTaxForDefaultFinantialEntity(EnrolmentEvaluation enrolmentEvaluation, LocalDate localDate) {
        return (Boolean)advice$createImprovementTaxForDefaultFinantialEntity.perform((Callable)new AcademicTaxServices$callable$createImprovementTaxForDefaultFinantialEntity(enrolmentEvaluation, localDate));
    }

    static /* synthetic */ boolean advised$createImprovementTaxForDefaultFinantialEntity(EnrolmentEvaluation enrolmentEvaluation, LocalDate when) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        FinantialEntity finantialEntity = academicTreasuryServices.finantialEntityOfDegree(enrolmentEvaluation.getRegistration().getDegree(), when);
        return AcademicTaxServices.createImprovementTax(finantialEntity, enrolmentEvaluation, when);
    }

    public static boolean createImprovementTax(FinantialEntity finantialEntity, EnrolmentEvaluation enrolmentEvaluation, LocalDate localDate) {
        return (Boolean)advice$createImprovementTax.perform((Callable)new AcademicTaxServices$callable$createImprovementTax(finantialEntity, enrolmentEvaluation, localDate));
    }

    static /* synthetic */ boolean advised$createImprovementTax(FinantialEntity finantialEntity, EnrolmentEvaluation enrolmentEvaluation, LocalDate when) {
        AcademicTreasuryEvent academicTreasuryEvent;
        if (!enrolmentEvaluation.getEvaluationSeason().isImprovement()) {
            throw new AcademicTreasuryDomainException("error.AcademicTaxServices.enrolmentEvaluation.is.not.improvement", new String[0]);
        }
        Registration registration = enrolmentEvaluation.getRegistration();
        ExecutionYear executionYear = enrolmentEvaluation.getExecutionPeriod().getExecutionYear();
        AcademicTreasurySettings instance = AcademicTreasurySettings.getInstance();
        if (instance == null) {
            return false;
        }
        AcademicTax improvementAcademicTax = instance.getImprovementAcademicTax();
        if (improvementAcademicTax == null) {
            return false;
        }
        AcademicTariff academicTariff = AcademicTariff.findMatch(finantialEntity, improvementAcademicTax.getProduct(), registration.getDegree(), when.toDateTimeAtStartOfDay());
        if (academicTariff == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTaxDebtCreation.tariff.not.found", new String[0]);
        }
        Person person = registration.getPerson();
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear) == null) {
            PersonCustomer personCustomer;
            if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
            }
            if (!PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).isPresent()) {
                PersonCustomer.create(person, addressFiscalCountryCode, fiscalNumber);
            }
            if (!(personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get()).isActive()) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", new String[]{addressFiscalCountryCode, fiscalNumber});
            }
            AcademicTreasuryEvent.createForImprovementTuition(registration, executionYear);
        }
        if ((academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear)).isChargedWithDebitEntry(enrolmentEvaluation)) {
            return false;
        }
        PersonCustomer personCustomer = PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get();
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialEntity.getFinantialInstitution(), (Customer)personCustomer).get();
        DebitEntry debitEntry = academicTariff.createDebitEntryForImprovement(debtAccount, academicTreasuryEvent, enrolmentEvaluation);
        return debitEntry != null;
    }

    public static boolean removeDebitEntryForImprovement(EnrolmentEvaluation improvementEnrolmentEvaluation) {
        ExecutionYear executionYear;
        Registration registration = improvementEnrolmentEvaluation.getRegistration();
        if (AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear = improvementEnrolmentEvaluation.getExecutionPeriod().getExecutionYear()) == null) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear);
        if (!academicTreasuryEvent.isChargedWithDebitEntry(improvementEnrolmentEvaluation)) {
            return false;
        }
        DebitEntry debitEntry = academicTreasuryEvent.findActiveEnrolmentEvaluationDebitEntry(improvementEnrolmentEvaluation).get();
        DebitNote debitNote = (DebitNote)debitEntry.getFinantialDocument();
        if (!debitEntry.isProcessedInDebitNote()) {
            debitEntry.annulDebitEntry(AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTaxServices.removeDebitEntryForImprovement.reason", new String[0]));
            return true;
        }
        if (debitEntry.getCreditEntriesSet().isEmpty()) {
            debitNote.anullDebitNoteWithCreditNote(AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTaxServices.removeDebitEntryForImprovement.reason", new String[0]), false);
            return true;
        }
        return false;
    }
}

