/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.DebtReportEntryBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class PaymentReportEntryBean
implements SpreadsheetRow {
    public static String[] SPREADSHEET_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.responsible", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.settlementNoteNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.settlementNoteDocumentDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.settlementOriginDocumentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.paymentDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.settlementNoteAnnuled", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.documentExportationPending", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.paymentMethod", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.amount", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.debtAccountId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.identificationType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.identificationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.email", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.address", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.closeDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.erpCertificationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportEntryBean.header.erpCertificateDocumentReference", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.documentObservations", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReportEntryBean.header.documentTermsAndConditions", new String[0])};
    private PaymentEntry paymentEntry;
    private boolean completed;
    private String identification;
    private DateTime creationDate;
    private String responsible;
    private String settlementNoteNumber;
    private DateTime settlementNoteDocumentDate;
    private String settlementOriginDocumentNumber;
    private DateTime paymentDate;
    private Boolean settlementNoteAnnuled;
    private Boolean documentExportationPending;
    private String paymentMethod;
    private BigDecimal amount;
    private String customerId;
    private String debtAccountId;
    private String name;
    private String identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String institutionalOrDefaultEmail;
    private String emailForSendingEmails;
    private String personalEmail;
    private String address;
    private Integer studentNumber;
    private DateTime closeDate;
    private Boolean exportedInLegacyERP;
    private LocalDate erpCertificationDate;
    private String erpCertificateDocumentReference;
    private String erpCustomerId;
    private String erpPayorCustomerId;
    private String decimalSeparator;
    private String documentObservations;
    private String documentTermsAndConditions;

    public PaymentReportEntryBean(PaymentEntry entry, DebtReportRequest request, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        this.decimalSeparator = request != null ? request.getDecimalSeparator() : ",";
        this.paymentEntry = entry;
        try {
            SettlementNote settlementNote = entry.getSettlementNote();
            this.identification = entry.getExternalId();
            this.creationDate = treasuryServices.versioningCreationDate((Object)entry);
            this.responsible = treasuryServices.versioningCreatorUsername((Object)entry);
            this.settlementNoteNumber = settlementNote.getUiDocumentNumber();
            this.settlementNoteDocumentDate = settlementNote.getDocumentDate();
            this.settlementOriginDocumentNumber = settlementNote.getOriginDocumentNumber();
            this.paymentDate = settlementNote.getPaymentDate();
            this.settlementNoteAnnuled = settlementNote.isAnnulled();
            this.documentExportationPending = settlementNote.isDocumentToExport();
            this.paymentMethod = entry.getPaymentMethod().getName().getContent();
            settlementNote.getDebtAccount().getFinantialInstitution().getCurrency();
            this.amount = Currency.getValueWithScale((BigDecimal)entry.getPayedAmount());
            this.fillStudentInformation(entry);
            this.fillERPInformation(settlementNote);
            this.documentObservations = entry.getSettlementNote().getDocumentObservations();
            this.documentTermsAndConditions = entry.getSettlementNote().getDocumentTermsAndConditions();
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(entry, e);
        }
    }

    private void fillERPInformation(SettlementNote settlementNote) {
        SettlementEntry settlementEntry;
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        this.closeDate = settlementNote != null ? settlementNote.getCloseDate() : null;
        this.exportedInLegacyERP = settlementNote != null ? settlementNote.isExportedInLegacyERP() : false;
        this.erpCertificationDate = settlementNote != null ? settlementNote.getErpCertificationDate() : null;
        this.erpCertificateDocumentReference = settlementNote != null ? settlementNote.getErpCertificateDocumentReference() : null;
        this.erpCustomerId = settlementNote.getDebtAccount().getCustomer().getErpCustomerId();
        if (!settlementNote.getSettlemetEntriesSet().isEmpty() && (settlementEntry = (SettlementEntry)settlementNote.getSettlemetEntriesSet().iterator().next()).getInvoiceEntry().getFinantialDocument() != null && ((Invoice)settlementEntry.getInvoiceEntry().getFinantialDocument()).getPayorDebtAccount() != null) {
            this.erpPayorCustomerId = ((Invoice)settlementEntry.getInvoiceEntry().getFinantialDocument()).getPayorDebtAccount().getCustomer().getErpCustomerId();
        }
        if (treasuryServices.hasCertifiedDocument((FinantialDocument)settlementNote)) {
            this.erpCertificationDate = treasuryServices.getCertifiedDocumentDate((FinantialDocument)settlementNote);
            this.erpCertificateDocumentReference = treasuryServices.getCertifiedDocumentNumber((FinantialDocument)settlementNote);
        }
    }

    private void fillStudentInformation(PaymentEntry entry) {
        Person person;
        Customer customer = entry.getSettlementNote().getDebtAccount().getCustomer();
        this.customerId = customer.getExternalId();
        this.debtAccountId = entry.getSettlementNote().getDebtAccount().getExternalId();
        this.name = customer.getName();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null && ((PersonCustomer)customer).getAssociatedPerson().getIdDocumentType() != null) {
            this.identificationType = ((PersonCustomer)customer).getAssociatedPerson().getIdDocumentType().getLocalizedName();
        }
        this.identificationNumber = customer.getIdentificationNumber();
        this.vatNumber = customer.getUiFiscalNumber();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null) {
            person = ((PersonCustomer)customer).getAssociatedPerson();
            this.institutionalOrDefaultEmail = person.getInstitutionalOrDefaultEmailAddressValue();
            this.emailForSendingEmails = person.getEmailForSendingEmails();
            this.personalEmail = DebtReportEntryBean.personalEmail(person) != null ? DebtReportEntryBean.personalEmail(person).getValue() : "";
        }
        this.address = customer.getAddress();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getAssociatedPerson() != null && ((PersonCustomer)customer).getAssociatedPerson().getStudent() != null) {
            person = ((PersonCustomer)customer).getAssociatedPerson();
            this.studentNumber = person.getStudent().getNumber();
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            String value;
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.responsible));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteDocumentDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementOriginDocumentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.paymentDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteAnnuled));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentExportationPending));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.paymentMethod));
            String string = value = this.amount != null ? this.amount.toString() : "";
            if (",".equals(this.decimalSeparator)) {
                value = value.replace(".", ",");
            }
            row.createCell(i++).setCellValue(value);
            row.createCell(i++).setCellValue(this.customerId);
            row.createCell(i++).setCellValue(this.debtAccountId);
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.name));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.institutionalOrDefaultEmail));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.address));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.studentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.closeDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.erpCertificationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.erpCertificateDocumentReference));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentObservations));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentTermsAndConditions));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.paymentEntry, e);
        }
    }

    private String valueOrEmpty(LocalDate value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd");
    }

    private String valueOrEmpty(DateTime value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd HH:mm:ss");
    }

    private String valueOrEmpty(Boolean value) {
        if (value == null) {
            return "";
        }
        return AcademicTreasuryConstants.academicTreasuryBundle(value != false ? "label.yes" : "label.no", new String[0]);
    }

    private String valueOrEmpty(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String valueOrEmpty(LocalizedString value) {
        if (value == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)value.getContent())) {
            return "";
        }
        return value.getContent();
    }

    private String valueOrEmpty(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return "";
    }

    public PaymentEntry getPaymentEntry() {
        return this.paymentEntry;
    }

    public void setPaymentEntry(PaymentEntry paymentEntry) {
        this.paymentEntry = paymentEntry;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime creationDate) {
        this.creationDate = creationDate;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public void setResponsible(String responsible) {
        this.responsible = responsible;
    }

    public String getSettlementNoteNumber() {
        return this.settlementNoteNumber;
    }

    public void setSettlementNoteNumber(String settlementNoteNumber) {
        this.settlementNoteNumber = settlementNoteNumber;
    }

    public DateTime getSettlementNoteDocumentDate() {
        return this.settlementNoteDocumentDate;
    }

    public void setSettlementNoteDocumentDate(DateTime settlementNoteDocumentDate) {
        this.settlementNoteDocumentDate = settlementNoteDocumentDate;
    }

    public String getSettlementOriginDocumentNumber() {
        return this.settlementOriginDocumentNumber;
    }

    public void setSettlementOriginDocumentNumber(String settlementOriginDocumentNumber) {
        this.settlementOriginDocumentNumber = settlementOriginDocumentNumber;
    }

    public DateTime getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(DateTime paymentDate) {
        this.paymentDate = paymentDate;
    }

    public Boolean getSettlementNoteAnnuled() {
        return this.settlementNoteAnnuled;
    }

    public void setSettlementNoteAnnuled(Boolean settlementNoteAnnuled) {
        this.settlementNoteAnnuled = settlementNoteAnnuled;
    }

    public boolean getDocumentExportationPending() {
        return this.documentExportationPending;
    }

    public void setDocumentExportationPending(Boolean documentExportationPending) {
        this.documentExportationPending = documentExportationPending;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getDebtAccountId() {
        return this.debtAccountId;
    }

    public void setDebtAccountId(String debtAccountId) {
        this.debtAccountId = debtAccountId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(String identificationType) {
        this.identificationType = identificationType;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public String getInstitutionalOrDefaultEmail() {
        return this.institutionalOrDefaultEmail;
    }

    public void setInstitutionalOrDefaultEmail(String institutionalOrDefaultEmail) {
        this.institutionalOrDefaultEmail = institutionalOrDefaultEmail;
    }

    public String getEmailForSendingEmails() {
        return this.emailForSendingEmails;
    }

    public void setEmailForSendingEmails(String emailForSendingEmails) {
        this.emailForSendingEmails = emailForSendingEmails;
    }

    public String getPersonalEmail() {
        return this.personalEmail;
    }

    public void setPersonalEmail(String personalEmail) {
        this.personalEmail = personalEmail;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    public DateTime getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(DateTime closeDate) {
        this.closeDate = closeDate;
    }

    public Boolean getExportedInLegacyERP() {
        return this.exportedInLegacyERP;
    }

    public void setExportedInLegacyERP(Boolean exportedInLegacyERP) {
        this.exportedInLegacyERP = exportedInLegacyERP;
    }

    public LocalDate getErpCertificationDate() {
        return this.erpCertificationDate;
    }

    public void setErpCertificationDate(LocalDate erpCertificationDate) {
        this.erpCertificationDate = erpCertificationDate;
    }

    public String getErpCertificateDocumentReference() {
        return this.erpCertificateDocumentReference;
    }

    public void setErpCertificateDocumentReference(String erpCertificateDocumentReference) {
        this.erpCertificateDocumentReference = erpCertificateDocumentReference;
    }

    public String getErpCustomerId() {
        return this.erpCustomerId;
    }

    public void setErpCustomerId(String erpCustomerId) {
        this.erpCustomerId = erpCustomerId;
    }

    public String getErpPayorCustomerId() {
        return this.erpPayorCustomerId;
    }

    public void setErpPayorCustomerId(String erpPayorCustomerId) {
        this.erpPayorCustomerId = erpPayorCustomerId;
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(String decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }
}

