/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reports;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.ReimbursementEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentCodeTransaction;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;

public class ErrorsLog
implements IErrorsLog {
    final StringBuffer sb = new StringBuffer();

    public void addError(InvoiceEntry entry, Exception e) {
        String oid = entry.getExternalId();
        String documentNumber = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getUiDocumentNumber() : "";
        String description = entry.getDescription();
        this.sb.append(String.format("[%s/%s] - '%s'\n%s\n\n", oid, documentNumber, description, ExceptionUtils.getFullStackTrace((Throwable)e)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(SettlementEntry entry, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = entry.getExternalId();
            String documentNumber = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getUiDocumentNumber() : "";
            String description = entry.getDescription() != null ? entry.getDescription() : "";
            this.sb.append(String.format("[%s/%s] - '%s'\n%s\n\n", oid, documentNumber, description, ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(PaymentEntry entry, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = entry.getExternalId();
            String documentNumber = entry.getSettlementNote() != null ? entry.getSettlementNote().getUiDocumentNumber() : "";
            this.sb.append(String.format("[%s/%s]\n%s\n\n", oid, documentNumber, ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(ReimbursementEntry entry, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = entry.getExternalId();
            String documentNumber = entry.getSettlementNote() != null ? entry.getSettlementNote().getUiDocumentNumber() : "";
            this.sb.append(String.format("[%s/%s]\n%s\n\n", oid, documentNumber, ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(DebtAccount debtAccount, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = debtAccount.getExternalId();
            String identification = "N/A";
            String name = "N/A";
            try {
                identification = debtAccount.getCustomer().getIdentificationNumber();
                name = debtAccount.getCustomer().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sb.append(String.format("[%s/%s] - %s\n%s\n\n", oid, identification, name, ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(AcademicActBlockingSuspension academicActBlockingSuspension, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = academicActBlockingSuspension.getExternalId();
            String name = academicActBlockingSuspension.getPerson().getName();
            this.sb.append(String.format("[%s] - %s\n%s\n\n", oid, name, ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(SibsPaymentRequest paymentRequest, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = paymentRequest.getExternalId();
            String referenceCode = paymentRequest.getReferenceCode();
            this.sb.append(String.format("[%s] - %s\n%s\n\n", oid, referenceCode, ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(SibsPaymentCodeTransaction sibsTransactionDetail, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = sibsTransactionDetail.getExternalId();
            String referenceCode = sibsTransactionDetail.getSibsPaymentReferenceCode();
            this.sb.append(String.format("[%s] - %s\n%s\n\n", oid, referenceCode, ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(TreasuryExemption treasuryExemption, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = treasuryExemption.getExternalId();
            this.sb.append(String.format("[%s]\n%s\n\n", oid, ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(Product product, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = product.getExternalId();
            this.sb.append(String.format("[%s]\n%s\n\n", oid, ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
    }

    public String getLog() {
        return this.sb.toString();
    }
}

