/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reports;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequestResultFile_Base;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

public class DebtReportRequestResultFile
extends DebtReportRequestResultFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/octet-stream";

    protected DebtReportRequestResultFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    protected DebtReportRequestResultFile(DebtReportRequest request, byte[] content) {
        this();
        this.setDebtReportRequest(request);
        String filename = AcademicTreasuryConstants.academicTreasuryBundle("label.DebtReportRequestResultFile.ZIP.filename", new DateTime().toString("YYYYMMddHHmmss"));
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        services.createFile((IGenericFile)this, filename, CONTENT_TYPE, content);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDebtReportRequest() == null) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequestResultFile.debtReportRequest.required", new String[0]);
        }
    }

    public String getFileSizeWithUnitDescription() {
        BigDecimal filesizeMb = this.getFilesizeMb();
        if (TreasuryConstants.isGreaterOrEqualThan((BigDecimal)filesizeMb, (BigDecimal)BigDecimal.ONE)) {
            return filesizeMb.toString() + " Mb";
        }
        return this.getFilesizeKb() + " Kb";
    }

    public BigDecimal getFilesizeKb() {
        return new BigDecimal(this.getSize()).setScale(4, RoundingMode.DOWN).divide(new BigDecimal(1024)).setScale(1, RoundingMode.DOWN);
    }

    public BigDecimal getFilesizeMb() {
        return new BigDecimal(this.getSize()).setScale(4, RoundingMode.DOWN).divide(new BigDecimal(1024)).divide(new BigDecimal(1024)).setScale(1, RoundingMode.DOWN);
    }

    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember((String)username);
    }

    public void delete() {
        this.setDomainRoot(null);
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        services.deleteFile((IGenericFile)this);
        super.deleteDomainObject();
    }

    public static DebtReportRequestResultFile create(DebtReportRequest request, byte[] content) {
        return new DebtReportRequestResultFile(request, content);
    }

    public static Stream<DebtReportRequestResultFile> findAll() {
        return FenixFramework.getDomainRoot().getDebtReportRequestResultFilesSet().stream();
    }
}

