/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineServices;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.YearMonthDay;
import org.joda.time.base.AbstractPartial;

public class AverageEntry
implements Comparable<AverageEntry> {
    public static final String ENTRY_INFO_EMPTY = "-";
    public static final String ENTRY_INFO_EQUALS = "Idem";
    private ICurriculumEntry entry;
    private StudentCurricularPlan studentCurricularPlan;
    private String approvalTypeDescription;
    private Integer curricularYear;
    private Integer curricularSemester;
    private String entryInfo;
    private String targetCurriculumLinesInfo;
    private YearMonthDay conclusionDateOnTarget;

    public AverageEntry(ICurriculumEntry entry, StudentCurricularPlan studentCurricularPlan) {
        this.entry = entry;
        this.studentCurricularPlan = studentCurricularPlan;
        this.approvalTypeDescription = AverageEntry.getApprovalTypeDescription(entry, studentCurricularPlan);
        this.curricularYear = AverageEntry.getCurricularYear(entry);
        this.curricularSemester = AverageEntry.getCurricularSemester(entry);
        this.entryInfo = AverageEntry.getEntryInfo(entry);
        this.targetCurriculumLinesInfo = AverageEntry.getTargetCurriculumLinesInfo(entry, studentCurricularPlan);
        this.conclusionDateOnTarget = AverageEntry.getConclusionDateOnTarget(entry, studentCurricularPlan);
    }

    public ICurriculumEntry getEntry() {
        return this.entry;
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.studentCurricularPlan;
    }

    public ExecutionYear getExecutionYear() {
        return this.getEntry().getExecutionYear();
    }

    public BigDecimal getEcts() {
        return this.getEntry().getEctsCreditsForCurriculum();
    }

    public BigDecimal getGradeValue() {
        return this.getEntry().getGrade().getNumericValue();
    }

    public String getApprovalTypeDescription() {
        return this.approvalTypeDescription;
    }

    public Integer getCurricularYear() {
        return this.curricularYear;
    }

    public Integer getCurricularSemester() {
        return this.curricularSemester;
    }

    public String getEntryInfo() {
        return this.entryInfo;
    }

    public String getTargetCurriculumLinesInfo() {
        return this.targetCurriculumLinesInfo;
    }

    public YearMonthDay getConclusionDateOnTarget() {
        return this.conclusionDateOnTarget;
    }

    @Override
    public int compareTo(AverageEntry o) {
        int result = this.getEntryInfo().compareTo(o.getEntryInfo());
        if (result == 0) {
            if (this.getCurricularYear() != null && o.getCurricularYear() != null) {
                result = 0;
            } else {
                int n = result = this.getCurricularYear() != null ? -1 : 1;
            }
        }
        if (result == 0) {
            result = AverageEntry.getPresentationNameFor(this.getEntry()).compareTo(AverageEntry.getPresentationNameFor(o.getEntry()));
        }
        return result;
    }

    private static String getPresentationNameFor(ICurriculumEntry entry) {
        String code;
        String string = code = !StringUtils.isEmpty((String)entry.getCode()) ? entry.getCode() + " - " : "";
        if (entry instanceof OptionalEnrolment) {
            OptionalEnrolment optionalEnrolment = (OptionalEnrolment)entry;
            return code + optionalEnrolment.getCurricularCourse().getNameI18N(entry.getExecutionPeriod()).getContent();
        }
        return code + entry.getName().getContent();
    }

    public static List<AverageEntry> getAverageEntries(Curriculum curriculum) {
        LinkedList result = Lists.newLinkedList();
        Predicate<AverageEntry> predicate = i -> i.isAccountable();
        curriculum.getEnrolmentRelatedEntries().stream().map(i -> new AverageEntry((ICurriculumEntry)i, curriculum.getStudentCurricularPlan())).filter(predicate).collect(Collectors.toCollection(() -> result));
        curriculum.getDismissalRelatedEntries().stream().map(i -> new AverageEntry((ICurriculumEntry)i, curriculum.getStudentCurricularPlan())).filter(predicate).collect(Collectors.toCollection(() -> result));
        Collections.sort(result);
        return result;
    }

    private boolean isAccountable() {
        return this.getEntry().getCurriculumLinesForCurriculum(this.studentCurricularPlan).stream().filter(i -> i.isDismissal()).map(Dismissal.class::cast).map(i -> i.getCredits()).filter(i -> i != null).map(i -> i.getReason()).noneMatch(i -> i != null && !i.getAverageEntry());
    }

    private static String getApprovalTypeDescription(ICurriculumEntry entry, StudentCurricularPlan studentCurricularPlan) {
        LocalizedString result = CurriculumLineServices.getCurriculumEntryDescription(entry, studentCurricularPlan, true, true);
        if (result == null || result.isEmpty()) {
            result = new LocalizedString();
            for (Locale locale : CoreConfiguration.supportedLocales()) {
                result = result.with(locale, ENTRY_INFO_EMPTY);
            }
        }
        return result.getContent();
    }

    private static Integer getCurricularYear(ICurriculumEntry entry) {
        Integer result = null;
        if (entry instanceof CurriculumLine) {
            result = CurricularPeriodServices.getCurricularYear((CurriculumLine)entry);
        }
        return result;
    }

    private static Integer getCurricularSemester(ICurriculumEntry entry) {
        Integer result = null;
        if (entry instanceof CurriculumLine) {
            result = CurricularPeriodServices.getCurricularSemester((CurriculumLine)entry);
        }
        return result;
    }

    private static String getTargetCurriculumLinesInfo(ICurriculumEntry entry, StudentCurricularPlan studentCurricularPlan) {
        Set lines = entry.getCurriculumLinesForCurriculum(studentCurricularPlan);
        if (lines.isEmpty()) {
            return ENTRY_INFO_EMPTY;
        }
        if (lines.size() == 1 && lines.contains(entry)) {
            return ENTRY_INFO_EQUALS;
        }
        return lines.stream().map(line -> AverageEntry.getEntryInfo((ICurriculumEntry)line)).distinct().sorted().collect(Collectors.joining(" "));
    }

    private static String getEntryInfo(ICurriculumEntry entry) {
        Object curricularYear = "";
        Object curricularSemester = "";
        if (entry instanceof CurriculumLine) {
            curricularYear = String.valueOf(CurricularPeriodServices.getCurricularYear((CurriculumLine)entry)) + " " + BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curricular.year", (String[])new String[0]) + ", ";
            curricularSemester = String.valueOf(CurricularPeriodServices.getCurricularSemester((CurriculumLine)entry)) + " " + BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.semester.short", (String[])new String[0]);
        }
        String executionYear = entry.getExecutionYear() == null ? "" : " " + entry.getExecutionYear().getQualifiedName();
        return (String)curricularYear + (String)curricularSemester + executionYear;
    }

    public static YearMonthDay getConclusionDateOnTarget(ICurriculumEntry entry, StudentCurricularPlan studentCurricularPlan) {
        Set lines = entry.getCurriculumLinesForCurriculum(studentCurricularPlan);
        return lines.isEmpty() ? entry.getApprovementDate() : (YearMonthDay)lines.stream().filter(i -> i.getApprovementDate() != null).map(i -> i.getApprovementDate()).max(AbstractPartial::compareTo).orElse(null);
    }
}

