/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.evaluation.season.rule;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.curriculum.grade.GradeScale;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.evaluation.season.rule.EvaluationSeasonRule;
import org.fenixedu.academic.domain.evaluation.season.rule.GradeScaleValidator$callable$create;
import org.fenixedu.academic.domain.evaluation.season.rule.GradeScaleValidator$callable$delete;
import org.fenixedu.academic.domain.evaluation.season.rule.GradeScaleValidator$callable$edit;
import org.fenixedu.academic.domain.evaluation.season.rule.GradeScaleValidator_Base;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GradeScaleValidator
extends GradeScaleValidator_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static EvaluationSeasonRule create(EvaluationSeason evaluationSeason, GradeScale gradeScale, String string, LocalizedString localizedString, boolean bl, Set<DegreeType> set) {
        return (EvaluationSeasonRule)((Object)advice$create.perform((Callable)new GradeScaleValidator$callable$create(evaluationSeason, gradeScale, string, localizedString, bl, set)));
    }

    static /* synthetic */ EvaluationSeasonRule advised$create(EvaluationSeason season, GradeScale gradeScale, String gradeValues, LocalizedString description, boolean appliesToCurriculumAggregatorEntry, Set<DegreeType> degreeTypes) {
        GradeScaleValidator result = new GradeScaleValidator();
        result.init(season, gradeScale, gradeValues, description, appliesToCurriculumAggregatorEntry, degreeTypes);
        return result;
    }

    private void init(EvaluationSeason season, GradeScale gradeScale, String gradeValues, LocalizedString description, boolean appliesToCurriculumAggregatorEntry, Set<DegreeType> degreeTypes) {
        super.init(season);
        this.setGradeScale(gradeScale);
        this.setGradeValues(gradeValues);
        this.setRuleDescription(description);
        this.setAppliesToCurriculumAggregatorEntry(appliesToCurriculumAggregatorEntry);
        this.getDegreeTypeSet().clear();
        this.getDegreeTypeSet().addAll(degreeTypes);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getGradeScale() == null) {
            throw new AcademicExtensionsDomainException("error.GradeScaleValidator.gradeScale.required", new String[0]);
        }
        if (StringUtils.isBlank((String)this.getGradeValues())) {
            throw new AcademicExtensionsDomainException("error.GradeScaleValidator.gradeValues.required", new String[0]);
        }
        if (this.getRuleDescription() == null || this.getRuleDescription().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.GradeScaleValidator.description.required", new String[0]);
        }
        if (this.getDegreeTypeSet().isEmpty()) {
            throw new AcademicExtensionsDomainException("error.GradeScaleValidator.degreeTypes.required", new String[0]);
        }
    }

    protected Predicate<? super EvaluationSeasonRule> checkDuplicate() {
        return i -> {
            if (i == this || !(i instanceof GradeScaleValidator)) {
                return false;
            }
            GradeScaleValidator o = (GradeScaleValidator)((Object)((Object)i));
            return o.getGradeScale() == this.getGradeScale() && o.getAppliesToCurriculumAggregatorEntry() == this.getAppliesToCurriculumAggregatorEntry() && !Sets.intersection((Set)o.getDegreeTypeSet(), (Set)this.getDegreeTypeSet()).isEmpty();
        };
    }

    public void edit(GradeScale gradeScale, String string, LocalizedString localizedString, boolean bl, Set<DegreeType> set) {
        Object object = advice$edit.perform((Callable)new GradeScaleValidator$callable$edit(this, gradeScale, string, localizedString, bl, set));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$edit(GradeScaleValidator this_, GradeScale gradeScale, String gradeValues, LocalizedString description, boolean appliesToCurriculumAggregatorEntry, Set degreeTypes) {
        this_.init(this_.getSeason(), gradeScale, gradeValues, description, appliesToCurriculumAggregatorEntry, degreeTypes);
    }

    public boolean isUpdatable() {
        return true;
    }

    public LocalizedString getDescriptionI18N() {
        LocalizedString.Builder builder = AcademicExtensionsUtil.bundleI18N(((Object)((Object)this)).getClass().getSimpleName(), new String[0]).builder();
        builder.append(this.getGradeScale().getName().getContent(), " [");
        builder.append(this.getGradeValues(), "]: ");
        builder.append(String.valueOf(this.getDegreeTypeSet().stream().count()), " [");
        builder.append(AcademicExtensionsUtil.bundle("label.Degree.degreeType", new String[0]), " ");
        builder.append("]");
        return builder.build();
    }

    public boolean isGradeValueAccepted(String input) {
        if (this.getGradeScale().belongsTo(input)) {
            for (String iter : this.getGradeValues().split(" ")) {
                if (iter.equals(input)) {
                    return true;
                }
                ArrayList limits = Lists.newArrayList((Object[])iter.split("-"));
                if (limits.size() != 2) continue;
                String limitMin = (String)limits.get(0);
                String limitMax = (String)limits.get(1);
                int scale = GradeScaleValidator.getScale(limitMin, limitMax);
                try {
                    BigDecimal value = new BigDecimal(input);
                    if (value.scale() <= scale) {
                        BigDecimal min = new BigDecimal(limitMin);
                        BigDecimal max = new BigDecimal(limitMax);
                        return BigDecimalValidator.getInstance().isInRange((Number)value, (Number)min, (Number)max);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static int getScale(String limitMin, String limitMax) {
        int temp;
        int scale = 0;
        if (limitMin.contains(".")) {
            temp = limitMin.split("[.]")[1].length();
            int n = scale = scale == 0 || temp < scale ? temp : scale;
        }
        if (limitMax.contains(".")) {
            temp = limitMax.split("[.]")[1].length();
            scale = scale == 0 || temp < scale ? temp : scale;
        }
        return scale;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new GradeScaleValidator$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(GradeScaleValidator this_) {
        super.setGradeScale(null);
        this_.getDegreeTypeSet().clear();
        super.delete();
    }
}

