/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.dml;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.fenixedu.commons.i18n.LocalizedString;

public class DynamicFieldValueConverter {
    private static Map<Class, Function<Object, String>> SERIALIZERS = new HashMap<Class, Function<Object, String>>();
    private static Map<Class, Function<String, Object>> DESERIALIZERS = new HashMap<Class, Function<String, Object>>();

    public static Set<Class> getSupportedTypes() {
        return SERIALIZERS.keySet();
    }

    public static boolean isSupported(Class input) {
        return DynamicFieldValueConverter.getSupportedTypes().contains(input);
    }

    public static String serialize(Class type, Object value) {
        return SERIALIZERS.get(type).apply(value);
    }

    public static <T> Object deserialize(Class<T> type, String value) {
        return DESERIALIZERS.get(type).apply(value);
    }

    static {
        SERIALIZERS.put(LocalizedString.class, value -> value == null ? null : ((LocalizedString)value).json().toString());
        DESERIALIZERS.put(LocalizedString.class, value -> Strings.isNullOrEmpty((String)value) ? null : LocalizedString.fromJson((JsonElement)new JsonParser().parse(value)));
        SERIALIZERS.put(String.class, value -> (String)value);
        DESERIALIZERS.put(String.class, value -> Strings.isNullOrEmpty((String)value) ? null : value);
        SERIALIZERS.put(Boolean.class, value -> value == null ? null : value.toString());
        DESERIALIZERS.put(Boolean.class, value -> Strings.isNullOrEmpty((String)value) ? null : Boolean.valueOf(value));
        SERIALIZERS.put(Long.class, value -> value == null ? null : value.toString());
        DESERIALIZERS.put(Long.class, value -> Strings.isNullOrEmpty((String)value) ? null : Long.valueOf(value));
        SERIALIZERS.put(Integer.class, value -> value == null ? null : value.toString());
        DESERIALIZERS.put(Integer.class, value -> Strings.isNullOrEmpty((String)value) ? null : Integer.valueOf(value));
        SERIALIZERS.put(BigDecimal.class, value -> value == null ? null : ((BigDecimal)value).toString());
        DESERIALIZERS.put(BigDecimal.class, value -> Strings.isNullOrEmpty((String)value) ? null : new BigDecimal((String)value));
    }
}

