/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum.conclusion;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.joda.time.LocalDate;

public class RegistrationConclusionInformation {
    private RegistrationConclusionBean registrationConclusionBean;

    public RegistrationConclusionInformation(RegistrationConclusionBean registrationConclusionBean) {
        this.registrationConclusionBean = registrationConclusionBean;
    }

    public RegistrationConclusionBean getRegistrationConclusionBean() {
        return this.registrationConclusionBean;
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.registrationConclusionBean.getStudentCurricularPlan();
    }

    public ProgramConclusion getProgramConclusion() {
        return this.registrationConclusionBean.getProgramConclusion();
    }

    public CurriculumGroup getCurriculumGroup() {
        return this.registrationConclusionBean.getCurriculumGroup();
    }

    public LocalDate getConclusionDate() {
        if (this.registrationConclusionBean.getConclusionDate() == null) {
            return null;
        }
        return this.registrationConclusionBean.getConclusionDate().toLocalDate();
    }

    public ExecutionYear getConclusionYear() {
        if (this.registrationConclusionBean.isConclusionProcessed()) {
            return this.registrationConclusionBean.getConclusionYear();
        }
        if (this.registrationConclusionBean.getConclusionYear() != null) {
            return this.registrationConclusionBean.getConclusionYear();
        }
        return ExecutionYear.readByDateTime((LocalDate)this.registrationConclusionBean.getConclusionDate().toLocalDate());
    }

    public boolean isConcluded() {
        return this.registrationConclusionBean.isConcluded();
    }

    public boolean isScholarPart() {
        return !this.getProgramConclusion().isTerminal();
    }

    public boolean isIntegratedMasterFirstCycle() {
        return this.getStudentCurricularPlan().getDegree().getDegreeType().isIntegratedMasterDegree() && this.getCurriculumGroup().isCycleCurriculumGroup() && ((CycleCurriculumGroup)this.getCurriculumGroup()).isFirstCycle();
    }
}

