/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curriculum.grade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScaleEnum;
import org.fenixedu.academic.domain.exceptions.DomainException;

@Deprecated
public class StandardType20GradeScaleLogic
implements GradeScaleEnum.GradeScaleLogic {
    protected static final List<String> APPROVED_TEXTUAL_GRADES = Arrays.asList("AP");
    protected static final List<String> NOT_APPROVED_TEXTUAL_GRADES = Arrays.asList("ANUL", "D", "F", "NADM", "RE", "SUSPEN");
    private static final List<String> NOT_EVALUATED_TEXTUAL_GRADES = Arrays.asList("NA");
    private static final List<String> TEXTUAL_GRADES = new ArrayList<String>();

    public boolean checkNotFinal(Grade grade) {
        return this.belongsTo(grade.getValue());
    }

    public boolean checkFinal(Grade grade) {
        return this.belongsTo(grade.getValue());
    }

    public boolean belongsTo(String value) {
        if (TEXTUAL_GRADES.contains(value)) {
            return true;
        }
        try {
            double doubleValue = Double.parseDouble(value);
            return doubleValue >= 0.0 && doubleValue <= 20.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String qualify(Grade grade) {
        throw new DomainException("GradeScale.unable.to.qualify.given.grade.use.qualitative.scale", new String[0]);
    }

    public boolean isNotEvaluated(Grade grade) {
        String value = grade.getValue();
        return grade.isEmpty() || NOT_EVALUATED_TEXTUAL_GRADES.contains(value);
    }

    public boolean isNotApproved(Grade grade) {
        String value = grade.getValue();
        if (NOT_APPROVED_TEXTUAL_GRADES.contains(value) || this.isNotEvaluated(grade)) {
            return true;
        }
        try {
            return Double.parseDouble(value) < 9.5;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isApproved(Grade grade) {
        String value = grade.getValue();
        if (APPROVED_TEXTUAL_GRADES.contains(value)) {
            return true;
        }
        try {
            double doubleValue = Double.parseDouble(value);
            return 9.5 <= doubleValue && doubleValue <= 20.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public int compareGrades(Grade leftGrade, Grade rightGrade) {
        if (rightGrade == null || rightGrade.isEmpty()) {
            return 1;
        }
        if (leftGrade == null || leftGrade.isEmpty()) {
            return -1;
        }
        if (!leftGrade.getGradeScale().equals((Object)rightGrade.getGradeScale())) {
            throw new DomainException("Grade.unsupported.comparassion.of.grades.of.different.scales", new String[0]);
        }
        boolean isLeftApproved = this.isApproved(leftGrade);
        boolean isRightApproved = this.isApproved(rightGrade);
        if (isLeftApproved && isRightApproved) {
            return this.compareGradeValues(leftGrade, rightGrade);
        }
        if (isLeftApproved) {
            return 1;
        }
        if (isRightApproved) {
            return -1;
        }
        return this.compareGradeValues(leftGrade, rightGrade);
    }

    private int compareGradeValues(Grade left, Grade right) {
        boolean leftIsNumber = NumberUtils.isNumber((String)left.getValue());
        boolean rightIsNumber = NumberUtils.isNumber((String)right.getValue());
        if (leftIsNumber && !rightIsNumber) {
            return 1;
        }
        if (!leftIsNumber && rightIsNumber) {
            return -1;
        }
        if (leftIsNumber && rightIsNumber) {
            return left.getNumericValue().compareTo(right.getNumericValue());
        }
        return left.getValue().compareTo(right.getValue());
    }

    static {
        TEXTUAL_GRADES.addAll(APPROVED_TEXTUAL_GRADES);
        TEXTUAL_GRADES.addAll(NOT_APPROVED_TEXTUAL_GRADES);
        TEXTUAL_GRADES.addAll(NOT_EVALUATED_TEXTUAL_GRADES);
    }
}

