/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academicextensions.util.AcademicExtensionsUtil;

public class ConditionedRouteExecutor
extends CurricularRuleExecutor {
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    @Deprecated
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (!this.canApplyRule(enrolmentContext, curricularRule)) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (this.isPersonAuthorized(enrolmentContext.getResponsiblePerson())) {
            return RuleResult.createTrue((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.searchDegreeModuleToEvaluate(enrolmentContext, curricularRule);
        if (degreeModuleToEvaluate.isEnroled()) {
            return RuleResult.createNA((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return this.createFalseResult(sourceDegreeModuleToEvaluate, degreeModuleToEvaluate);
    }

    private RuleResult createFalseResult(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        return RuleResult.createFalseWithLiteralMessage((DegreeModule)sourceDegreeModuleToEvaluate.getDegreeModule(), (String)AcademicExtensionsUtil.bundle("curricularRules.ruleExecutors.ConditionedRouteExecutor.route.choice.must.be.performed.by.academic.office", degreeModuleToEvaluate.getDegreeModule().getName()));
    }

    private boolean isPersonAuthorized(Person person) {
        return person != null && (RoleType.ACADEMIC_ADMINISTRATIVE_OFFICE.isMember(person.getUser()) || RoleType.MANAGER.isMember(person.getUser()));
    }
}

