/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsEnroledAsFirstTime$callable$create;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.enrolment.CreditsEnroledAsFirstTime_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreditsEnroledAsFirstTime
extends CreditsEnroledAsFirstTime_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected CreditsEnroledAsFirstTime() {
    }

    public static CreditsEnroledAsFirstTime create(CurricularPeriodConfiguration curricularPeriodConfiguration, BigDecimal bigDecimal) {
        return (CreditsEnroledAsFirstTime)((Object)advice$create.perform((Callable)new CreditsEnroledAsFirstTime$callable$create(curricularPeriodConfiguration, bigDecimal)));
    }

    static /* synthetic */ CreditsEnroledAsFirstTime advised$create(CurricularPeriodConfiguration configuration, BigDecimal credits) {
        CreditsEnroledAsFirstTime result = new CreditsEnroledAsFirstTime();
        result.init(configuration, credits, null);
        return result;
    }

    public RuleResult execute(EnrolmentContext enrolmentContext) {
        BigDecimal total = BigDecimal.ZERO;
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isLeaf() || !this.isFirstTimeEnrolment(enrolmentContext, degreeModuleToEvaluate)) continue;
            total = total.add(BigDecimal.valueOf(degreeModuleToEvaluate.getEctsCredits()));
        }
        return total.compareTo(this.getCredits()) <= 0 ? this.createTrue() : this.createFalseLabelled(total);
    }

    private boolean isFirstTimeEnrolment(EnrolmentContext enrolmentContext, IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        Registration registration = enrolmentContext.getStudentCurricularPlan().getRegistration();
        for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
            Collection filteredEnrolments = studentCurricularPlan.getEnrolmentsSet().stream().filter(e -> enrolmentContext.isToEvaluateRulesByYear() ? e.getExecutionYear().isBefore(enrolmentContext.getExecutionYear()) : e.getExecutionPeriod().isBefore(enrolmentContext.getExecutionPeriod())).collect(Collectors.toSet());
            for (CurricularCourse curricularCourse : this.collectCurricularCoursesToInspect(degreeModuleToEvaluate)) {
                if (!filteredEnrolments.stream().anyMatch(e -> e.getCurricularCourse() == curricularCourse)) continue;
                return false;
            }
        }
        return true;
    }

    private Collection<CurricularCourse> collectCurricularCoursesToInspect(IDegreeModuleToEvaluate degreeModuleToEvaluate) {
        HashSet result = Sets.newHashSet();
        if (degreeModuleToEvaluate instanceof OptionalDegreeModuleToEnrol) {
            OptionalDegreeModuleToEnrol optionalDegreeModuleToEnrol = (OptionalDegreeModuleToEnrol)degreeModuleToEvaluate;
            result.addAll(this.getAllCurricularCourses(optionalDegreeModuleToEnrol.getCurricularCourse()));
        } else {
            result.addAll(this.getAllCurricularCourses((CurricularCourse)degreeModuleToEvaluate.getDegreeModule()));
        }
        return result;
    }

    private Collection<CurricularCourse> getAllCurricularCourses(CurricularCourse curricularCourse) {
        return curricularCourse.getCompetenceCourse().getAssociatedCurricularCoursesSet();
    }

    public String getLabel() {
        return BundleUtil.getString((String)MODULE_BUNDLE, (String)("label." + ((Object)((Object)this)).getClass().getSimpleName()), (String[])new String[]{this.getCredits().toString()});
    }
}

