/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.curricularPeriod;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodConfiguration;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.CurricularPeriodRule;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.RuleEnrolment$callable$delete;
import org.fenixedu.academic.domain.curricularRules.curricularPeriod.RuleEnrolment_Base;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.services.StatuteServices;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class RuleEnrolment
extends RuleEnrolment_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected RuleEnrolment() {
    }

    public BigDecimal getCredits() {
        return super.getValue();
    }

    protected void init(CurricularPeriodConfiguration configuration, BigDecimal credits, Integer semester) {
        super.init(credits);
        this.setConfigurationEnrolment(configuration);
        this.setSemester(semester);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getConfigurationEnrolment() == null) {
            throw new DomainException("error." + ((Object)((Object)this)).getClass().getSimpleName() + ".configuration.is.required", new String[0]);
        }
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.getConfigurationEnrolment() != null) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)("error." + ((Object)((Object)this)).getClass().getSimpleName() + ".cannot.be.deleted"), (String[])new String[0]));
        }
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new RuleEnrolment$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(RuleEnrolment this_) {
        super.setConfigurationEnrolment(null);
        this_.getStatuteTypesSet().clear();
        super.delete();
    }

    protected CurricularPeriodConfiguration getConfiguration() {
        return this.getConfigurationEnrolment();
    }

    protected DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getConfigurationEnrolment().getDegreeCurricularPlan();
    }

    public void copyConfigurationTo(CurricularPeriodRule target) {
        super.copyConfigurationTo(target);
        RuleEnrolment ruleEnrolment = (RuleEnrolment)((Object)target);
        ruleEnrolment.setIncludeEnrolments(this.getIncludeEnrolments());
        ruleEnrolment.setApplyToFlunkedStudents(this.getApplyToFlunkedStudents());
        ruleEnrolment.getStatuteTypesSet().addAll(this.getStatuteTypesSet());
    }

    protected boolean hasValidStatute(EnrolmentContext enrolmentContext) {
        return this.getStatuteTypesSet().isEmpty() || StatuteServices.findStatuteTypes(enrolmentContext.getRegistration(), (ExecutionInterval)enrolmentContext.getExecutionYear()).stream().anyMatch(s -> this.getStatuteTypesSet().contains(s));
    }

    protected String getStatuteTypesLabelPrefix() {
        return !this.getStatuteTypesSet().isEmpty() ? "[" + this.getStatuteTypesSet().stream().map(s -> s.getName().getContent()).collect(Collectors.joining(", ")) + "] " : "";
    }

    public abstract RuleResult execute(EnrolmentContext var1);

    public static Set<IDegreeModuleToEvaluate> getEnroledAndEnroling(EnrolmentContext enrolmentContext) {
        return enrolmentContext.getDegreeModulesToEvaluate().stream().filter(i -> i.isLeaf() && (i.isEnroled() || i.isEnroling())).collect(Collectors.toSet());
    }

    protected static Set<IDegreeModuleToEvaluate> getEnroledAndEnroling(EnrolmentContext enrolmentContext, Predicate<IDegreeModuleToEvaluate> predicate) {
        return RuleEnrolment.getEnroledAndEnroling(enrolmentContext).stream().filter(predicate).collect(Collectors.toSet());
    }
}

