/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academicextensions.services.registrationhistory;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CurricularPeriodServices;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.AcademicExtensionsDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataServices;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.CurriculumGradeCalculator;
import org.fenixedu.academic.domain.student.curriculum.CurriculumLineServices;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionInformation;
import org.fenixedu.academic.domain.student.curriculum.conclusion.RegistrationConclusionServices;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.academic.dto.student.RegistrationStateBean;
import org.fenixedu.academicextensions.services.registrationhistory.RegistrationHistoryReport;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class RegistrationHistoryReportService {
    private Set<ExecutionYear> enrolmentExecutionYears = Sets.newHashSet();
    private Set<DegreeType> degreeTypes = Sets.newHashSet();
    private Set<Degree> degrees = Sets.newHashSet();
    private Set<RegistrationRegimeType> regimeTypes = Sets.newHashSet();
    private Set<RegistrationProtocol> registrationProtocols = Sets.newHashSet();
    private Set<IngressionType> ingressionTypes = Sets.newHashSet();
    private Set<RegistrationStateType> registrationStateTypes = Sets.newHashSet();
    private Set<StatuteType> statuteTypes = Sets.newHashSet();
    private Boolean firstTimeOnly;
    private Boolean withEnrolments;
    private Boolean withAnnuledEnrolments;
    private Boolean dismissalsOnly;
    private Boolean improvementEnrolmentsOnly;
    private Integer studentNumber;
    private Collection<ProgramConclusion> programConclusionsToFilter = Sets.newHashSet();
    private Set<ExecutionYear> graduatedExecutionYears = Sets.newHashSet();
    private LocalDate graduationPeriodStartDate;
    private LocalDate graduationPeriodEndDate;
    private Boolean registrationStateSetInExecutionYear;
    private Boolean registrationStateLastInExecutionYear;

    private List<Integer> getStudentNumbers() {
        ArrayList result = Lists.newArrayList();
        if (this.studentNumber != null) {
            result.add(this.studentNumber);
        }
        return result;
    }

    private Set<Registration> getRegistrations() {
        HashSet result = Sets.newHashSet();
        for (Integer number : this.getStudentNumbers()) {
            Student student;
            result.addAll(Registration.readByNumber((Integer)number));
            if (!result.isEmpty() || (student = Student.readStudentByNumber((Integer)number)) == null) continue;
            result.addAll(student.getRegistrationsSet());
        }
        return result;
    }

    public void filterEnrolmentExecutionYears(Collection<ExecutionYear> executionYears) {
        this.enrolmentExecutionYears.addAll(executionYears);
    }

    public void filterGraduatedExecutionYears(Collection<ExecutionYear> executionYears) {
        this.graduatedExecutionYears.addAll(executionYears);
    }

    public void filterDegreeTypes(Collection<DegreeType> degreeTypes) {
        this.degreeTypes.addAll(degreeTypes);
    }

    public void filterDegrees(Collection<Degree> degrees) {
        this.degrees.addAll(degrees);
    }

    public void filterRegimeTypes(Collection<RegistrationRegimeType> regimeTypes) {
        this.regimeTypes.addAll(regimeTypes);
    }

    public void filterRegistrationProtocols(Collection<RegistrationProtocol> protocols) {
        this.registrationProtocols.addAll(protocols);
    }

    public void filterIngressionTypes(Collection<IngressionType> ingressionTypes) {
        this.ingressionTypes.addAll(ingressionTypes);
    }

    public void filterRegistrationStateTypes(Collection<RegistrationStateType> registrationStateTypes) {
        this.registrationStateTypes.addAll(registrationStateTypes);
    }

    public void filterStatuteTypes(Collection<StatuteType> statuteTypes) {
        this.statuteTypes.addAll(statuteTypes);
    }

    public void filterFirstTimeOnly(Boolean firstTime) {
        this.firstTimeOnly = firstTime;
    }

    public void filterWithEnrolments(Boolean input) {
        this.withEnrolments = input;
    }

    public void filterWithAnnuledEnrolments(Boolean input) {
        this.withAnnuledEnrolments = input;
    }

    public void filterDismissalsOnly(Boolean dismissalsOnly) {
        this.dismissalsOnly = dismissalsOnly;
    }

    public void filterImprovementEnrolmentsOnly(Boolean improvementsEnrolmentsOnly) {
        this.improvementEnrolmentsOnly = improvementsEnrolmentsOnly;
    }

    public void filterStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    public void filterGraduationPeriodStartDate(LocalDate startDate) {
        this.graduationPeriodStartDate = startDate;
    }

    public void filterGraduationPeriodEndDate(LocalDate endDate) {
        this.graduationPeriodEndDate = endDate;
    }

    public void filterProgramConclusions(Set<ProgramConclusion> programConclusions) {
        this.programConclusionsToFilter.addAll(programConclusions);
    }

    public void filterRegistrationStateSetInExecutionYear(Boolean input) {
        this.registrationStateSetInExecutionYear = input;
    }

    public void filterRegistrationStateLastInExecutionYear(Boolean input) {
        this.registrationStateLastInExecutionYear = input;
    }

    public Collection<RegistrationHistoryReport> generateReport() {
        HashSet result = Sets.newHashSet();
        for (ExecutionYear executionYear : this.enrolmentExecutionYears) {
            result.addAll(this.process(executionYear, this.buildSearchUniverse(executionYear)));
        }
        return result;
    }

    private Set<ProgramConclusion> calculateProgramConclusions() {
        HashSet result = Sets.newHashSet();
        Set<DegreeType> degreeTypesToProcess = this.degreeTypes.isEmpty() ? DegreeType.all().collect(Collectors.toSet()) : this.degreeTypes;
        for (DegreeType degreeType : degreeTypesToProcess) {
            for (Degree degree : degreeType.getDegreeSet()) {
                for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
                    result.addAll(ProgramConclusion.conclusionsFor((DegreeCurricularPlan)degreeCurricularPlan).collect(Collectors.toSet()));
                }
            }
        }
        return result;
    }

    private Predicate<RegistrationHistoryReport> filterGraduated() {
        return report -> {
            if (this.programConclusionsToFilter.isEmpty()) {
                return report.getProgramConclusionsToReport().stream().anyMatch(pc -> this.isValidGraduated((RegistrationHistoryReport)report, (ProgramConclusion)pc));
            }
            return report.getProgramConclusionsToReport().stream().allMatch(pc -> this.isValidGraduated((RegistrationHistoryReport)report, (ProgramConclusion)pc));
        };
    }

    private boolean isValidGraduated(RegistrationHistoryReport report, ProgramConclusion programConclusion) {
        RegistrationConclusionBean conclusionBean = report.getConclusionReportFor(programConclusion);
        if (conclusionBean == null) {
            return false;
        }
        if (!conclusionBean.isConcluded()) {
            return false;
        }
        ExecutionYear conclusionYear = conclusionBean.getConclusionYear();
        LocalDate conclusionDate = conclusionBean.getConclusionDate().toLocalDate();
        if (!this.graduatedExecutionYears.contains(conclusionYear)) {
            return false;
        }
        if (this.graduationPeriodStartDate != null && conclusionDate.isBefore((ReadablePartial)this.graduationPeriodStartDate)) {
            return false;
        }
        return this.graduationPeriodEndDate == null || !conclusionDate.isAfter((ReadablePartial)this.graduationPeriodEndDate);
    }

    private Predicate<RegistrationHistoryReport> filterPredicate() {
        Predicate<RegistrationHistoryReport> result = r -> true;
        Predicate<RegistrationHistoryReport> protocolFilter = r -> this.registrationProtocols.contains(r.getRegistrationProtocol());
        if (!this.registrationProtocols.isEmpty()) {
            result = result.and(protocolFilter);
        }
        Predicate<RegistrationHistoryReport> ingressionTypeFilter = r -> this.ingressionTypes.contains(r.getIngressionType());
        if (!this.ingressionTypes.isEmpty()) {
            result = result.and(ingressionTypeFilter);
        }
        Predicate<RegistrationHistoryReport> regimeTypeFilter = r -> this.regimeTypes.contains(r.getRegimeType());
        if (!this.regimeTypes.isEmpty()) {
            result = result.and(regimeTypeFilter);
        }
        Predicate<RegistrationHistoryReport> firstTimeFilter = r -> this.firstTimeOnly != false && r.isFirstTime() || this.firstTimeOnly == false && !r.isFirstTime();
        if (this.firstTimeOnly != null) {
            result = result.and(firstTimeFilter);
        }
        Predicate<RegistrationHistoryReport> degreeTypeFilter = r -> this.degreeTypes.contains(r.getDegreeType());
        if (!this.degreeTypes.isEmpty()) {
            result = result.and(degreeTypeFilter);
        }
        Predicate<RegistrationHistoryReport> degreeFilter = r -> this.degrees.contains(r.getDegree());
        if (!this.degrees.isEmpty()) {
            result = result.and(degreeFilter);
        }
        Predicate<RegistrationHistoryReport> statuteTypeFilter = r -> r.getStudentStatutes().stream().anyMatch(s -> this.statuteTypes.contains(s.getType()));
        if (!this.statuteTypes.isEmpty()) {
            result = result.and(statuteTypeFilter);
        }
        if (!this.registrationStateTypes.isEmpty()) {
            Predicate<RegistrationHistoryReport> lastStateFilter = null;
            lastStateFilter = Boolean.TRUE.equals(this.registrationStateLastInExecutionYear) ? r -> r.getLastRegistrationState() != null && this.registrationStateTypes.contains(r.getLastRegistrationState().getStateType()) : r -> this.checkRegistrationStatesIntersection((RegistrationHistoryReport)r);
            result = result.and(lastStateFilter);
            if (this.registrationStateSetInExecutionYear != null && this.registrationStateSetInExecutionYear.booleanValue()) {
                Predicate<RegistrationHistoryReport> registrationStateFilter = r -> r.getAllLastRegistrationStates().stream().filter(b -> this.checkRegistrationStateIsInExecutionYear((RegistrationHistoryReport)r, (RegistrationStateBean)b)).anyMatch(b -> this.registrationStateTypes.contains(b.getStateType()));
                result = result.and(registrationStateFilter);
            }
        }
        Predicate<RegistrationHistoryReport> graduatedFilter = this.filterGraduated();
        if (!this.graduatedExecutionYears.isEmpty()) {
            result = result.and(graduatedFilter);
        }
        if (this.withEnrolments != null) {
            if (this.withEnrolments.booleanValue()) {
                Predicate<RegistrationHistoryReport> withEnrolmentsFilter = r -> this.hasActiveEnrolments((RegistrationHistoryReport)r);
                result = result.and(withEnrolmentsFilter);
            } else {
                Predicate<RegistrationHistoryReport> noEnrolmentsFilter = r -> Boolean.TRUE.equals(this.withAnnuledEnrolments) ? this.hasAllAnnuledEnrolments((RegistrationHistoryReport)r) : this.hasNoEnrolments((RegistrationHistoryReport)r);
                result = result.and(noEnrolmentsFilter);
            }
        }
        if (!this.registrationStateTypes.isEmpty()) {
            // empty if block
        }
        return result;
    }

    private boolean checkRegistrationStatesIntersection(RegistrationHistoryReport r) {
        return !Sets.intersection(this.registrationStateTypes, r.getAllLastRegistrationStates().stream().map(b -> b.getStateType()).collect(Collectors.toSet())).isEmpty();
    }

    private boolean checkRegistrationStateIsInExecutionYear(RegistrationHistoryReport r, RegistrationStateBean b) {
        if (b.getStateType() == RegistrationStateType.CONCLUDED) {
            return RegistrationServices.getConclusionExecutionYear(b.getRegistration()) == r.getExecutionYear();
        }
        ExecutionInterval executionInterval = b.getExecutionInterval();
        if (executionInterval != null) {
            return executionInterval.convert(ExecutionYear.class) == r.getExecutionYear();
        }
        return ExecutionYear.readByDateTime((DateTime)b.getStateDate().toLocalDate().toDateTimeAtStartOfDay()) == r.getExecutionYear();
    }

    private boolean hasActiveEnrolments(RegistrationHistoryReport report) {
        boolean hasImprovement;
        boolean hasDismissal;
        ExecutionYear executionYear = report.getExecutionYear();
        Registration registration = report.getRegistration();
        if (this.dismissalsOnly != null && this.dismissalsOnly.booleanValue() && (hasDismissal = executionYear.getExecutionPeriodsSet().stream().flatMap(ep -> ep.getCreditsSet().stream()).map(c -> c.getStudentCurricularPlan().getRegistration()).anyMatch(r -> r == registration))) {
            return true;
        }
        if (this.improvementEnrolmentsOnly != null && this.improvementEnrolmentsOnly.booleanValue() && (hasImprovement = executionYear.getExecutionPeriodsSet().stream().flatMap(e -> e.getEnrolmentEvaluationsSet().stream().map(ev -> ev.getRegistration())).anyMatch(r -> r == registration))) {
            return true;
        }
        return report.getEnrolmentsIncludingAnnuled().stream().anyMatch(e -> Boolean.TRUE.equals(this.withAnnuledEnrolments) || !e.isAnnulled());
    }

    private boolean hasAllAnnuledEnrolments(RegistrationHistoryReport report) {
        return !report.getEnrolmentsIncludingAnnuled().isEmpty() && this.isAllAnnuledEnrolments(report);
    }

    private boolean hasNoEnrolments(RegistrationHistoryReport report) {
        return report.getEnrolments().isEmpty() || this.isAllAnnuledEnrolments(report);
    }

    private Collection<RegistrationHistoryReport> process(ExecutionYear executionYear, Set<Registration> universe) {
        Predicate<RegistrationHistoryReport> filterPredicate = this.filterPredicate();
        Set programConclusionsToReport = this.calculateProgramConclusions().stream().filter(pc -> this.programConclusionsToFilter.isEmpty() || this.programConclusionsToFilter.contains(pc)).collect(Collectors.toSet());
        return this.buildSearchUniverse(executionYear).stream().filter(r -> r.getRegistrationYear().isBeforeOrEquals(executionYear)).map(r -> this.buildReport((Registration)r, executionYear, programConclusionsToReport)).filter(filterPredicate).collect(Collectors.toSet());
    }

    private boolean isAllAnnuledEnrolments(RegistrationHistoryReport report) {
        return report.getEnrolments().stream().allMatch(e -> e.isAnnulled());
    }

    private Set<Registration> buildSearchUniverse(ExecutionYear executionYear) {
        boolean withEnrolments;
        HashSet result = Sets.newHashSet();
        Set<Registration> chosen = this.getRegistrations();
        Predicate<Registration> studentNumberFilter = r -> chosen.isEmpty() || chosen.contains(r);
        if (this.dismissalsOnly != null && this.dismissalsOnly.booleanValue()) {
            result.addAll(executionYear.getExecutionPeriodsSet().stream().flatMap(ep -> ep.getCreditsSet().stream()).map(c -> c.getStudentCurricularPlan().getRegistration()).filter(studentNumberFilter).collect(Collectors.toSet()));
        }
        if (this.improvementEnrolmentsOnly != null && this.improvementEnrolmentsOnly.booleanValue()) {
            result.addAll(executionYear.getExecutionPeriodsSet().stream().flatMap(e -> e.getEnrolmentEvaluationsSet().stream().map(ev -> ev.getRegistration())).filter(studentNumberFilter).collect(Collectors.toSet()));
        }
        boolean bl = withEnrolments = this.withEnrolments != null && this.withEnrolments != false;
        if (this.withEnrolments == null || withEnrolments) {
            Stream<Object> stream = executionYear.getExecutionPeriodsSet().stream().flatMap(semester -> semester.getEnrolmentsSet().stream());
            if (withEnrolments) {
                stream = stream.filter(e -> Boolean.TRUE.equals(this.withAnnuledEnrolments) || !e.isAnnulled());
            }
            if (this.firstTimeOnly != null && this.firstTimeOnly.booleanValue()) {
                stream = stream.filter(enrolment -> enrolment.getRegistration().getRegistrationYear() == executionYear);
            }
            result.addAll(stream.map(enrolment -> enrolment.getRegistration()).filter(studentNumberFilter).filter(reg -> RegistrationDataServices.getRegistrationData(reg, executionYear) != null).collect(Collectors.toSet()));
        } else if (!this.withEnrolments.booleanValue() && Boolean.TRUE.equals(this.withAnnuledEnrolments)) {
            Stream<Object> stream = executionYear.getExecutionPeriodsSet().stream().flatMap(semester -> semester.getEnrolmentsSet().stream());
            stream = stream.filter(e -> e.isAnnulled());
            if (this.firstTimeOnly != null && this.firstTimeOnly.booleanValue()) {
                stream = stream.filter(enrolment -> enrolment.getRegistration().getRegistrationYear() == executionYear);
            }
            result.addAll(stream.map(enrolment -> enrolment.getRegistration()).filter(studentNumberFilter).collect(Collectors.toSet()));
        }
        if (this.firstTimeOnly != null && this.firstTimeOnly.booleanValue()) {
            result.addAll(executionYear.getStudentsSet().stream().filter(studentNumberFilter).collect(Collectors.toSet()));
        }
        if (this.registrationStateTypes != null && !this.registrationStateTypes.isEmpty()) {
            result.addAll(Bennu.getInstance().getRegistrationsSet().stream().filter(studentNumberFilter).collect(Collectors.toSet()));
        }
        if (result.isEmpty()) {
            throw new AcademicExtensionsDomainException("error.RegistrationHistoryReportService.insufficient.search.parameters", new String[0]);
        }
        return result;
    }

    private boolean isRegistrationStateConcluded(RegistrationState s) {
        return s.getStateType() == RegistrationStateType.CONCLUDED;
    }

    private boolean isRegistrationStateActive(RegistrationState s) {
        return s.isActive();
    }

    private boolean isRegistrationConcludedInExecutionYear(Registration registration, ExecutionYear executionYear) {
        for (RegistrationConclusionInformation conclusionInformation : RegistrationConclusionServices.inferConclusion(registration)) {
            if (!conclusionInformation.isConcluded() || conclusionInformation.isScholarPart() || conclusionInformation.getRegistrationConclusionBean().getConclusionYear() == null && conclusionInformation.getRegistrationConclusionBean().getConclusionDate() == null || conclusionInformation.getConclusionYear() != executionYear) continue;
            if (this.programConclusionsToFilter == null || this.programConclusionsToFilter.isEmpty()) {
                return true;
            }
            return this.programConclusionsToFilter.contains(conclusionInformation.getProgramConclusion());
        }
        return false;
    }

    private RegistrationHistoryReport buildReport(Registration registration, ExecutionYear executionYear, Set<ProgramConclusion> programConclusionsToReport) {
        RegistrationHistoryReport result = new RegistrationHistoryReport(registration, executionYear);
        result.setProgramConclusionsToReport(programConclusionsToReport);
        return result;
    }

    protected static void addEnrolmentsAndCreditsCount(RegistrationHistoryReport report) {
        Collection<Enrolment> enrolmentsByYear = report.getEnrolments();
        Predicate<Enrolment> normalFilter = RegistrationHistoryReportService.normalEnrolmentFilter(report);
        Predicate<Enrolment> extraCurricularFilter = RegistrationHistoryReportService.extraCurricularEnrolmentFilter();
        Predicate<Enrolment> standaloneFilter = RegistrationHistoryReportService.standaloneEnrolmentFilter();
        Predicate<Enrolment> affinityFilter = RegistrationHistoryReportService.affinityEnrolmentFilter();
        report.setEnrolmentsCount(RegistrationHistoryReportService.countFiltered(enrolmentsByYear, normalFilter));
        report.setEnrolmentsCredits(RegistrationHistoryReportService.sumCredits(enrolmentsByYear, normalFilter));
        report.setExtraCurricularEnrolmentsCount(RegistrationHistoryReportService.countFiltered(enrolmentsByYear, extraCurricularFilter));
        report.setExtraCurricularEnrolmentsCredits(RegistrationHistoryReportService.sumCredits(enrolmentsByYear, extraCurricularFilter));
        report.setStandaloneEnrolmentsCount(RegistrationHistoryReportService.countFiltered(enrolmentsByYear, standaloneFilter));
        report.setStandaloneEnrolmentsCredits(RegistrationHistoryReportService.sumCredits(enrolmentsByYear, standaloneFilter));
        report.setAffinityEnrolmentsCount(RegistrationHistoryReportService.countFiltered(enrolmentsByYear, affinityFilter));
        report.setAffinityEnrolmentsCredits(RegistrationHistoryReportService.sumCredits(enrolmentsByYear, affinityFilter));
    }

    private static Predicate<Enrolment> standaloneEnrolmentFilter() {
        return e -> e.isStandalone();
    }

    private static Predicate<Enrolment> extraCurricularEnrolmentFilter() {
        return e -> e.isExtraCurricular();
    }

    private static Predicate<Enrolment> normalEnrolmentFilter(RegistrationHistoryReport result) {
        return e -> CurriculumLineServices.isNormal((CurriculumLine)e);
    }

    private static Predicate<Enrolment> affinityEnrolmentFilter() {
        return e -> CurriculumLineServices.isAffinity((CurriculumLine)e);
    }

    private static int countFiltered(Collection<Enrolment> enrolments, Predicate<Enrolment> filter) {
        return (int)enrolments.stream().filter(filter.and(e -> !e.isAnnulled())).count();
    }

    private static BigDecimal sumCredits(Collection<Enrolment> enrolments, Predicate<Enrolment> filter) {
        return enrolments.stream().filter(filter.and(e -> !e.isAnnulled())).map(e -> e.getEctsCreditsForCurriculum()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
    }

    protected static BigDecimal calculateExecutionYearWeightedAverage(RegistrationHistoryReport report) {
        Collection<Enrolment> enrolmentsByYear = report.getEnrolments();
        BigDecimal gradesSum = BigDecimal.ZERO;
        BigDecimal creditsSum = BigDecimal.ZERO;
        for (Enrolment enrolment : enrolmentsByYear.stream().filter(RegistrationHistoryReportService.normalEnrolmentFilter(report)).filter(e -> e.isApproved() && e.getGrade().isNumeric()).collect(Collectors.toSet())) {
            gradesSum = gradesSum.add(enrolment.getGrade().getNumericValue().multiply(enrolment.getEctsCreditsForCurriculum()));
            creditsSum = creditsSum.add(enrolment.getEctsCreditsForCurriculum());
        }
        return gradesSum.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : gradesSum.divide(creditsSum, MathContext.DECIMAL128).setScale(3, RoundingMode.HALF_UP);
    }

    protected static BigDecimal calculateExecutionYearSimpleAverage(RegistrationHistoryReport report) {
        Collection<Enrolment> enrolmentsByYear = report.getEnrolments();
        BigDecimal gradesSum = BigDecimal.ZERO;
        int total = 0;
        for (Enrolment enrolment : enrolmentsByYear.stream().filter(RegistrationHistoryReportService.normalEnrolmentFilter(report)).filter(e -> e.isApproved() && e.getGrade().isNumeric()).collect(Collectors.toSet())) {
            gradesSum = gradesSum.add(enrolment.getGrade().getNumericValue());
            ++total;
        }
        return gradesSum.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : gradesSum.divide(BigDecimal.valueOf(total), MathContext.DECIMAL128).setScale(3, RoundingMode.HALF_UP);
    }

    protected static BigDecimal calculateAverage(Registration registration) {
        Curriculum curriculum = (Curriculum)RegistrationServices.getCurriculum(registration, null);
        return ((CurriculumGradeCalculator)curriculum.getGradeCalculator()).calculateAverage(curriculum).setScale(5, RoundingMode.DOWN);
    }

    protected static void addConclusion(RegistrationHistoryReport report) {
        Map<ProgramConclusion, RegistrationConclusionBean> conclusions = RegistrationConclusionServices.getConclusions(report.getRegistration());
        for (ProgramConclusion iter : report.getProgramConclusionsToReport()) {
            if (!conclusions.containsKey(iter)) {
                report.addEmptyConclusion(iter);
                continue;
            }
            report.addConclusion(iter, conclusions.get(iter));
        }
    }

    protected static void addExecutionYearMandatoryCoursesData(RegistrationHistoryReport report) {
        Integer registrationYear;
        Collection<Enrolment> enrolments = report.getEnrolments();
        if (!enrolments.isEmpty() && (registrationYear = report.getCurricularYear()) != null) {
            boolean enroledMandatoryFlunked = false;
            boolean enroledMandatoryInAdvance = false;
            BigDecimal creditsMandatoryEnroled = BigDecimal.ZERO;
            BigDecimal creditsMandatoryApproved = BigDecimal.ZERO;
            for (Enrolment iter : enrolments) {
                boolean isOptionalByGroup;
                if (!CurriculumLineServices.isNormal((CurriculumLine)iter) || (isOptionalByGroup = CurriculumLineServices.isOptionalByGroup((CurriculumLine)iter))) continue;
                int enrolmentYear = CurricularPeriodServices.getCurricularYear((CurriculumLine)iter);
                if (enrolmentYear < registrationYear) {
                    enroledMandatoryFlunked = true;
                    continue;
                }
                if (enrolmentYear > registrationYear) {
                    enroledMandatoryInAdvance = true;
                    continue;
                }
                BigDecimal ects = iter.getEctsCreditsForCurriculum();
                creditsMandatoryEnroled = creditsMandatoryEnroled.add(ects);
                if (!iter.isApproved()) continue;
                creditsMandatoryApproved = creditsMandatoryApproved.add(ects);
            }
            report.setExecutionYearEnroledMandatoryFlunked(enroledMandatoryFlunked);
            report.setExecutionYearEnroledMandatoryInAdvance(enroledMandatoryInAdvance);
            report.setExecutionYearCreditsMandatoryEnroled(creditsMandatoryEnroled);
            report.setExecutionYearCreditsMandatoryApproved(creditsMandatoryApproved);
        }
    }
}

