/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.evaluation.markSheet.report;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.dto.evaluation.markSheet.report.AbstractSeasonReport;
import org.joda.time.LocalDate;

public class CompetenceCourseSeasonReport
extends AbstractSeasonReport {
    private CompetenceCourse competenceCourse;
    private ExecutionInterval executionInterval;
    private Integer notEvaluatedStudents = 0;
    private Integer evaluatedStudents = 0;
    private Integer marksheetsTotal = 0;
    private Integer marksheetsToConfirm = 0;

    public CompetenceCourseSeasonReport(CompetenceCourse competenceCourse, EvaluationSeason season, ExecutionInterval executionInterval, LocalDate evaluationDate) {
        super(season, evaluationDate);
        this.competenceCourse = competenceCourse;
        this.executionInterval = executionInterval;
    }

    public CompetenceCourse getCompetenceCourse() {
        return this.competenceCourse;
    }

    @Override
    public Collection<Person> getResponsibles() {
        HashSet<Person> result = new HashSet<Person>();
        for (ExecutionCourse executionCourse : this.getCompetenceCourse().getExecutionCoursesByExecutionPeriod(this.getExecutionSemester())) {
            for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                if (!professorship.isResponsibleFor()) continue;
                result.add(professorship.getPerson());
            }
        }
        return result;
    }

    @Override
    public Integer getNotEvaluatedStudents() {
        return this.notEvaluatedStudents;
    }

    public void setNotEvaluatedStudents(Integer notEvaluatedStudents) {
        this.notEvaluatedStudents = notEvaluatedStudents;
    }

    @Override
    public Integer getEvaluatedStudents() {
        return this.evaluatedStudents;
    }

    public void setEvaluatedStudents(Integer evaluatedStudents) {
        this.evaluatedStudents = evaluatedStudents;
    }

    @Override
    public Integer getMarksheetsTotal() {
        return this.marksheetsTotal;
    }

    public void setMarksheetsTotal(Integer input) {
        this.marksheetsTotal = input;
    }

    @Override
    public Integer getMarksheetsToConfirm() {
        return this.marksheetsToConfirm;
    }

    public void setMarksheetsToConfirm(Integer marksheetsToConfirm) {
        this.marksheetsToConfirm = marksheetsToConfirm;
    }

    @Override
    @Deprecated
    public ExecutionInterval getExecutionSemester() {
        return this.executionInterval;
    }

    @Override
    public ExecutionInterval getExecutionInterval() {
        return this.executionInterval;
    }

    public String getExecutionCourses() {
        LinkedList nameSame = Lists.newLinkedList();
        LinkedList nameDifferent = Lists.newLinkedList();
        if (this.getCompetenceCourse() != null && this.getExecutionSemester() != null) {
            for (ExecutionCourse iter : this.getCompetenceCourse().getExecutionCoursesByExecutionPeriod(this.getExecutionSemester())) {
                if (iter.getName().equals(this.getCompetenceCourse().getName())) {
                    nameSame.add(this.getDegrees(iter));
                    continue;
                }
                nameDifferent.add(this.getDegrees(iter) + " [" + iter.getName() + "]");
            }
        }
        String result = "";
        if (!nameSame.isEmpty()) {
            result = result + nameSame.stream().collect(Collectors.joining("; "));
        }
        if (!nameDifferent.isEmpty()) {
            result = result + nameDifferent.stream().collect(Collectors.joining("; "));
        }
        return result;
    }

    private String getDegrees(ExecutionCourse i) {
        return i.getAssociatedCurricularCoursesSet().stream().map(x -> x.getDegree().getCode()).collect(Collectors.joining("; "));
    }
}

